/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class JsonPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull File file) throws IOException {
        if (file == null) {
            JsonPlistReader.$$$reportNull$$$0(0);
        }
        return this.read(new FileInputStream(file));
    }

    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        if (inputStream == null) {
            JsonPlistReader.$$$reportNull$$$0(1);
        }
        return JsonPlistReader.internalRead(new Gson().fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), Object.class));
    }

    private static Plist internalRead(Object root) throws IOException {
        if (!(root instanceof Map)) {
            throw new IOException("Unknown json format. Root element is '" + root + "'");
        }
        return (Plist)JsonPlistReader.readDict((Map)root).getValue();
    }

    private static PListValue readDict(@NotNull Map<String, Object> map) {
        if (map == null) {
            JsonPlistReader.$$$reportNull$$$0(2);
        }
        Plist dict = new Plist();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            PListValue value = JsonPlistReader.readValue(entry.getValue());
            if (value == null) continue;
            dict.setEntry(entry.getKey(), value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(Object value) {
        if (value instanceof Map) {
            return JsonPlistReader.readDict((Map)value);
        }
        if (value instanceof ArrayList) {
            return JsonPlistReader.readArray((ArrayList)value);
        }
        return JsonPlistReader.readBasicValue(value);
    }

    private static PListValue readArray(ArrayList list) {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (Object o : list) {
            PListValue value = JsonPlistReader.readValue(o);
            if (value == null) continue;
            result.add(value);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(Object value) {
        if (value instanceof String) {
            return PListValue.value(value, PlistValueType.STRING);
        }
        if (value instanceof Boolean) {
            return PListValue.value(value, PlistValueType.BOOLEAN);
        }
        if (value instanceof Double) {
            long integer = ((Double)value).longValue();
            if (value.equals(integer)) {
                return PListValue.value(integer, PlistValueType.INTEGER);
            }
            return PListValue.value(value, PlistValueType.REAL);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/textmate/plist/JsonPlistReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readDict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

