/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.TextMateBundlesListPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.configuration.TextMateThemeMappingPanel;

public class TextMateSettingsUI
implements ConfigurableUi<TextMateSettings>,
Disposable {
    private TextMateBundlesListPanel myBundlesListPanel;
    private TextMateThemeMappingPanel myThemeMappingPanel;
    private JPanel myPanel;
    private JPanel myBundlesList;
    private JPanel myThemeMappingComponent;

    public TextMateSettingsUI() {
        this.$$$setupUI$$$();
    }

    public void apply(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(0);
        }
        if ((state = settings.getState()) == null) {
            state = new TextMateSettings.TextMateSettingsState();
        }
        settings.loadState(state);
        if (this.myThemeMappingPanel.isModified(state.getThemesMapping())) {
            this.myThemeMappingPanel.apply(state);
            EditorFactory.getInstance().refreshAllEditors();
        }
        if (this.myBundlesListPanel.isModified(state.getBundles())) {
            final TextMateService textMateService = TextMateService.getInstance();
            state.setBundles(this.myBundlesListPanel.getState());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, "Loading TextMate Bundles", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    textMateService.unregisterAllBundles();
                    textMateService.reloadThemesFromDisk();
                    textMateService.registerEnabledBundles();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI$1", "run"));
                }
            });
        }
    }

    public void reset(@NotNull TextMateSettings settings) {
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(1);
        }
        this.myThemeMappingPanel.reset(settings);
        this.myBundlesListPanel.setState(settings.getBundles());
    }

    public boolean isModified(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state;
        if (settings == null) {
            TextMateSettingsUI.$$$reportNull$$$0(2);
        }
        if ((state = settings.getState()) == null) {
            return !this.myBundlesListPanel.getState().isEmpty() || this.myThemeMappingPanel.isModified(this.myThemeMappingPanel.getDefaultThemesMapping(settings));
        }
        return this.myBundlesListPanel.isModified(state.getBundles()) || this.myThemeMappingPanel.isModified(state.getThemesMapping());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            TextMateSettingsUI.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    public void dispose() {
        this.myBundlesList = null;
        this.myThemeMappingComponent = null;
    }

    private static String[] retrieveAllSchemeNames() {
        return (String[])ContainerUtil.map2Array((Object[])EditorColorsManager.getInstance().getAllSchemes(), String.class, s -> SchemeManager.getDisplayName((Scheme)s));
    }

    private void createUIComponents() {
        this.myBundlesListPanel = new TextMateBundlesListPanel();
        this.myBundlesList = this.myBundlesListPanel.createMainComponent();
        this.myThemeMappingPanel = new TextMateThemeMappingPanel(TextMateService.getInstance().getThemeNames(), TextMateSettingsUI.retrieveAllSchemeNames());
        this.myThemeMappingComponent = this.myThemeMappingPanel.getMainComponent();
        if (Registry.is((String)"textmate.theme.emulation")) {
            this.myThemeMappingComponent.setVisible(false);
        }
        Disposer.register((Disposable)this, (Disposable)this.myThemeMappingPanel);
        Disposer.register((Disposable)this, (Disposable)this.myBundlesListPanel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/configuration/TextMateSettingsUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = this.myBundlesList;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = this.myThemeMappingComponent;
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

