/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.remote.RemoteConnectionType;
import com.intellij.remote.RemoteConnector;
import com.intellij.remote.VagrantSupport;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantSshConnectionProvider
implements SshConnectionProvider {
    @Override
    @NotNull
    public Collection<? extends RemoteConnector> collectRemoteConnectors() {
        List<RemoteConnector> list = VagrantSshConnectionProvider.collectVagrantConnections();
        if (list == null) {
            VagrantSshConnectionProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static List<RemoteConnector> collectVagrantConnections() {
        ArrayList result = Lists.newArrayList();
        VagrantSupport vs = VagrantSupport.getInstance();
        if (vs != null) {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                result.addAll(vs.getVagrantInstancesConnectors(project));
            }
        }
        return result;
    }

    @Override
    @Nullable
    public RemoteConnector getRemoteConnector(RemoteConnectionType type, @Nullable String id, Project project, Module module) {
        for (RemoteConnector remoteConnector : this.collectRemoteConnectors()) {
            if (remoteConnector.getType() != type || remoteConnector.getId() == null || !remoteConnector.getId().equals(id)) continue;
            return remoteConnector;
        }
        return null;
    }

    @Override
    @Nullable
    public String getSettingCreationDescription() {
        return "add Vagrant";
    }

    @Override
    @Nls
    @NotNull
    public String getRadioButtonDescription() {
        if ("Current Vagrant" == null) {
            VagrantSshConnectionProvider.$$$reportNull$$$0(1);
        }
        return "Current Vagrant";
    }

    @Override
    @NotNull
    public RemoteConnectionType getTypeForConfigurable() {
        RemoteConnectionType remoteConnectionType = RemoteConnectionType.CURRENT_VAGRANT;
        if (remoteConnectionType == null) {
            VagrantSshConnectionProvider.$$$reportNull$$$0(2);
        }
        return remoteConnectionType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/plugins/remotesdk/VagrantSshConnectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRemoteConnectors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRadioButtonDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeForConfigurable";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

