/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.Angular2Language;
import org.angular2.lang.expr.psi.Angular2EmbeddedExpression;
import org.angular2.lang.expr.psi.Angular2PipeArgumentsList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Angular2InspectionSuppressor
implements InspectionSuppressor {
    public static final Angular2InspectionSuppressor INSTANCE = new Angular2InspectionSuppressor();
    @NonNls
    private static final String[] PREFIXES_TO_STRIP = new String[]{"TypeScript", "JS", "Angular"};

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(1);
        }
        return Angular2InspectionSuppressor.isSuppressedInStatement(element, Angular2InspectionSuppressor.stripToolIdPrefix(toolId));
    }

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new Angular2SuppressByCommentFix(Angular2InspectionSuppressor.stripToolIdPrefix(toolId))};
        if (suppressQuickFixArray == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @Nullable
    private static PsiElement getStatementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        PsiElement statement;
        if (place == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(4);
        }
        if (toolId == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(5);
        }
        if ((statement = PsiTreeUtil.getParentOfType((PsiElement)place, Angular2EmbeddedExpression.class)) != null) {
            String text;
            Matcher matcher;
            PsiElement candidate = PsiTreeUtil.skipWhitespacesForward((PsiElement)statement);
            if (!(candidate instanceof PsiComment) && statement.getLastChild() instanceof Angular2PipeArgumentsList) {
                candidate = PsiTreeUtil.skipWhitespacesBackward((PsiElement)statement.getLastChild());
            }
            if (candidate instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = candidate.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) {
                return candidate;
            }
        }
        return null;
    }

    private static boolean isSuppressedInStatement(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(6);
        }
        if (toolId == null) {
            Angular2InspectionSuppressor.$$$reportNull$$$0(7);
        }
        return ReadAction.compute(() -> Angular2InspectionSuppressor.getStatementToolSuppressedIn(place, toolId)) != null;
    }

    private static String stripToolIdPrefix(String toolId) {
        for (String prefix : PREFIXES_TO_STRIP) {
            if (!toolId.startsWith(prefix)) continue;
            return toolId.substring(prefix.length());
        }
        return toolId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/Angular2InspectionSuppressor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/Angular2InspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStatementToolSuppressedIn";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Angular2SuppressByCommentFix
    extends AbstractBatchSuppressByNoInspectionCommentFix {
        Angular2SuppressByCommentFix(String key) {
            super(key, false);
        }

        protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
            if (project == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(0);
            }
            if (element == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(1);
            }
            if (container == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(2);
            }
            PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)project);
            PsiComment comment = parserFacade.createLineOrBlockCommentFromText((Language)Angular2Language.INSTANCE, this.getSuppressText());
            container.getParent().addAfter((PsiElement)comment, container);
        }

        @Nullable
        public PsiElement getContainer(PsiElement context) {
            return PsiTreeUtil.getParentOfType((PsiElement)context, Angular2EmbeddedExpression.class);
        }

        @NotNull
        public String getText() {
            String string = Angular2Bundle.message("angular.suppress.for-expression", new Object[0]);
            if (string == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container) {
            PsiElement next;
            if (container == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(4);
            }
            if ((next = PsiTreeUtil.skipWhitespacesForward((PsiElement)container)) == null) {
                return null;
            }
            return Collections.singletonList(next);
        }

        @NotNull
        protected String getSuppressText() {
            String string = "noinspection " + this.myID;
            if (string == null) {
                Angular2SuppressByCommentFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/angular2/inspections/Angular2InspectionSuppressor$Angular2SuppressByCommentFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/angular2/inspections/Angular2InspectionSuppressor$Angular2SuppressByCommentFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuppressText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createSuppression";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentsFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

