/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities.metadata.stubs;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.metadata.psi.Angular2MetadataDirectiveBase;
import org.angular2.entities.metadata.stubs.Angular2MetadataEntityStub;
import org.angular2.index.Angular2MetadataDirectiveIndex;
import org.angular2.lang.metadata.MetadataUtils;
import org.angular2.lang.metadata.psi.MetadataElementType;
import org.angular2.lang.metadata.stubs.MetadataElementStub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Angular2MetadataDirectiveStubBase<Psi extends Angular2MetadataDirectiveBase>
extends Angular2MetadataEntityStub<Psi> {
    private static final BooleanStructureElement HAS_EXPORT_AS = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ATTRIBUTES = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(Angular2MetadataEntityStub.FLAGS_STRUCTURE, new FlagsStructureElement[]{HAS_EXPORT_AS, HAS_ATTRIBUTES});
    private final StringRef mySelector;
    private final StringRef myExportAs;
    @NotNull
    private final Map<String, Integer> myAttributes;

    public Angular2MetadataDirectiveStubBase(@Nullable String memberName, @Nullable StubElement parent, @NotNull JsonObject source, @NotNull JsonObject decoratorSource, @NotNull MetadataElementType elementType) {
        if (source == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(0);
        }
        if (decoratorSource == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(2);
        }
        super(memberName, parent, source, elementType);
        this.myAttributes = Angular2MetadataDirectiveStubBase.loadAttributesMapping(source);
        JsonObject initializer = Angular2MetadataDirectiveStubBase.getDecoratorInitializer(decoratorSource, JsonObject.class);
        if (initializer == null) {
            this.mySelector = null;
            this.myExportAs = null;
            return;
        }
        this.mySelector = StringRef.fromString((String)MetadataUtils.readStringPropertyValue(initializer.findProperty("selector")));
        this.myExportAs = StringRef.fromString((String)MetadataUtils.readStringPropertyValue(initializer.findProperty("exportAs")));
        this.loadAdditionalBindingMappings(this.myInputMappings, initializer, "inputs");
        this.loadAdditionalBindingMappings(this.myOutputMappings, initializer, "outputs");
    }

    public Angular2MetadataDirectiveStubBase(@NotNull StubInputStream stream, @Nullable StubElement parent, @NotNull MetadataElementType elementType) throws IOException {
        if (stream == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(3);
        }
        if (elementType == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(4);
        }
        super(stream, parent, elementType);
        this.mySelector = stream.readName();
        this.myExportAs = (Boolean)this.readFlag(HAS_EXPORT_AS) != false ? stream.readName() : null;
        this.myAttributes = (Boolean)this.readFlag(HAS_ATTRIBUTES) != false ? MetadataElementStub.readIntegerMap(stream) : Collections.emptyMap();
    }

    @Nullable
    public String getSelector() {
        return StringRef.toString((StringRef)this.mySelector);
    }

    @Nullable
    public String getExportAs() {
        return StringRef.toString((StringRef)this.myExportAs);
    }

    @NotNull
    public Map<String, Integer> getAttributes() {
        Map<String, Integer> map = this.myAttributes;
        if (map == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(5);
        }
        return map;
    }

    @Override
    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(6);
        }
        this.writeFlag(HAS_EXPORT_AS, this.myExportAs != null);
        this.writeFlag(HAS_ATTRIBUTES, !this.myAttributes.isEmpty());
        super.serialize(stream);
        Angular2MetadataDirectiveStubBase.writeString(this.mySelector, stream);
        if (this.myExportAs != null) {
            Angular2MetadataDirectiveStubBase.writeString(this.myExportAs, stream);
        }
        if (!this.myAttributes.isEmpty()) {
            Angular2MetadataDirectiveStubBase.writeIntegerMap(this.myAttributes, stream);
        }
    }

    @Override
    public void index(@NotNull IndexSink sink) {
        if (sink == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(7);
        }
        super.index(sink);
        if (this.getSelector() != null) {
            Angular2EntityUtils.getDirectiveIndexNames(this.getSelector()).forEach(indexName -> sink.occurrence(Angular2MetadataDirectiveIndex.KEY, indexName));
        }
    }

    @Override
    protected FlagsStructure getFlagsStructure() {
        return FLAGS_STRUCTURE;
    }

    @NotNull
    private static Map<String, Integer> loadAttributesMapping(@NotNull JsonObject source) {
        if (source == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(8);
        }
        Map<String, Integer> map = StreamEx.ofNullable((Object)MetadataUtils.getPropertyValue(source.findProperty("members"), JsonObject.class)).map(Angular2MetadataDirectiveStubBase.toPropertyValue("__ctor__", JsonArray.class)).nonNull().flatCollection(JsonArray::getValueList).select(JsonObject.class).map(Angular2MetadataDirectiveStubBase.toPropertyValue("parameterDecorators", JsonArray.class)).nonNull().findFirst().map(Angular2MetadataDirectiveStubBase::buildAttributesMapping).orElse(Collections.emptyMap());
        if (map == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(9);
        }
        return map;
    }

    @NotNull
    private static Map<String, Integer> buildAttributesMapping(@NotNull JsonArray paramDecorators) {
        if (paramDecorators == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(10);
        }
        Predicate<JsonObject> isAttributeDecorator = object -> {
            JsonObject expr = MetadataUtils.getPropertyValue(object.findProperty("expression"), JsonObject.class);
            String decoratorName = expr != null ? MetadataUtils.readStringPropertyValue(expr.findProperty("name")) : null;
            return "Attribute".equals(decoratorName);
        };
        Map map = (Map)EntryStream.of((List)paramDecorators.getValueList()).selectValues(JsonArray.class).flatMapValues(a -> a.getValueList().stream()).selectValues(JsonObject.class).filterValues(isAttributeDecorator).mapValues(Angular2MetadataDirectiveStubBase.toPropertyValue("arguments", JsonArray.class)).nonNullValues().mapValues(o -> (JsonValue)o.getValueList().get(0)).selectValues(JsonStringLiteral.class).mapValues(JsonStringLiteral::getValue).filterValues(s -> !s.trim().isEmpty()).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (i, __) -> i));
        if (map == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(11);
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void loadAdditionalBindingMappings(@NotNull Map<String, String> mappings, @NotNull JsonObject initializer, @NotNull String propertyName) {
        JsonArray list;
        if (mappings == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(12);
        }
        if (initializer == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(13);
        }
        if (propertyName == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(14);
        }
        if ((list = (JsonArray)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)initializer.findProperty(propertyName), JsonProperty::getValue), JsonArray.class)) != null) {
            if (ContainerUtil.all((Collection)list.getValueList(), JsonStringLiteral.class::isInstance)) {
                Iterator iterator = list.getValueList().iterator();
                while (iterator.hasNext()) {
                    JsonValue v = (JsonValue)iterator.next();
                    if (!(v instanceof JsonStringLiteral)) continue;
                    String value = ((JsonStringLiteral)v).getValue();
                    Pair<String, String> p = Angular2EntityUtils.parsePropertyMapping(value);
                    mappings.putIfAbsent((String)p.first, (String)p.second);
                }
                return;
            }
        }
        this.stubDecoratorFields(initializer, propertyName);
    }

    private static <T extends JsonValue> Function<JsonObject, T> toPropertyValue(@NotNull String property, @NotNull Class<T> clazz) {
        if (property == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(15);
        }
        if (clazz == null) {
            Angular2MetadataDirectiveStubBase.$$$reportNull$$$0(16);
        }
        return o -> MetadataUtils.getPropertyValue(o.findProperty(property), clazz);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorSource";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/metadata/stubs/Angular2MetadataDirectiveStubBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramDecorators";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/metadata/stubs/Angular2MetadataDirectiveStubBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAttributesMapping";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAttributesMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadAttributesMapping";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildAttributesMapping";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalBindingMappings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toPropertyValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

