/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.angular2.cli.BlueprintParser;
import org.angular2.cli.Schematic;
import org.angular2.cli.SchematicsJsonParser;
import org.angular2.cli.SchematicsLoaderKt;
import org.angularjs.lang.AngularJSLanguage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006\u001a\u001a\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002\u001a \u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"DEFAULT_OUTPUT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "myLogErrors", "Ljava/lang/ThreadLocal;", "", "doLoad", "", "Lorg/angular2/cli/Schematic;", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeHidden", "logErrors", "grabCommandOutput", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "workingDir", "loadBlueprintHelpOutput", "configurator", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator;", "loadSchematicsInfoJson", "shortenOutput", "output", "intellij.angularJS"})
public final class SchematicsLoaderKt {
    private static ThreadLocal<Boolean> myLogErrors;
    private static final Logger LOG;
    @NotNull
    public static final String DEFAULT_OUTPUT = "\n\n  Available blueprints:\n    class <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    component <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --inline-template (Boolean) Specifies if the template will be in the ts file.\n        aliases: -it, --inlineTemplate\n      --inline-style (Boolean) Specifies if the style will be in the ts file.\n        aliases: -is, --inlineStyle\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --view-encapsulation (String) Specifies the view encapsulation strategy.\n        aliases: -ve <value>, --viewEncapsulation <value>\n      --change-detection (String) Specifies the change detection strategy.\n        aliases: -cd <value>, --changeDetection <value>\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    directive <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    enum <name> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    guard <name> <options...>\n      --flat (Boolean) Indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n    interface <interface-type> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    module <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --routing (Boolean) (Default: false) Specifies if a routing module file should be generated.\n        aliases: --routing\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    pipe <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the pipe.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    service <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n\nng generate <blueprint> <options...>\n  Generates new code from blueprints.\n  aliases: g\n  --dry-run (Boolean) (Default: false) Run through without making any changes.\n    aliases: -d, --dryRun\n  --verbose (Boolean) (Default: false) Adds more details to output logging.\n    aliases: -v, --verbose\n\n    ";

    @NotNull
    public static final List<Schematic> doLoad(@NotNull Project project, @NotNull VirtualFile cli, boolean includeHidden, boolean logErrors) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)cli, (String)"cli");
        myLogErrors.set(logErrors);
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter nodeJsInterpreter = nodeJsInterpreterManager.getInterpreter();
        if (nodeJsInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreter, (String)"NodeJsInterpreterManager\u2026ter ?: return emptyList()");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodeCommandLineConfigurator configurator = null;
        try {
            NodeCommandLineConfigurator nodeCommandLineConfigurator = NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeCommandLineConfigurator, (String)"NodeCommandLineConfigurator.find(interpreter)");
            configurator = nodeCommandLineConfigurator;
        }
        catch (Exception e) {
            LOG.error("Cannot load schematics", (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Collection<Schematic> parse = CollectionsKt.emptyList();
        String schematicsInfoJson = SchematicsLoaderKt.loadSchematicsInfoJson(configurator, cli, includeHidden);
        CharSequence charSequence = schematicsInfoJson;
        boolean bl = false;
        if (charSequence.length() > 0 && !StringsKt.startsWith$default((String)schematicsInfoJson, (String)"No schematics", (boolean)false, (int)2, null)) {
            try {
                List<Schematic> list = SchematicsJsonParser.parse(schematicsInfoJson);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"SchematicsJsonParser.parse(schematicsInfoJson)");
                parse = (Collection<Schematic>)list;
            }
            catch (Exception e) {
                LOG.error("Failed to parse schematics: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", schematicsInfoJson)});
            }
        }
        if (parse.isEmpty()) {
            String blueprintHelpOutput = SchematicsLoaderKt.loadBlueprintHelpOutput(configurator, cli);
            CharSequence charSequence2 = blueprintHelpOutput;
            boolean bl2 = false;
            if (charSequence2.length() > 0) {
                try {
                    parse = new BlueprintParser().parse(blueprintHelpOutput);
                }
                catch (Exception e) {
                    LOG.error("Failed to parse blueprints: " + e.getMessage(), (Throwable)e, new Attachment[]{new Attachment("output", blueprintHelpOutput)});
                }
            }
        }
        if (parse.isEmpty()) {
            parse = new BlueprintParser().parse(DEFAULT_OUTPUT);
        }
        Iterable $this$sortedBy$iv = parse;
        boolean $i$f$sortedBy = false;
        Iterable iterable = $this$sortedBy$iv;
        boolean bl3 = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Schematic it = (Schematic)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Schematic)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private static final String loadSchematicsInfoJson(NodeCommandLineConfigurator configurator, VirtualFile cli, boolean includeHidden) {
        File directory = JSLanguageServiceUtil.getPluginDirectory(AngularJSLanguage.class, (String)"ngCli");
        String utilityExe = directory + File.separator + "runner.js";
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"", utilityExe, cli.getPath(), "./schematicsInfoProvider.js"});
        if (includeHidden) {
            commandLine.addParameter("--includeHidden");
        }
        configurator.configure(commandLine);
        return SchematicsLoaderKt.grabCommandOutput(commandLine, cli.getPath());
    }

    private static final String loadBlueprintHelpOutput(NodeCommandLineConfigurator configurator, VirtualFile cli) {
        boolean bl = false;
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, null);
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return "";
        }
        CompletionModuleInfo module = completionModuleInfo;
        StringBuilder stringBuilder = new StringBuilder();
        VirtualFile virtualFile = module.getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"module.virtualFile!!");
        String moduleExe = stringBuilder.append(virtualFile.getPath()).append(File.separator).append("bin").append(File.separator).append("ng").toString();
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"", moduleExe, "help", "generate"});
        configurator.configure(commandLine);
        return SchematicsLoaderKt.grabCommandOutput(commandLine, cli.getPath());
    }

    private static final String grabCommandOutput(GeneralCommandLine commandLine, String workingDir) {
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = handler.runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"handler.runProcess()");
        ProcessOutput output = processOutput;
        if (output.getExitCode() == 0) {
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            CharSequence charSequence = string;
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            charSequence = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            bl = false;
            if (charSequence.length() > 0) {
                Boolean bl2 = myLogErrors.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"myLogErrors.get()");
                if (bl2.booleanValue()) {
                    StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
                    String string3 = output.getStderr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"output.stderr");
                    LOG.error(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string3)).toString(), new Attachment[]{new Attachment("err-output", output.getStderr())});
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
                    String string4 = output.getStderr();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"output.stderr");
                    LOG.info(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string4)).toString());
                }
            }
            String string5 = output.getStdout();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"output.stdout");
            return string5;
        }
        Boolean bl = myLogErrors.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"myLogErrors.get()");
        if (bl.booleanValue()) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to load schematics info.\n");
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            LOG.error(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string)).toString(), new Attachment[]{new Attachment("err-output", output.getStderr()), new Attachment("std-output", output.getStdout())});
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Error while loading schematics info.\n");
            String string = output.getStderr();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"output.stderr");
            LOG.info(stringBuilder.append(SchematicsLoaderKt.shortenOutput(string)).toString());
        }
        return "";
    }

    private static final String shortenOutput(String output) {
        CharSequence charSequence = StringsKt.replace$default((String)output, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        String string = "(/[^()/:]+)+(/[^()/:]+)(/[^()/:]+)";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "/...$1$2$3";
        boolean bl2 = false;
        String string3 = StringUtil.shortenTextWithEllipsis((String)string.replace(charSequence, string2), (int)750, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringUtil.shortenTextWi\u2026/...$1$2$3\"),\n    750, 0)");
        return string3;
    }

    static {
        ThreadLocal threadLocal = ThreadLocal.withInitial(myLogErrors.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(threadLocal, (String)"ThreadLocal.withInitial { true }");
        myLogErrors = threadLocal;
        Logger logger = Logger.getInstance((String)"#org.angular2.cli.SchematicsLoader");
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(\"#org\u2026r2.cli.SchematicsLoader\")");
        LOG = logger;
    }
}

