/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;

public abstract class ShapeTransform {
    protected GeneralPath myPath = new GeneralPath();
    private Rectangle myShapeRect;
    private final int myXTransform;
    private final int myYTransform;
    private final boolean mySwap;

    protected ShapeTransform(Rectangle shapeRect, int xTransform, int yTransform, boolean swap) {
        this.myShapeRect = shapeRect;
        this.myXTransform = xTransform;
        this.myYTransform = yTransform;
        this.mySwap = swap;
    }

    protected final Rectangle getShapeRect() {
        return this.myShapeRect;
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getMaxX();

    public abstract int getMaxY();

    public final int deltaX(int deltaX) {
        return deltaX * this.myXTransform;
    }

    public final int deltaY(int deltaY) {
        return deltaY * this.myYTransform;
    }

    public final <T> T transformY1(T o1, T o2) {
        return (this.mySwap ? this.myXTransform : this.myYTransform) == 1 ? o1 : o2;
    }

    public abstract Insets transformInsets(Insets var1);

    public abstract Line2D.Float transformLine(int var1, int var2, int var3, int var4);

    public abstract ShapeTransform createTransform(Rectangle var1);

    public abstract ShapeTransform copy();

    public final int getWidth() {
        return Math.abs(this.getMaxX() - this.getX());
    }

    public final int getHeight() {
        return Math.abs(this.getMaxY() - this.getY());
    }

    public final ShapeTransform moveTo(int x, int y) {
        if (this.mySwap) {
            this.myPath.moveTo(y, x);
        } else {
            this.myPath.moveTo(x, y);
        }
        return this;
    }

    public final ShapeTransform quadTo(int x1, int y1, int x2, int y2) {
        if (this.mySwap) {
            this.myPath.quadTo(y1, x1, y2, x2);
        } else {
            this.myPath.quadTo(x1, y1, x2, y2);
        }
        return this;
    }

    public final ShapeTransform lineTo(int x, int y) {
        if (this.mySwap) {
            this.myPath.lineTo(y, x);
        } else {
            this.myPath.lineTo(x, y);
        }
        return this;
    }

    public final GeneralPath getShape() {
        return this.myPath;
    }

    public final ShapeTransform reset() {
        return this.reset(null);
    }

    protected final ShapeTransform reset(Rectangle shapeRec) {
        this.myPath = new GeneralPath();
        if (shapeRec != null) {
            this.myShapeRect = shapeRec;
        }
        return this;
    }

    public final ShapeTransform closePath() {
        this.myPath.closePath();
        return this;
    }

    public final ShapeTransform doRect(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            return this;
        }
        return this.moveTo(x, y).lineTo(x + this.deltaX(width), y).lineTo(x + this.deltaX(width), y + this.deltaY(height)).lineTo(x, y + this.deltaY(height)).closePath();
    }

    public static class Right
    extends ShapeTransform {
        public Right(Rectangle shapeRect, GeneralPath path2) {
            super(shapeRect, 1, -1, true);
            this.myPath = path2;
        }

        public Right(Rectangle rec) {
            this(rec, new GeneralPath());
        }

        public Right() {
            this(null);
        }

        @Override
        public int getX() {
            return this.getShapeRect().y;
        }

        @Override
        public int getY() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxY() {
            return this.getShapeRect().x;
        }

        @Override
        public ShapeTransform copy() {
            return new Right((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.right, insets.top, insets.left, insets.bottom);
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Right(innerRec);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(y1, x1, y2, x2);
        }
    }

    public static class Bottom
    extends ShapeTransform {
        public Bottom(Rectangle shapeRect, GeneralPath path2) {
            super(shapeRect, 1, -1, false);
            this.myPath = path2;
        }

        public Bottom(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Bottom() {
            this(null);
        }

        @Override
        public int getX() {
            return this.getShapeRect().x;
        }

        @Override
        public int getY() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxY() {
            return this.getShapeRect().y;
        }

        @Override
        public ShapeTransform copy() {
            return new Bottom((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Bottom(innerRec);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.bottom, insets.right, insets.top, insets.left);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(x2, Math.abs(y2), x1, Math.abs(y1));
        }
    }

    public static class Left
    extends ShapeTransform {
        public Left() {
            this(null);
        }

        public Left(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Left(Rectangle shapeRect, GeneralPath path2) {
            super(shapeRect, 1, 1, true);
            this.myPath = path2;
        }

        @Override
        public int getX() {
            return this.getShapeRect().y;
        }

        @Override
        public int getY() {
            return this.getShapeRect().x;
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public int getMaxY() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Left(innerRec);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(y1, x1, y2, x2);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.left, insets.top, insets.right, insets.bottom);
        }

        @Override
        public ShapeTransform copy() {
            return new Left((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }
    }

    public static class Top
    extends ShapeTransform {
        public Top() {
            this(null);
        }

        public Top(Rectangle shapeRect) {
            this(shapeRect, new GeneralPath());
        }

        public Top(Rectangle shapeRect, GeneralPath path2) {
            super(shapeRect, 1, 1, false);
            this.myPath = path2;
        }

        @Override
        public int getX() {
            return this.getShapeRect().x;
        }

        @Override
        public int getY() {
            return this.getShapeRect().y;
        }

        @Override
        public int getMaxX() {
            return (int)this.getShapeRect().getMaxX();
        }

        @Override
        public int getMaxY() {
            return (int)this.getShapeRect().getMaxY();
        }

        @Override
        public ShapeTransform createTransform(Rectangle innerRec) {
            return new Top(innerRec);
        }

        @Override
        public Insets transformInsets(Insets insets) {
            return new Insets(insets.top, insets.left, insets.bottom, insets.right);
        }

        @Override
        public Line2D.Float transformLine(int x1, int y1, int x2, int y2) {
            return new Line2D.Float(x1, y1, x2, y2);
        }

        @Override
        public ShapeTransform copy() {
            return new Top((Rectangle)this.getShapeRect().clone(), (GeneralPath)this.myPath.clone());
        }
    }
}

