/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.newImpl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsBorder;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.UiDecorator;
import com.intellij.ui.tabs.newImpl.DefaultTabPainterAdapter;
import com.intellij.ui.tabs.newImpl.DragHelper;
import com.intellij.ui.tabs.newImpl.JBDefaultTabsBorder;
import com.intellij.ui.tabs.newImpl.LayoutPassInfo;
import com.intellij.ui.tabs.newImpl.ShapeTransform;
import com.intellij.ui.tabs.newImpl.TabLabel;
import com.intellij.ui.tabs.newImpl.TabLayout;
import com.intellij.ui.tabs.newImpl.TabPainterAdapter;
import com.intellij.ui.tabs.newImpl.TabsSideSplitter;
import com.intellij.ui.tabs.newImpl.singleRow.ScrollableSingleRowLayout;
import com.intellij.ui.tabs.newImpl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.newImpl.singleRow.SingleRowPassInfo;
import com.intellij.ui.tabs.newImpl.table.TableLayout;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.Animator;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.LazyUiDisposable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsImpl
extends JComponent
implements JBTabsEx,
PropertyChangeListener,
TimerListener,
DataProvider,
PopupMenuListener,
Disposable,
JBTabsPresentation,
Queryable,
UISettingsListener,
QuickActionProvider,
Accessible {
    @NonNls
    public static final Key<Integer> SIDE_TABS_SIZE_LIMIT_KEY = Key.create((String)"SIDE_TABS_SIZE_LIMIT_KEY");
    static final int MIN_TAB_WIDTH = JBUIScale.scale((int)75);
    public static final int DEFAULT_MAX_TAB_WIDTH = JBUIScale.scale((int)300);
    public static final Color MAC_AQUA_BG_COLOR = Gray._200;
    private static final Comparator<TabInfo> ABC_COMPARATOR = (o1, o2) -> StringUtil.naturalCompare((String)o1.getText(), (String)o2.getText());
    @NotNull
    final ActionManager myActionManager;
    private final List<TabInfo> myVisibleInfos;
    private final Map<TabInfo, AccessibleTabPage> myInfo2Page;
    private final Map<TabInfo, Integer> myHiddenInfos;
    private TabInfo mySelectedInfo;
    public final Map<TabInfo, TabLabel> myInfo2Label;
    public final Map<TabInfo, Toolbar> myInfo2Toolbar;
    public Dimension myHeaderFitSize;
    private Insets myInnerInsets;
    private final List<EventListener> myTabMouseListeners;
    private final List<TabsListener> myTabListeners;
    private boolean myFocused;
    private Getter<? extends ActionGroup> myPopupGroup;
    private String myPopupPlace;
    TabInfo myPopupInfo;
    final DefaultActionGroup myNavigationActions;
    final PopupMenuListener myPopupListener;
    JPopupMenu myActivePopup;
    public boolean myHorizontalSide;
    private boolean myStealthTabMode;
    private boolean mySideComponentOnTabs;
    private boolean mySideComponentBefore;
    private boolean mySizeBySelected;
    private DataProvider myDataProvider;
    private final WeakHashMap<Component, Component> myDeferredToRemove;
    private SingleRowLayout mySingleRowLayout;
    private final TableLayout myTableLayout;
    private final TabsSideSplitter mySplitter;
    private TabLayout myLayout;
    private LayoutPassInfo myLastLayoutPass;
    private TabInfo myLastPaintedSelection;
    public boolean myForcedRelayout;
    private UiDecorator myUiDecorator;
    static final UiDecorator ourDefaultDecorator = new DefaultDecorator();
    private boolean myPaintFocus;
    private boolean myHideTabs;
    @Nullable
    private Project myProject;
    private boolean myRequestFocusOnLastFocusedComponent;
    private boolean myListenerAdded;
    final Set<TabInfo> myAttractions;
    private final Animator myAnimator;
    private List<TabInfo> myAllTabs;
    private IdeFocusManager myFocusManager;
    private static final boolean myAdjustBorders = true;
    boolean myAddNavigationGroup;
    private boolean myGhostsAlwaysVisible;
    private boolean myDisposed;
    private boolean myToDrawBorderIfTabsHidden;
    private Color myActiveTabFillIn;
    private boolean myTabLabelActionsAutoHide;
    private final TabActionsAutoHideListener myTabActionsAutoHideListener;
    private Disposable myTabActionsAutoHideListenerDisposable;
    private IdeGlassPane myGlassPane;
    @NonNls
    private static final String LAYOUT_DONE = "Layout.done";
    @NonNls
    public static final String STRETCHED_BY_WIDTH = "Layout.stretchedByWidth";
    private TimedDeadzone.Length myTabActionsMouseDeadzone;
    private long myRemoveDeferredRequest;
    private boolean myTestMode;
    private JBTabsPosition myPosition;
    private final JBTabsBorder myBorder;
    private final BaseNavigationAction myNextAction;
    private final BaseNavigationAction myPrevAction;
    private boolean myTabDraggingEnabled;
    private DragHelper myDragHelper;
    private boolean myNavigationActionsEnabled;
    private boolean myUseBufferedPaint;
    protected TabInfo myDropInfo;
    private int myDropInfoIndex;
    protected boolean myShowDropLocation;
    private TabInfo myOldSelection;
    private JBTabs.SelectionChangeHandler mySelectionChangeHandler;
    private Runnable myDeferredFocusRequest;
    private int myFirstTabOffset;
    protected final TabPainterAdapter myTabPainterAdapter;
    protected final JBTabPainter myTabPainter;
    private boolean myAlphabeticalMode;
    private boolean mySupportsCompression;
    private String myEmptyText;
    private boolean myMouseInsideTabsArea;
    private TabLabel tabLabelAtMouse;

    protected JBTabsBorder createTabBorder() {
        return new JBDefaultTabsBorder(this);
    }

    public JBTabPainter getTabPainter() {
        return this.myTabPainter;
    }

    public TabPainterAdapter getTabPainterAdapter() {
        return this.myTabPainterAdapter;
    }

    protected TabPainterAdapter createTabPainterAdapter() {
        return new DefaultTabPainterAdapter(JBTabPainter.getDEFAULT());
    }

    public JBTabsImpl(@NotNull Project project) {
        if (project == null) {
            JBTabsImpl.$$$reportNull$$$0(0);
        }
        this(project, project);
    }

    private JBTabsImpl(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            JBTabsImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JBTabsImpl.$$$reportNull$$$0(2);
        }
        this(project, ActionManager.getInstance(), IdeFocusManager.getInstance(project), parent);
    }

    public JBTabsImpl(@Nullable Project project, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (parent == null) {
            JBTabsImpl.$$$reportNull$$$0(3);
        }
        this(project, ActionManager.getInstance(), focusManager, parent);
    }

    public JBTabsImpl(@Nullable Project project, @NotNull ActionManager actionManager, IdeFocusManager focusManager, @NotNull Disposable parent) {
        if (actionManager == null) {
            JBTabsImpl.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            JBTabsImpl.$$$reportNull$$$0(5);
        }
        this.myVisibleInfos = new ArrayList<TabInfo>();
        this.myInfo2Page = new HashMap<TabInfo, AccessibleTabPage>();
        this.myHiddenInfos = new HashMap<TabInfo, Integer>();
        this.myInfo2Label = new HashMap<TabInfo, TabLabel>();
        this.myInfo2Toolbar = new HashMap<TabInfo, Toolbar>();
        this.myInnerInsets = JBUI.emptyInsets();
        this.myTabMouseListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myTabListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myHorizontalSide = true;
        this.myStealthTabMode = false;
        this.mySideComponentOnTabs = true;
        this.mySideComponentBefore = true;
        this.myDeferredToRemove = new WeakHashMap();
        this.myTableLayout = new TableLayout(this);
        this.mySplitter = new TabsSideSplitter(this);
        this.myHideTabs = false;
        this.myRequestFocusOnLastFocusedComponent = false;
        this.myAttractions = new HashSet<TabInfo>();
        this.myAddNavigationGroup = true;
        this.myGhostsAlwaysVisible = false;
        this.myToDrawBorderIfTabsHidden = true;
        this.myTabActionsAutoHideListener = new TabActionsAutoHideListener();
        this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable();
        this.myTabActionsMouseDeadzone = TimedDeadzone.DEFAULT;
        this.myPosition = JBTabsPosition.top;
        this.myBorder = this.createTabBorder();
        this.myNavigationActionsEnabled = true;
        this.myUseBufferedPaint = true;
        this.myShowDropLocation = true;
        this.myTabPainterAdapter = this.createTabPainterAdapter();
        this.myTabPainter = this.myTabPainterAdapter.getTabPainter();
        this.myAlphabeticalMode = false;
        this.mySupportsCompression = false;
        this.myEmptyText = null;
        this.myMouseInsideTabsArea = false;
        this.myProject = project;
        this.myActionManager = actionManager;
        this.myFocusManager = focusManager != null ? focusManager : IdeFocusManager.getGlobalInstance();
        this.setOpaque(true);
        this.setBackground(this.myTabPainter.getBackgroundColor());
        this.setBorder(this.myBorder);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myNavigationActions = new DefaultActionGroup();
        this.myNextAction = new SelectNextAction(this, this.myActionManager);
        this.myPrevAction = new SelectPreviousAction(this, this.myActionManager);
        this.myNavigationActions.add(this.myNextAction);
        this.myNavigationActions.add(this.myPrevAction);
        this.setUiDecorator(null);
        this.mySingleRowLayout = this.createSingleRowLayout();
        this.myLayout = this.mySingleRowLayout;
        if (JBTabsFactory.getUseNewTabs()) {
            OnePixelDivider divider = this.mySplitter.getDivider();
            divider.setOpaque(false);
        }
        this.myPopupListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                JBTabsImpl.this.disposePopupListener();
            }
        };
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect != null && ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.moreRect.contains(e.getPoint())) {
                    JBTabsImpl.this.showMorePopup(e);
                }
            }
        });
        this.addMouseWheelListener(event -> {
            int units = event.getUnitsToScroll();
            if (units == 0) {
                return;
            }
            if (this.mySingleRowLayout.myLastSingRowLayout != null) {
                this.mySingleRowLayout.scroll((int)(event.getPreciseWheelRotation() * (double)this.mySingleRowLayout.getScrollUnitIncrement()));
                this.revalidateAndRepaint(false);
            }
        });
        final AWTEventListener listener2 = new AWTEventListener(){
            final Alarm afterScroll;
            {
                this.afterScroll = new Alarm(JBTabsImpl.this);
            }

            @Override
            public void eventDispatched(AWTEvent event) {
                if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout == null) {
                    return;
                }
                MouseEvent me = (MouseEvent)event;
                Point point = me.getPoint();
                SwingUtilities.convertPointToScreen(point, me.getComponent());
                Rectangle rect = JBTabsImpl.this.getVisibleRect();
                rect = rect.intersection(((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myLastSingRowLayout.tabRectangle);
                Point p = rect.getLocation();
                SwingUtilities.convertPointToScreen(p, JBTabsImpl.this);
                rect.setLocation(p);
                boolean inside = rect.contains(point);
                if (inside != JBTabsImpl.this.myMouseInsideTabsArea) {
                    JBTabsImpl.this.myMouseInsideTabsArea = inside;
                    this.afterScroll.cancelAllRequests();
                    if (!inside) {
                        this.afterScroll.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                if (!JBTabsImpl.this.myMouseInsideTabsArea) {
                                    JBTabsImpl.this.doLayoutTwice();
                                }
                            }
                        }, 500);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 32L);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit != null) {
                    toolkit.removeAWTEventListener(listener2);
                }
            }
        });
        this.myAnimator = new Animator("JBTabs Attractions", 2, 500, true){

            @Override
            public void paintNow(int frame, int totalFrames, int cycle) {
                JBTabsImpl.this.repaintAttractions();
            }
        };
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTabsImpl.this.getToFocus();
            }
        });
        this.add(this.mySingleRowLayout.myLeftGhost);
        this.add(this.mySingleRowLayout.myRightGhost);
        new LazyUiDisposable<JBTabsImpl>(parent, (JComponent)this, this){

            @Override
            protected void initialize(@NotNull Disposable parent, @NotNull JBTabsImpl child, @Nullable Project project) {
                if (parent == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (child == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (JBTabsImpl.this.myProject == null && project != null) {
                    JBTabsImpl.this.myProject = project;
                }
                Disposer.register((Disposable)child, (Disposable)JBTabsImpl.this.myAnimator);
                Disposer.register((Disposable)child, (Disposable)new Disposable(){

                    public void dispose() {
                        JBTabsImpl.this.removeTimerUpdate();
                    }
                });
                if (!JBTabsImpl.this.myTestMode) {
                    IdeGlassPane gp = IdeGlassPaneUtil.find(child);
                    if (gp != null) {
                        JBTabsImpl.this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable((String)"myTabActionsAutoHideListener");
                        Disposer.register((Disposable)child, (Disposable)JBTabsImpl.this.myTabActionsAutoHideListenerDisposable);
                        gp.addMouseMotionPreprocessor(JBTabsImpl.this.myTabActionsAutoHideListener, JBTabsImpl.this.myTabActionsAutoHideListenerDisposable);
                        JBTabsImpl.this.myGlassPane = gp;
                    }
                    UIUtil.addAwtListener((AWTEventListener)new AWTEventListener(){

                        @Override
                        public void eventDispatched(AWTEvent event) {
                            if (((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup != null) {
                                return;
                            }
                            JBTabsImpl.this.processFocusChange();
                        }
                    }, (long)4L, (Disposable)child);
                    JBTabsImpl.this.myDragHelper = new DragHelper(child);
                    JBTabsImpl.this.myDragHelper.start();
                }
                if (JBTabsImpl.this.myProject != null && JBTabsImpl.this.myFocusManager == IdeFocusManager.getGlobalInstance()) {
                    JBTabsImpl.this.myFocusManager = IdeFocusManager.getInstance(JBTabsImpl.this.myProject);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "child";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/tabs/newImpl/JBTabsImpl$7";
                objectArray[2] = "initialize";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, (Object)new Iterable<JComponent>(){

            @Override
            public Iterator<JComponent> iterator() {
                return JBIterable.from(JBTabsImpl.this.getVisibleInfos()).filter(Conditions.not((Condition)Conditions.is((Object)JBTabsImpl.this.mySelectedInfo))).transform(info -> info.getComponent()).iterator();
            }
        });
    }

    public boolean isMouseInsideTabsArea() {
        return this.myMouseInsideTabsArea;
    }

    @Override
    public void uiSettingsChanged(UISettings uiSettings) {
        for (Map.Entry<TabInfo, TabLabel> entry : this.myInfo2Label.entrySet()) {
            entry.getKey().revalidate();
        }
        boolean oldHideTabsIfNeeded = this.mySingleRowLayout instanceof ScrollableSingleRowLayout;
        boolean newHideTabsIfNeeded = UISettings.getInstance().getHideTabsIfNeeded();
        if (oldHideTabsIfNeeded != newHideTabsIfNeeded) {
            this.updateRowLayout();
        }
    }

    private void updateRowLayout() {
        boolean wasSingleRow = this.isSingleRow();
        if (this.mySingleRowLayout != null) {
            this.remove(this.mySingleRowLayout.myLeftGhost);
            this.remove(this.mySingleRowLayout.myRightGhost);
        }
        this.mySingleRowLayout = this.createSingleRowLayout();
        if (wasSingleRow) {
            this.myLayout = this.mySingleRowLayout;
        }
        this.add(this.mySingleRowLayout.myLeftGhost);
        this.add(this.mySingleRowLayout.myRightGhost);
        this.relayout(true, true);
    }

    protected SingleRowLayout createSingleRowLayout() {
        return new SingleRowLayout(this);
    }

    @Override
    public JBTabs setNavigationActionBinding(String prevActionId, String nextActionId) {
        if (this.myNextAction != null) {
            this.myNextAction.reconnect(nextActionId);
        }
        if (this.myPrevAction != null) {
            this.myPrevAction.reconnect(prevActionId);
        }
        return this;
    }

    public void setHovered(TabLabel label) {
        TabLabel old = this.tabLabelAtMouse;
        this.tabLabelAtMouse = label;
        if (old != null) {
            old.repaint();
        }
        if (this.tabLabelAtMouse != null) {
            this.tabLabelAtMouse.repaint();
        }
    }

    public void unHover(TabLabel label) {
        if (this.tabLabelAtMouse == label) {
            this.tabLabelAtMouse = null;
            label.repaint();
        }
    }

    protected boolean isHoveredTab(TabLabel label) {
        return label != null && label == this.tabLabelAtMouse;
    }

    protected boolean isActiveTabs(TabInfo info) {
        return UIUtil.isFocusAncestor((Component)this);
    }

    @Override
    public boolean isEditorTabs() {
        return false;
    }

    public boolean supportsCompression() {
        return this.mySupportsCompression;
    }

    @Override
    public JBTabs setNavigationActionsEnabled(boolean enabled) {
        this.myNavigationActionsEnabled = enabled;
        return this;
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposed;
    }

    public static Image getComponentImage(TabInfo info) {
        BufferedImage img;
        JComponent cmp = info.getComponent();
        if (cmp.isShowing()) {
            int width = cmp.getWidth();
            int height = cmp.getHeight();
            img = UIUtil.createImage((Component)info.getComponent(), (int)(width > 0 ? width : 500), (int)(height > 0 ? height : 500), (int)2);
            Graphics2D g = img.createGraphics();
            cmp.paint(g);
        } else {
            img = UIUtil.createImage((Component)info.getComponent(), (int)500, (int)500, (int)2);
        }
        return img;
    }

    public void dispose() {
        this.myDisposed = true;
        this.mySelectedInfo = null;
        this.myDeferredFocusRequest = null;
        this.resetTabsCache();
        this.myAttractions.clear();
        this.myVisibleInfos.clear();
        this.myUiDecorator = null;
        this.myActivePopup = null;
        this.myInfo2Label.clear();
        this.myInfo2Page.clear();
        this.myInfo2Toolbar.clear();
        this.myTabListeners.clear();
        this.myLastLayoutPass = null;
    }

    protected void resetTabsCache() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAllTabs = null;
    }

    private void processFocusChange() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (owner == null) {
            this.setFocused(false);
            return;
        }
        if (owner == this || SwingUtilities.isDescendingFrom(owner, this)) {
            this.setFocused(true);
        } else {
            this.setFocused(false);
        }
    }

    private void repaintAttractions() {
        boolean needsUpdate = false;
        for (TabInfo each : this.myVisibleInfos) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            needsUpdate |= eachLabel.repaintAttraction();
        }
        if (needsUpdate) {
            this.relayout(true, false);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addTimerUpdate();
        if (this.myDeferredFocusRequest != null) {
            Runnable request = this.myDeferredFocusRequest;
            this.myDeferredFocusRequest = null;
            request.run();
        }
    }

    @Override
    public void removeNotify() {
        try {
            super.removeNotify();
        }
        catch (Exception e) {
            GuiUtils.printDebugInfo(this);
        }
        this.setFocused(false);
        this.removeTimerUpdate();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this) && this.myGlassPane != null) {
            Disposer.dispose((Disposable)this.myTabActionsAutoHideListenerDisposable);
            this.myTabActionsAutoHideListenerDisposable = Disposer.newDisposable();
            this.myGlassPane = null;
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
    }

    private void addTimerUpdate() {
        if (!this.myListenerAdded) {
            this.myActionManager.addTimerListener(500, this);
            this.myListenerAdded = true;
        }
    }

    private void removeTimerUpdate() {
        if (this.myListenerAdded) {
            this.myActionManager.removeTimerListener(this);
            this.myListenerAdded = false;
        }
    }

    void setTestMode(boolean testMode) {
        this.myTestMode = testMode;
    }

    public void layoutComp(SingleRowPassInfo data, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        JComponent hToolbar = (JComponent)data.hToolbar.get();
        JComponent vToolbar = (JComponent)data.vToolbar.get();
        if (hToolbar != null) {
            int toolbarHeight = hToolbar.getPreferredSize().height;
            int hSeparatorHeight = toolbarHeight > 0 ? 1 : 0;
            Rectangle compRect = this.layoutComp(deltaX, toolbarHeight + hSeparatorHeight + deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
            this.layout(hToolbar, compRect.x, compRect.y - toolbarHeight - hSeparatorHeight, compRect.width, toolbarHeight);
        } else if (vToolbar != null) {
            int vSeparatorWidth;
            int toolbarWidth = vToolbar.getPreferredSize().width;
            int n = vSeparatorWidth = toolbarWidth > 0 ? 1 : 0;
            if (this.mySideComponentBefore) {
                Rectangle compRect = this.layoutComp(toolbarWidth + vSeparatorWidth + deltaX, deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
                this.layout(vToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            } else {
                Rectangle compRect = this.layoutComp(new Rectangle(deltaX, deltaY, this.getWidth() - toolbarWidth - vSeparatorWidth, this.getHeight()), (JComponent)data.comp.get(), deltaWidth, deltaHeight);
                this.layout(vToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
            }
        } else {
            this.layoutComp(deltaX, deltaY, (JComponent)data.comp.get(), deltaWidth, deltaHeight);
        }
    }

    public boolean isDropTarget(TabInfo info) {
        return this.myDropInfo != null && this.myDropInfo == info;
    }

    protected void setDropInfoIndex(int dropInfoIndex) {
        this.myDropInfoIndex = dropInfoIndex;
    }

    public int getFirstTabOffset() {
        return this.myFirstTabOffset;
    }

    @Override
    public void setFirstTabOffset(int firstTabOffset) {
        this.myFirstTabOffset = firstTabOffset;
    }

    @Override
    public JBTabsPresentation setEmptyText(@Nullable String text) {
        this.myEmptyText = text;
        return this;
    }

    public int tabMSize() {
        return 20;
    }

    @Override
    public ModalityState getModalityState() {
        return ModalityState.stateForComponent(this);
    }

    @Override
    public void run() {
        this.updateTabActions(false);
    }

    @Override
    public void updateTabActions(boolean validateNow) {
        Ref changed = new Ref((Object)Boolean.FALSE);
        for (TabInfo eachInfo : this.myInfo2Label.keySet()) {
            boolean changes = this.myInfo2Label.get(eachInfo).updateTabActions();
            changed.set((Object)((Boolean)changed.get() != false || changes ? 1 : 0));
        }
        if (((Boolean)changed.get()).booleanValue()) {
            this.revalidateAndRepaint();
        }
    }

    @Override
    public boolean canShowMorePopup() {
        SingleRowPassInfo lastLayout = this.mySingleRowLayout.myLastSingRowLayout;
        return lastLayout != null && lastLayout.moreRect != null;
    }

    @Override
    public void showMorePopup(@Nullable MouseEvent e) {
        SingleRowPassInfo lastLayout = this.mySingleRowLayout.myLastSingRowLayout;
        if (lastLayout == null) {
            return;
        }
        this.mySingleRowLayout.myMorePopup = new JBPopupMenu();
        for (final TabInfo each : this.getVisibleInfos()) {
            if (!this.mySingleRowLayout.isTabHidden(each)) continue;
            JBMenuItem item = new JBMenuItem(each.getText(), each.getIcon());
            item.setForeground(each.getDefaultForeground());
            item.setBackground(each.getTabColor());
            this.mySingleRowLayout.myMorePopup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JBTabsImpl.this.select(each, true);
                }
            });
        }
        this.mySingleRowLayout.myMorePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                ((JBTabsImpl)JBTabsImpl.this).mySingleRowLayout.myMorePopup = null;
            }
        });
        if (e != null) {
            this.mySingleRowLayout.myMorePopup.show(this, e.getX(), e.getY());
        } else {
            Rectangle rect = lastLayout.moreRect;
            if (rect != null) {
                this.mySingleRowLayout.myMorePopup.show(this, rect.x, rect.y + rect.height);
            }
        }
    }

    @Nullable
    private JComponent getToFocus() {
        JComponent policyToFocus;
        TabInfo info = this.getSelectedInfo();
        if (info == null) {
            return null;
        }
        JComponent toFocus = null;
        if (this.isRequestFocusOnLastFocusedComponent() && info.getLastFocusOwner() != null && !this.isMyChildIsFocusedNow()) {
            toFocus = info.getLastFocusOwner();
        }
        if (toFocus == null && info.getPreferredFocusableComponent() == null) {
            return null;
        }
        if (toFocus == null && (policyToFocus = this.myFocusManager.getFocusTargetFor(toFocus = info.getPreferredFocusableComponent())) != null) {
            toFocus = policyToFocus;
        }
        return toFocus;
    }

    @Override
    public void requestFocus() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(toFocus, true));
        } else {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> super.requestFocus());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent toFocus = this.getToFocus();
        if (toFocus != null) {
            return toFocus.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    @Override
    @NotNull
    public TabInfo addTab(TabInfo info, int index) {
        TabInfo tabInfo = this.addTab(info, index, false, true);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(6);
        }
        return tabInfo;
    }

    @Override
    public TabInfo addTabSilently(TabInfo info, int index) {
        return this.addTab(info, index, false, false);
    }

    private TabInfo addTab(TabInfo info, int index, boolean isDropTarget, boolean fireEvents) {
        if (!isDropTarget && this.getTabs().contains(info)) {
            return this.getTabs().get(this.getTabs().indexOf(info));
        }
        info.getChangeSupport().addPropertyChangeListener(this);
        TabLabel label = this.createTabLabel(info);
        Disposer.register((Disposable)this, (Disposable)label);
        this.myInfo2Label.put(info, label);
        this.myInfo2Page.put(info, new AccessibleTabPage(info));
        if (!isDropTarget) {
            if (index < 0 || index > this.myVisibleInfos.size() - 1) {
                this.myVisibleInfos.add(info);
            } else {
                this.myVisibleInfos.add(index, info);
            }
        }
        this.resetTabsCache();
        this.updateText(info);
        this.updateIcon(info);
        this.updateSideComponent(info);
        this.updateTabActions(info);
        this.add(label);
        this.adjust(info);
        this.updateAll(false, false);
        if (info.isHidden()) {
            this.updateHiding();
        }
        if (!isDropTarget && fireEvents && this.getTabCount() == 1) {
            this.fireBeforeSelectionChanged(null, info);
            this.fireSelectionChanged(null, info);
        }
        this.revalidateAndRepaint(false);
        return info;
    }

    private void doLayoutTwice() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.doLayout();
            ApplicationManager.getApplication().invokeLater(() -> this.doLayout());
        });
    }

    protected TabLabel createTabLabel(TabInfo info) {
        return new TabLabel(this, info);
    }

    @Override
    @NotNull
    public TabInfo addTab(TabInfo info) {
        TabInfo tabInfo = this.addTab(info, -1);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(7);
        }
        return tabInfo;
    }

    @Override
    public TabLabel getTabLabel(TabInfo info) {
        return this.myInfo2Label.get(info);
    }

    @Nullable
    public ActionGroup getPopupGroup() {
        return this.myPopupGroup != null ? (ActionGroup)this.myPopupGroup.get() : null;
    }

    public String getPopupPlace() {
        return this.myPopupPlace;
    }

    @Override
    @NotNull
    public JBTabs setPopupGroup(@NotNull ActionGroup popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            JBTabsImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            JBTabsImpl.$$$reportNull$$$0(9);
        }
        JBTabs jBTabs = this.setPopupGroup((Getter<? extends ActionGroup>)((Getter)() -> popupGroup), place, addNavigationGroup);
        if (jBTabs == null) {
            JBTabsImpl.$$$reportNull$$$0(10);
        }
        return jBTabs;
    }

    @Override
    @NotNull
    public JBTabs setPopupGroup(@NotNull Getter<? extends ActionGroup> popupGroup, @NotNull String place, boolean addNavigationGroup) {
        if (popupGroup == null) {
            JBTabsImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JBTabsImpl.$$$reportNull$$$0(12);
        }
        this.myPopupGroup = popupGroup;
        this.myPopupPlace = place;
        this.myAddNavigationGroup = addNavigationGroup;
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(13);
        }
        return jBTabsImpl;
    }

    private void updateAll(boolean forcedRelayout, boolean now) {
        this.mySelectedInfo = this.getSelectedInfo();
        this.updateContainer(forcedRelayout, now);
        this.removeDeferred();
        this.updateListeners();
        this.updateTabActions(false);
        this.updateEnabling();
    }

    private boolean isMyChildIsFocusedNow() {
        JComponent owner = JBTabsImpl.getFocusOwner();
        if (owner == null) {
            return false;
        }
        if (this.mySelectedInfo != null && !SwingUtilities.isDescendingFrom(owner, this.mySelectedInfo.getComponent())) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(owner, this);
    }

    @Nullable
    private static JComponent getFocusOwner() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return (JComponent)(owner instanceof JComponent ? owner : null);
    }

    @Override
    @NotNull
    public ActionCallback select(@NotNull TabInfo info, boolean requestFocus) {
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(14);
        }
        ActionCallback actionCallback = this._setSelected(info, requestFocus);
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(15);
        }
        return actionCallback;
    }

    @NotNull
    private ActionCallback _setSelected(final TabInfo info, final boolean requestFocus) {
        if (!this.isEnabled()) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(16);
            }
            return actionCallback;
        }
        if (this.mySelectionChangeHandler != null) {
            ActionCallback actionCallback = this.mySelectionChangeHandler.execute(info, requestFocus, new ActiveRunnable(){

                @NotNull
                public ActionCallback run() {
                    ActionCallback actionCallback = JBTabsImpl.this.executeSelectionChange(info, requestFocus);
                    if (actionCallback == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    return actionCallback;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/newImpl/JBTabsImpl$11", "run"));
                }
            });
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(17);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.executeSelectionChange(info, requestFocus);
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(18);
        }
        return actionCallback;
    }

    @NotNull
    private ActionCallback executeSelectionChange(TabInfo info, boolean requestFocus) {
        if (this.mySelectedInfo != null && this.mySelectedInfo.equals(info)) {
            if (!requestFocus) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    JBTabsImpl.$$$reportNull$$$0(19);
                }
                return actionCallback;
            }
            Component owner = this.myFocusManager.getFocusOwner();
            JComponent c = info.getComponent();
            if (c != null && owner != null && (c == owner || SwingUtilities.isDescendingFrom(owner, c))) {
                ActionCallback actionCallback = ActionCallback.DONE;
                if (actionCallback == null) {
                    JBTabsImpl.$$$reportNull$$$0(20);
                }
                return actionCallback;
            }
            ActionCallback actionCallback = this.requestFocus(this.getToFocus());
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(21);
            }
            return actionCallback;
        }
        if (this.myRequestFocusOnLastFocusedComponent && this.mySelectedInfo != null && this.isMyChildIsFocusedNow()) {
            this.mySelectedInfo.setLastFocusOwner(JBTabsImpl.getFocusOwner());
        }
        TabInfo oldInfo = this.mySelectedInfo;
        this.mySelectedInfo = info;
        TabInfo newInfo = this.getSelectedInfo();
        TabLabel label = this.myInfo2Label.get(info);
        if (label != null) {
            this.setComponentZOrder(label, 0);
        }
        this.fireBeforeSelectionChanged(oldInfo, newInfo);
        this.updateContainer(false, true);
        this.fireSelectionChanged(oldInfo, newInfo);
        if (requestFocus) {
            JComponent toFocus = this.getToFocus();
            if (this.myProject != null && toFocus != null) {
                ActionCallback result = new ActionCallback();
                this.requestFocus(toFocus).doWhenProcessed(() -> {
                    if (this.myDisposed) {
                        result.setRejected();
                    } else {
                        this.removeDeferred().notifyWhenDone(result);
                    }
                });
                ActionCallback actionCallback = result;
                if (actionCallback == null) {
                    JBTabsImpl.$$$reportNull$$$0(22);
                }
                return actionCallback;
            }
            this.requestFocus();
            ActionCallback actionCallback = this.removeDeferred();
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(23);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.removeDeferred();
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(24);
        }
        return actionCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBeforeSelectionChanged(@Nullable TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            this.myOldSelection = oldInfo;
            try {
                for (TabsListener eachListener : this.myTabListeners) {
                    eachListener.beforeSelectionChanged(oldInfo, newInfo);
                }
            }
            finally {
                this.myOldSelection = null;
            }
        }
    }

    private void fireSelectionChanged(@Nullable TabInfo oldInfo, TabInfo newInfo) {
        if (oldInfo != newInfo) {
            for (TabsListener eachListener : this.myTabListeners) {
                if (eachListener == null) continue;
                eachListener.selectionChanged(oldInfo, newInfo);
            }
        }
    }

    void fireTabsMoved() {
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabsMoved();
        }
    }

    void fireTabRemoved(@NotNull TabInfo info) {
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(25);
        }
        for (TabsListener eachListener : this.myTabListeners) {
            if (eachListener == null) continue;
            eachListener.tabRemoved(info);
        }
    }

    @NotNull
    private ActionCallback requestFocus(JComponent toFocus) {
        if (toFocus == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(26);
            }
            return actionCallback;
        }
        if (this.myTestMode) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(toFocus, true));
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(27);
            }
            return actionCallback;
        }
        if (this.isShowing()) {
            ActionCallback actionCallback = this.myFocusManager.requestFocus(toFocus, true);
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(28);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.REJECTED;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(29);
        }
        return actionCallback;
    }

    @NotNull
    private ActionCallback removeDeferred() {
        if (this.myDeferredToRemove.isEmpty()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(30);
            }
            return actionCallback;
        }
        ActionCallback callback = new ActionCallback();
        long executionRequest = ++this.myRemoveDeferredRequest;
        Runnable onDone = () -> {
            if (this.myRemoveDeferredRequest == executionRequest) {
                this.removeDeferredNow();
            }
            callback.setDone();
        };
        this.myFocusManager.doWhenFocusSettlesDown(onDone);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(31);
        }
        return actionCallback;
    }

    private void queueForRemove(Component c) {
        if (c instanceof JComponent) {
            this.addToDeferredRemove(c);
        } else {
            this.remove(c);
        }
    }

    private void unqueueFromRemove(Component c) {
        this.myDeferredToRemove.remove(c);
    }

    private void removeDeferredNow() {
        for (Component each : this.myDeferredToRemove.keySet()) {
            if (each == null || each.getParent() != this) continue;
            this.remove(each);
        }
        this.myDeferredToRemove.clear();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        TabInfo tabInfo = (TabInfo)evt.getSource();
        if ("actionGroup".equals(evt.getPropertyName())) {
            this.updateSideComponent(tabInfo);
            this.relayout(false, false);
        } else if ("component".equals(evt.getPropertyName())) {
            this.relayout(true, false);
        } else if ("text".equals(evt.getPropertyName())) {
            this.updateText(tabInfo);
        } else if ("icon".equals(evt.getPropertyName())) {
            this.updateIcon(tabInfo);
            this.doLayoutTwice();
        } else if ("color".equals(evt.getPropertyName())) {
            this.updateColor(tabInfo);
        } else if ("alertStatus".equals(evt.getPropertyName())) {
            boolean start = (Boolean)evt.getNewValue();
            this.updateAttraction(tabInfo, start);
        } else if ("tabActionGroup".equals(evt.getPropertyName())) {
            this.updateTabActions(tabInfo);
            this.relayout(false, false);
        } else if ("hidden".equals(evt.getPropertyName())) {
            this.updateHiding();
            this.relayout(false, false);
        } else if ("enabled".equals(evt.getPropertyName())) {
            this.updateEnabling();
        }
    }

    private void updateEnabling() {
        TabInfo toSelect;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.setTabEnabled(each.isEnabled());
        }
        TabInfo selected = this.getSelectedInfo();
        if (selected != null && !selected.isEnabled() && (toSelect = this.getToSelectOnRemoveOf(selected)) != null) {
            this.select(toSelect, this.myFocusManager.getFocusedDescendantFor(this) != null);
        }
    }

    private void updateHiding() {
        boolean update = false;
        Iterator<TabInfo> visible = this.myVisibleInfos.iterator();
        while (visible.hasNext()) {
            TabInfo each = visible.next();
            if (!each.isHidden() || this.myHiddenInfos.containsKey(each)) continue;
            this.myHiddenInfos.put(each, this.myVisibleInfos.indexOf(each));
            visible.remove();
            update = true;
        }
        Iterator<TabInfo> hidden = this.myHiddenInfos.keySet().iterator();
        while (hidden.hasNext()) {
            TabInfo each = hidden.next();
            if (each.isHidden() || !this.myHiddenInfos.containsKey(each)) continue;
            this.myVisibleInfos.add(this.getIndexInVisibleArray(each), each);
            hidden.remove();
            update = true;
        }
        if (update) {
            this.resetTabsCache();
            if (this.mySelectedInfo != null && this.myHiddenInfos.containsKey(this.mySelectedInfo)) {
                this.mySelectedInfo = this.getToSelectOnRemoveOf(this.mySelectedInfo);
            }
            this.updateAll(true, false);
        }
    }

    private int getIndexInVisibleArray(TabInfo each) {
        Integer index = this.myHiddenInfos.get(each);
        if (index == null) {
            index = this.myVisibleInfos.size();
        }
        if (index > this.myVisibleInfos.size()) {
            index = this.myVisibleInfos.size();
        }
        if (index < 0) {
            index = 0;
        }
        return index;
    }

    private void updateIcon(TabInfo tabInfo) {
        this.myInfo2Label.get(tabInfo).setIcon(tabInfo.getIcon());
        this.revalidateAndRepaint();
    }

    private void updateColor(TabInfo tabInfo) {
        this.revalidateAndRepaint();
    }

    public void revalidateAndRepaint() {
        this.revalidateAndRepaint(true);
    }

    void revalidateAndRepaint(boolean layoutNow) {
        if (this.myVisibleInfos.isEmpty()) {
            this.setOpaque(false);
            Component nonOpaque = UIUtil.findUltimateParent((Component)this);
            if (nonOpaque != null && this.getParent() != null) {
                Rectangle toRepaint = SwingUtilities.convertRectangle(this.getParent(), this.getBounds(), nonOpaque);
                nonOpaque.repaint(toRepaint.x, toRepaint.y, toRepaint.width, toRepaint.height);
            }
        } else {
            this.setOpaque(true);
        }
        if (layoutNow) {
            this.validate();
        } else {
            this.revalidate();
        }
        this.repaint();
    }

    private void updateAttraction(TabInfo tabInfo, boolean start) {
        if (start) {
            this.myAttractions.add(tabInfo);
        } else {
            this.myAttractions.remove(tabInfo);
            tabInfo.setBlinkCount(0);
        }
        if (start && !this.myAnimator.isRunning()) {
            this.myAnimator.resume();
        } else if (!start && this.myAttractions.isEmpty()) {
            this.myAnimator.suspend();
            this.repaintAttractions();
        }
    }

    private void updateText(TabInfo tabInfo) {
        TabLabel label = this.myInfo2Label.get(tabInfo);
        label.setText(tabInfo.getColoredText());
        label.setToolTipText(tabInfo.getTooltipText());
        this.revalidateAndRepaint();
    }

    private void updateSideComponent(TabInfo tabInfo) {
        Toolbar old = this.myInfo2Toolbar.get(tabInfo);
        if (old != null) {
            this.remove(old);
        }
        Toolbar toolbar = this.createToolbarComponent(tabInfo);
        this.myInfo2Toolbar.put(tabInfo, toolbar);
        this.add(toolbar);
    }

    private void updateTabActions(TabInfo info) {
        this.myInfo2Label.get(info).setTabActions(info.getTabLabelActions());
    }

    @Override
    @Nullable
    public TabInfo getSelectedInfo() {
        if (this.myOldSelection != null) {
            return this.myOldSelection;
        }
        if (!this.myVisibleInfos.contains(this.mySelectedInfo)) {
            this.mySelectedInfo = null;
        }
        return this.mySelectedInfo != null ? this.mySelectedInfo : (!this.myVisibleInfos.isEmpty() ? this.myVisibleInfos.get(0) : null);
    }

    @Override
    @Nullable
    public TabInfo getToSelectOnRemoveOf(TabInfo info) {
        if (!this.myVisibleInfos.contains(info)) {
            return null;
        }
        if (this.mySelectedInfo != info) {
            return null;
        }
        if (this.myVisibleInfos.size() == 1) {
            return null;
        }
        int index = this.getVisibleInfos().indexOf(info);
        TabInfo result = null;
        if (index > 0) {
            result = this.findEnabledBackward(index, false);
        }
        if (result == null) {
            result = this.findEnabledForward(index, false);
        }
        return result;
    }

    @Nullable
    protected TabInfo findEnabledForward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (++index == infos.size()) {
                    if (!cycle) break block3;
                    index = 0;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    public boolean isAlphabeticalMode() {
        return this.myAlphabeticalMode;
    }

    @Nullable
    protected TabInfo findEnabledBackward(int from, boolean cycle) {
        block3: {
            TabInfo each;
            if (from < 0) {
                return null;
            }
            int index = from;
            List<TabInfo> infos = this.getVisibleInfos();
            do {
                if (--index == -1) {
                    if (!cycle) break block3;
                    index = infos.size() - 1;
                }
                if (index == from) break block3;
            } while (!(each = infos.get(index)).isEnabled());
            return each;
        }
        return null;
    }

    protected Toolbar createToolbarComponent(TabInfo tabInfo) {
        return new Toolbar(this, tabInfo);
    }

    @Override
    @NotNull
    public TabInfo getTabAt(int tabIndex) {
        TabInfo tabInfo = this.getTabs().get(tabIndex);
        if (tabInfo == null) {
            JBTabsImpl.$$$reportNull$$$0(32);
        }
        return tabInfo;
    }

    @Override
    @NotNull
    public List<TabInfo> getTabs() {
        if (this.myAllTabs != null) {
            List<TabInfo> list = this.myAllTabs;
            if (list == null) {
                JBTabsImpl.$$$reportNull$$$0(33);
            }
            return list;
        }
        ArrayList<TabInfo> result = new ArrayList<TabInfo>(this.myVisibleInfos);
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            result.add(this.getIndexInVisibleArray(each), each);
        }
        if (this.isAlphabeticalMode()) {
            Collections.sort(result, ABC_COMPARATOR);
        }
        this.myAllTabs = result;
        ArrayList<TabInfo> arrayList = result;
        if (arrayList == null) {
            JBTabsImpl.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @Override
    public TabInfo getTargetInfo() {
        return this.myPopupInfo != null ? this.myPopupInfo : this.getSelectedInfo();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.resetPopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.resetPopup();
    }

    private void resetPopup() {
        SwingUtilities.invokeLater(() -> {
            if (this.myActivePopup == null) {
                this.myPopupInfo = null;
            }
        });
    }

    @Override
    public void setPaintBlocked(boolean blocked, boolean takeSnapshot) {
    }

    private void addToDeferredRemove(Component c) {
        if (!this.myDeferredToRemove.containsKey(c)) {
            this.myDeferredToRemove.put(c, c);
        }
    }

    private boolean isToDrawBorderIfTabsHidden() {
        return this.myToDrawBorderIfTabsHidden;
    }

    @Override
    @NotNull
    public JBTabsPresentation setToDrawBorderIfTabsHidden(boolean toDrawBorderIfTabsHidden) {
        this.myToDrawBorderIfTabsHidden = toDrawBorderIfTabsHidden;
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(35);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabs getJBTabs() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(36);
        }
        return jBTabsImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.myHeaderFitSize = this.computeHeaderFitSize();
            Collection<TabLabel> labels = this.myInfo2Label.values();
            for (TabLabel each : labels) {
                each.setTabActionsAutoHide(this.myTabLabelActionsAutoHide);
            }
            ArrayList<TabInfo> visible = new ArrayList<TabInfo>(this.getVisibleInfos());
            if (this.myDropInfo != null && !visible.contains(this.myDropInfo) && this.myShowDropLocation) {
                if (this.getDropInfoIndex() >= 0 && this.getDropInfoIndex() < visible.size()) {
                    visible.add(this.getDropInfoIndex(), this.myDropInfo);
                } else {
                    visible.add(this.myDropInfo);
                }
            }
            if (this.isSingleRow()) {
                this.mySingleRowLayout.scrollSelectionInView();
                this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow(visible);
                this.mySingleRowLayout.scrollSelectionInView();
                this.myLastLayoutPass = this.mySingleRowLayout.layoutSingleRow(visible);
                this.myTableLayout.myLastTableLayout = null;
                OnePixelDivider divider = this.mySplitter.getDivider();
                if (divider.getParent() == this) {
                    int location = this.getTabsPosition() == JBTabsPosition.left ? this.mySingleRowLayout.myLastSingRowLayout.tabRectangle.width : this.getWidth() - this.mySingleRowLayout.myLastSingRowLayout.tabRectangle.width;
                    divider.setBounds(location, 0, 1, this.getHeight());
                }
            } else {
                this.myLastLayoutPass = this.myTableLayout.layoutTable(visible);
                this.mySingleRowLayout.myLastSingRowLayout = null;
            }
            if (this.isStealthModeEffective() && !this.isHideTabs()) {
                TabLabel label = this.getSelectedLabel();
                Rectangle bounds = label.getBounds();
                Insets insets = this.getLayoutInsets();
                this.layout(label, insets.left, bounds.y, this.getWidth() - insets.right - insets.left, bounds.height);
            }
            this.moveDraggedTabLabel();
            this.myTabActionsAutoHideListener.processMouseOver();
        }
        finally {
            this.myForcedRelayout = false;
        }
        this.applyResetComponents();
    }

    void moveDraggedTabLabel() {
        TabLabel selectedLabel;
        if (this.myDragHelper != null && this.myDragHelper.myDragRec != null && (selectedLabel = this.myInfo2Label.get(this.getSelectedInfo())) != null) {
            Rectangle bounds = selectedLabel.getBounds();
            if (this.isHorizontalTabs()) {
                selectedLabel.setBounds(this.myDragHelper.myDragRec.x, bounds.y, bounds.width, bounds.height);
            } else {
                selectedLabel.setBounds(bounds.x, this.myDragHelper.myDragRec.y, bounds.width, bounds.height);
            }
        }
    }

    private Dimension computeHeaderFitSize() {
        Max max = this.computeMaxSize();
        if (this.myPosition == JBTabsPosition.top || this.myPosition == JBTabsPosition.bottom) {
            return new Dimension(this.getSize().width, this.myHorizontalSide ? Math.max(max.myLabel.height, max.myToolbar.height) : max.myLabel.height);
        }
        return new Dimension(max.myLabel.width + (this.myHorizontalSide ? 0 : max.myToolbar.width), this.getSize().height);
    }

    public Rectangle layoutComp(int componentX, int componentY, JComponent comp, int deltaWidth, int deltaHeight) {
        return this.layoutComp(new Rectangle(componentX, componentY, this.getWidth(), this.getHeight()), comp, deltaWidth, deltaHeight);
    }

    public Rectangle layoutComp(Rectangle bounds, JComponent comp, int deltaWidth, int deltaHeight) {
        boolean noTabsVisible;
        Insets insets = this.getLayoutInsets();
        Insets inner = this.getInnerInsets();
        int x = insets.left + bounds.x + inner.left;
        int y = insets.top + bounds.y + inner.top;
        int width = bounds.width - insets.left - insets.right - bounds.x - inner.left - inner.right;
        int height = bounds.height - insets.top - insets.bottom - bounds.y - inner.top - inner.bottom;
        boolean bl = noTabsVisible = this.isStealthModeEffective() || this.isHideTabs();
        if (!noTabsVisible) {
            width += deltaWidth;
            height += deltaHeight;
        }
        return this.layout(comp, x, y, width, height);
    }

    @Override
    public JBTabsPresentation setInnerInsets(Insets innerInsets) {
        this.myInnerInsets = innerInsets;
        return this;
    }

    private Insets getInnerInsets() {
        return this.myInnerInsets;
    }

    public Insets getLayoutInsets() {
        return this.myBorder.getEffectiveBorder();
    }

    public int getToolbarInset() {
        return JBTabsImpl.getArcSize() + 1;
    }

    public void resetLayout(boolean resetLabels) {
        if (resetLabels) {
            this.mySingleRowLayout.myLeftGhost.reset();
            this.mySingleRowLayout.myRightGhost.reset();
        }
        for (TabInfo each : this.myVisibleInfos) {
            this.reset(each, resetLabels);
        }
        if (this.myDropInfo != null) {
            this.reset(this.myDropInfo, resetLabels);
        }
        for (TabInfo each : this.myHiddenInfos.keySet()) {
            this.reset(each, resetLabels);
        }
        for (Component eachDeferred : this.myDeferredToRemove.keySet()) {
            JBTabsImpl.resetLayout((JComponent)eachDeferred);
        }
    }

    private void reset(TabInfo each, boolean resetLabels) {
        JComponent c = each.getComponent();
        if (c != null) {
            JBTabsImpl.resetLayout(c);
        }
        JBTabsImpl.resetLayout(this.myInfo2Toolbar.get(each));
        if (resetLabels) {
            JBTabsImpl.resetLayout(this.myInfo2Label.get(each));
        }
    }

    private static int getArcSize() {
        return 4;
    }

    public int getGhostTabLength() {
        return 15;
    }

    protected JBTabsPosition getPosition() {
        return this.myPosition;
    }

    @Deprecated
    protected void doPaintBackground(Graphics2D g2d, Rectangle clip) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myVisibleInfos.isEmpty()) {
            if (this.myEmptyText != null) {
                UISettings.setupAntialiasing(g);
                UIUtil.drawCenteredString((Graphics2D)((Graphics2D)g), (Rectangle)this.getBounds(), (String)this.myEmptyText);
            }
            return;
        }
        this.myTabPainter.fillBackground((Graphics2D)g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        this.drawBorder(g);
        if (!this.isStealthModeEffective() && !this.isHideTabs()) {
            this.myLastPaintedSelection = this.getSelectedInfo();
        }
    }

    protected TabLabel getSelectedLabel() {
        return this.myInfo2Label.get(this.getSelectedInfo());
    }

    protected List<TabInfo> getVisibleInfos() {
        if (!this.isAlphabeticalMode()) {
            return this.myVisibleInfos;
        }
        ArrayList<TabInfo> sortedCopy = new ArrayList<TabInfo>(this.myVisibleInfos);
        Collections.sort(sortedCopy, ABC_COMPARATOR);
        return sortedCopy;
    }

    protected LayoutPassInfo getLastLayoutPass() {
        return this.myLastLayoutPass;
    }

    public static int getSelectionTabVShift() {
        return 2;
    }

    protected boolean isStealthModeEffective() {
        return this.myStealthTabMode && this.getTabCount() == 1 && (this.isSideComponentVertical() || !this.isSideComponentOnTabs()) && this.getTabsPosition() == JBTabsPosition.top;
    }

    private boolean isNavigationVisible() {
        if (this.myStealthTabMode && this.getTabCount() == 1) {
            return false;
        }
        return !this.myVisibleInfos.isEmpty();
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.mySingleRowLayout.myMoreIcon.paintIcon(this, g);
    }

    protected void drawBorder(Graphics g) {
        this.myBorder.paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
    }

    private Max computeMaxSize() {
        Max max = new Max();
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            max.myLabel.height = Math.max(max.myLabel.height, label.getPreferredSize().height);
            max.myLabel.width = Math.max(max.myLabel.width, label.getPreferredSize().width);
            Toolbar toolbar = this.myInfo2Toolbar.get(eachInfo);
            if (!this.myLayout.isSideComponentOnTabs() || toolbar == null || toolbar.isEmpty()) continue;
            max.myToolbar.height = Math.max(max.myToolbar.height, toolbar.getPreferredSize().height);
            max.myToolbar.width = Math.max(max.myToolbar.width, toolbar.getPreferredSize().width);
        }
        if ((this.getTabsPosition() == JBTabsPosition.left || this.getTabsPosition() == JBTabsPosition.right) && this.mySplitter.getSideTabsLimit() > 0) {
            max.myLabel.width = Math.min(max.myLabel.width, this.mySplitter.getSideTabsLimit());
        }
        ++max.myToolbar.height;
        return max;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mySizeBySelected) {
            return this.computeSizeBySelected(true);
        }
        return this.computeSize((Function<? super JComponent, ? extends Dimension>)((Function)component -> component.getMinimumSize()), 1);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mySizeBySelected) {
            return this.computeSizeBySelected(false);
        }
        return this.computeSize((Function<? super JComponent, ? extends Dimension>)((Function)component -> component.getPreferredSize()), 3);
    }

    @NotNull
    private Dimension computeSizeBySelected(boolean minimum) {
        JComponent component;
        Dimension size = new Dimension();
        TabInfo tabInfo = this.getSelectedInfo();
        if (tabInfo == null && this.myVisibleInfos.size() > 0) {
            tabInfo = this.myVisibleInfos.get(0);
        }
        JComponent jComponent = component = tabInfo == null ? null : tabInfo.getComponent();
        if (component != null) {
            Dimension tabSize;
            Dimension dimension = tabSize = minimum ? component.getMinimumSize() : component.getPreferredSize();
            if (tabSize != null) {
                size.width = tabSize.width;
                size.height = tabSize.height;
            }
        }
        this.addHeaderSize(size, 3);
        Dimension dimension = size;
        if (dimension == null) {
            JBTabsImpl.$$$reportNull$$$0(37);
        }
        return dimension;
    }

    private Dimension computeSize(Function<? super JComponent, ? extends Dimension> transform, int tabCount) {
        Dimension size = new Dimension();
        for (TabInfo each : this.myVisibleInfos) {
            JComponent c = each.getComponent();
            if (c == null) continue;
            Dimension eachSize = (Dimension)transform.fun((Object)c);
            size.width = Math.max(eachSize.width, size.width);
            size.height = Math.max(eachSize.height, size.height);
        }
        this.addHeaderSize(size, tabCount);
        return size;
    }

    private void addHeaderSize(Dimension size, int tabsCount) {
        boolean horizontal;
        Dimension header = this.computeHeaderPreferredSize(tabsCount);
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        if (horizontal) {
            size.height += header.height;
            size.width = Math.max(size.width, header.width);
        } else {
            size.height += Math.max(size.height, header.height);
            size.width += header.width;
        }
        Insets insets = this.getLayoutInsets();
        size.width += insets.left + insets.right + 1;
        size.height += insets.top + insets.bottom + 1;
    }

    private Dimension computeHeaderPreferredSize(int tabsCount) {
        boolean horizontal;
        Iterator<TabInfo> infos = this.myInfo2Label.keySet().iterator();
        Dimension size = new Dimension();
        int currentTab = 0;
        boolean bl = horizontal = this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
        while (infos.hasNext()) {
            boolean canGrow = currentTab < tabsCount;
            TabInfo eachInfo = infos.next();
            TabLabel eachLabel = this.myInfo2Label.get(eachInfo);
            Dimension eachPrefSize = eachLabel.getPreferredSize();
            if (horizontal) {
                if (canGrow) {
                    size.width += eachPrefSize.width;
                }
                size.height = Math.max(size.height, eachPrefSize.height);
            } else {
                size.width = Math.max(size.width, eachPrefSize.width);
                if (canGrow) {
                    size.height += eachPrefSize.height;
                }
            }
            ++currentTab;
        }
        if (this.isSingleRow() && this.isGhostsAlwaysVisible()) {
            if (horizontal) {
                size.width += this.getGhostTabLength() * 2;
            } else {
                size.height += this.getGhostTabLength() * 2;
            }
        }
        if (horizontal) {
            size.height += this.myBorder.getThickness();
        } else {
            size.width += this.myBorder.getThickness();
        }
        return size;
    }

    @Override
    public int getTabCount() {
        return this.getTabs().size();
    }

    @Override
    @NotNull
    public JBTabsPresentation getPresentation() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(38);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public ActionCallback removeTab(TabInfo info) {
        ActionCallback actionCallback = this.removeTab(info, null, true);
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(39);
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTransfer, boolean transferFocus) {
        ActionCallback actionCallback = this.removeTab(info, forcedSelectionTransfer, transferFocus, false);
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(40);
        }
        return actionCallback;
    }

    @NotNull
    private ActionCallback removeTab(TabInfo info, @Nullable TabInfo forcedSelectionTransfer, boolean transferFocus, boolean isDropTarget) {
        TabInfo toSelect;
        if (this.myPopupInfo == info) {
            this.myPopupInfo = null;
        }
        if (!(isDropTarget || info != null && this.getTabs().contains(info))) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                JBTabsImpl.$$$reportNull$$$0(41);
            }
            return actionCallback;
        }
        if (isDropTarget && this.myLastLayoutPass != null) {
            this.myLastLayoutPass.myVisibleInfos.remove(info);
        }
        ActionCallback result = new ActionCallback();
        if (forcedSelectionTransfer == null) {
            toSelect = this.getToSelectOnRemoveOf(info);
        } else {
            assert (this.myVisibleInfos.contains(forcedSelectionTransfer)) : "Cannot find tab for selection transfer, tab=" + forcedSelectionTransfer;
            toSelect = forcedSelectionTransfer;
        }
        if (toSelect != null) {
            boolean clearSelection = info.equals(this.mySelectedInfo);
            this.processRemove(info, false);
            if (clearSelection) {
                this.mySelectedInfo = info;
            }
            this._setSelected(toSelect, transferFocus).doWhenProcessed(() -> this.removeDeferred().notifyWhenDone(result));
        } else {
            this.processRemove(info, true);
            this.removeDeferred().notifyWhenDone(result);
        }
        if (this.myVisibleInfos.isEmpty()) {
            this.removeDeferredNow();
        }
        this.revalidateAndRepaint(true);
        this.fireTabRemoved(info);
        ActionCallback actionCallback = result;
        if (actionCallback == null) {
            JBTabsImpl.$$$reportNull$$$0(42);
        }
        return actionCallback;
    }

    private void processRemove(TabInfo info, boolean forcedNow) {
        this.remove(this.myInfo2Label.get(info));
        this.remove(this.myInfo2Toolbar.get(info));
        JComponent tabComponent = info.getComponent();
        if (!JBTabsImpl.isToDeferRemoveForLater(tabComponent) || forcedNow) {
            this.remove(tabComponent);
        } else {
            this.queueForRemove(tabComponent);
        }
        TabLabel tabLabel = this.myInfo2Label.get(info);
        if (tabLabel != null) {
            Disposer.dispose((Disposable)tabLabel);
        }
        this.myVisibleInfos.remove(info);
        this.myHiddenInfos.remove(info);
        this.myInfo2Label.remove(info);
        this.myInfo2Page.remove(info);
        this.myInfo2Toolbar.remove(info);
        this.resetTabsCache();
        this.updateAll(false, false);
        this.myLastPaintedSelection = null;
    }

    @Override
    @Nullable
    public TabInfo findInfo(Component component) {
        for (TabInfo each : this.getTabs()) {
            if (each.getComponent() != component) continue;
            return each;
        }
        return null;
    }

    @Override
    public TabInfo findInfo(MouseEvent event) {
        return this.findInfo(event, false);
    }

    @Nullable
    private TabInfo findInfo(MouseEvent event, boolean labelsOnly) {
        Point point = SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), this);
        return this._findInfo(point, labelsOnly);
    }

    @Override
    public TabInfo findInfo(Object object) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            TabInfo each = this.getTabAt(i);
            Object eachObject = each.getObject();
            if (eachObject == null || !eachObject.equals(object)) continue;
            return each;
        }
        return null;
    }

    @Nullable
    private TabInfo _findInfo(Point point, boolean labelsOnly) {
        Component component = this.findComponentAt(point);
        if (component == null) {
            return null;
        }
        while (component != this || component != null) {
            TabInfo info;
            if (component instanceof TabLabel) {
                return ((TabLabel)component).getInfo();
            }
            if (!labelsOnly && (info = this.findInfo(component)) != null) {
                return info;
            }
            if (component == null) break;
            component = component.getParent();
        }
        return null;
    }

    @Override
    public void removeAllTabs() {
        for (TabInfo each : this.getTabs()) {
            this.removeTab(each);
        }
    }

    private void updateContainer(boolean forced, boolean layoutNow) {
        if (this.myProject != null && !this.myProject.isOpen()) {
            return;
        }
        for (TabInfo each : new ArrayList<TabInfo>(this.myVisibleInfos)) {
            JComponent eachComponent = each.getComponent();
            if (this.getSelectedInfo() == each && this.getSelectedInfo() != null) {
                this.unqueueFromRemove(eachComponent);
                Container parent = eachComponent.getParent();
                if (parent != null && parent != this) {
                    parent.remove(eachComponent);
                }
                if (eachComponent.getParent() != null) continue;
                this.add(eachComponent);
                continue;
            }
            if (eachComponent.getParent() == null) continue;
            if (JBTabsImpl.isToDeferRemoveForLater(eachComponent)) {
                this.queueForRemove(eachComponent);
                continue;
            }
            this.remove(eachComponent);
        }
        this.mySingleRowLayout.scrollSelectionInView();
        this.relayout(forced, layoutNow);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.unqueueFromRemove(comp);
        if (comp instanceof TabLabel) {
            ((TabLabel)comp).apply(this.myUiDecorator != null ? this.myUiDecorator.getDecoration() : ourDefaultDecorator.getDecoration());
        }
        super.addImpl(comp, constraints, index);
    }

    private static boolean isToDeferRemoveForLater(JComponent c) {
        return c.getRootPane() != null;
    }

    void relayout(boolean forced, boolean layoutNow) {
        if (!this.myForcedRelayout) {
            this.myForcedRelayout = forced;
        }
        this.revalidateAndRepaint(layoutNow);
    }

    public int getBorderThickness() {
        return this.myBorder.getThickness();
    }

    @Override
    @NotNull
    public JBTabs addTabMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            JBTabsImpl.$$$reportNull$$$0(43);
        }
        this.removeListeners();
        this.myTabMouseListeners.add(listener2);
        this.addListeners();
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(44);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(45);
        }
        return jBTabsImpl;
    }

    private void addListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.addMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.addMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void removeListeners() {
        for (TabInfo eachInfo : this.myVisibleInfos) {
            TabLabel label = this.myInfo2Label.get(eachInfo);
            for (EventListener eachListener : this.myTabMouseListeners) {
                if (eachListener instanceof MouseListener) {
                    label.removeMouseListener((MouseListener)eachListener);
                    continue;
                }
                if (eachListener instanceof MouseMotionListener) {
                    label.removeMouseMotionListener((MouseMotionListener)eachListener);
                    continue;
                }
                assert (false);
            }
        }
    }

    private void updateListeners() {
        this.removeListeners();
        this.addListeners();
    }

    @Override
    public JBTabs addListener(@NotNull TabsListener listener2) {
        if (listener2 == null) {
            JBTabsImpl.$$$reportNull$$$0(46);
        }
        this.myTabListeners.add(listener2);
        return this;
    }

    @Override
    public JBTabs setSelectionChangeHandler(JBTabs.SelectionChangeHandler handler) {
        this.mySelectionChangeHandler = handler;
        return this;
    }

    public void setFocused(boolean focused) {
        if (this.myFocused == focused) {
            return;
        }
        this.myFocused = focused;
        if (this.myPaintFocus) {
            this.repaint();
        }
    }

    @Override
    public int getIndexOf(@Nullable TabInfo tabInfo) {
        return this.getVisibleInfos().indexOf(tabInfo);
    }

    @Override
    public boolean isHideTabs() {
        return this.myHideTabs;
    }

    @Override
    public void setHideTabs(boolean hideTabs) {
        if (this.isHideTabs() == hideTabs) {
            return;
        }
        this.myHideTabs = hideTabs;
        this.relayout(true, false);
    }

    @Override
    public JBTabsPresentation setPaintBorder(int top, int left, int right, int bottom) {
        return this;
    }

    @Override
    public JBTabsPresentation setTabSidePaintBorder(int size) {
        return this;
    }

    static int getBorder(int size) {
        return size == -1 ? 1 : size;
    }

    private boolean isPaintFocus() {
        return this.myPaintFocus;
    }

    @Override
    @NotNull
    public JBTabsPresentation setActiveTabFillIn(@Nullable Color color) {
        if (!JBTabsImpl.isChanged(this.myActiveTabFillIn, color)) {
            JBTabsImpl jBTabsImpl = this;
            if (jBTabsImpl == null) {
                JBTabsImpl.$$$reportNull$$$0(47);
            }
            return jBTabsImpl;
        }
        this.myActiveTabFillIn = color;
        this.revalidateAndRepaint(false);
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(48);
        }
        return jBTabsImpl;
    }

    private static boolean isChanged(Object oldObject, Object newObject) {
        return !Comparing.equal((Object)oldObject, (Object)newObject);
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsAutoHide(boolean autoHide) {
        if (this.myTabLabelActionsAutoHide != autoHide) {
            this.myTabLabelActionsAutoHide = autoHide;
            this.revalidateAndRepaint(false);
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(49);
        }
        return jBTabsImpl;
    }

    @Nullable
    protected Color getActiveTabFillIn() {
        return this.myActiveTabFillIn;
    }

    @Override
    public JBTabsPresentation setFocusCycle(boolean root) {
        this.setFocusCycleRoot(root);
        return this;
    }

    @Override
    public JBTabsPresentation setPaintFocus(boolean paintFocus) {
        this.myPaintFocus = paintFocus;
        return this;
    }

    private void disposePopupListener() {
        if (this.myActivePopup != null) {
            this.myActivePopup.removePopupMenuListener(this.myPopupListener);
            this.myActivePopup = null;
        }
    }

    @Override
    public JBTabsPresentation setStealthTabMode(boolean stealthTabMode) {
        this.myStealthTabMode = stealthTabMode;
        this.relayout(true, false);
        return this;
    }

    public boolean isStealthTabMode() {
        return this.myStealthTabMode;
    }

    @Override
    public JBTabsPresentation setSideComponentVertical(boolean vertical) {
        this.myHorizontalSide = !vertical;
        for (TabInfo each : this.myVisibleInfos) {
            each.getChangeSupport().firePropertyChange("actionGroup", "new1", "new2");
        }
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSideComponentOnTabs(boolean onTabs) {
        this.mySideComponentOnTabs = onTabs;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSideComponentBefore(boolean before) {
        this.mySideComponentBefore = before;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setSingleRow(boolean singleRow) {
        this.myLayout = singleRow ? this.mySingleRowLayout : this.myTableLayout;
        this.relayout(true, false);
        return this;
    }

    @Override
    public JBTabsPresentation setGhostsAlwaysVisible(boolean visible) {
        this.myGhostsAlwaysVisible = visible;
        this.relayout(true, false);
        return this;
    }

    public boolean isSizeBySelected() {
        return this.mySizeBySelected;
    }

    public void setSizeBySelected(boolean value) {
        this.mySizeBySelected = value;
    }

    public boolean useSmallLabels() {
        return false;
    }

    public boolean useBoldLabels() {
        return false;
    }

    public boolean isGhostsAlwaysVisible() {
        return this.myGhostsAlwaysVisible;
    }

    @Override
    public boolean isSingleRow() {
        return this.getEffectiveLayout() == this.mySingleRowLayout;
    }

    public boolean isSideComponentVertical() {
        return !this.myHorizontalSide;
    }

    public boolean isSideComponentOnTabs() {
        return this.mySideComponentOnTabs;
    }

    public boolean isSideComponentBefore() {
        return this.mySideComponentBefore;
    }

    public TabLayout getEffectiveLayout() {
        if (this.myLayout == this.myTableLayout && this.getTabsPosition() == JBTabsPosition.top) {
            return this.myTableLayout;
        }
        return this.mySingleRowLayout;
    }

    @Override
    public JBTabsPresentation setUiDecorator(@Nullable UiDecorator decorator) {
        this.myUiDecorator = decorator == null ? ourDefaultDecorator : decorator;
        this.applyDecoration();
        return this;
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.applyDecoration();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        SwingUtilities.invokeLater(() -> {
            this.applyDecoration();
            this.revalidateAndRepaint(false);
        });
    }

    private void applyDecoration() {
        if (this.myUiDecorator != null) {
            UiDecorator.UiDecoration uiDecoration = this.myUiDecorator.getDecoration();
            for (TabLabel each : this.myInfo2Label.values()) {
                each.apply(uiDecoration);
            }
        }
        for (TabInfo each : this.getTabs()) {
            this.adjust(each);
        }
        this.relayout(true, false);
    }

    private void adjust(TabInfo each) {
        UIUtil.removeScrollBorder((Component)each.getComponent());
    }

    @Override
    public void sortTabs(Comparator<? super TabInfo> comparator) {
        Collections.sort(this.myVisibleInfos, comparator);
        this.relayout(true, false);
    }

    private boolean isRequestFocusOnLastFocusedComponent() {
        return this.myRequestFocusOnLastFocusedComponent;
    }

    @Override
    public JBTabsPresentation setRequestFocusOnLastFocusedComponent(boolean requestFocusOnLastFocusedComponent) {
        this.myRequestFocusOnLastFocusedComponent = requestFocusOnLastFocusedComponent;
        return this;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        Object value;
        if (dataId == null) {
            JBTabsImpl.$$$reportNull$$$0(50);
        }
        if (this.myDataProvider != null && (value = this.myDataProvider.getData(dataId)) != null) {
            return value;
        }
        if (QuickActionProvider.KEY.getName().equals(dataId)) {
            return this;
        }
        return NAVIGATION_ACTIONS_KEY.is(dataId) ? this : null;
    }

    @Override
    @NotNull
    public List<AnAction> getActions(boolean originalProvider) {
        ActionGroup group;
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        TabInfo selection = this.getSelectedInfo();
        if (selection != null && (group = selection.getGroup()) != null) {
            AnAction[] children = group.getChildren(null);
            Collections.addAll(result, children);
        }
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            JBTabsImpl.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    @Override
    public DataProvider getDataProvider() {
        return this.myDataProvider;
    }

    @Override
    public JBTabsImpl setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            JBTabsImpl.$$$reportNull$$$0(52);
        }
        this.myDataProvider = dataProvider;
        return this;
    }

    public static boolean isSelectionClick(MouseEvent e, boolean canBeQuick) {
        if ((e.getClickCount() == 1 || canBeQuick) && !e.isPopupTrigger()) {
            return e.getButton() == 1 && !e.isControlDown() && !e.isAltDown() && !e.isMetaDown();
        }
        return false;
    }

    public Rectangle layout(JComponent c, Rectangle bounds) {
        Rectangle now = c.getBounds();
        if (!bounds.equals(now)) {
            c.setBounds(bounds);
        }
        c.doLayout();
        c.putClientProperty(LAYOUT_DONE, Boolean.TRUE);
        return bounds;
    }

    public Rectangle layout(JComponent c, int x, int y, int width, int height) {
        return this.layout(c, new Rectangle(x, y, width, height));
    }

    public static void resetLayout(JComponent c) {
        if (c == null) {
            return;
        }
        c.putClientProperty(LAYOUT_DONE, null);
        c.putClientProperty(STRETCHED_BY_WIDTH, null);
    }

    private void applyResetComponents() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JComponent jc;
            Component each = this.getComponent(i);
            if (!(each instanceof JComponent) || UIUtil.isClientPropertyTrue((Object)(jc = (JComponent)each), (Object)LAYOUT_DONE)) continue;
            this.layout(jc, new Rectangle(0, 0, 0, 0));
        }
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabLabelActionsMouseDeadzone(TimedDeadzone.Length length) {
        this.myTabActionsMouseDeadzone = length;
        List<TabInfo> all = this.getTabs();
        for (TabInfo each : all) {
            TabLabel eachLabel = this.myInfo2Label.get(each);
            eachLabel.updateTabActions();
        }
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(53);
        }
        return jBTabsImpl;
    }

    @Override
    @NotNull
    public JBTabsPresentation setTabsPosition(JBTabsPosition position) {
        this.myPosition = position;
        OnePixelDivider divider = this.mySplitter.getDivider();
        if ((position == JBTabsPosition.left || position == JBTabsPosition.right) && divider.getParent() == null) {
            this.add((Component)((Object)divider));
        } else if (divider.getParent() == this) {
            this.remove((Component)((Object)divider));
        }
        this.relayout(true, false);
        JBTabsImpl jBTabsImpl = this;
        if (jBTabsImpl == null) {
            JBTabsImpl.$$$reportNull$$$0(54);
        }
        return jBTabsImpl;
    }

    @Override
    public JBTabsPosition getTabsPosition() {
        return this.myPosition;
    }

    public TimedDeadzone.Length getTabActionsMouseDeadzone() {
        return this.myTabActionsMouseDeadzone;
    }

    @Override
    public JBTabsPresentation setTabDraggingEnabled(boolean enabled) {
        this.myTabDraggingEnabled = enabled;
        return this;
    }

    @Override
    public JBTabsPresentation setAlphabeticalMode(boolean alphabeticalMode) {
        this.myAlphabeticalMode = alphabeticalMode;
        return this;
    }

    @Override
    public JBTabsPresentation setSupportsCompression(boolean supportsCompression) {
        this.mySupportsCompression = supportsCompression;
        this.updateRowLayout();
        return this;
    }

    public boolean isTabDraggingEnabled() {
        return this.myTabDraggingEnabled && !this.mySplitter.isDragging();
    }

    void reallocate(TabInfo source, TabInfo target) {
        if (source == target || source == null || target == null) {
            return;
        }
        int targetIndex = this.myVisibleInfos.indexOf(target);
        this.myVisibleInfos.remove(source);
        this.myVisibleInfos.add(targetIndex, source);
        this.invalidate();
        this.relayout(true, true);
    }

    public boolean isHorizontalTabs() {
        return this.getTabsPosition() == JBTabsPosition.top || this.getTabsPosition() == JBTabsPosition.bottom;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        TabInfo selected;
        if (info == null) {
            JBTabsImpl.$$$reportNull$$$0(55);
        }
        if ((selected = this.getSelectedInfo()) != null) {
            selected.putInfo(info);
        }
    }

    @Override
    public void resetDropOver(TabInfo tabInfo) {
        if (this.myDropInfo != null) {
            TabInfo dropInfo = this.myDropInfo;
            this.myDropInfo = null;
            this.myShowDropLocation = true;
            this.myForcedRelayout = true;
            this.setDropInfoIndex(-1);
            if (!this.isDisposed()) {
                this.removeTab(dropInfo, null, false, true);
            }
        }
    }

    @Override
    public Image startDropOver(TabInfo tabInfo, RelativePoint point) {
        this.myDropInfo = tabInfo;
        int index = this.myLayout.getDropIndexFor(point.getPoint((Component)this));
        this.setDropInfoIndex(index);
        this.addTab(this.myDropInfo, index, true, true);
        TabLabel label = this.myInfo2Label.get(this.myDropInfo);
        Dimension size = label.getPreferredSize();
        label.setBounds(0, 0, size.width, size.height);
        BufferedImage img = UIUtil.createImage((Component)this, (int)size.width, (int)size.height, (int)2);
        Graphics2D g = img.createGraphics();
        label.paintOffscreen(g);
        g.dispose();
        this.relayout(true, false);
        return img;
    }

    @Override
    public void processDropOver(TabInfo over, RelativePoint point) {
        int index = this.myLayout.getDropIndexFor(point.getPoint((Component)this));
        if (index != this.getDropInfoIndex()) {
            this.setDropInfoIndex(index);
            this.relayout(true, false);
        }
    }

    @Override
    public int getDropInfoIndex() {
        return this.myDropInfoIndex;
    }

    @Override
    public boolean isEmptyVisible() {
        return this.myVisibleInfos.isEmpty();
    }

    public int getTabHGap() {
        return -this.myBorder.getThickness();
    }

    @Override
    public String toString() {
        return "JBTabs visible=" + this.myVisibleInfos + " selected=" + this.mySelectedInfo;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJBTabsImpl();
        }
        return this.accessibleContext;
    }

    @Deprecated
    public int getActiveTabUnderlineHeight() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/newImpl/JBTabsImpl";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupGroup";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: 
            case 25: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/newImpl/JBTabsImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addTab";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "_setSelected";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "executeSelectionChange";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "requestFocus";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDeferred";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabAt";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setToDrawBorderIfTabsHidden";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBTabs";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSizeBySelected";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTab";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "addTabMouseListener";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "setActiveTabFillIn";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabLabelActionsAutoHide";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabLabelActionsMouseDeadzone";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabsPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setPopupGroup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireTabRemoved";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addTabMouseListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    protected static class ShapeInfo {
        public ShapeTransform path;
        public ShapeTransform fillPath;
        public ShapeTransform labelPath;
        public int labelBottomY;
        public int labelTopY;
        public int labelLeftX;
        public int labelRightX;
        public Insets insets;
        public Color from;
        public Color to;
    }

    private class AccessibleTabPage
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleAction {
        @NotNull
        private final JBTabsImpl myParent;
        @NotNull
        private final TabInfo myTabInfo;
        private final Component myComponent;

        AccessibleTabPage(TabInfo tabInfo) {
            if (tabInfo == null) {
                AccessibleTabPage.$$$reportNull$$$0(0);
            }
            this.myParent = JBTabsImpl.this;
            this.myTabInfo = tabInfo;
            this.myComponent = tabInfo.getComponent();
            this.setAccessibleParent(this.myParent);
            this.initAccessibleContext();
        }

        @NotNull
        private TabInfo getTabInfo() {
            TabInfo tabInfo = this.myTabInfo;
            if (tabInfo == null) {
                AccessibleTabPage.$$$reportNull$$$0(1);
            }
            return tabInfo;
        }

        private int getTabIndex() {
            return JBTabsImpl.this.getIndexOf(this.myTabInfo);
        }

        private TabLabel getTabLabel() {
            return JBTabsImpl.this.myInfo2Label.get(this.getTabInfo());
        }

        void initAccessibleContext() {
            AccessibleContext ac;
            if (JBTabsImpl.this.accessibleContext != null && this.myComponent instanceof Accessible && (ac = this.myComponent.getAccessibleContext()) != null) {
                ac.setAccessibleParent(this);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        @Override
        public String getAccessibleName() {
            TabLabel label;
            String name = this.accessibleName;
            if (name == null) {
                name = (String)JBTabsImpl.this.getClientProperty("AccessibleName");
            }
            if (name == null && (label = this.getTabLabel()) != null && label.getAccessibleContext() != null) {
                name = label.getAccessibleContext().getAccessibleName();
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public String getAccessibleDescription() {
            TabLabel label;
            String description = this.accessibleDescription;
            if (description == null) {
                description = (String)JBTabsImpl.this.getClientProperty("AccessibleDescription");
            }
            if (description == null && (label = this.getTabLabel()) != null && label.getAccessibleContext() != null) {
                description = label.getAccessibleContext().getAccessibleDescription();
            }
            if (description == null) {
                description = super.getAccessibleDescription();
            }
            return description;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = this.myParent.getAccessibleContext().getAccessibleStateSet();
            states.add(AccessibleState.SELECTABLE);
            TabInfo info = this.myParent.getSelectedInfo();
            if (info == this.getTabInfo()) {
                states.add(AccessibleState.SELECTED);
            }
            return states;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return this.getTabIndex();
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (JBTabsImpl.this.getSelectedInfo() == this.getTabInfo() && this.myComponent instanceof Accessible) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (JBTabsImpl.this.getSelectedInfo() == this.getTabInfo() && this.myComponent instanceof Accessible) {
                return (Accessible)((Object)this.myComponent);
            }
            return null;
        }

        @Override
        public Locale getLocale() {
            return JBTabsImpl.this.getLocale();
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public Color getBackground() {
            return JBTabsImpl.this.getBackground();
        }

        @Override
        public void setBackground(Color c) {
            JBTabsImpl.this.setBackground(c);
        }

        @Override
        public Color getForeground() {
            return JBTabsImpl.this.getForeground();
        }

        @Override
        public void setForeground(Color c) {
            JBTabsImpl.this.setForeground(c);
        }

        @Override
        public Cursor getCursor() {
            return JBTabsImpl.this.getCursor();
        }

        @Override
        public void setCursor(Cursor c) {
            JBTabsImpl.this.setCursor(c);
        }

        @Override
        public Font getFont() {
            return JBTabsImpl.this.getFont();
        }

        @Override
        public void setFont(Font f) {
            JBTabsImpl.this.setFont(f);
        }

        @Override
        public FontMetrics getFontMetrics(Font f) {
            return JBTabsImpl.this.getFontMetrics(f);
        }

        @Override
        public boolean isEnabled() {
            return this.getTabInfo().isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this.getTabInfo().setEnabled(b);
        }

        @Override
        public boolean isVisible() {
            return !this.getTabInfo().isHidden();
        }

        @Override
        public void setVisible(boolean b) {
            this.getTabInfo().setHidden(!b);
        }

        @Override
        public boolean isShowing() {
            return JBTabsImpl.this.isShowing();
        }

        @Override
        public boolean contains(Point p) {
            Rectangle r = this.getBounds();
            return r.contains(p);
        }

        @Override
        public Point getLocationOnScreen() {
            Point parentLocation = JBTabsImpl.this.getLocationOnScreen();
            Point componentLocation = this.getLocation();
            componentLocation.translate(parentLocation.x, parentLocation.y);
            return componentLocation;
        }

        @Override
        public Point getLocation() {
            Rectangle r = this.getBounds();
            return new Point(r.x, r.y);
        }

        @Override
        public void setLocation(Point p) {
        }

        @Override
        public Rectangle getBounds() {
            return this.getTabLabel().getBounds();
        }

        @Override
        public void setBounds(Rectangle r) {
        }

        @Override
        public Dimension getSize() {
            Rectangle r = this.getBounds();
            return new Dimension(r.width, r.height);
        }

        @Override
        public void setSize(Dimension d) {
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            if (this.myComponent instanceof Accessible) {
                return (Accessible)((Object)this.myComponent);
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener l) {
        }

        @Override
        public void removeFocusListener(FocusListener l) {
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleIcon accessibleIcon = null;
            if (this.getTabInfo().getIcon() instanceof ImageIcon) {
                AccessibleContext ac = ((ImageIcon)this.getTabInfo().getIcon()).getAccessibleContext();
                accessibleIcon = (AccessibleIcon)((Object)ac);
            }
            if (accessibleIcon != null) {
                AccessibleIcon[] returnIcons = new AccessibleIcon[]{accessibleIcon};
                return returnIcons;
            }
            return null;
        }

        @Override
        public int getAccessibleActionCount() {
            return 1;
        }

        @Override
        public String getAccessibleActionDescription(int i) {
            if (i != 0) {
                return null;
            }
            return "Activate";
        }

        @Override
        public boolean doAccessibleAction(int i) {
            if (i != 0) {
                return false;
            }
            JBTabsImpl.this.select(this.getTabInfo(), true);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tabs/newImpl/JBTabsImpl$AccessibleTabPage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tabs/newImpl/JBTabsImpl$AccessibleTabPage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class AccessibleJBTabsImpl
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        public AccessibleJBTabsImpl() {
            super(JBTabsImpl.this);
            this.getAccessibleComponent();
            JBTabsImpl.this.addListener(new TabsListener(){

                @Override
                public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                    AccessibleJBTabsImpl.this.firePropertyChange("AccessibleSelection", null, null);
                }
            });
        }

        @Override
        public String getAccessibleName() {
            TabLabel selectedLabel;
            String name = this.accessibleName;
            if (name == null) {
                name = (String)JBTabsImpl.this.getClientProperty("AccessibleName");
            }
            if (name == null && (selectedLabel = JBTabsImpl.this.getSelectedLabel()) != null && selectedLabel.getAccessibleContext() != null) {
                name = selectedLabel.getAccessibleContext().getAccessibleName();
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            Accessible accessibleChild = super.getAccessibleChild(i);
            if (accessibleChild instanceof TabLabel) {
                TabLabel label = (TabLabel)accessibleChild;
                return (Accessible)JBTabsImpl.this.myInfo2Page.get(label.getInfo());
            }
            return accessibleChild;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            return JBTabsImpl.this.getSelectedInfo() == null ? 0 : 1;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (JBTabsImpl.this.getSelectedInfo() == null) {
                return null;
            }
            return (Accessible)JBTabsImpl.this.myInfo2Page.get(JBTabsImpl.this.getSelectedInfo());
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            return i == JBTabsImpl.this.getIndexOf(JBTabsImpl.this.getSelectedInfo());
        }

        @Override
        public void addAccessibleSelection(int i) {
            TabInfo info = JBTabsImpl.this.getTabAt(i);
            if (info != null) {
                JBTabsImpl.this.select(info, false);
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
        }

        @Override
        public void clearAccessibleSelection() {
        }

        @Override
        public void selectAllAccessibleSelection() {
        }
    }

    private static class DefaultDecorator
    implements UiDecorator {
        private DefaultDecorator() {
        }

        @Override
        @NotNull
        public UiDecorator.UiDecoration getDecoration() {
            UiDecorator.UiDecoration uiDecoration = new UiDecorator.UiDecoration(null, (Insets)new JBInsets(5, 12, 5, 12));
            if (uiDecoration == null) {
                DefaultDecorator.$$$reportNull$$$0(0);
            }
            return uiDecoration;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/newImpl/JBTabsImpl$DefaultDecorator", "getDecoration"));
        }
    }

    private static class SelectPreviousAction
    extends BaseNavigationAction {
        private SelectPreviousAction(JBTabsImpl tabs, @NotNull ActionManager mgr) {
            if (mgr == null) {
                SelectPreviousAction.$$$reportNull$$$0(0);
            }
            super("PreviousTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledBackward(selectedIndex, true) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledBackward(selectedIndex, true);
            if (tabInfo != null) {
                tabs.select(tabInfo, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/intellij/ui/tabs/newImpl/JBTabsImpl$SelectPreviousAction", "<init>"));
        }
    }

    private static class SelectNextAction
    extends BaseNavigationAction {
        private SelectNextAction(JBTabsImpl tabs, @NotNull ActionManager mgr) {
            if (mgr == null) {
                SelectNextAction.$$$reportNull$$$0(0);
            }
            super("NextTab", tabs, mgr);
        }

        @Override
        protected void _update(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            e.getPresentation().setEnabled(tabs.findEnabledForward(selectedIndex, true) != null);
        }

        @Override
        protected void _actionPerformed(AnActionEvent e, JBTabsImpl tabs, int selectedIndex) {
            TabInfo tabInfo = tabs.findEnabledForward(selectedIndex, true);
            if (tabInfo != null) {
                tabs.select(tabInfo, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mgr", "com/intellij/ui/tabs/newImpl/JBTabsImpl$SelectNextAction", "<init>"));
        }
    }

    private static abstract class BaseNavigationAction
    extends AnAction {
        private final ShadowAction myShadow;
        @NotNull
        private final ActionManager myActionManager;
        private final JBTabsImpl myTabs;

        protected BaseNavigationAction(@NotNull String copyFromID, @NotNull JBTabsImpl tabs, @NotNull ActionManager mgr) {
            if (copyFromID == null) {
                BaseNavigationAction.$$$reportNull$$$0(0);
            }
            if (tabs == null) {
                BaseNavigationAction.$$$reportNull$$$0(1);
            }
            if (mgr == null) {
                BaseNavigationAction.$$$reportNull$$$0(2);
            }
            this.myActionManager = mgr;
            this.myTabs = tabs;
            this.myShadow = new ShadowAction(this, this.myActionManager.getAction(copyFromID), tabs, tabs);
            this.setEnabledInModalContext(true);
        }

        @Override
        public final void update(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseNavigationAction.$$$reportNull$$$0(3);
            }
            JBTabsImpl tabs = (JBTabsImpl)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY);
            e.getPresentation().setVisible(tabs != null);
            if (tabs == null) {
                return;
            }
            tabs = this.findNavigatableTabs(tabs);
            e.getPresentation().setEnabled(tabs != null);
            if (tabs != null) {
                this._update(e, tabs, tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo()));
            }
        }

        @Nullable
        protected JBTabsImpl findNavigatableTabs(JBTabsImpl tabs) {
            if (tabs == null || tabs != this.myTabs) {
                return null;
            }
            if (BaseNavigationAction.isNavigatable(tabs)) {
                return tabs;
            }
            for (Container c = tabs.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof JBTabsImpl) || !BaseNavigationAction.isNavigatable((JBTabsImpl)c)) continue;
                return (JBTabsImpl)c;
            }
            return null;
        }

        private static boolean isNavigatable(JBTabsImpl tabs) {
            int selectedIndex = tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo());
            return tabs.isNavigationVisible() && selectedIndex >= 0 && tabs.myNavigationActionsEnabled;
        }

        public void reconnect(String actionId) {
            this.myShadow.reconnect(this.myActionManager.getAction(actionId));
        }

        protected abstract void _update(AnActionEvent var1, JBTabsImpl var2, int var3);

        @Override
        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                BaseNavigationAction.$$$reportNull$$$0(4);
            }
            JBTabsImpl tabs = (JBTabsImpl)e.getData(JBTabsEx.NAVIGATION_ACTIONS_KEY);
            if ((tabs = this.findNavigatableTabs(tabs)) == null) {
                return;
            }
            int index = tabs.getVisibleInfos().indexOf(tabs.getSelectedInfo());
            if (index == -1) {
                return;
            }
            this._actionPerformed(e, tabs, index);
        }

        protected abstract void _actionPerformed(AnActionEvent var1, JBTabsImpl var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copyFromID";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tabs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mgr";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tabs/newImpl/JBTabsImpl$BaseNavigationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Max {
        final Dimension myLabel = new Dimension();
        final Dimension myToolbar = new Dimension();

        private Max() {
        }
    }

    public static class Toolbar
    extends JPanel {
        private final JBTabsImpl myTabs;

        public Toolbar(JBTabsImpl tabs, TabInfo info) {
            this.myTabs = tabs;
            this.setLayout(new BorderLayout());
            ActionGroup group = info.getGroup();
            JComponent side = info.getSideComponent();
            if (group != null) {
                String place = info.getPlace();
                ActionToolbar toolbar = this.myTabs.myActionManager.createActionToolbar(place != null ? place : "JBTabs", group, this.myTabs.myHorizontalSide);
                toolbar.setTargetComponent(info.getActionsContextComponent());
                JComponent actionToolbar = toolbar.getComponent();
                this.add((Component)actionToolbar, "Center");
            }
            if (side != null) {
                if (group != null) {
                    this.add((Component)side, "East");
                } else {
                    this.add((Component)side, "Center");
                }
            }
        }

        public boolean isEmpty() {
            return this.getComponentCount() == 0;
        }
    }

    @Deprecated
    class TabActionsAutoHideListener
    extends MouseMotionAdapter
    implements Weighted {
        private TabLabel myCurrentOverLabel;
        private Point myLastOverPoint;

        TabActionsAutoHideListener() {
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            this.myLastOverPoint = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), JBTabsImpl.this);
            this.processMouseOver();
        }

        void processMouseOver() {
            TabLabel label;
            if (!JBTabsImpl.this.myTabLabelActionsAutoHide) {
                return;
            }
            if (this.myLastOverPoint == null) {
                return;
            }
            if (this.myLastOverPoint.x >= 0 && this.myLastOverPoint.x < JBTabsImpl.this.getWidth() && this.myLastOverPoint.y > 0 && this.myLastOverPoint.y < JBTabsImpl.this.getHeight() && (label = JBTabsImpl.this.myInfo2Label.get(JBTabsImpl.this._findInfo(this.myLastOverPoint, true))) != null) {
                if (this.myCurrentOverLabel != null) {
                    this.myCurrentOverLabel.toggleShowActions(false);
                }
                label.toggleShowActions(true);
                this.myCurrentOverLabel = label;
                return;
            }
            if (this.myCurrentOverLabel != null) {
                this.myCurrentOverLabel.toggleShowActions(false);
                this.myCurrentOverLabel = null;
            }
        }
    }
}

