/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.Key;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.ScrollBarPainter;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

class DefaultScrollBarUI
extends ScrollBarUI {
    static final Key<Component> LEADING = Key.create((String)"JB_SCROLL_BAR_LEADING_COMPONENT");
    static final Key<Component> TRAILING = Key.create((String)"JB_SCROLL_BAR_TRAILING_COMPONENT");
    private final Listener myListener = new Listener();
    private final Timer myScrollTimer = UIUtil.createNamedTimer((String)"ScrollBarThumbScrollTimer", (int)60, (ActionListener)this.myListener);
    private final int myThickness;
    private final int myThicknessMax;
    private final int myThicknessMin;
    JScrollBar myScrollBar;
    final ScrollBarPainter.Track myTrack = new ScrollBarPainter.Track(() -> this.myScrollBar);
    final ScrollBarPainter.Thumb myThumb = new ScrollBarPainter.Thumb(() -> this.myScrollBar, false);
    private boolean isValueCached;
    private int myCachedValue;
    private int myOldValue;

    DefaultScrollBarUI() {
        this(ScrollSettings.isThumbSmallIfOpaque() ? 13 : 10, 14, 10);
    }

    DefaultScrollBarUI(int thickness, int thicknessMax, int thicknessMin) {
        this.myThickness = thickness;
        this.myThicknessMax = thicknessMax;
        this.myThicknessMin = thicknessMin;
    }

    int getThickness() {
        return this.scale(this.myScrollBar == null || DefaultScrollBarUI.isOpaque(this.myScrollBar) ? this.myThickness : this.myThicknessMax);
    }

    int getMinimalThickness() {
        return this.scale(this.myScrollBar == null || DefaultScrollBarUI.isOpaque(this.myScrollBar) ? this.myThickness : this.myThicknessMin);
    }

    static boolean isOpaque(Component c) {
        if (c.isOpaque()) {
            return true;
        }
        Container parent = c.getParent();
        return parent instanceof JScrollPane && parent.getLayout() instanceof ScrollPaneLayout.UIResource;
    }

    boolean isAbsolutePositioning(MouseEvent event) {
        return SwingUtilities.isMiddleMouseButton(event);
    }

    boolean isTrackClickable() {
        return DefaultScrollBarUI.isOpaque(this.myScrollBar) || this.myTrack.animator.myValue > 0.0f;
    }

    boolean isTrackExpandable() {
        return false;
    }

    boolean isTrackContains(int x, int y) {
        return this.myTrack.bounds.contains(x, y);
    }

    boolean isThumbContains(int x, int y) {
        return this.myThumb.bounds.contains(x, y);
    }

    void onTrackHover(boolean hover) {
        this.myTrack.animator.start(hover);
    }

    void onThumbHover(boolean hover) {
        this.myThumb.animator.start(hover);
    }

    void paintTrack(Graphics2D g, JComponent c) {
        this.paint(this.myTrack, g, c, false);
    }

    void paintThumb(Graphics2D g, JComponent c) {
        this.paint(this.myThumb, g, c, ScrollSettings.isThumbSmallIfOpaque() && DefaultScrollBarUI.isOpaque(c));
    }

    void onThumbMove() {
    }

    void paint(ScrollBarPainter p, Graphics2D g, JComponent c, boolean small) {
        int x = p.bounds.x;
        int y = p.bounds.y;
        int width = p.bounds.width;
        int height = p.bounds.height;
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
            int offset = this.getTrackOffset(width - this.getMinimalThickness());
            if (offset > 0) {
                width -= offset;
                if (alignment == JBScrollPane.Alignment.RIGHT) {
                    x += offset;
                }
            }
        } else {
            int offset = this.getTrackOffset(height - this.getMinimalThickness());
            if (offset > 0) {
                height -= offset;
                if (alignment == JBScrollPane.Alignment.BOTTOM) {
                    y += offset;
                }
            }
        }
        if (small) {
            ++x;
            ++y;
            width -= 2;
            height -= 2;
        }
        p.paint(g, x, y, width, height, Float.valueOf(p.animator.myValue));
    }

    private int getTrackOffset(int offset) {
        if (!this.isTrackExpandable()) {
            return offset;
        }
        float value = this.myTrack.animator.myValue;
        if (value <= 0.0f) {
            return offset;
        }
        if (value >= 1.0f) {
            return 0;
        }
        return (int)(0.5f + (float)offset * (1.0f - value));
    }

    void repaint() {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint();
        }
    }

    void repaint(int x, int y, int width, int height) {
        if (this.myScrollBar != null) {
            this.myScrollBar.repaint(x, y, width, height);
        }
    }

    private int scale(int value) {
        value = JBUIScale.scale((int)value);
        switch (UIUtil.getComponentStyle((Component)this.myScrollBar)) {
            case LARGE: {
                return (int)((double)value * 1.15);
            }
            case SMALL: {
                return (int)((double)value * 0.857);
            }
            case MINI: {
                return (int)((double)value * 0.714);
            }
        }
        return value;
    }

    @Override
    public void installUI(JComponent c) {
        this.myScrollBar = (JScrollBar)c;
        ScrollBarPainter.setBackground(c);
        this.myScrollBar.setOpaque(false);
        this.myScrollBar.setFocusable(false);
        this.myScrollBar.addMouseListener(this.myListener);
        this.myScrollBar.addMouseMotionListener(this.myListener);
        this.myScrollBar.getModel().addChangeListener(this.myListener);
        this.myScrollBar.addPropertyChangeListener(this.myListener);
        this.myScrollBar.addFocusListener(this.myListener);
        this.myScrollTimer.setInitialDelay(300);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.myScrollTimer.stop();
        this.myTrack.animator.stop();
        this.myThumb.animator.stop();
        this.myScrollBar.removeFocusListener(this.myListener);
        this.myScrollBar.removePropertyChangeListener(this.myListener);
        this.myScrollBar.getModel().removeChangeListener(this.myListener);
        this.myScrollBar.removeMouseMotionListener(this.myListener);
        this.myScrollBar.removeMouseListener(this.myListener);
        this.myScrollBar.setForeground(null);
        this.myScrollBar.setBackground(null);
        this.myScrollBar = null;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int thickness = this.getThickness();
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        Dimension preferred = new Dimension(thickness, thickness);
        if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
            preferred.height += preferred.height;
            DefaultScrollBarUI.addPreferredHeight(preferred, (Component)UIUtil.getClientProperty((Object)this.myScrollBar, LEADING));
            DefaultScrollBarUI.addPreferredHeight(preferred, (Component)UIUtil.getClientProperty((Object)this.myScrollBar, TRAILING));
        } else {
            preferred.width += preferred.width;
            DefaultScrollBarUI.addPreferredWidth(preferred, (Component)UIUtil.getClientProperty((Object)this.myScrollBar, LEADING));
            DefaultScrollBarUI.addPreferredWidth(preferred, (Component)UIUtil.getClientProperty((Object)this.myScrollBar, TRAILING));
        }
        return preferred;
    }

    private static void addPreferredWidth(Dimension preferred, Component component) {
        if (component != null) {
            Dimension size = component.getPreferredSize();
            preferred.width += size.width;
            if (preferred.height < size.height) {
                preferred.height = size.height;
            }
        }
    }

    private static void addPreferredHeight(Dimension preferred, Component component) {
        if (component != null) {
            Dimension size = component.getPreferredSize();
            preferred.height += size.height;
            if (preferred.width < size.width) {
                preferred.width = size.width;
            }
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
        if (alignment != null && g instanceof Graphics2D) {
            boolean animate;
            int offset;
            Component trailing;
            Color background;
            Color color = background = !DefaultScrollBarUI.isOpaque(c) ? null : c.getBackground();
            if (background != null) {
                g.setColor(background);
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
            Rectangle bounds = new Rectangle(c.getWidth(), c.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)c.getInsets());
            Component leading = (Component)UIUtil.getClientProperty((Object)c, LEADING);
            if (leading != null) {
                int size;
                if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                    size = leading.getPreferredSize().height;
                    leading.setBounds(bounds.x, bounds.y, bounds.width, size);
                    bounds.height -= size;
                    bounds.y += size;
                } else {
                    size = leading.getPreferredSize().width;
                    leading.setBounds(bounds.x, bounds.y, size, bounds.height);
                    bounds.width -= size;
                    bounds.x += size;
                }
            }
            if ((trailing = (Component)UIUtil.getClientProperty((Object)c, TRAILING)) != null) {
                int size;
                if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                    size = trailing.getPreferredSize().height;
                    bounds.height -= size;
                    trailing.setBounds(bounds.x, bounds.y + bounds.height, bounds.width, size);
                } else {
                    size = trailing.getPreferredSize().width;
                    bounds.width -= size;
                    trailing.setBounds(bounds.x + bounds.width, bounds.y, size, bounds.height);
                }
            }
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                offset = bounds.width - this.getThickness();
                if (offset > 0) {
                    bounds.width -= offset;
                    if (alignment == JBScrollPane.Alignment.RIGHT) {
                        bounds.x += offset;
                    }
                }
            } else {
                offset = bounds.height - this.getThickness();
                if (offset > 0) {
                    bounds.height -= offset;
                    if (alignment == JBScrollPane.Alignment.BOTTOM) {
                        bounds.y += offset;
                    }
                }
            }
            boolean bl = animate = !this.myTrack.bounds.equals(bounds);
            if (animate) {
                this.myTrack.bounds.setBounds(bounds);
            }
            this.updateThumbBounds(animate);
            this.paintTrack((Graphics2D)g, c);
            RegionPainter track = (RegionPainter)UIUtil.getClientProperty((Object)c, JBScrollBar.TRACK);
            if (track != null && this.myTrack.bounds.width > 0 && this.myTrack.bounds.height > 0) {
                track.paint((Graphics2D)g, this.myTrack.bounds.x, this.myTrack.bounds.y, this.myTrack.bounds.width, this.myTrack.bounds.height, null);
            }
            if (this.myThumb.bounds.width > 0 && this.myThumb.bounds.height > 0) {
                this.paintThumb((Graphics2D)g, c);
            }
        }
    }

    private void updateThumbBounds(boolean animate) {
        int value = 0;
        int min = this.myScrollBar.getMinimum();
        int max = this.myScrollBar.getMaximum();
        int range = max - min;
        if (range <= 0) {
            this.myThumb.bounds.setBounds(0, 0, 0, 0);
        } else if (1 == this.myScrollBar.getOrientation()) {
            int extent = this.myScrollBar.getVisibleAmount();
            int height = Math.max(DefaultScrollBarUI.convert(this.myTrack.bounds.height, extent, range), 2 * this.getThickness());
            if (this.myTrack.bounds.height <= height) {
                this.myThumb.bounds.setBounds(0, 0, 0, 0);
            } else {
                value = this.getValue();
                int maxY = this.myTrack.bounds.y + this.myTrack.bounds.height - height;
                int y = value < max - extent ? DefaultScrollBarUI.convert(this.myTrack.bounds.height - height, value - min, range - extent) : maxY;
                this.myThumb.bounds.setBounds(this.myTrack.bounds.x, DefaultScrollBarUI.adjust(y, this.myTrack.bounds.y, maxY), this.myTrack.bounds.width, height);
                animate |= this.myOldValue != value;
            }
        } else {
            int extent = this.myScrollBar.getVisibleAmount();
            int width = Math.max(DefaultScrollBarUI.convert(this.myTrack.bounds.width, extent, range), 2 * this.getThickness());
            if (this.myTrack.bounds.width <= width) {
                this.myThumb.bounds.setBounds(0, 0, 0, 0);
            } else {
                int x;
                value = this.getValue();
                int maxX = this.myTrack.bounds.x + this.myTrack.bounds.width - width;
                int n = x = value < max - extent ? DefaultScrollBarUI.convert(this.myTrack.bounds.width - width, value - min, range - extent) : maxX;
                if (!this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                    x = this.myTrack.bounds.x - x + maxX;
                }
                this.myThumb.bounds.setBounds(DefaultScrollBarUI.adjust(x, this.myTrack.bounds.x, maxX), this.myTrack.bounds.y, width, this.myTrack.bounds.height);
                animate |= this.myOldValue != value;
            }
        }
        this.myOldValue = value;
        if (animate) {
            this.onThumbMove();
        }
    }

    private int getValue() {
        return this.isValueCached ? this.myCachedValue : this.myScrollBar.getValue();
    }

    private static int convert(double newRange, double oldValue, double oldRange) {
        return (int)(0.5 + newRange * oldValue / oldRange);
    }

    private static int adjust(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    private final class Listener
    extends MouseAdapter
    implements ActionListener,
    FocusListener,
    ChangeListener,
    PropertyChangeListener {
        private int myOffset;
        private int myMouseX;
        private int myMouseY;
        private boolean isReversed;
        private boolean isDragging;
        private boolean isOverTrack;
        private boolean isOverThumb;

        private Listener() {
        }

        private void updateMouse(int x, int y) {
            if (DefaultScrollBarUI.this.isTrackContains(x, y)) {
                boolean hover;
                if (!this.isOverTrack) {
                    this.isOverTrack = true;
                    DefaultScrollBarUI.this.onTrackHover(true);
                }
                if (this.isOverThumb != (hover = DefaultScrollBarUI.this.isThumbContains(x, y))) {
                    this.isOverThumb = hover;
                    DefaultScrollBarUI.this.onThumbHover(this.isOverThumb);
                }
            } else {
                this.updateMouseExit();
            }
        }

        private void updateMouseExit() {
            if (this.isOverThumb) {
                this.isOverThumb = false;
                DefaultScrollBarUI.this.onThumbHover(false);
            }
            if (this.isOverTrack) {
                this.isOverTrack = false;
                DefaultScrollBarUI.this.onTrackHover(false);
            }
        }

        private boolean redispatchIfTrackNotClickable(MouseEvent event) {
            JScrollPane pane;
            Component view;
            if (DefaultScrollBarUI.this.isTrackClickable()) {
                return false;
            }
            Container parent = DefaultScrollBarUI.this.myScrollBar.getParent();
            if (parent instanceof JScrollPane && (view = (pane = (JScrollPane)parent).getViewport().getView()) != null) {
                Point point = event.getLocationOnScreen();
                SwingUtilities.convertPointFromScreen(point, view);
                Component target = SwingUtilities.getDeepestComponentAt(view, point.x, point.y);
                MouseEventAdapter.redispatch((MouseEvent)event, (Component)target);
            }
            return true;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (DefaultScrollBarUI.this.myScrollBar != null && DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                this.redispatchIfTrackNotClickable(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean vertical;
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (this.redispatchIfTrackNotClickable(event)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.myCachedValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            DefaultScrollBarUI.this.myScrollBar.setValueIsAdjusting(true);
            this.myMouseX = event.getX();
            this.myMouseY = event.getY();
            boolean bl = vertical = 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation();
            if (DefaultScrollBarUI.this.isThumbContains(this.myMouseX, this.myMouseY)) {
                this.myOffset = vertical ? this.myMouseY - DefaultScrollBarUI.this.myThumb.bounds.y : this.myMouseX - DefaultScrollBarUI.this.myThumb.bounds.x;
                this.isDragging = true;
            } else if (DefaultScrollBarUI.this.isTrackContains(this.myMouseX, this.myMouseY)) {
                if (DefaultScrollBarUI.this.isAbsolutePositioning(event)) {
                    this.myOffset = (vertical ? DefaultScrollBarUI.this.myThumb.bounds.height : DefaultScrollBarUI.this.myThumb.bounds.width) / 2;
                    this.isDragging = true;
                    this.setValueFrom(event);
                } else {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                    this.isDragging = false;
                    if (1 == DefaultScrollBarUI.this.myScrollBar.getOrientation()) {
                        int y = DefaultScrollBarUI.this.myThumb.bounds.isEmpty() ? DefaultScrollBarUI.this.myScrollBar.getHeight() / 2 : DefaultScrollBarUI.this.myThumb.bounds.y;
                        this.isReversed = this.myMouseY < y;
                    } else {
                        int x = DefaultScrollBarUI.this.myThumb.bounds.isEmpty() ? DefaultScrollBarUI.this.myScrollBar.getWidth() / 2 : DefaultScrollBarUI.this.myThumb.bounds.x;
                        boolean bl2 = this.isReversed = this.myMouseX < x;
                        if (!DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight()) {
                            this.isReversed = !this.isReversed;
                        }
                    }
                    this.scroll(this.isReversed);
                    this.startScrollTimerIfNecessary();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (this.redispatchIfTrackNotClickable(event)) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            this.isDragging = false;
            this.myOffset = 0;
            DefaultScrollBarUI.this.myScrollTimer.stop();
            DefaultScrollBarUI.this.isValueCached = true;
            DefaultScrollBarUI.this.myCachedValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            DefaultScrollBarUI.this.myScrollBar.setValueIsAdjusting(false);
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (DefaultScrollBarUI.this.myThumb.bounds.isEmpty() || SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (this.isDragging) {
                this.setValueFrom(event);
            } else {
                this.myMouseX = event.getX();
                this.myMouseY = event.getY();
                this.updateMouse(this.myMouseX, this.myMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouse(event.getX(), event.getY());
            }
            this.redispatchIfTrackNotClickable(event);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null || !DefaultScrollBarUI.this.myScrollBar.isEnabled()) {
                return;
            }
            if (!this.isDragging) {
                this.updateMouseExit();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (DefaultScrollBarUI.this.myScrollBar == null) {
                DefaultScrollBarUI.this.myScrollTimer.stop();
            } else {
                this.scroll(this.isReversed);
                if (!DefaultScrollBarUI.this.myThumb.bounds.isEmpty() && (this.isReversed ? !this.isMouseBeforeThumb() : !this.isMouseAfterThumb())) {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                }
                int value = DefaultScrollBarUI.this.myScrollBar.getValue();
                if (this.isReversed ? value <= DefaultScrollBarUI.this.myScrollBar.getMinimum() : value >= DefaultScrollBarUI.this.myScrollBar.getMaximum() - DefaultScrollBarUI.this.myScrollBar.getVisibleAmount()) {
                    DefaultScrollBarUI.this.myScrollTimer.stop();
                }
            }
        }

        @Override
        public void focusGained(FocusEvent event) {
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent event) {
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            DefaultScrollBarUI.this.updateThumbBounds(false);
            DefaultScrollBarUI.this.isValueCached = false;
            DefaultScrollBarUI.this.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String name = event.getPropertyName();
            if ("model" == name) {
                BoundedRangeModel oldModel = (BoundedRangeModel)event.getOldValue();
                BoundedRangeModel newModel = (BoundedRangeModel)event.getNewValue();
                oldModel.removeChangeListener(this);
                newModel.addChangeListener(this);
            }
            if ("model" == name || "orientation" == name || "componentOrientation" == name) {
                DefaultScrollBarUI.this.repaint();
            }
            if ("opaque" == name || "visible" == name) {
                DefaultScrollBarUI.this.myTrack.animator.rewind(false);
                DefaultScrollBarUI.this.myThumb.animator.rewind(false);
                DefaultScrollBarUI.this.myTrack.bounds.setBounds(0, 0, 0, 0);
                DefaultScrollBarUI.this.myThumb.bounds.setBounds(0, 0, 0, 0);
            }
        }

        private void setValueFrom(MouseEvent event) {
            boolean isDefaultOrientation;
            int thumbPos;
            int thumbMin;
            int thumbMax;
            int x = event.getX();
            int y = event.getY();
            if (1 == DefaultScrollBarUI.this.myScrollBar.getOrientation()) {
                thumbMax = DefaultScrollBarUI.this.myTrack.bounds.y + DefaultScrollBarUI.this.myTrack.bounds.height - DefaultScrollBarUI.this.myThumb.bounds.height;
                thumbMin = DefaultScrollBarUI.this.myTrack.bounds.y;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, y - this.myOffset));
                if (DefaultScrollBarUI.this.myThumb.bounds.y != thumbPos) {
                    int minY = Math.min(DefaultScrollBarUI.this.myThumb.bounds.y, thumbPos);
                    int maxY = Math.max(DefaultScrollBarUI.this.myThumb.bounds.y, thumbPos) + DefaultScrollBarUI.this.myThumb.bounds.height;
                    DefaultScrollBarUI.this.myThumb.bounds.y = thumbPos;
                    DefaultScrollBarUI.this.onThumbMove();
                    DefaultScrollBarUI.this.repaint(DefaultScrollBarUI.this.myThumb.bounds.x, minY, DefaultScrollBarUI.this.myThumb.bounds.width, maxY - minY);
                }
            } else {
                thumbMax = DefaultScrollBarUI.this.myTrack.bounds.x + DefaultScrollBarUI.this.myTrack.bounds.width - DefaultScrollBarUI.this.myThumb.bounds.width;
                thumbMin = DefaultScrollBarUI.this.myTrack.bounds.x;
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, x - this.myOffset));
                if (DefaultScrollBarUI.this.myThumb.bounds.x != thumbPos) {
                    int minX = Math.min(DefaultScrollBarUI.this.myThumb.bounds.x, thumbPos);
                    int maxX = Math.max(DefaultScrollBarUI.this.myThumb.bounds.x, thumbPos) + DefaultScrollBarUI.this.myThumb.bounds.width;
                    DefaultScrollBarUI.this.myThumb.bounds.x = thumbPos;
                    DefaultScrollBarUI.this.onThumbMove();
                    DefaultScrollBarUI.this.repaint(minX, DefaultScrollBarUI.this.myThumb.bounds.y, maxX - minX, DefaultScrollBarUI.this.myThumb.bounds.height);
                }
            }
            int valueMin = DefaultScrollBarUI.this.myScrollBar.getMinimum();
            int valueMax = DefaultScrollBarUI.this.myScrollBar.getMaximum() - DefaultScrollBarUI.this.myScrollBar.getVisibleAmount();
            boolean bl = isDefaultOrientation = 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() || DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight();
            if (thumbPos == thumbMax) {
                DefaultScrollBarUI.this.myScrollBar.setValue(isDefaultOrientation ? valueMax : valueMin);
            } else {
                int valueRange = valueMax - valueMin;
                int thumbRange = thumbMax - thumbMin;
                int thumbValue = isDefaultOrientation ? thumbPos - thumbMin : thumbMax - thumbPos;
                DefaultScrollBarUI.this.isValueCached = true;
                DefaultScrollBarUI.this.myCachedValue = valueMin + DefaultScrollBarUI.convert(valueRange, thumbValue, thumbRange);
                DefaultScrollBarUI.this.myScrollBar.setValue(DefaultScrollBarUI.this.myCachedValue);
            }
            if (!this.isDragging) {
                this.updateMouse(x, y);
            }
        }

        private void startScrollTimerIfNecessary() {
            if (!DefaultScrollBarUI.this.myScrollTimer.isRunning() && (this.isReversed ? this.isMouseBeforeThumb() : this.isMouseAfterThumb())) {
                DefaultScrollBarUI.this.myScrollTimer.start();
            }
        }

        private boolean isMouseBeforeThumb() {
            return 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnTop() : (DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnLeft() : this.isMouseOnRight());
        }

        private boolean isMouseAfterThumb() {
            return 1 == DefaultScrollBarUI.this.myScrollBar.getOrientation() ? this.isMouseOnBottom() : (DefaultScrollBarUI.this.myScrollBar.getComponentOrientation().isLeftToRight() ? this.isMouseOnRight() : this.isMouseOnLeft());
        }

        private boolean isMouseOnTop() {
            return this.myMouseY < DefaultScrollBarUI.this.myThumb.bounds.y;
        }

        private boolean isMouseOnLeft() {
            return this.myMouseX < DefaultScrollBarUI.this.myThumb.bounds.x;
        }

        private boolean isMouseOnRight() {
            return this.myMouseX > DefaultScrollBarUI.this.myThumb.bounds.x + DefaultScrollBarUI.this.myThumb.bounds.width;
        }

        private boolean isMouseOnBottom() {
            return this.myMouseY > DefaultScrollBarUI.this.myThumb.bounds.y + DefaultScrollBarUI.this.myThumb.bounds.height;
        }

        private void scroll(boolean reversed) {
            int delta = DefaultScrollBarUI.this.myScrollBar.getBlockIncrement(reversed ? -1 : 1);
            if (reversed) {
                delta = -delta;
            }
            int oldValue = DefaultScrollBarUI.this.myScrollBar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = DefaultScrollBarUI.this.myScrollBar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = DefaultScrollBarUI.this.myScrollBar.getMinimum();
            }
            if (oldValue != newValue) {
                DefaultScrollBarUI.this.myScrollBar.setValue(newValue);
            }
        }
    }
}

