/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePatternPackageSet
extends PatternBasedPackageSet {
    @NonNls
    public static final String SCOPE_FILE = "file";
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.psi.search.scope.packageSet.FilePatternPackageSet");

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        super(modulePattern);
        this.myPathPattern = filePattern;
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull NamedScopesHolder holder) {
        if (file == null) {
            FilePatternPackageSet.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            FilePatternPackageSet.$$$reportNull$$$0(1);
        }
        return this.contains(file, holder.getProject(), holder);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (file == null) {
            FilePatternPackageSet.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FilePatternPackageSet.$$$reportNull$$$0(3);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return this.fileMatcher(file, fileIndex, holder != null ? holder.getProjectBaseDir() : project.getBaseDir()) && this.matchesModule(file, fileIndex);
    }

    private boolean fileMatcher(@NotNull VirtualFile virtualFile2, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        String relativePath;
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(4);
        }
        if (virtualFile2 instanceof VirtualFileWindow) {
            virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
        }
        if ((relativePath = FilePatternPackageSet.getRelativePath(virtualFile2, fileIndex, true, projectBaseDir)) == null) {
            LOG.error("vFile: " + virtualFile2 + "; projectBaseDir: " + projectBaseDir + "; content File: " + fileIndex.getContentRootForFile(virtualFile2));
        }
        if (StringUtil.isEmptyOrSpaces((String)relativePath) && !virtualFile2.equals(projectBaseDir)) {
            return false;
        }
        if (virtualFile2.isDirectory()) {
            relativePath = relativePath + '/';
        }
        return this.myFilePattern.matcher(relativePath).matches();
    }

    static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\").append(separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\").append(separator).append("]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\").append(separator).append("(.*\\").append(separator).append(")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\").append(separator).append("]*");
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        FilePatternPackageSet filePatternPackageSet = new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
        if (filePatternPackageSet == null) {
            FilePatternPackageSet.$$$reportNull$$$0(5);
        }
        return filePatternPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        StringBuilder buf = new StringBuilder(SCOPE_FILE);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        String string = buf.toString();
        if (string == null) {
            FilePatternPackageSet.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual((String)this.myPathPattern, (String)oldQName) || Comparing.strEqual((String)(oldQName + "//*"), (String)this.myPathPattern) || Comparing.strEqual((String)(oldQName + "/*"), (String)this.myPathPattern);
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updatePattern(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(7);
        }
        if (newName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(8);
        }
        FilePatternPackageSet filePatternPackageSet = new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern.replace(oldName, newName));
        if (filePatternPackageSet == null) {
            FilePatternPackageSet.$$$reportNull$$$0(9);
        }
        return filePatternPackageSet;
    }

    @Override
    @NotNull
    public PatternBasedPackageSet updateModulePattern(@NotNull String oldName, @NotNull String newName) {
        if (oldName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            FilePatternPackageSet.$$$reportNull$$$0(11);
        }
        FilePatternPackageSet filePatternPackageSet = new FilePatternPackageSet(this.myModulePatternText.replace(oldName, newName), this.myPathPattern);
        if (filePatternPackageSet == null) {
            FilePatternPackageSet.$$$reportNull$$$0(12);
        }
        return filePatternPackageSet;
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile virtualFile2, @NotNull ProjectFileIndex index, boolean useFQName, VirtualFile projectBaseDir) {
        VirtualFile contentRootForFile;
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(13);
        }
        if (index == null) {
            FilePatternPackageSet.$$$reportNull$$$0(14);
        }
        if ((contentRootForFile = index.getContentRootForFile(virtualFile2)) != null) {
            return VfsUtilCore.getRelativePath(virtualFile2, contentRootForFile, '/');
        }
        Module module = index.getModuleForFile(virtualFile2);
        if (module != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor(projectBaseDir, virtualFile2, false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath(virtualFile2, projectBaseDir, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile2.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile2, index);
    }

    public static String getLibRelativePath(VirtualFile virtualFile2, ProjectFileIndex index) {
        ArrayList<String> path2 = new ArrayList<String>();
        for (VirtualFile directory = virtualFile2; directory != null && index.isInLibrary(directory); directory = directory.getParent()) {
            path2.add(directory.getName());
        }
        if (path2.isEmpty()) {
            return "";
        }
        Collections.reverse(path2);
        return StringUtil.join((String[])ArrayUtilRt.toStringArray(path2), (int)1, (int)path2.size(), (String)"/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCOPE_FILE;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePattern";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "updateModulePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileMatcher";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePattern";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateModulePattern";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

