/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListener;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemSettings<SS extends AbstractExternalSystemSettings<SS, PS, L>, PS extends ExternalProjectSettings, L extends ExternalSystemSettingsListener<PS>>
implements Disposable {
    @NotNull
    private final Topic<L> myChangesTopic;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettings;
    @NotNull
    private final Map<String, PS> myLinkedProjectsSettingsView;

    protected AbstractExternalSystemSettings(@NotNull Topic<L> topic, @NotNull Project project) {
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(1);
        }
        this.myLinkedProjectsSettings = new HashMap<String, PS>();
        this.myLinkedProjectsSettingsView = Collections.unmodifiableMap(this.myLinkedProjectsSettings);
        this.myChangesTopic = topic;
        this.myProject = project;
    }

    public void dispose() {
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(2);
        }
        return project;
    }

    public boolean showSelectiveImportDialogOnInitialImport() {
        return SystemProperties.is((String)"external.system.show.selective.import.dialog");
    }

    public void subscribe(@NotNull ExternalSystemSettingsListener<PS> listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(4);
        }
        this.subscribe(listener2);
    }

    @Deprecated
    public abstract void subscribe(@NotNull ExternalSystemSettingsListener<PS> var1);

    protected void doSubscribe(@NotNull L listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(6);
        }
        Project project = this.getProject();
        MessageBus messageBus = project.getMessageBus();
        MessageBusConnection connection = messageBus.connect(parentDisposable);
        connection.subscribe(this.getChangesTopic(), listener2);
    }

    public void copyFrom(@NotNull SS settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(7);
        }
        for (ExternalProjectSettings projectSettings : ((AbstractExternalSystemSettings)settings).getLinkedProjectsSettings()) {
            this.myLinkedProjectsSettings.put(projectSettings.getExternalProjectPath(), projectSettings);
        }
        this.copyExtraSettingsFrom(settings);
    }

    protected abstract void copyExtraSettingsFrom(@NotNull SS var1);

    @NotNull
    public Collection<PS> getLinkedProjectsSettings() {
        Collection<PS> collection = this.myLinkedProjectsSettingsView.values();
        if (collection == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nullable
    public PS getLinkedProjectSettings(@NotNull String linkedProjectPath) {
        ExternalProjectSettings ps;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(9);
        }
        if ((ps = (ExternalProjectSettings)this.myLinkedProjectsSettings.get(linkedProjectPath)) == null) {
            for (ExternalProjectSettings ps1 : this.myLinkedProjectsSettings.values()) {
                for (String modulePath : ps1.getModules()) {
                    if (!linkedProjectPath.equals(modulePath)) continue;
                    return (PS)ps1;
                }
            }
        }
        return (PS)ps;
    }

    public void linkProject(@NotNull PS settings) throws IllegalArgumentException {
        PS existing;
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(10);
        }
        if ((existing = this.getLinkedProjectSettings(((ExternalProjectSettings)settings).getExternalProjectPath())) != null) {
            throw new IllegalArgumentException(String.format("Can't link project '%s'. Reason: it's already linked to the IDE project", ((ExternalProjectSettings)settings).getExternalProjectPath()));
        }
        this.myLinkedProjectsSettings.put(((ExternalProjectSettings)settings).getExternalProjectPath(), settings);
        this.getPublisher().onProjectsLinked(Collections.singleton(settings));
    }

    public boolean unlinkExternalProject(@NotNull String linkedProjectPath) {
        ExternalProjectSettings removed;
        if (linkedProjectPath == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(11);
        }
        if ((removed = (ExternalProjectSettings)this.myLinkedProjectsSettings.remove(linkedProjectPath)) == null) {
            return false;
        }
        this.getPublisher().onProjectsUnlinked(Collections.singleton(linkedProjectPath));
        return true;
    }

    public void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(12);
        }
        this.setLinkedProjectsSettings(settings, null);
    }

    private void setLinkedProjectsSettings(@NotNull Collection<? extends PS> settings, @Nullable ExternalSystemSettingsListener listener2) {
        if (settings == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(13);
        }
        settings = ContainerUtil.filter(settings, ps -> ps.getExternalProjectPath() != null);
        ArrayList<ExternalProjectSettings> added = new ArrayList<ExternalProjectSettings>();
        HashMap<String, PS> removed = new HashMap<String, PS>(this.myLinkedProjectsSettings);
        this.myLinkedProjectsSettings.clear();
        for (ExternalProjectSettings current : settings) {
            this.myLinkedProjectsSettings.put(current.getExternalProjectPath(), current);
        }
        for (ExternalProjectSettings current : settings) {
            ExternalProjectSettings old = (ExternalProjectSettings)removed.remove(current.getExternalProjectPath());
            if (old == null) {
                added.add(current);
                continue;
            }
            if (current.isUseAutoImport() != old.isUseAutoImport()) {
                if (listener2 != null) {
                    listener2.onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
                }
                this.getPublisher().onUseAutoImportChange(current.isUseAutoImport(), current.getExternalProjectPath());
            }
            this.checkSettings(old, current);
        }
        if (!added.isEmpty()) {
            if (listener2 != null) {
                listener2.onProjectsLinked(added);
            }
            this.getPublisher().onProjectsLinked(added);
        }
        if (!removed.isEmpty()) {
            if (listener2 != null) {
                listener2.onProjectsUnlinked(removed.keySet());
            }
            this.getPublisher().onProjectsUnlinked(removed.keySet());
        }
    }

    protected abstract void checkSettings(@NotNull PS var1, @NotNull PS var2);

    @NotNull
    public Topic<L> getChangesTopic() {
        Topic<L> topic = this.myChangesTopic;
        if (topic == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(14);
        }
        return topic;
    }

    @NotNull
    public L getPublisher() {
        ExternalSystemSettingsListener externalSystemSettingsListener = (ExternalSystemSettingsListener)this.getProject().getMessageBus().syncPublisher(this.myChangesTopic);
        if (externalSystemSettingsListener == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(15);
        }
        return (L)externalSystemSettingsListener;
    }

    protected void fillState(@NotNull State<PS> state) {
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(16);
        }
        state.setLinkedExternalProjectsSettings(ContainerUtilRt.newTreeSet(this.myLinkedProjectsSettings.values()));
    }

    protected void loadState(@NotNull State<PS> state) {
        Set<PS> settings;
        if (state == null) {
            AbstractExternalSystemSettings.$$$reportNull$$$0(17);
        }
        if ((settings = state.getLinkedExternalProjectsSettings()) != null) {
            this.setLinkedProjectsSettings(settings, new ExternalSystemSettingsListenerAdapter(){

                @Override
                public void onProjectsLinked(@NotNull Collection linked) {
                    if (linked == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        return;
                    }
                    Project project = AbstractExternalSystemSettings.this.getProject();
                    for (Object o : linked) {
                        ExternalProjectSettings settings = (ExternalProjectSettings)o;
                        for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                            AbstractExternalSystemSettings se = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)project);
                            ProjectSystemId externalSystemId = manager.getSystemId();
                            if (settings != se.getLinkedProjectSettings(settings.getExternalProjectPath())) continue;
                            ExternalProjectsManager.getInstance(project).refreshProject(settings.getExternalProjectPath(), new ImportSpecBuilder(project, externalSystemId).useDefaultCallback().use(ProgressExecutionMode.IN_BACKGROUND_ASYNC).build());
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linked", "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings$1", "onProjectsLinked"));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPath";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinkedProjectsSettings";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesTopic";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublisher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doSubscribe";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProjectSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "linkProject";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unlinkExternalProject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setLinkedProjectsSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface State<S> {
        public Set<S> getLinkedExternalProjectsSettings();

        public void setLinkedExternalProjectsSettings(Set<S> var1);
    }
}

