/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplicationNamesInfo {
    private static final String COMPONENT_NAME = "ApplicationInfo";
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myDefaultLauncherName;
    private final String myMotto;

    public static String getComponentName() {
        String prefix = System.getProperty("idea.platform.prefix");
        return prefix != null ? prefix + COMPONENT_NAME : COMPONENT_NAME;
    }

    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfoHolder.ourInstance;
        if (applicationNamesInfo == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(0);
        }
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo() {
        String resource = "/idea/" + ApplicationNamesInfo.getComponentName() + ".xml";
        try {
            Element rootElement = JDOMUtil.load(ApplicationNamesInfo.class, (String)resource);
            Element names = rootElement.getChild("names", rootElement.getNamespace());
            this.myProductName = names.getAttributeValue("product");
            this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
            this.myEditionName = names.getAttributeValue("edition");
            this.myScriptName = names.getAttributeValue("script");
            this.myDefaultLauncherName = names.getAttributeValue("default-launcher-name", this.myScriptName);
            this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
    }

    public String getProductName() {
        return this.myProductName;
    }

    public String getFullProductName() {
        return this.myFullProductName;
    }

    public String getFullProductNameWithEdition() {
        return this.myEditionName != null ? this.myFullProductName + ' ' + this.myEditionName : this.myFullProductName;
    }

    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        return StringUtil.capitalize((String)StringUtil.toLowerCase((String)this.myProductName));
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    public String getDefaultLauncherName() {
        return this.myDefaultLauncherName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ApplicationNamesInfoHolder {
        private static final ApplicationNamesInfo ourInstance = new ApplicationNamesInfo();

        private ApplicationNamesInfoHolder() {
        }
    }
}

