/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.SelfKiller;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseOutputReader;
import gnu.trove.THashSet;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OSProcessHandler
extends BaseOSProcessHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.process.OSProcessHandler");
    private static final Set<String> REPORTED_EXECUTIONS = ContainerUtil.newConcurrentSet();
    private static final long ALLOWED_TIMEOUT_THRESHOLD = 10L;
    public static final Key<Set<File>> DELETE_FILES_ON_TERMINATION = Key.create((String)"OSProcessHandler.FileToDelete");
    private boolean myHasErrorStream;
    private boolean myHasPty;
    private boolean myDestroyRecursively;
    private Set<File> myFilesToDelete;

    public OSProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(0);
        }
        this(OSProcessHandler.startProcess(commandLine), commandLine.getCommandLineString(), commandLine.getCharset());
        this.myHasErrorStream = !commandLine.isRedirectErrorStream();
        this.myFilesToDelete = commandLine.getUserData(DELETE_FILES_ON_TERMINATION);
    }

    private static Process startProcess(GeneralCommandLine commandLine) throws ExecutionException {
        try {
            return commandLine.createProcess();
        }
        catch (ExecutionException | Error | RuntimeException e) {
            OSProcessHandler.deleteTempFiles(commandLine.getUserData(DELETE_FILES_ON_TERMINATION));
            throw e;
        }
    }

    public boolean waitFor() {
        OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        return super.waitFor();
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        if (timeoutInMilliseconds > 10L) {
            OSProcessHandler.checkEdtAndReadAction((ProcessHandler)this);
        }
        return super.waitFor(timeoutInMilliseconds);
    }

    public static void checkEdtAndReadAction(@NotNull ProcessHandler processHandler) {
        Application application;
        if (processHandler == null) {
            OSProcessHandler.$$$reportNull$$$0(1);
        }
        if ((application = ApplicationManager.getApplication()) == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        String message = null;
        if (application.isDispatchThread()) {
            message = "Synchronous execution on EDT: ";
        } else if (application.isReadAccessAllowed()) {
            message = "Synchronous execution under ReadAction: ";
        }
        if (message != null && REPORTED_EXECUTIONS.add(ExceptionUtil.currentStackTrace())) {
            LOG.error(message + processHandler);
        }
    }

    private static void deleteTempFiles(Set<? extends File> tempFiles) {
        if (tempFiles != null) {
            try {
                for (File file : tempFiles) {
                    FileUtil.delete((File)file);
                }
            }
            catch (Throwable t) {
                LOG.error("failed to delete temp. files", t);
            }
        }
    }

    @Deprecated
    public OSProcessHandler(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(2);
        }
        this(process, null);
    }

    public OSProcessHandler(@NotNull Process process, String commandLine) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(3);
        }
        this(process, commandLine, EncodingManager.getInstance().getDefaultCharset());
    }

    public OSProcessHandler(@NotNull Process process, String commandLine, @Nullable Charset charset) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(4);
        }
        super(process, commandLine, charset);
        this.myHasErrorStream = true;
        this.myDestroyRecursively = true;
        this.myFilesToDelete = null;
        this.setHasPty(OSProcessHandler.isPtyProcess(process));
    }

    private static boolean isPtyProcess(Process process) {
        for (Class<?> c = process.getClass(); c != null; c = c.getSuperclass()) {
            if (!"com.pty4j.unix.UnixPtyProcess".equals(c.getName()) && !"com.pty4j.windows.WinPtyProcess".equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    protected void onOSProcessTerminated(int exitCode) {
        super.onOSProcessTerminated(exitCode);
        OSProcessHandler.deleteTempFiles(this.myFilesToDelete);
    }

    protected boolean processHasSeparateErrorStream() {
        return this.myHasErrorStream;
    }

    protected boolean shouldDestroyProcessRecursively() {
        return this.myDestroyRecursively;
    }

    public void setShouldDestroyProcessRecursively(boolean destroyRecursively) {
        this.myDestroyRecursively = destroyRecursively;
    }

    protected void doDestroyProcess() {
        Process process = this.getProcess();
        if (this.shouldDestroyProcessRecursively() && OSProcessHandler.processCanBeKilledByOS(process)) {
            this.killProcessTree(process);
        } else {
            process.destroy();
        }
    }

    public static boolean processCanBeKilledByOS(Process process) {
        return !(process instanceof SelfKiller);
    }

    protected void killProcessTree(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.killProcessTreeSync(process);
        } else {
            this.executeTask(() -> this.killProcessTreeSync(process));
        }
    }

    private void killProcessTreeSync(@NotNull Process process) {
        if (process == null) {
            OSProcessHandler.$$$reportNull$$$0(6);
        }
        LOG.debug("killing process tree");
        boolean destroyed = OSProcessManager.getInstance().killProcessTree(process);
        if (!destroyed) {
            if (!process.isAlive()) {
                LOG.warn("Process has been already terminated: " + this.myCommandLine);
            } else {
                LOG.warn("Cannot kill process tree. Trying to destroy process using Java API. Cmdline:\n" + this.myCommandLine);
                process.destroy();
            }
        }
    }

    public void setHasPty(boolean hasPty) {
        this.myHasPty = hasPty;
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = this.myHasPty ? BaseOutputReader.Options.BLOCKING : super.readerOptions();
        if (options == null) {
            OSProcessHandler.$$$reportNull$$$0(7);
        }
        return options;
    }

    public static void deleteFileOnTermination(@NotNull GeneralCommandLine commandLine, @NotNull File fileToDelete) {
        THashSet set;
        if (commandLine == null) {
            OSProcessHandler.$$$reportNull$$$0(8);
        }
        if (fileToDelete == null) {
            OSProcessHandler.$$$reportNull$$$0(9);
        }
        if ((set = commandLine.getUserData(DELETE_FILES_ON_TERMINATION)) == null) {
            set = new THashSet();
            commandLine.putUserData(DELETE_FILES_ON_TERMINATION, set);
        }
        set.add((File)fileToDelete);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/OSProcessHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkEdtAndReadAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTree";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "killProcessTreeSync";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deleteFileOnTermination";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

