/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.mock.MockApplicationEx;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.UsefulTestCase;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.MutablePicoContainer;

public abstract class PlatformLiteFixture
extends UsefulTestCase {
    protected MockProjectEx myProject;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Extensions.cleanRootArea((Disposable)this.getTestRootDisposable());
    }

    @NotNull
    public static MockApplicationEx getApplication() {
        MockApplicationEx mockApplicationEx = (MockApplicationEx)ApplicationManager.getApplication();
        if (mockApplicationEx == null) {
            PlatformLiteFixture.$$$reportNull$$$0(0);
        }
        return mockApplicationEx;
    }

    public void initApplication() {
        MockApplicationEx instance2 = new MockApplicationEx(this.getTestRootDisposable());
        ApplicationManager.setApplication((Application)instance2, () -> FileTypeManager.getInstance(), (Disposable)this.getTestRootDisposable());
        PlatformLiteFixture.getApplication().registerService(EncodingManager.class, EncodingManagerImpl.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myProject = null;
        try {
            super.tearDown();
        }
        finally {
            PlatformLiteFixture.clearFields((Object)this);
        }
    }

    protected <T> void registerExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull T extension) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(1);
        }
        if (extension == null) {
            PlatformLiteFixture.$$$reportNull$$$0(2);
        }
        this.registerExtension(Extensions.getRootArea(), extensionPointName, extension);
    }

    public <T> void registerExtension(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> name, @NotNull T extension) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(3);
        }
        if (name == null) {
            PlatformLiteFixture.$$$reportNull$$$0(4);
        }
        if (extension == null) {
            PlatformLiteFixture.$$$reportNull$$$0(5);
        }
        this.registerExtensionPoint(area, name, extension.getClass());
        PlatformTestUtil.registerExtension(area, name, extension, this.getTestRootDisposable());
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(6);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(7);
        }
        this.registerExtensionPoint(Extensions.getRootArea(), extensionPointName, aClass);
    }

    protected <T> void registerExtensionPoint(@NotNull ExtensionsArea area, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<? extends T> aClass) {
        if (area == null) {
            PlatformLiteFixture.$$$reportNull$$$0(8);
        }
        if (extensionPointName == null) {
            PlatformLiteFixture.$$$reportNull$$$0(9);
        }
        if (aClass == null) {
            PlatformLiteFixture.$$$reportNull$$$0(10);
        }
        if (!area.hasExtensionPoint(extensionPointName)) {
            ExtensionPoint.Kind kind = aClass.isInterface() || (aClass.getModifiers() & 0x400) != 0 ? ExtensionPoint.Kind.INTERFACE : ExtensionPoint.Kind.BEAN_CLASS;
            area.registerExtensionPoint(extensionPointName, aClass.getName(), kind, this.getTestRootDisposable());
        }
    }

    protected void registerComponentImplementation(@NotNull MutablePicoContainer container, @NotNull Class<?> key, @NotNull Class<?> implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(11);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(12);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(13);
        }
        container.unregisterComponent(key);
        container.registerComponentImplementation(key, implementation);
    }

    public static <T> T registerComponentInstance(@NotNull MutablePicoContainer container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(14);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(15);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(16);
        }
        Object old = container.getComponentInstance(key);
        container.unregisterComponent(key);
        container.registerComponentInstance(key, implementation);
        return (T)old;
    }

    public static <T> T registerComponentInstance(@NotNull ComponentManager container, @NotNull Class<T> key, @NotNull T implementation) {
        if (container == null) {
            PlatformLiteFixture.$$$reportNull$$$0(17);
        }
        if (key == null) {
            PlatformLiteFixture.$$$reportNull$$$0(18);
        }
        if (implementation == null) {
            PlatformLiteFixture.$$$reportNull$$$0(19);
        }
        return PlatformLiteFixture.registerComponentInstance((MutablePicoContainer)container.getPicoContainer(), key, implementation);
    }

    protected <T> void registerApplicationService(Class<T> aClass, T object) {
        PlatformLiteFixture.getApplication().registerService(aClass, object);
        Disposer.register((Disposable)this.getTestRootDisposable(), () -> PlatformLiteFixture.getApplication().getPicoContainer().unregisterComponent((Object)aClass.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PlatformLiteFixture";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PlatformLiteFixture";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

