/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ConstantConditionalExpressionJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.CONTROL_FLOW_GROUP_NAME;
        if (string == null) {
            ConstantConditionalExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("constant.conditional.expression.display.name", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantConditionalExpressionVisitor();
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("constant.conditional.expression.error.string", new Object[0]);
        if (string == null) {
            ConstantConditionalExpressionJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    static String calculateReplacementExpression(JSConditionalExpression exp) {
        JSExpression thenExpression = exp.getThen();
        JSExpression elseExpression = exp.getElse();
        JSExpression condition = exp.getCondition();
        assert (thenExpression != null);
        assert (elseExpression != null);
        if (ControlFlowUtils.isTrue(condition)) {
            return thenExpression.getText();
        }
        return elseExpression.getText();
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return new ConstantConditionalFix();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/control/ConstantConditionalExpressionJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ConstantConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConstantConditionalExpressionVisitor() {
        }

        public void visitJSConditionalExpression(JSConditionalExpression expression) {
            super.visitJSConditionalExpression(expression);
            JSExpression condition = expression.getCondition();
            JSExpression thenExpression = expression.getThen();
            if (thenExpression == null) {
                return;
            }
            JSExpression elseExpression = expression.getElse();
            if (elseExpression == null) {
                return;
            }
            if (ControlFlowUtils.isTrueOrFalse(condition)) {
                this.registerError((PsiElement)expression, expression);
            }
        }
    }

    private static class ConstantConditionalFix
    extends InspectionJSFix {
        private ConstantConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("simplify.fix", new Object[0]);
            if (string == null) {
                ConstantConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor2.getPsiElement();
            String newExpression = ConstantConditionalExpressionJSInspection.calculateReplacementExpression(expression);
            ConstantConditionalFix.replaceExpression((JSExpression)expression, newExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConstantConditionalExpressionJSInspection$ConstantConditionalFix", "getFamilyName"));
        }
    }
}

