/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.assignment;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToForLoopParameterJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("assignment.to.for.loop.parameter.display.name", new Object[0]);
        if (string == null) {
            AssignmentToForLoopParameterJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.ASSIGNMENT_GROUP_NAME;
        if (string == null) {
            AssignmentToForLoopParameterJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("assignment.to.for.loop.parameter.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final TokenSet INC_DEC = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PLUSPLUS, JSTokenTypes.MINUSMINUS});

        private Visitor() {
        }

        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSAssignmentExpression(expression);
            JSExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            this.checkForForLoopParam(lhs);
            this.checkForForeachLoopParam(lhs);
        }

        public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitJSPrefixExpression(expression);
            this.validateIncDec(expression.getOperationSign(), expression.getExpression());
        }

        public void visitJSPostfixExpression(@NotNull JSPostfixExpression expression) {
            if (expression == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            super.visitJSPostfixExpression(expression);
            this.validateIncDec(expression.getOperationSign(), expression.getExpression());
        }

        private void validateIncDec(IElementType sign, JSExpression operand) {
            if (!INC_DEC.contains(sign) || operand == null) {
                return;
            }
            this.checkForForLoopParam(operand);
            this.checkForForeachLoopParam(operand);
        }

        private void checkForForLoopParam(JSExpression expression) {
            JSVariable variable = Visitor.getVariable(expression);
            if (variable == null) {
                return;
            }
            JSVarStatement decl = variable.getStatement();
            if (decl == null) {
                return;
            }
            PsiElement parent = decl.getParent();
            if (!(parent instanceof JSForStatement)) {
                return;
            }
            JSForStatement forStatement = (JSForStatement)parent;
            if (!Visitor.isInForStatementBody(expression, forStatement)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private void checkForForeachLoopParam(JSExpression expression) {
            JSVariable parameter = Visitor.getVariable(expression);
            if (parameter == null) {
                return;
            }
            JSVarStatement varStatement = parameter.getStatement();
            if (varStatement == null || !(varStatement.getParent() instanceof JSForInStatement)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        @Nullable
        private static JSVariable getVariable(JSExpression expression) {
            if (!(expression instanceof JSReferenceExpression)) {
                return null;
            }
            JSReferenceExpression ref = (JSReferenceExpression)expression;
            PsiElement element = ref.resolve();
            if (!(element instanceof JSVariable)) {
                return null;
            }
            return (JSVariable)element;
        }

        private static boolean isInForStatementBody(JSExpression expression, JSForStatement statement) {
            JSStatement body = statement.getBody();
            return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)expression, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/assignment/AssignmentToForLoopParameterJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPostfixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

