/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.action.TypeScriptRestartServiceAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.Nullable;

public class TypeScriptToolWindowProvider {
    private final JSLanguageServiceToolWindowManager myToolWindow;

    @Nullable
    public static JSLanguageServiceToolWindowManager getToolWindow(Project project) {
        if (project == null || project.isDefault() || project.isDisposed()) {
            return null;
        }
        TypeScriptToolWindowProvider provider2 = (TypeScriptToolWindowProvider)ServiceManager.getService((Project)project, TypeScriptToolWindowProvider.class);
        return provider2 == null ? null : provider2.getToolWindow();
    }

    public TypeScriptToolWindowProvider(Project project, TypeScriptCompilerSettings settings) {
        TypeScriptRestartServiceAction restartCompilerAction = new TypeScriptRestartServiceAction(){

            @Override
            protected void setEnableAndVisible(Presentation presentation, boolean isEnabled) {
                presentation.setEnabled(isEnabled);
            }
        };
        this.myToolWindow = new TypeScriptLanguageServiceToolWindowManager(project, restartCompilerAction, settings);
        Disposer.register((Disposable)project, (Disposable)this.myToolWindow);
    }

    public JSLanguageServiceToolWindowManager getToolWindow() {
        return this.myToolWindow;
    }
}

