/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSJoinDeclarationAndAssignmentFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<JSVariable> myVariablePointer;
    private final SmartPsiElementPointer<JSReferenceExpression> myExpressionPointer;

    public JSJoinDeclarationAndAssignmentFix(JSVariable node, JSReferenceExpression expression) {
        this.myVariablePointer = SmartPointerManager.createPointer((PsiElement)node);
        this.myExpressionPointer = SmartPointerManager.createPointer((PsiElement)expression);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.join.declaration.assignment.inspection.fix", (Object[])new Object[0]);
        if (string == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            JSJoinDeclarationAndAssignmentFix.$$$reportNull$$$0(2);
        }
        JSVariable variable = (JSVariable)this.myVariablePointer.getElement();
        JSReferenceExpression expression = (JSReferenceExpression)this.myExpressionPointer.getElement();
        if (variable == null || expression == null) {
            return;
        }
        JSVarStatement statement = variable.getStatement();
        assert (statement != null);
        JSVarStatement.VarKeyword keyword = statement.getVarKeyword();
        assert (keyword != null);
        PsiElement parent = expression.getParent();
        if (parent instanceof JSForInStatement) {
            JSJoinDeclarationAndAssignmentFix.transformForInLoop(variable, expression, statement, keyword, (PsiElement)expression);
            return;
        }
        assert (parent instanceof JSDefinitionExpression);
        JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)ObjectUtils.tryCast((Object)parent.getParent(), JSAssignmentExpression.class);
        if (assignmentExpression == null) {
            JSForInStatement forInStatement = (JSForInStatement)ObjectUtils.tryCast((Object)parent.getParent(), JSForInStatement.class);
            if (forInStatement != null) {
                JSJoinDeclarationAndAssignmentFix.transformForInLoop(variable, expression, statement, keyword, parent);
            }
            return;
        }
        JSExpression rOperand = assignmentExpression.getROperand();
        if (rOperand == null) {
            return;
        }
        PsiElement typeElement = variable.getTypeElement();
        String typeAnno = typeElement == null ? "" : ": " + typeElement.getText();
        String newStatementText = keyword.getText() + " " + variable.getName() + typeAnno + " = " + rOperand.getText();
        PsiElement assignmentParent = assignmentExpression.getParent();
        if (assignmentParent instanceof JSForStatement) {
            PsiElement replaced = assignmentExpression.replace((PsiElement)JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression));
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments((JSStatement)statement, replaced);
            return;
        }
        newStatementText = newStatementText + JSCodeStyleSettings.getSemicolon((PsiElement)variable);
        JSStatement newStatement = JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression);
        JSStatement jsStatement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)assignmentExpression, JSStatement.class);
        assert (jsStatement != null);
        JSVarStatement introducedStatement = (JSVarStatement)jsStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)jsStatement);
        if (statement.getVariables().length == 1) {
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments((JSStatement)statement, (PsiElement)introducedStatement);
        } else {
            variable.delete();
        }
        if (jsStatement instanceof JSExpressionStatement && ((JSExpressionStatement)jsStatement).getExpression() == assignmentExpression) {
            JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments(jsStatement, (PsiElement)introducedStatement);
        } else {
            assignmentExpression.delete();
        }
        JSJoinDeclarationAndAssignmentFix.fixTrailingWhitespaces((PsiElement)introducedStatement);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            editor.getCaretModel().moveToOffset(introducedStatement.getVariables()[0].getTextOffset());
        }
    }

    private static void transformForInLoop(JSVariable variable, JSReferenceExpression expression, JSVarStatement statement, JSVarStatement.VarKeyword keyword, PsiElement parent) {
        String newStatementText = keyword.getText() + " " + variable.getName();
        PsiElement replaced = parent.replace((PsiElement)JSPsiElementFactory.createJSStatement(newStatementText, (PsiElement)expression));
        JSJoinDeclarationAndAssignmentFix.eraseStatementFixingNewlinesAndComments((JSStatement)statement, replaced);
    }

    private static void fixTrailingWhitespaces(PsiElement introducedStatement) {
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)introducedStatement);
        if (prev == null) {
            PsiElement next = introducedStatement.getNextSibling();
            while (next != null) {
                next = JSJoinDeclarationAndAssignmentFix.dropIfWhitespace(next, false);
            }
        }
        while (prev != null && prev.getPrevSibling() != introducedStatement) {
            prev = JSJoinDeclarationAndAssignmentFix.dropIfWhitespace(prev, true);
        }
    }

    private static PsiElement dropIfWhitespace(PsiElement prev, boolean backwards) {
        PsiElement res;
        if (PsiUtilCore.getElementType((PsiElement)prev) != JSTokenTypes.WHITE_SPACE) {
            return backwards ? prev.getPrevSibling() : prev.getNextSibling();
        }
        PsiElement psiElement = res = backwards ? prev.getPrevSibling() : prev.getNextSibling();
        if (backwards || res != null || !prev.getText().contains("\n") && !prev.getText().contains("\r")) {
            prev.delete();
        }
        return res;
    }

    private static void eraseStatementFixingNewlinesAndComments(JSStatement statement, PsiElement introducedStatement) {
        NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)statement);
        Set<PsiElement> toMoveTo = Collections.singleton(introducedStatement);
        commentsMover.move(toMoveTo, toMoveTo);
        statement.delete();
        eraser.process();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/JSJoinDeclarationAndAssignmentFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/JSJoinDeclarationAndAssignmentFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

