/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSAsyncReturnType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGeneratorReturnType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeFromUsageDetector {
    private TypeFromUsageDetector() {
    }

    @Nullable
    public static JSType detectTypeFromUsage(@NotNull PsiElement parent) {
        JSExpression expression;
        if (parent == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(0);
        }
        if (parent instanceof JSInitializerOwner && (expression = ((JSInitializerOwner)parent).getInitializer()) != null) {
            if (DialectDetector.isActionScript(parent)) {
                return JSResolveUtil.getExpressionJSType(expression);
            }
            return JSTypeofTypeImpl.typeOfTypeWithWidening(expression, JSTypeSourceFactory.createTypeSource(parent, true));
        }
        if (!(parent instanceof JSFunction)) {
            return null;
        }
        JSFunction function = (JSFunction)parent;
        JSType functionType = TypeFromUsageDetector.getFunctionType(function, false);
        JSType generatorReturn = TypeFromUsageDetector.getFunctionType(function, true);
        return TypeFromUsageDetector.getReturnTypeInContext(functionType, generatorReturn, function);
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    public static JSType getReturnTypeInContext(@Nullable JSType functionType, @Nullable JSType generatorReturn, @NotNull JSFunction function) {
        if (function == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(1);
        }
        boolean isGenerator = ES6PsiUtil.isGeneratorContext(function);
        boolean isAsync = ES6PsiUtil.isAsyncContext(function);
        if (isAsync && !isGenerator) {
            if (functionType == null) {
                return null;
            }
            return new JSAsyncReturnType(JSTypeSourceFactory.createTypeSource((PsiElement)function, true), functionType);
        }
        if (isAsync) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource((PsiElement)function, true), functionType, generatorReturn, true);
        }
        if (isGenerator && (functionType == null || !TypeFromUsageDetector.isValidGeneratorReturn(functionType.substitute()))) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource((PsiElement)function, true), functionType, generatorReturn, false);
        }
        return functionType;
    }

    private static boolean isValidGeneratorReturn(@NotNull JSType functionType) {
        if (functionType == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(2);
        }
        if (JSTypeUtils.getIterableComponentType(functionType) == null) {
            return false;
        }
        return !(functionType instanceof JSStringType) && !(functionType instanceof JSArrayType) && !(functionType instanceof JSTupleType) && !(functionType instanceof JSRecordType) && (!(functionType instanceof JSGenericTypeImpl) || !JSArrayType.isGenericArray((JSGenericTypeImpl)functionType));
    }

    @Nullable
    private static JSType getFunctionType(@NotNull JSFunction parent, final boolean forGeneratorReturnOnly) {
        JSExpression arrowFunctionReturnExpression;
        if (parent == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(3);
        }
        if ((arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(parent)) != null) {
            return JSResolveUtil.getExpressionJSType(arrowFunctionReturnExpression);
        }
        JSBlockStatement body = parent.getBlock();
        if (body == null) {
            return null;
        }
        THashSet usedTypes = new THashSet(4, (TObjectHashingStrategy)new TObjectHashingStrategy<JSType>(){

            public int computeHashCode(JSType object) {
                return object.getTypeText(JSType.TypeTextFormat.SIMPLE).hashCode();
            }

            public boolean equals(JSType o1, JSType o2) {
                return o1.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(o2.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
        });
        ArrayList<JSClass> classesList = new ArrayList<JSClass>();
        Ref hasUnresolvedTypes = new Ref();
        Ref hasValuelessReturns = new Ref();
        final boolean isGenerator = parent.isGenerator();
        body.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor((Set)usedTypes, parent, classesList, hasUnresolvedTypes, hasValuelessReturns){
            final /* synthetic */ Set val$usedTypes;
            final /* synthetic */ JSFunction val$parent;
            final /* synthetic */ List val$classesList;
            final /* synthetic */ Ref val$hasUnresolvedTypes;
            final /* synthetic */ Ref val$hasValuelessReturns;
            {
                this.val$usedTypes = set;
                this.val$parent = jSFunction;
                this.val$classesList = list2;
                this.val$hasUnresolvedTypes = ref;
                this.val$hasValuelessReturns = ref2;
            }

            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitJSReturnStatement(node);
                if (isGenerator && !forGeneratorReturnOnly) {
                    return;
                }
                this.tryAddTypeFromExpression(node.getExpression());
            }

            private void tryAddTypeFromExpression(@Nullable JSExpression expression) {
                if (expression != null) {
                    JSType jsType = JSResolveUtil.getExpressionJSType(expression);
                    if (jsType instanceof JSLiteralType) {
                        jsType = JSTypeUtils.widenLiteralTypes(jsType);
                    }
                    if (jsType == null || !this.val$usedTypes.add(jsType)) {
                        return;
                    }
                    String type = jsType.getTypeText();
                    PsiElement psiElement = JSResolveUtil.findType(type, (PsiElement)this.val$parent, true);
                    if (psiElement instanceof JSClass) {
                        this.val$classesList.add((JSClass)psiElement);
                    } else {
                        this.val$hasUnresolvedTypes.set((Object)true);
                    }
                } else {
                    this.val$hasValuelessReturns.set((Object)true);
                }
            }

            public void visitJSYieldExpression(JSYieldExpression statement) {
                super.visitJSYieldExpression(statement);
                if (!isGenerator || forGeneratorReturnOnly) {
                    return;
                }
                this.tryAddTypeFromExpression(statement.getExpression());
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(1);
                }
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/types/TypeFromUsageDetector$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (classesList.isEmpty() && hasUnresolvedTypes.get() == null) {
            if (parent.isGenerator()) {
                return null;
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parent, false);
            return JSNamedTypeFactory.createType("void", source, JSTypeContext.INSTANCE);
        }
        if (!classesList.isEmpty() && hasUnresolvedTypes.get() == null && hasValuelessReturns.get() == null) {
            return TypeFromUsageDetector.calcCommonType(classesList);
        }
        if (hasUnresolvedTypes.get() != null && usedTypes.size() > 0) {
            if (usedTypes.size() == 1) {
                return (JSType)usedTypes.iterator().next();
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)parent, false);
            return new JSCompositeTypeImpl(source, new ArrayList(usedTypes));
        }
        return DialectDetector.isActionScript((PsiElement)parent) ? JSAnyType.get((PsiElement)parent, false) : null;
    }

    @NotNull
    private static JSType calcCommonType(@NotNull List<JSClass> aClasses) {
        JSClass aClass;
        if (aClasses == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(4);
        }
        if (aClasses.size() == 0) {
            JSAnyType jSAnyType = JSAnyType.get(null, false);
            if (jSAnyType == null) {
                TypeFromUsageDetector.$$$reportNull$$$0(5);
            }
            return jSAnyType;
        }
        Ref classRef = new Ref((Object)aClasses.get(0));
        THashSet descendantClasses = new THashSet();
        TypeFromUsageDetector.processNontrivialAncestors(aClasses.get(0), (Processor<? super JSClass>)((Processor)arg_0 -> TypeFromUsageDetector.lambda$calcCommonType$0((Set)descendantClasses, arg_0)), (Set<? super JSClass>)new THashSet());
        for (JSClass clazz : aClasses.subList(1, aClasses.size())) {
            THashSet visitedClasses;
            boolean res;
            if (((JSClass)classRef.get()).equals(clazz) || !(res = TypeFromUsageDetector.processNontrivialAncestors(clazz, (Processor<? super JSClass>)((Processor)arg_0 -> TypeFromUsageDetector.lambda$calcCommonType$1((Set)descendantClasses, classRef, arg_0)), (Set<? super JSClass>)(visitedClasses = new THashSet())))) continue;
            classRef.set(null);
            break;
        }
        String qualifiedName = (aClass = (JSClass)classRef.get()) != null ? aClass.getQualifiedName() : null;
        JSAnyType jSAnyType = qualifiedName == null ? JSAnyType.get((PsiElement)aClasses.get(0), false) : JSNamedTypeFactory.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)aClasses.get(0), true), JSTypeContext.INSTANCE);
        if (jSAnyType == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(6);
        }
        return jSAnyType;
    }

    private static boolean processNontrivialAncestors(JSClass aClass, Processor<? super JSClass> processor, Set<? super JSClass> visited) {
        if (!visited.add((JSClass)aClass)) {
            return false;
        }
        if (!processor.process((Object)aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        for (JSClass superClazz : aClass.getImplementedInterfaces()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            visited.add((JSClass)superClazz);
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$calcCommonType$1(Set descendantClasses, Ref classRef, JSClass jsClass) {
        String qName = jsClass.getQualifiedName();
        if (descendantClasses.contains(qName)) {
            classRef.set((Object)jsClass);
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$calcCommonType$0(Set descendantClasses, JSClass jsClass) {
        descendantClasses.add(jsClass.getQualifiedName());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/TypeFromUsageDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/TypeFromUsageDetector";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCommonType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeFromUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeInContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidGeneratorReturn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcCommonType";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

