/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConstType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSWidenType
extends JSTypeBaseImpl
implements JSWrapperType,
JSCodeBasedType {
    @NotNull
    private final Widening myWideningFunction;
    @NotNull
    private final JSType myType;

    @NotNull
    private static JSType getTypeInConstContext(@NotNull JSType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(0);
        }
        if (original instanceof JSTupleType) {
            JSType jSType = JSWidenType.getReadonlyTupleType((JSTupleType)original);
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(1);
            }
            return jSType;
        }
        if (original instanceof JSRecordType) {
            JSType jSType = JSWidenType.makePropsReadonly(original);
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(2);
            }
            return jSType;
        }
        if (original instanceof JSLiteralType) {
            JSLiteralType jSLiteralType = ((JSLiteralType)original).copyWithAllowWidening(false);
            if (jSLiteralType == null) {
                JSWidenType.$$$reportNull$$$0(3);
            }
            return jSLiteralType;
        }
        if (original instanceof JSArrayType) {
            JSReadonlyArrayTypeImpl jSReadonlyArrayTypeImpl = new JSReadonlyArrayTypeImpl(((JSArrayType)original).getType(), original.getSource());
            if (jSReadonlyArrayTypeImpl == null) {
                JSWidenType.$$$reportNull$$$0(4);
            }
            return jSReadonlyArrayTypeImpl;
        }
        JSType jSType = original;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(5);
        }
        return jSType;
    }

    @NotNull
    private static JSType getReadonlyTupleType(@NotNull JSTupleType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(6);
        }
        JSType jSType = JSTupleTypeImpl.createTupleType(original.getSource(), original.getTypes(), original.isSourceStrict(), original.getOptionalStart(), true);
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @NotNull
    private static JSType makePropsReadonly(@NotNull JSType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(8);
        }
        List originalMembers = ((JSRecordType)original).getTypeMembers();
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> members = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(originalMembers.size());
        boolean modified = false;
        for (JSRecordType.TypeMember member : originalMembers) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)ObjectUtils.tryCast((Object)member, JSRecordType.PropertySignature.class);
            if (propertySignature != null) {
                modified = true;
                members.add(new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getJSType(), propertySignature.isOptional(), true, member.getMemberSource()));
                continue;
            }
            members.add((JSRecordTypeImpl.PropertySignatureImpl)member);
        }
        JSType jSType = modified ? new JSRecordTypeImpl(original.getSource(), members) : original;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Contract(value="null -> false")
    public static boolean isConstContext(@Nullable PsiElement element) {
        PsiElement grandParent;
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getContext();
        if (parent instanceof TypeScriptCastExpression) {
            return ((TypeScriptCastExpression)parent).getType() instanceof TypeScriptConstType;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return JSWidenType.isConstContext(parent);
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return JSWidenType.isConstContext(parent);
        }
        JSProperty property = (JSProperty)ObjectUtils.coalesce((Object)ObjectUtils.tryCast((Object)parent, JSProperty.class), (Object)ObjectUtils.tryCast((Object)element, JSProperty.class));
        if (property != null && (grandParent = property.getContext()) instanceof JSObjectLiteralExpression) {
            return JSWidenType.isConstContext(grandParent);
        }
        if (parent instanceof JSSpreadExpression) {
            return JSWidenType.isConstContext(parent);
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTupleLikeType(@Nullable JSType type, boolean isTypeScript) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSTupleType) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type);
        }
        if (!isTypeScript || type instanceof JSUtilType) {
            return false;
        }
        if (type instanceof TypeScriptOverloadContextualType) {
            return true;
        }
        Ref isTuple = Ref.create((Object)false);
        JSType finalType = type;
        RecursionManager.doPreventingRecursion((Object)type.getResolvedTypeId(), (boolean)false, () -> {
            isTuple.set((Object)finalType.asRecordType().hasProperty("0"));
            return true;
        });
        return (Boolean)isTuple.get();
    }

    @Nullable
    private static JSType widenMultiStatementReturnType(@NotNull JSFunctionItem function, @NotNull JSUnionType returnType, @NotNull JSTypeSubstitutionContext context) {
        if (function == null) {
            JSWidenType.$$$reportNull$$$0(10);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(12);
        }
        JSType type = returnType.substitute(context);
        boolean prohibitWidening = false;
        if (type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(JSTypeUtils::containsLiteralTypes)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            return TypeScriptTypeRelations.subtypeReduction(JSTypeUtils.getApparentType(JSCompositeTypeImpl.optimizeTypeIfComposite(type)), (PsiElement)function);
        }
        return TypeScriptTypeRelations.subtypeReduction(JSCompositeTypeImpl.optimizeTypeIfComposite(type), (PsiElement)function);
    }

    @NotNull
    private static JSType widenOneStatementReturnType(@NotNull JSFunctionItem function, @NotNull JSExpectedTypeKind kind, @NotNull JSType returnType, @NotNull JSTypeSubstitutionContext context) {
        JSType type;
        if (function == null) {
            JSWidenType.$$$reportNull$$$0(13);
        }
        if (kind == null) {
            JSWidenType.$$$reportNull$$$0(14);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(16);
        }
        boolean prohibitWidening = false;
        if (function instanceof JSFunctionExpression) {
            if (kind != JSExpectedTypeKind.CONTEXTUAL) {
                JSType jSType = returnType;
                if (jSType == null) {
                    JSWidenType.$$$reportNull$$$0(17);
                }
                return jSType;
            }
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)function, JSExpectedTypeKind.WIDENING);
            if (expectedType instanceof JSFunctionTypeImpl && JSTypeUtils.containsLiteralTypes(((JSFunctionTypeImpl)expectedType).getReturnType())) {
                prohibitWidening = true;
            }
        }
        if (!prohibitWidening && (type = returnType.substitute(context)) instanceof JSUnionType && JSTypeUtils.containsLiteralTypes(type)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            returnType = JSTypeUtils.getApparentType(returnType);
        }
        JSType jSType = returnType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    public JSWidenType(@NotNull JSType type) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(19);
        }
        this(type, SimpleWidening.INSTANCE);
    }

    public JSWidenType(@NotNull JSType type, @NotNull PsiElement contextualOwner) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(20);
        }
        if (contextualOwner == null) {
            JSWidenType.$$$reportNull$$$0(21);
        }
        this(type, new ExpectedTypeWidening(contextualOwner));
    }

    public JSWidenType(@NotNull JSType type, @NotNull Widening wideningFunction) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(22);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(23);
        }
        this(type, type.getSource(), wideningFunction);
    }

    JSWidenType(@NotNull JSType type, @NotNull JSTypeSource source, @NotNull Widening wideningFunction) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(24);
        }
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(25);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(26);
        }
        super(source);
        this.myType = type instanceof JSWidenType && ((JSWidenType)type).getContextTypeProvider() == wideningFunction ? ((JSWidenType)type).getOriginalType() : type;
        this.myWideningFunction = wideningFunction;
    }

    public JSWidenType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(27);
        }
        if (inputStream == null) {
            JSWidenType.$$$reportNull$$$0(28);
        }
        super(source);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myWideningFunction = SimpleWidening.INSTANCE;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSWidenType.$$$reportNull$$$0(29);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        assert (this.myWideningFunction instanceof SimpleWidening);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSWidenType.$$$reportNull$$$0(30);
        }
        this.myType.accept(visitor);
    }

    @NotNull
    public JSType distributeType() {
        JSType substitute = this.substitute();
        if (substitute != this && substitute instanceof JSDistributedType) {
            JSType jSType = ((JSDistributedType)substitute).distributeType();
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(31);
            }
            return jSType;
        }
        JSWidenType jSWidenType = this;
        if (jSWidenType == null) {
            JSWidenType.$$$reportNull$$$0(32);
        }
        return jSWidenType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType jsType;
        if (elementType == null) {
            JSWidenType.$$$reportNull$$$0(33);
        }
        if (processingContext == null) {
            JSWidenType.$$$reportNull$$$0(34);
        }
        if ((jsType = this.substitute()) == this) {
            return true;
        }
        return jsType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        JSType processed;
        if (childTransform == null) {
            JSWidenType.$$$reportNull$$$0(35);
        }
        if ((processed = (JSType)childTransform.fun((Object)this.myType)) == this.myType) {
            JSWidenType jSWidenType = this;
            if (jSWidenType == null) {
                JSWidenType.$$$reportNull$$$0(36);
            }
            return jSWidenType;
        }
        JSWidenType jSWidenType = new JSWidenType(processed, this.myWideningFunction);
        if (jSWidenType == null) {
            JSWidenType.$$$reportNull$$$0(37);
        }
        return jSWidenType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(38);
        }
        JSWidenType jSWidenType = new JSWidenType(this.myType, source, this.myWideningFunction);
        if (jSWidenType == null) {
            JSWidenType.$$$reportNull$$$0(39);
        }
        return jSWidenType;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(40);
        }
        JSWidenType rType = (JSWidenType)type;
        return this.myType.isEquivalentTo(rType.myType, context, allowResolve) && Objects.equals(this.myWideningFunction, rType.myWideningFunction);
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), this.myType.resolvedHashCode(), this.myWideningFunction);
    }

    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(41);
        }
        return jSType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSWidenType.$$$reportNull$$$0(42);
        }
        if (builder == null) {
            JSWidenType.$$$reportNull$$$0(43);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder.append("(widen ");
            this.myType.buildTypeText(format, builder);
            builder.append(")");
            return;
        }
        JSType substitute = this.substitute();
        if (substitute == this) {
            substitute = this.myType;
        }
        substitute.buildTypeText(format, builder);
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSWidenType.$$$reportNull$$$0(44);
        }
        return this.myWideningFunction.apply(this.myType, context);
    }

    @NotNull
    private static JSType expandIfCodeBaseType(@NotNull JSType type) {
        if (type == null) {
            JSWidenType.$$$reportNull$$$0(45);
        }
        JSType jSType = type instanceof JSCodeBasedType ? type.substitute() : type;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(46);
        }
        return jSType;
    }

    @NotNull
    public Widening getContextTypeProvider() {
        Widening widening = this.myWideningFunction;
        if (widening == null) {
            JSWidenType.$$$reportNull$$$0(47);
        }
        return widening;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 12: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextualOwner";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideningFunction";
                break;
            }
            case 25: 
            case 27: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInConstContext";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadonlyTupleType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makePropsReadonly";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "widenOneStatementReturnType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "expandIfCodeBaseType";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInConstContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReadonlyTupleType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makePropsReadonly";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "widenMultiStatementReturnType";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "widenOneStatementReturnType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "expandIfCodeBaseType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 39: 
            case 41: 
            case 46: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ReturnTypeWidening
    implements Widening {
        @NotNull
        private final JSFunctionItem myFunction;
        @NotNull
        private final JSExpectedTypeKind myKind;

        public ReturnTypeWidening(@NotNull JSFunctionItem function, @NotNull JSExpectedTypeKind kind) {
            if (function == null) {
                ReturnTypeWidening.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ReturnTypeWidening.$$$reportNull$$$0(1);
            }
            this.myFunction = function;
            this.myKind = kind;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context) {
            PsiElement sourceElement;
            if (original == null) {
                ReturnTypeWidening.$$$reportNull$$$0(2);
            }
            if ((sourceElement = original.getSourceElement()) != null && sourceElement.getContext() instanceof JSReturnStatement) {
                return JSWidenType.widenOneStatementReturnType(this.myFunction, this.myKind, original, context);
            }
            if (original instanceof JSUnionType && sourceElement == this.myFunction) {
                return JSWidenType.widenMultiStatementReturnType(this.myFunction, (JSUnionType)original, context);
            }
            return original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReturnTypeWidening widening = (ReturnTypeWidening)o;
            return this.myFunction.equals(widening.myFunction) && this.myKind == widening.myKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myFunction, this.myKind});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ReturnTypeWidening";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ExpectedTypeWidening
    implements Widening {
        @NotNull
        private final PsiElement myElement;

        public ExpectedTypeWidening(@NotNull PsiElement element) {
            if (element == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context) {
            if (original == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(1);
            }
            if (JSWidenType.isConstContext(this.myElement)) {
                return JSWidenType.getTypeInConstContext(original);
            }
            if (this.myElement instanceof JSArrayLiteralExpression) {
                boolean isTypeScript;
                if (!(original instanceof JSTupleType)) {
                    return original;
                }
                JSType contextType = this.getContextType();
                return JSWidenType.isTupleLikeType(contextType, isTypeScript = DialectDetector.isTypeScript(this.myElement)) ? original : ((JSTupleType)original).toArrayType(true);
            }
            JSType nested = original.substitute(context);
            if (nested == null) {
                return null;
            }
            if (!this.isWideningApplicable(nested)) {
                return nested;
            }
            JSType expectedType = this.getContextType();
            return expectedType instanceof TypeScriptOverloadContextualType ? nested : JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(nested, TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(expectedType));
        }

        private boolean isWideningApplicable(@NotNull JSType type) {
            if (type == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(2);
            }
            if (type instanceof JSLiteralType) {
                return ((JSLiteralType)type).allowWidening();
            }
            if (type instanceof JSEvaluableType) {
                return true;
            }
            if (type instanceof JSTypeImpl) {
                return ((JSTypeImpl)type).allowWidening() && ((JSTypeImpl)type).resolveType().isEnumLiteral();
            }
            if (type instanceof JSUnionOrIntersectionType) {
                return ((JSUnionOrIntersectionType)type).getTypes().stream().anyMatch(this::isWideningApplicable);
            }
            return false;
        }

        @Nullable
        private JSType getContextType() {
            JSExpectedTypeKind kind = JSExpectedTypeKind.WIDENING;
            if (this.myElement instanceof JSProperty) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSProperty)this.myElement, kind);
            }
            if (this.myElement instanceof JSExpression) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)this.myElement, kind);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpectedTypeWidening widening = (ExpectedTypeWidening)o;
            return this.myElement.equals(widening.myElement);
        }

        public int hashCode() {
            return Objects.hash(this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ExpectedTypeWidening";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isWideningApplicable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SimpleWidening
    implements Widening {
        private static final SimpleWidening INSTANCE = new SimpleWidening();

        private SimpleWidening() {
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context) {
            PsiElement element;
            if (original == null) {
                SimpleWidening.$$$reportNull$$$0(0);
            }
            if ((element = original.getSourceElement()) == null) {
                return original;
            }
            JSType nested = original.substitute(context);
            if (nested == null) {
                return null;
            }
            if (nested instanceof JSCodeBasedType) {
                return original;
            }
            if (JSWidenType.isConstContext(nested.getSourceElement())) {
                return JSWidenType.getTypeInConstContext(nested);
            }
            return element instanceof TypeScriptVariable && ((JSVariable)element).isConst() ? nested : JSTypeUtils.getApparentType(JSTypeUtils.widenLiteralTypes(nested, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/javascript/psi/types/JSWidenType$SimpleWidening", "apply"));
        }
    }

    static interface Widening {
        @Nullable
        public JSType apply(@NotNull JSType var1, JSTypeSubstitutionContext var2);
    }
}

