/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    public static final JSRecordType NO_RECORD_TYPE = new JSRecordTypeImpl(JSTypeSource.EMPTY, ContainerUtil.emptyList());

    public static boolean isFalsy(@Nullable JSType type) {
        return JSCompositeTypeBaseImpl.isNullOrUndefinedType(type) || JSTypeCastUtil.isFalseBooleanLiteralType(type) || JSTypeCastUtil.isEmptyStringLiteralType(type) || JSTypeCastUtil.isZeroBigIntLiteralType(type) || JSTypeCastUtil.isZeroNumberLiteralType(type);
    }

    private static boolean isFalseBooleanLiteralType(@Nullable JSType type) {
        return type instanceof JSBooleanLiteralTypeImpl && ((JSBooleanLiteralTypeImpl)type).getLiteral() == Boolean.FALSE;
    }

    private static boolean isEmptyStringLiteralType(@Nullable JSType type) {
        return type instanceof JSStringLiteralTypeImpl && ((JSStringLiteralTypeImpl)type).getLiteral().isEmpty();
    }

    private static boolean isZeroNumberLiteralType(@Nullable JSType type) {
        return type instanceof JSNumberLiteralTypeImpl && ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
    }

    private static boolean isZeroBigIntLiteralType(@Nullable JSType type) {
        return type instanceof JSBigIntLiteralTypeImpl && ((JSBigIntLiteralTypeImpl)type).getLiteral().equals(BigInteger.ZERO);
    }

    public static boolean areListsEquivalent(@NotNull List<JSType> types1, @NotNull List<JSType> types2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (types1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(1);
        }
        Iterator<JSType> iterator = types2.iterator();
        for (JSType jsType : types1) {
            if (iterator.hasNext() && jsType.isEquivalentTo(iterator.next(), processingContext, allowResolve)) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @NotNull
    public static NullableState getNullableState(@Nullable JSType type) {
        if (!((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSUnionType)) {
            if (type instanceof JSNullType) {
                NullableState nullableState = NullableState.HAS_NULL;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(2);
                }
                return nullableState;
            }
            if (type instanceof JSUndefinedType) {
                NullableState nullableState = NullableState.HAS_UNDEFINED;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(3);
                }
                return nullableState;
            }
            NullableState nullableState = NullableState.NOT_NULLABLE;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(4);
            }
            return nullableState;
        }
        boolean hasNull = false;
        boolean hasUndefined = false;
        for (JSType part : ((JSUnionType)type).getTypes()) {
            if (part instanceof JSNullType) {
                hasNull = true;
                continue;
            }
            if (part instanceof JSUndefinedType) {
                hasUndefined = true;
                continue;
            }
            if (!hasNull || !hasUndefined) continue;
            break;
        }
        if (hasNull && hasUndefined) {
            NullableState nullableState = NullableState.HAS_NULL_AND_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(5);
            }
            return nullableState;
        }
        if (hasNull) {
            NullableState nullableState = NullableState.HAS_NULL;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(6);
            }
            return nullableState;
        }
        if (hasUndefined) {
            NullableState nullableState = NullableState.HAS_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(7);
            }
            return nullableState;
        }
        NullableState nullableState = NullableState.NOT_NULLABLE;
        if (nullableState == null) {
            JSTypeCastUtil.$$$reportNull$$$0(8);
        }
        return nullableState;
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @NotNull ProcessingContext processingContext) {
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(9);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(11);
        }
        if (rOperand.isTypeScript() && JSTypeCastUtil.strictNullChecks(processingContext)) {
            if (rOperand instanceof JSNullType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSNullType || thisOperand instanceof JSAnyType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(12);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSUndefinedType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSUndefinedType || thisOperand instanceof JSAnyType || thisOperand instanceof JSVoidType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(13);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(14);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (constraintType != null && thisOperand.isDirectlyAssignableType(constraintType, processingContext)) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(15);
                }
                return assignableResult;
            }
            boolean assignable = rOperand.isDirectlyAssignableType(thisOperand, processingContext);
            if (assignable) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(16);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(17);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionType;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType) && thisOperand.isSourceStrict() && thisOperand.isTypeScript();
            boolean result2 = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result2 || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result2);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(18);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            JSType typedefValue = jsType.getJSTypedef();
            if (typedefValue != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(19);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getJSTypedef() != null && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(20);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSRestTypeImpl && ((JSRestTypeImpl)rOperand).getIterableType() instanceof JSTupleType) {
            AssignableResult assignableResult = AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(21);
            }
            return assignableResult;
        }
        if ((rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl) && (type = ((JSTypeWithIncompleteSubstitution)rOperand).substituteCompletely()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(22);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSTupleType) {
            type = ((JSTupleType)rOperand).toArrayType(true);
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(23);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSEvaluableType || rOperand instanceof JSCompositeTypeBaseImpl) {
            TypeScriptMappedJSTypeImpl mappedType;
            JSType paramType;
            type = rOperand.substitute();
            if (type != rOperand) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(24);
                }
                return assignableResult;
            }
            if (rOperand instanceof TypeScriptMappedJSTypeImpl && JSTypeCastUtil.isTypeOperatorLikeType(paramType = (mappedType = (TypeScriptMappedJSTypeImpl)rOperand).getParameterType()) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(thisOperand, mappedType, processingContext, true)) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(25);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSEvaluableType) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(26);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSWrapperType) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(JSTypeUtils.unwrapType(rOperand), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(27);
            }
            return assignableResult;
        }
        AssignableResult assignableResult = thisOperand.isEcma() && thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(28);
        }
        return assignableResult;
    }

    @Contract(value="null -> false")
    public static boolean isTypeOperatorLikeType(@Nullable JSType paramType) {
        return paramType instanceof JSKeyofType || paramType instanceof JSGenericParameterImpl && ((JSGenericParameterImpl)paramType).getConstraintType() instanceof JSKeyofType;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, boolean isJavaScriptContext, @Nullable ProcessingContext processingContext, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(29);
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSRequireCallExpressionType || type instanceof JSUnionType && ((JSUnionType)type).isAnyType()) {
            return true;
        }
        if ((type instanceof JSNullType || type instanceof JSUndefinedType) && !isJavaScriptContext) {
            if (processingContext != null) {
                return !JSTypeCastUtil.strictNullChecks(processingContext);
            }
            return !TypeScriptConfigUtil.strictNullChecks(context);
        }
        return false;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(30);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(type, type.getSource().isJavaScript(), null, context);
    }

    public static boolean isStrictTypeScriptUnionType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(31);
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        if (!baseType.isTypeScript() || !baseType.isSourceStrict()) {
            return false;
        }
        for (JSType type : rOperand.getTypes()) {
            if (!(type instanceof JSAnyType)) continue;
            return false;
        }
        return true;
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type, boolean hasOuters) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            JSTypeCastUtil.$$$reportNull$$$0(32);
        }
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(33);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || hasOuters)) {
            JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, genericArgumentsMap);
        }
        return null;
    }

    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @NotNull ProcessingContext beforeContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(34);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(35);
        }
        if (beforeContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(36);
        }
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)processingContext -> {
            StreamEx collection = thisOperand instanceof JSUnionType ? StreamEx.of(((JSUnionType)thisOperand).getTypes()) : StreamEx.of((Object)thisOperand);
            Set ids = collection.map(el -> TypeScriptTypeRelations.getRegularTypeOfLiteralType(el).getResolvedTypeId()).toSet();
            for (JSType jsType : rOperand.getTypes()) {
                boolean result2;
                boolean bl = result2 = ids.contains(TypeScriptTypeRelations.getRegularTypeOfLiteralType(jsType).getResolvedTypeId()) || thisOperand.isDirectlyAssignableType(jsType, processingContext);
                if (needCheckAllTypes) {
                    if (result2) continue;
                    return false;
                }
                if (!result2) continue;
                return true;
            }
            return needCheckAllTypes;
        }), beforeContext, rOperand.getSource());
    }

    public static boolean compareByExcessProperties(@NotNull JSTypeBaseImpl ownType, @NotNull JSFreshObjectLiteralType otherType) {
        if (ownType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(37);
        }
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(38);
        }
        if (ownType instanceof JSObjectType || JSTypeCastUtil.excessPropertyChecksDisabled(ownType)) {
            return true;
        }
        Set literalProperties = otherType.getPropertyNames();
        JSType expanded = ownType.substitute();
        if (expanded instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)expanded).getTypes();
            if (types2.isEmpty()) {
                return true;
            }
            Collection<String> properties = JSTypeCastUtil.getObjectTypeProperties(otherType);
            for (JSType type : types2) {
                if (!JSTypeCastUtil.checkExcessPropertiesForFinalType(type, properties, literalProperties)) continue;
                return true;
            }
            return false;
        }
        return JSTypeCastUtil.checkExcessPropertiesForFinalType(expanded, JSTypeCastUtil.getObjectTypeProperties(otherType), literalProperties);
    }

    @NotNull
    public static Collection<String> getObjectTypeProperties(@NotNull JSFreshObjectLiteralType otherType) {
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(39);
        }
        JSType objectType = JSNamedType.createType("Object", otherType.getSource(), JSContext.INSTANCE);
        Set set = objectType.asRecordType().getPropertyNames();
        if (set == null) {
            JSTypeCastUtil.$$$reportNull$$$0(40);
        }
        return set;
    }

    private static boolean checkExcessPropertiesForFinalType(@Nullable JSType finalType, @NotNull Collection<String> objectTypeProperties, @NotNull Collection<String> literalProperties) {
        if (objectTypeProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(41);
        }
        if (literalProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(42);
        }
        if (finalType instanceof JSObjectType || finalType == null) {
            return true;
        }
        JSRecordType ownTypeAsRecord = finalType.asRecordType();
        if (!JSTypeCastUtil.shouldCheckForExcessProperties(ownTypeAsRecord)) {
            return true;
        }
        HashSet<String> otherProps = new HashSet<String>(literalProperties);
        otherProps.removeAll(ownTypeAsRecord.getPropertyNames());
        otherProps.removeAll(objectTypeProperties);
        return otherProps.size() == 0;
    }

    private static boolean shouldCheckForExcessProperties(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(43);
        }
        return !recordType.hasIndexers() && recordType.hasProperties();
    }

    public static boolean strictNullChecks(@Nullable ProcessingContext context) {
        return context != null && Boolean.TRUE.equals(context.get(JSTypeComparingContextService.NULL_CHECKS));
    }

    private static boolean excessPropertyChecksDisabled(@NotNull JSTypeBaseImpl type) {
        TypeScriptConfig config2;
        PsiFile scope;
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(44);
        }
        return (scope = type.getSource().getScope()) != null && scope.isValid() && (config2 = TypeScriptConfigUtil.getConfigForPsiFile(scope)) != null && config2.suppressExcessPropertyChecks();
    }

    public static boolean executeJoinInferredGenerics(@NotNull Processor<? super ProcessingContext> command, @NotNull ProcessingContext processingContext, @NotNull JSTypeSource source) {
        JSGenericMappings originalGenericArgumentsMapping;
        if (command == null) {
            JSTypeCastUtil.$$$reportNull$$$0(45);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(46);
        }
        if (source == null) {
            JSTypeCastUtil.$$$reportNull$$$0(47);
        }
        if ((originalGenericArgumentsMapping = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey)) == null) {
            return command.process((Object)processingContext);
        }
        JSGenericMappings newGenericArgumentsMap = originalGenericArgumentsMapping.copyWithMapping((MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>)MultiMap.createSmart());
        processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)newGenericArgumentsMap);
        boolean result2 = command.process((Object)processingContext);
        processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)originalGenericArgumentsMapping);
        for (Map.Entry entry : newGenericArgumentsMap.getMapping().entrySet()) {
            Collection items = (Collection)entry.getValue();
            if (items.isEmpty()) continue;
            JSType resultType = items.size() == 1 ? (JSType)items.iterator().next() : JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(source, new ArrayList(items)));
            originalGenericArgumentsMapping.getMapping().putValue(entry.getKey(), (Object)resultType);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 9: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOperand";
                break;
            }
            case 10: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOperand";
                break;
            }
            case 11: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 29: 
            case 30: 
            case 33: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContext";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectTypeProperties";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalProperties";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullableState";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypeProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areListsEquivalent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 40: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysAssignableType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeScriptUnionType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "buildWithAppliedGenericArguments";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableComposite";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "compareByExcessProperties";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeProperties";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkExcessPropertiesForFinalType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckForExcessProperties";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "excessPropertyChecksDisabled";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "executeJoinInferredGenerics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false),
        NO_CACHE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public String toString() {
            return "AssignableResult{myStrict=" + this.myStrict + ", myAssignable=" + this.myAssignable + '}';
        }
    }

    public static enum NullableState {
        HAS_NULL,
        HAS_UNDEFINED,
        HAS_NULL_AND_UNDEFINED,
        NOT_NULLABLE;


        public boolean hasNull() {
            return this == HAS_NULL || this == HAS_NULL_AND_UNDEFINED;
        }

        public boolean hasUndefined() {
            return this == HAS_UNDEFINED || this == HAS_NULL_AND_UNDEFINED;
        }
    }
}

