/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNumberLiteralTypeImpl
extends JSNumberType
implements JSPrimitiveLiteralType<Double> {
    private final double myLiteral;
    private final boolean myAllowWidening;
    @Nullable
    private final String myValueAsString;

    /*
     * WARNING - void declaration
     */
    public JSNumberLiteralTypeImpl(double literal, boolean allowWidening, @NotNull JSTypeSource source, @Nullable String string) {
        void valueAsString;
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
        this.myValueAsString = valueAsString;
    }

    public JSNumberLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource, inputStream);
        this.myAllowWidening = JSTypeSerializer.readBoolean(inputStream);
        String value = JSTypeSerializer.readString(inputStream);
        Double aDouble = JSNumberParser.tryParseNumericValue(value, false);
        this.myLiteral = aDouble != null ? aDouble : 0.0;
        this.myValueAsString = value;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
        JSTypeSerializer.writeString(this.getValueAsString(), outputStream);
    }

    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public Double getLiteral() {
        Double d = this.myLiteral;
        if (d == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        return d;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (format == JSType.TypeTextFormat.RESOLVED) {
            builder.append("Number");
            return;
        }
        builder.append(this.isTypeScript() && (!this.allowWidening() || format != JSType.TypeTextFormat.CODE) ? this.getValueAsString() : "number");
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        if (elementType instanceof JSNumberLiteralTypeImpl && this.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral == ((JSNumberLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myAllowWidening && elementType instanceof JSNumberType) {
            return this.isJavaScript();
        }
        if (!this.myAllowWidening && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                Double numericValue = value.getNumericValue();
                return numericValue != null && numericValue == this.myLiteral;
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myLiteral == ((JSNumberLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        if ("number" == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return "number";
    }

    @Override
    @NotNull
    protected JSNumberLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.getLiteral(), this.myAllowWidening, source, this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return jSNumberLiteralTypeImpl;
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = this;
            if (jSNumberLiteralTypeImpl == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(14);
            }
            return jSNumberLiteralTypeImpl;
        }
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource(), this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(15);
        }
        return jSNumberLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.getValueAsString();
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

