/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariantRecordTypeConverter {
    @Nullable
    public static JSRecordType getTypeAsRecord(@Nullable JSType type, @Nullable PsiElement context) {
        JSRecordType recordType;
        PsiElement sourceElement;
        ArrayList types2;
        JSRecordType mergedMembers;
        if (type == null) {
            return null;
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSRecordType) {
            return (JSRecordType)type;
        }
        if (type.getSource().isEcma()) {
            return null;
        }
        if (type instanceof JSUnionType) {
            JSRecordType mergedMembers2 = JSVariantRecordTypeConverter.mergeMappedRecordTypes(type, context, ((JSUnionType)type).getTypes());
            if (mergedMembers2 != null) {
                return mergedMembers2;
            }
        } else if (type instanceof JSExtendingTypeImpl && (mergedMembers = JSVariantRecordTypeConverter.mergeMappedRecordTypes(type, context, types2 = ContainerUtil.newArrayList((Object[])new JSType[]{((JSExtendingTypeImpl)type).getType(), ((JSExtendingTypeImpl)type).getParentType()}))) != null) {
            return mergedMembers;
        }
        if (context != null && (DialectDetector.isTypeScript(context) || type.isTypeScript())) {
            return type.asRecordType();
        }
        if (context != null && type.isJavaScript() && ((sourceElement = type.getSource().getSourceElement()) instanceof JSDocComment || sourceElement instanceof TypeScriptType) && (recordType = type.asRecordType()).hasProperties()) {
            return recordType;
        }
        Collection<TypeScriptInterface> classTypes = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type);
        return JSVariantRecordTypeConverter.buildSimpleRecordType(type, classTypes);
    }

    @Nullable
    private static JSRecordType mergeMappedRecordTypes(@NotNull JSType type, @Nullable PsiElement context, @NotNull List<JSType> types2) {
        if (type == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(1);
        }
        ArrayList typeMembers = new ArrayList();
        for (JSType jsType : types2) {
            JSRecordType record = JSVariantRecordTypeConverter.getTypeAsRecord(jsType, context);
            if (record == null) continue;
            typeMembers.addAll(record.getTypeMembers());
        }
        if (!typeMembers.isEmpty()) {
            return new JSRecordTypeImpl(type.getSource(), typeMembers);
        }
        return null;
    }

    @Nullable
    public static JSRecordType buildSimpleRecordType(@NotNull JSType type, Collection<? extends TypeScriptInterface> types2) {
        if (type == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(2);
        }
        if (types2.isEmpty()) {
            return null;
        }
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> recordMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
        for (JSClass jSClass : types2) {
            Collection<JSClass<?>> parents = TypeScriptUtil.getNonStrictParents(jSClass, true);
            for (JSClass<?> jsClass : parents) {
                Iterable members = jsClass.getMembers();
                for (JSElement member : members) {
                    String name;
                    if (!(member instanceof JSFunction) && !(member instanceof JSProperty) && !(member instanceof TypeScriptPropertySignature) || (name = member.getName()) == null) continue;
                    recordMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(member.getName(), null, false, false));
                }
            }
        }
        return new JSRecordTypeImpl(type.getSource(), recordMembers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSVariantRecordTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeMappedRecordTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSimpleRecordType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

