/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptVariableImpl
extends JSVariableImpl<JSVariableStub<JSVariable>, JSVariable>
implements TypeScriptVariable {
    public TypeScriptVariableImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptVariableImpl(JSVariableStub<JSVariable> stub, JSStubElementType<JSVariableStub<JSVariable>, JSVariable> signature) {
        super(stub, signature);
    }

    @Override
    public JSType calculateDeclarationTypeStubSafe() {
        JSType result2 = TypeScriptPsiUtil.getTypeFromDeclaration(this);
        if (result2 != null) {
            return result2;
        }
        JSExpression initializer = this.getInitializerOrStub();
        if (initializer instanceof JSObjectLiteralExpression) {
            return new JSWidenType(new JSPsiBasedTypeOfType(JSTypeSourceFactory.createTypeSource(this, true), (PsiElement)initializer, false));
        }
        PsiElement parent = this.getContext();
        if (JSDestructuringUtil.isDestructuring(parent)) {
            return new JSDestructuringTypeImpl(this);
        }
        return null;
    }

    @Override
    @Nullable
    public final JSType calculateType() {
        JSType type = this.calculateDeclarationTypeStubSafe();
        if (type != null) {
            return type;
        }
        if (this.hasInitializer()) {
            JSType typeFromConstant;
            JSExpression initializer = this.getInitializer();
            if (initializer == null) {
                return null;
            }
            if (initializer instanceof JSLiteralExpression && (typeFromConstant = JSTypeEvaluator.getTypeFromConstant(initializer)) != null) {
                return this.isConst() ? typeFromConstant : JSTypeUtils.getApparentType(typeFromConstant);
            }
            return JSTypeofTypeImpl.typeOfTypeWithWidening(initializer, JSTypeSourceFactory.createTypeSource(this, true));
        }
        return null;
    }

    @Override
    public boolean isLocal() {
        return PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, JSFunction.class) != null || this.hasBlockScope() && PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class}) != null;
    }

    public TypeScriptType getTypeElement() {
        return TypeScriptPsiUtil.getStubOrPsiTypeElement(this);
    }

    @Override
    @Nullable
    protected String doGetName() {
        boolean computed;
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = TypeScriptPsiUtil.getNameFromIdentifier(this.findNameIdentifier());
        if (name != null) {
            return name;
        }
        ASTNode nameNode = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
        boolean bl = computed = nameNode != null;
        if (nameNode == null) {
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
        }
        return TypeScriptVariableImpl.getResultNameFromNameNode(nameNode, computed);
    }

    @Override
    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return super.useLocalSearchScope(declarationScope) && !(declarationScope instanceof TypeScriptModule);
    }

    @Override
    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList attributeList = this.getAttributeList();
        JSAttributeList.AccessType accessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            TypeScriptVariableImpl.$$$reportNull$$$0(0);
        }
        return accessType;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStub stub = (JSVariableStub)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return TypeScriptPsiUtil.isTopLevelContainerMember(this) || super.isNamespaceExplicitlyDeclared();
    }

    @Override
    @Deprecated
    @Nullable
    public String getTypeString() {
        JSType type = this.getJSType();
        return JSTypeUtils.serializeType(type);
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptVariableImpl", "calcAccessType"));
    }
}

