/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNewExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.ES6ReferenceListImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluatorBase;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveExpandTransformer;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyTypeofType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeUtils {
    public static final int MAX_ALIASES_TO_UNWRAP = 10;

    @Nullable
    public static PsiElement getScopeInOriginalTree(@NotNull PsiElement scope) {
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(0);
        }
        if (scope instanceof ImplicitJSVariableImpl) {
            return scope;
        }
        PsiElement originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
        if (originalElement != null) {
            return originalElement;
        }
        PsiElement someElementAtOriginalTree = scope.getContainingFile().getOriginalFile().findElementAt(scope.getTextRange().getStartOffset());
        return someElementAtOriginalTree;
    }

    private JSTypeUtils() {
    }

    public static String transformActionScriptSpecificTypesIntoEcma(String type) {
        if ("int".equals(type) || "uint".equals(type)) {
            type = "Number";
        }
        return type;
    }

    public static boolean isInstanceType(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.INSTANCE && !((JSNamespace)type).isDeclaration();
    }

    public static boolean isInstanceOrPrototype(@Nullable JSType type) {
        return (type = JSTypeUtils.getValuableType(type)) instanceof JSNamespace && ((JSNamespace)type).getJSContext() == JSContext.INSTANCE;
    }

    public static boolean isNewPropertiesDefinitionAllowed(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null || type instanceof JSAnyType || type instanceof JSObjectType || type instanceof JSArrayType || type instanceof JSPrimitiveFunctionType || type instanceof JSFunctionTypeImpl || JSTypeUtils.isMapType(type)) {
            return true;
        }
        if (!type.isSourceStrict()) {
            return true;
        }
        if (JSTypeUtils.isInstanceType(type)) {
            return false;
        }
        if (type instanceof JSFreshObjectLiteralType) {
            return true;
        }
        return !(type instanceof JSRecordType) || !type.isJavaScript() || !(type.getSourceElement() instanceof PsiComment) && !(type.getSourceElement() instanceof JSImplicitElement);
    }

    public static boolean isStrictType(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return JSTypeUtils.isRestrictiveType(type) && type.getSource().isStrict();
    }

    @Contract(value="null -> false")
    public static boolean isRestrictiveType(@Nullable JSType type) {
        return type != null && !(type instanceof JSAnyType) && (!(type instanceof JSUnionType) || !((JSUnionType)type).isAnyType()) && !(type instanceof JSObjectType);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static String serializeType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if (type.getSource().isEcma()) {
            return type.getTypeText(JSType.TypeTextFormat.SIMPLE);
        }
        StringBuilder builder = new StringBuilder();
        JSTypeSerializer.TYPE_SERIALIZER.write(type, builder);
        return builder.toString();
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType parseSerializedOrJSDocType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(1);
        }
        return JSTypeUtils.createType(typeString, source);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType parseSerializedType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(2);
        }
        return JSTypeUtils.createType(typeString, source);
    }

    @Nullable
    public static JSType createTypeFromJSDoc(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, true);
        return parser.parse(false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(4);
        }
        return JSTypeUtils.createType(typeString, source, false);
    }

    @Nullable
    public static JSType createType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source);
        return parser.parse(allowCommentAfterType);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(6);
        }
        return JSTypeUtils.createParameterType(typeString, source, false, false);
    }

    @Nullable
    public static JSParameterTypeDecorator createParameterType(@Nullable String typeString, @NotNull JSTypeSource source, boolean allowCommentAfterType, boolean isFromJSDoc) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)typeString)) {
            return null;
        }
        JSTypeParser parser = new JSTypeParser(typeString, source, isFromJSDoc);
        return parser.parseParameterType(allowCommentAfterType);
    }

    @Contract(value="null -> false")
    public static boolean isArrayLikeType(@Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSArrayType || type instanceof JSGenericTypeImpl && JSArrayType.isGenericArray((JSGenericTypeImpl)type) || type instanceof JSTupleType) {
            return true;
        }
        if (!(type instanceof JSGenericParameterImpl)) {
            return false;
        }
        JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
        return constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType);
    }

    public static boolean isIterableCollectionType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(8);
        }
        if (JSTypeUtils.isIndexableType(type)) {
            return true;
        }
        if (JSNamedType.isNamedTypeWithNames(type, JSCommonTypeNames.TYPED_ARRAY_NAMES)) {
            return true;
        }
        if (JSNamedType.isNamedTypeWithName(type, "IArguments")) {
            return true;
        }
        return type.asRecordType().hasProperty("[Symbol.iterator]");
    }

    public static boolean isIndexableType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(9);
        }
        return JSTypeUtils.getIndexableComponentType(type, false) != null;
    }

    public static boolean isMapType(@NotNull JSType type) {
        JSType baseType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(10);
        }
        if (type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getArguments().size() == 2 && (baseType = ((JSGenericTypeImpl)type).getType()) instanceof JSNamedType) {
            String typeText = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE);
            return "Array".equals(typeText) || "Object".equals(typeText) || "Map".equals(typeText) || "WeakMap".equals(typeText);
        }
        return false;
    }

    public static boolean isExactlyPromiseLikeType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) == null) {
            return false;
        }
        String qualifiedName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        return "Promise".equals(qualifiedName) || "PromiseLike".equals(qualifiedName);
    }

    public static boolean isPromiseLikeType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isExactlyPromiseLikeType(type = type.substitute())) {
            return true;
        }
        if (type instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(((JSGenericTypeImpl)type).getType())) {
            return true;
        }
        return type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(type1 -> type1 instanceof JSAnyType && !type1.isSourceStrict() || JSTypeUtils.isPromiseLikeType(type1));
    }

    @NotNull
    public static JSType wrapInPromiseType(@NotNull JSType jsType, @NotNull JSTypeSource typeSource) {
        if (jsType == null) {
            JSTypeUtils.$$$reportNull$$$0(11);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(12);
        }
        JSType promiseType = JSNamedTypeFactory.createExplicitlyDeclaredType("Promise", typeSource.getSourceElement());
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(typeSource, promiseType, jsType);
        if (jSGenericTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(13);
        }
        return jSGenericTypeImpl;
    }

    @Nullable
    public static JSType getPromiseComponentTypeOrNull(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(14);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, el -> {
                if (!(el instanceof JSNamedType)) {
                    return false;
                }
                return JSNamedType.isNamedTypeWithName(el, "Promise") || JSNamedType.isNamedTypeWithName(el, "PromiseLike");
            }, true);
        }
        return null;
    }

    public static JSType getIndexableComponentType(@Nullable JSType type) {
        return JSTypeUtils.getIndexableComponentType(type, true);
    }

    @Nullable
    public static JSType getIndexableComponentType(@Nullable JSType type, boolean includeIndexers) {
        if (type instanceof JSArrayType) {
            return (JSType)ObjectUtils.coalesce((Object)((JSArrayType)type).getType(), (Object)JSAnyType.getWithLanguage(type.getSource().getLanguage(), false));
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getIndexableComponentType(((JSTupleType)type).toArrayType(true), false);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)type, JSTypeUtils::isSingleGenericComponentType, true);
        }
        if (type instanceof JSRecordType && includeIndexers) {
            JSRecordType recordType = (JSRecordType)type;
            JSRecordType.IndexSignature indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
            if (indexer == null) {
                indexer = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
            }
            if (indexer != null) {
                return indexer.getMemberType();
            }
        } else if (type instanceof JSSpreadType) {
            return ((JSSpreadType)type).getComponentType();
        }
        return null;
    }

    @Nullable
    public static JSType getSingleGenericArgTypeFromGenericType(@NotNull JSGenericTypeImpl genericType, @NotNull Predicate<? super JSType> acceptType, boolean traverseClassHierarchy) {
        JSType baseType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(15);
        }
        if (acceptType == null) {
            JSTypeUtils.$$$reportNull$$$0(16);
        }
        if (!((baseType = genericType.getType()) instanceof JSNamedType)) {
            return null;
        }
        List<JSType> genericArguments = genericType.getArguments();
        if (genericArguments.isEmpty()) {
            return null;
        }
        if (acceptType.test((JSType)baseType)) {
            return genericArguments.size() == 1 || !baseType.isTypeScript() ? genericArguments.get(genericArguments.size() - 1) : null;
        }
        if (!traverseClassHierarchy) {
            return null;
        }
        if (!(baseType instanceof JSResolvableType)) {
            return null;
        }
        JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)baseType).resolveType();
        JSClass sourceElement = resolvedTypeInfo.getDeclarationOfType(JSClass.class);
        if (sourceElement == null) {
            return null;
        }
        JSTypeSubstitutor typeArguments = sourceElement instanceof TypeScriptTypeParameterListOwner ? TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments((TypeScriptTypeParameterListOwner)sourceElement, genericArguments) : JSTypeSubstitutor.EMPTY;
        Ref indexerType = new Ref();
        JSClassUtils.processClassesInHierarchy(sourceElement, true, (klass, typeSubstitutor, fromImplements, fromStaticContext, depth) -> {
            if (klass == null) {
                JSTypeUtils.$$$reportNull$$$0(111);
            }
            if (typeSubstitutor == null) {
                JSTypeUtils.$$$reportNull$$$0(112);
            }
            if (!(klass instanceof TypeScriptTypeParameterListOwner) || klass == sourceElement) {
                return true;
            }
            String qualifiedName = klass.getQualifiedName();
            if (qualifiedName == null) {
                return true;
            }
            JSType type = klass.getJSType();
            if (acceptType.test(type)) {
                TypeScriptTypeParameter[] parameters = ((TypeScriptTypeParameterListOwner)klass).getTypeParameters();
                if (parameters.length == 0) {
                    return true;
                }
                List<JSType> generics = TypeScriptGenericTypesEvaluator.buildGenericParameters(parameters);
                if (generics.size() == 0) {
                    return true;
                }
                indexerType.set((Object)JSTypeUtils.applyGenericArguments(generics.get(0), typeSubstitutor));
                return false;
            }
            return true;
        }, (Condition<? super JSClass>)Conditions.alwaysTrue(), typeArguments);
        return (JSType)indexerType.get();
    }

    private static boolean isSingleGenericComponentType(@NotNull JSType baseType) {
        String s;
        if (baseType == null) {
            JSTypeUtils.$$$reportNull$$$0(17);
        }
        switch (s = baseType.getTypeText(JSType.TypeTextFormat.SIMPLE)) {
            case "Vector": 
            case "Array": 
            case "Object": 
            case "ReadonlyArray": 
            case "ArrayLike": 
            case "Iterable": 
            case "AsyncIterable": 
            case "Iterator": 
            case "Generator": 
            case "AsyncIterator": 
            case "AsyncGenerator": 
            case "IterableIterator": 
            case "AsyncIterableIterator": 
            case "Set": 
            case "WeakSet": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(18);
        }
        return JSTypeUtils.getIterableComponentType(type, true, true);
    }

    @Nullable
    public static JSType getIterableComponentType(@NotNull JSType type, boolean allowAsyncIterable, boolean allowNonAsyncIterable) {
        JSType realType;
        JSType componentType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(19);
        }
        if ((componentType = JSTypeUtils.getIndexableComponentType(realType = type.substitute())) == null) {
            JSType genericType;
            JSRecordType recordType = realType.asRecordType();
            JSType jSType = genericType = allowNonAsyncIterable ? JSTypeUtils.getIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
            JSType jSType2 = genericType = allowAsyncIterable ? JSTypeUtils.getAsyncIteratorComponentType(recordType) : null;
            if (genericType != null) {
                return genericType;
            }
        }
        return componentType;
    }

    @Nullable
    private static JSType getIteratorComponentType(JSRecordType recordType) {
        return JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.iterator]", "Iterator", "IterableIterator", "Generator");
    }

    @Nullable
    private static JSType getAsyncIteratorComponentType(JSRecordType recordType) {
        return JSTypeUtils.getCustomIteratorComponentType(recordType, "[Symbol.asyncIterator]", "AsyncIterator", "AsyncIterableIterator", "AsyncGenerator");
    }

    @Nullable
    private static JSType getCustomIteratorComponentType(JSRecordType recordType, String iteratorSymbol, String ... iteratorClassNames) {
        JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(iteratorSymbol);
        if (propertySignature == null) {
            return null;
        }
        JSType iteratorType = propertySignature.getJSType();
        if (iteratorType instanceof JSFunctionTypeImpl) {
            iteratorType = ((JSFunctionTypeImpl)iteratorType).getReturnType();
        }
        if (iteratorType instanceof JSFunctionReturnWrapperType) {
            iteratorType = iteratorType.substitute();
        }
        if (iteratorType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)iteratorType;
            String typeName = JSTypeUtils.getQualifiedNameMatchingType(iteratorType, false);
            if (ArrayUtil.contains((String)typeName, (String[])iteratorClassNames)) {
                return (JSType)ContainerUtil.getFirstItem(genericType.getArguments());
            }
        }
        return null;
    }

    public static boolean typeCanBeAssignedWithoutCoercion(@NotNull JSType lOpType, @Nullable JSType rOpType) {
        if (lOpType == null) {
            JSTypeUtils.$$$reportNull$$$0(20);
        }
        if (lOpType instanceof JSNumberType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSNumberType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSIntType || lOpType instanceof JSUintType) {
            return rOpType instanceof JSIntType || rOpType instanceof JSUintType;
        }
        if (lOpType instanceof JSObjectType) {
            return true;
        }
        if (lOpType instanceof JSSpecialNamedTypeImpl || lOpType instanceof JSUndefinedType || lOpType instanceof JSNullType || lOpType instanceof JSVoidType) {
            return lOpType.isEquivalentTo(rOpType, null);
        }
        if (lOpType instanceof JSUnionType) {
            boolean anyTypeCanBeAssignedWithoutCoercion = false;
            for (JSType lOpTypePart : ((JSUnionType)lOpType).getTypes()) {
                anyTypeCanBeAssignedWithoutCoercion |= JSTypeUtils.typeCanBeAssignedWithoutCoercion(lOpTypePart, rOpType);
            }
            return anyTypeCanBeAssignedWithoutCoercion;
        }
        return rOpType != null && !(rOpType instanceof JSAnyType) && !(rOpType instanceof JSObjectType) && !(rOpType instanceof JSUndefinedType) && !(rOpType instanceof JSNullType) && !(rOpType instanceof JSVoidType);
    }

    @NotNull
    public static String getTypeMatchingNamespace(@NotNull String type) {
        JSType jsType;
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(21);
        }
        if ((jsType = JSTypeUtils.createType(type, JSTypeSource.EMPTY_TS)) == null) {
            String string = type;
            if (string == null) {
                JSTypeUtils.$$$reportNull$$$0(22);
            }
            return string;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(jsType, false);
        String string = qName != null ? qName : type;
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    public static String getQualifiedNameMatchingType(@NotNull JSType type, boolean resolved) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(24);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSTypeWithOuterGenerics) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSTypeWithOuterGenerics)type).getOriginalType(), resolved);
        }
        if (type instanceof JSGenericTypeImpl) {
            return JSTypeUtils.getQualifiedNameMatchingType(((JSGenericTypeImpl)type).getType(), resolved);
        }
        if (type instanceof JSArrayType && !((JSArrayType)type).isPrimitive()) {
            return ((JSArrayType)type).getTypeName();
        }
        if (type instanceof JSNullType || type instanceof JSUndefinedType) {
            return null;
        }
        if (type instanceof JSStringType) {
            return "String";
        }
        if (type instanceof JSNumberType) {
            return "Number";
        }
        if (type instanceof JSBigIntType) {
            return "BigInt";
        }
        if (type instanceof JSBooleanType || type instanceof TypeScriptTypePredicateTypeImpl) {
            return "Boolean";
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getQualifiedNameMatchingType(constraintType, resolved);
        }
        if (type instanceof JSFunctionTypeImpl) {
            return JSTypeUtils.getFunctionTypeName(type.getSource().getScope(), false);
        }
        if (type instanceof JSTupleType) {
            return "Array";
        }
        if (type instanceof JSNamedType) {
            String text = type.getTypeText(resolved ? JSType.TypeTextFormat.RESOLVED : JSType.TypeTextFormat.SIMPLE);
            return StringUtil.replace((String)text, (String)"prototype.", (String)"");
        }
        return null;
    }

    @NotNull
    public static String getFunctionTypeName(@Nullable PsiFile scope, boolean newable) {
        TypeScriptConfig config2;
        TypeScriptConfig typeScriptConfig = config2 = scope == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(scope);
        String string = config2 == null || !config2.strictBindCallApply() ? "Function" : (newable ? "NewableFunction" : "CallableFunction");
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static JSNamespace getNamespaceMatchingType(@NotNull JSType type, boolean forcedExplicitlyDeclared) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(26);
        }
        if ((type = JSTypeUtils.unwrapDecorations(type)) instanceof JSGenericTypeImpl) {
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(((JSGenericTypeImpl)type).getType(), forcedExplicitlyDeclared);
            if (namespace != null) {
                JSTypeSubstitutor typeSubstitutor;
                PsiElement sourceElement = type.getSource().getSourceElement();
                JSQualifiedName name = namespace.getQualifiedName();
                if (sourceElement != null && name != null && !(typeSubstitutor = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(type, name, sourceElement)).isEmpty()) {
                    return new JSTypeWithOuterGenerics((JSType)namespace, typeSubstitutor);
                }
            }
            return namespace;
        }
        if (type instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)type).getConstraintType();
            if (constraintType == null) {
                return null;
            }
            return JSTypeUtils.getNamespaceMatchingType(constraintType, forcedExplicitlyDeclared);
        }
        if (type instanceof JSNamespace) {
            return (JSNamespace)(forcedExplicitlyDeclared ? type.copyWithStrict(true) : type);
        }
        return null;
    }

    public static boolean hasFunctionType(@NotNull JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            JSTypeUtils.$$$reportNull$$$0(27);
        }
        return JSTypeUtils.getFunctionType(_type, includeConstructorSignatures, context).findAny().isPresent();
    }

    @NotNull
    public static Stream<JSType> getFunctionType(@Nullable JSType _type, boolean includeConstructorSignatures, @Nullable PsiElement context) {
        if (_type == null) {
            Stream<JSType> stream = Stream.empty();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(28);
            }
            return stream;
        }
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(context);
        Stream stream = _type.getFunctionTypes(processingContext, includeConstructorSignatures);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(29);
        }
        return stream;
    }

    @Nullable
    public static Stream<JSType> getMergedUnionSignatureType(@NotNull List<List<JSType>> overloadPacks) {
        if (overloadPacks == null) {
            JSTypeUtils.$$$reportNull$$$0(30);
        }
        int indexWithOverloads = -1;
        for (int i = 0; i < overloadPacks.size(); ++i) {
            List<JSType> overloadPack = overloadPacks.get(i);
            if (overloadPack.size() > 1) {
                if (indexWithOverloads != -1) {
                    return null;
                }
                indexWithOverloads = i;
            }
            if (!overloadPack.isEmpty() && !overloadPack.stream().anyMatch(f -> !(f instanceof JSFunctionType))) continue;
            return null;
        }
        List<JSType> masterList = overloadPacks.get(indexWithOverloads == -1 ? 0 : indexWithOverloads);
        List<Object> results = new ArrayList<JSType>(masterList);
        for (List<JSType> pack : overloadPacks) {
            if (pack == masterList) continue;
            assert (pack.size() == 1);
            JSType signature = pack.get(0);
            if (!(signature instanceof JSFunctionType)) {
                return null;
            }
            if (((JSFunctionType)signature).hasGenericArguments() && results.stream().anyMatch(f -> !(f instanceof JSFunctionType) || !((JSFunctionType)f).hasGenericArguments())) {
                return null;
            }
            results = ContainerUtil.map(results, sig -> JSTypeUtils.combineSignaturesOfUnionMembers((JSFunctionType)sig, (JSFunctionType)signature));
        }
        return results.stream();
    }

    @NotNull
    private static JSType combineSignaturesOfUnionMembers(@NotNull JSFunctionType left, @NotNull JSFunctionType right) {
        if (left == null) {
            JSTypeUtils.$$$reportNull$$$0(31);
        }
        if (right == null) {
            JSTypeUtils.$$$reportNull$$$0(32);
        }
        List leftParameters = left.getParameters();
        List rightParameters = right.getParameters();
        JSFunctionType longest = leftParameters.size() >= rightParameters.size() ? left : right;
        List longestParameters = longest == left ? leftParameters : rightParameters;
        List shorterParameters = longest == right ? leftParameters : rightParameters;
        JSFunctionType shorter = longest == left ? right : left;
        int longestCount = longestParameters.size();
        boolean eitherHasEffectiveRest = JSTypeUtils.hasEffectiveRestParameter(left) || JSTypeUtils.hasEffectiveRestParameter(right);
        boolean needsExtraRestElement = eitherHasEffectiveRest && !JSTypeUtils.hasEffectiveRestParameter(longest);
        int size = longestCount + (needsExtraRestElement ? 1 : 0);
        ArrayList<JSParameterTypeDecorator> params = new ArrayList<JSParameterTypeDecorator>(size);
        JSTypeSource typeSource = left.getSource();
        for (int i = 0; i < longestCount; ++i) {
            String rightName;
            JSParameterTypeDecorator longestParamType = (JSParameterTypeDecorator)longestParameters.get(i);
            JSParameterTypeDecorator shorterParamType = shorterParameters.size() > i ? (JSParameterTypeDecorator)shorterParameters.get(i) : (JSTypeUtils.hasEffectiveRestParameter(shorter) ? (JSParameterTypeDecorator)shorterParameters.get(shorterParameters.size() - 1) : null);
            JSType unionParamType = shorterParamType == null ? longestParamType.getSimpleType() : JSIntersectionTypeImpl.getIntersectionType(Arrays.asList(longestParamType.getSimpleType(), shorterParamType.getSimpleType()), typeSource);
            boolean isRestParam = eitherHasEffectiveRest && !needsExtraRestElement && i == longestCount - 1;
            boolean isOptional = i >= JSTypeUtils.getMinArgumentCount(longest) && i >= JSTypeUtils.getMinArgumentCount(shorter);
            String leftName = leftParameters.size() > i ? ((JSParameterTypeDecorator)leftParameters.get(i)).getName() : null;
            String string = rightName = rightParameters.size() > i ? ((JSParameterTypeDecorator)rightParameters.get(i)).getName() : null;
            String paramName = leftName != null && (Objects.equals(leftName, rightName) || rightName == null) ? leftName : (leftName == null && rightName != null ? rightName : "arg" + i);
            params.add(new JSParameterTypeDecoratorImpl(paramName, unionParamType, isOptional, isRestParam, false));
        }
        if (needsExtraRestElement) {
            params.add(new JSParameterTypeDecoratorImpl(JSTypeUtils.typeOrAny(((JSParameterTypeDecorator)shorterParameters.get(shorterParameters.size() - 1)).getSimpleType(), typeSource), false, true, false));
        }
        TypeScriptJSFunctionTypeImpl typeScriptJSFunctionTypeImpl = new TypeScriptJSFunctionTypeImpl(typeSource, left instanceof TypeScriptJSFunctionTypeImpl ? ((TypeScriptJSFunctionTypeImpl)left).getGenericDeclarations() : ContainerUtil.emptyList(), params, left.getThisType(), (JSType)new JSCompositeTypeImpl(typeSource, left.getReturnType(), right.getReturnType()));
        if (typeScriptJSFunctionTypeImpl == null) {
            JSTypeUtils.$$$reportNull$$$0(33);
        }
        return typeScriptJSFunctionTypeImpl;
    }

    @NotNull
    private static JSType typeOrAny(@Nullable JSType unionParamType, @NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeUtils.$$$reportNull$$$0(34);
        }
        JSType jSType = unionParamType == null ? JSAnyType.get(source) : unionParamType;
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    private static int getMinArgumentCount(JSFunctionType type) {
        int i = 0;
        for (JSParameterTypeDecorator parameter : type.getParameters()) {
            if (parameter.isRest() || parameter.isOptional()) {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static boolean hasEffectiveRestParameter(JSFunctionType left) {
        return left.getParameters().stream().anyMatch(p -> p.isRest());
    }

    @NotNull
    public static Stream<JSType> collectValidConstituents(JSUnionOrIntersectionType compositeType, boolean strict) {
        Stream<JSType> stream = compositeType.getTypes().stream().filter(el -> strict || !JSCompositeTypeBaseImpl.isNullOrUndefinedType(el)).filter(el -> el != null);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(36);
        }
        return stream;
    }

    @NotNull
    public static Stream<JSType> mergeWithMixins(@NotNull List<JSType> originalTypes) {
        if (originalTypes == null) {
            JSTypeUtils.$$$reportNull$$$0(37);
        }
        List functionTypes = ContainerUtil.newSmartList();
        List mixinReturnTypes = ContainerUtil.newSmartList();
        List nonFunctionTypes = ContainerUtil.newSmartList();
        for (JSType type : originalTypes) {
            if (type instanceof JSFunctionType) {
                JSFunctionType functionType = (JSFunctionType)type;
                if (ES6ReferenceListImpl.isMixinConstructor(functionType)) {
                    ContainerUtil.addIfNotNull((Collection)mixinReturnTypes, (Object)functionType.getReturnType());
                    continue;
                }
                functionTypes.add(functionType);
                continue;
            }
            nonFunctionTypes.add(type);
        }
        if (mixinReturnTypes.size() == 0 || functionTypes.size() == 0) {
            Stream<JSType> stream = originalTypes.stream();
            if (stream == null) {
                JSTypeUtils.$$$reportNull$$$0(38);
            }
            return stream;
        }
        Stream<JSType> functionWithMixin = functionTypes.stream().map(el -> {
            JSType mixinType = JSIntersectionTypeImpl.getIntersectionType(mixinReturnTypes, el.getSource());
            JSType newReturnType = JSIntersectionTypeImpl.getIntersectionType(StreamEx.of((Object[])new JSType[]{mixinType, el.getReturnType()}).nonNull().toList(), el.getSource());
            return el.copyWithReturnType(newReturnType);
        });
        Stream<JSType> stream = Stream.concat(nonFunctionTypes.stream(), functionWithMixin);
        if (stream == null) {
            JSTypeUtils.$$$reportNull$$$0(39);
        }
        return stream;
    }

    @NotNull
    public static Collection<TypeScriptInterface> getTypeScriptInterfaceInJavaScriptContext(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(40);
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (sourceElement == null || qName == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeUtils.$$$reportNull$$$0(41);
            }
            return list2;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveTypeName(qName, sourceElement);
        List list3 = ContainerUtil.mapNotNull(result2.getElements(), TypeScriptUtil.TYPESCRIPT_INTERFACE_FILTER);
        if (list3 == null) {
            JSTypeUtils.$$$reportNull$$$0(42);
        }
        return list3;
    }

    public static boolean hasAnyTypeOrNotStrictType(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(43);
        }
        if (type instanceof JSAnyType || !type.isSourceStrict()) {
            return true;
        }
        Ref ref = Ref.create();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)el -> {
            if (el instanceof JSAnyType || !el.isSourceStrict()) {
                ref.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        }), type, false, true, true);
        return !ref.isNull();
    }

    @Nullable
    public static JSType tryGetReturnType(@NotNull JSType functionType, @NotNull JSApplyCallElement applyCallElement) {
        if (functionType == null) {
            JSTypeUtils.$$$reportNull$$$0(44);
        }
        if (applyCallElement == null) {
            JSTypeUtils.$$$reportNull$$$0(45);
        }
        JSCallItem callItem = applyCallElement.getCallItem();
        return JSTypeUtils.getReturnType(functionType, callItem);
    }

    @Nullable
    public static JSType getReturnType(@NotNull JSType startFunction, @NotNull JSCallItem callItem) {
        if (startFunction == null) {
            JSTypeUtils.$$$reportNull$$$0(46);
        }
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(47);
        }
        boolean includeConstructors = callItem.isNewExpression();
        List candidates = JSTypeUtils.getFunctionType(startFunction, includeConstructors, callItem.getPsiContext()).collect(Collectors.toList());
        JSTypeSignatureChooser chooser = new JSTypeSignatureChooser(callItem);
        return chooser.resolveOverloadsReturnTypeWithApplying(candidates);
    }

    @Nullable
    public static JSType getNewOrReturnType(@Nullable JSType rawType, boolean includeConstructors) {
        if (rawType instanceof JSFunctionType) {
            JSType type;
            JSFunctionType functionType = (JSFunctionType)rawType;
            if (includeConstructors && (type = functionType.getNewType()) != null) {
                return type;
            }
            return functionType.getReturnType();
        }
        return rawType;
    }

    public static boolean hasTypeArguments(@NotNull JSCallItem callItem) {
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(48);
        }
        if (!(callItem instanceof TypeScriptNewExpression)) {
            return false;
        }
        TypeScriptNewExpression newExpression = (TypeScriptNewExpression)callItem;
        TypeScriptTypeArgumentList arguments = newExpression.getTypeArgumentList();
        return arguments != null && arguments.getTypeArguments().length > 0;
    }

    @NotNull
    public static List<JSType> chooseOverloadFunctionTypes(@NotNull List<? extends JSType> candidates, @NotNull JSCallItem callItem, boolean applyGenerics) {
        if (candidates == null) {
            JSTypeUtils.$$$reportNull$$$0(49);
        }
        if (callItem == null) {
            JSTypeUtils.$$$reportNull$$$0(50);
        }
        List<JSType> list2 = new JSTypeSignatureChooser(callItem).resolveOverloadsWithApplying(candidates, applyGenerics);
        if (list2 == null) {
            JSTypeUtils.$$$reportNull$$$0(51);
        }
        return list2;
    }

    public static JSType applyJSGenericsForType(@NotNull List<JSType> generics, @NotNull JSType type, @NotNull PsiFile scope, @Nullable JSType resultType) {
        List<String> genericParameters;
        if (generics == null) {
            JSTypeUtils.$$$reportNull$$$0(52);
        }
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(53);
        }
        if (scope == null) {
            JSTypeUtils.$$$reportNull$$$0(54);
        }
        List<String> list2 = genericParameters = type instanceof JSNamedType ? JSGenericsIndex.findGenericParameters(type.getResolvedTypeText(), scope) : null;
        if (genericParameters != null && genericParameters.size() == generics.size()) {
            JSTypeSubstitutor map = new JSTypeSubstitutor(ContainerUtil.newHashMap(genericParameters, generics));
            resultType = JSTypeUtils.applyGenericArguments(resultType, map);
        }
        return resultType;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType getValuableType(@Nullable JSType type) {
        return JSTypeUtils.getValuableType(type, true);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType getValuableType(@Nullable JSType type, boolean expandDecorators) {
        if (type == null) {
            return null;
        }
        JSType expanded = type.substitute();
        return expandDecorators ? JSTypeUtils.unwrapDecorations(expanded) : expanded;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static JSType unwrapDecorations(@Nullable JSType type) {
        if (type instanceof JSDecoratedTypeImpl) {
            return ((JSDecoratedTypeImpl)type).getType();
        }
        return type;
    }

    @Deprecated
    @Contract(value="!null -> !null")
    public static JSType resolveType(@Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null && type.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return type.substitute();
        }
        return type;
    }

    public static boolean areArgumentsAssignable(@NotNull List<JSParameterTypeDecorator> parameters, @Nullable List<JSParameterTypeDecorator> arguments, @Nullable ProcessingContext processingContext, boolean functionAssignment, boolean jsDocFunctionAssignment, boolean typescript) {
        if (parameters == null) {
            JSTypeUtils.$$$reportNull$$$0(55);
        }
        if (arguments == null) {
            return parameters.isEmpty();
        }
        arguments = JSTypeUtils.spreadArguments(arguments);
        if (typescript && !functionAssignment) {
            int min = TypeScriptSignatureChooser.getMinArgumentCount(parameters);
            int max = TypeScriptSignatureChooser.getMaxArgumentCount(parameters);
            int argumentSize = arguments.size();
            if (min > argumentSize || argumentSize > max) {
                return false;
            }
        }
        Iterator<JSParameterTypeDecorator> paramIterator = parameters.iterator();
        Iterator<JSParameterTypeDecorator> argIterator = arguments.iterator();
        Ref paramRestType = null;
        Ref argRestType = null;
        boolean remainingArgumentsAreOptional = false;
        boolean remainingParametersAreOptional = false;
        int paramIndex = -1;
        int argIndex = -1;
        while (paramIterator.hasNext() || argIterator.hasNext()) {
            int tupleOffset;
            JSTupleType argRestTuple;
            JSType argument;
            boolean isParameterRest;
            JSType parameter;
            JSParameterTypeDecorator parameterTypeDecorator = null;
            boolean hasParameter = true;
            if (paramIterator.hasNext()) {
                parameterTypeDecorator = paramIterator.next();
                ++paramIndex;
                parameter = parameterTypeDecorator.getSimpleType();
            } else if (paramRestType != null) {
                parameter = (JSType)paramRestType.get();
            } else {
                parameter = null;
                hasParameter = false;
            }
            boolean bl = isParameterRest = parameterTypeDecorator != null && parameterTypeDecorator.isRest();
            if (isParameterRest) {
                paramRestType = Ref.create((Object)parameter);
                remainingParametersAreOptional = true;
            }
            if (parameterTypeDecorator != null && parameterTypeDecorator.isOptional()) {
                remainingParametersAreOptional = true;
            }
            JSParameterTypeDecorator argumentTypeDecorator = null;
            boolean hasArgument = true;
            if (argIterator.hasNext()) {
                argumentTypeDecorator = argIterator.next();
                argument = JSTypeUtils.getArgumentType(argumentTypeDecorator, isParameterRest);
                ++argIndex;
            } else if (argRestType != null) {
                argument = (JSType)argRestType.get();
            } else {
                hasArgument = false;
                argument = null;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isRest()) {
                argRestType = Ref.create((Object)argument);
                remainingArgumentsAreOptional = true;
            }
            if (argumentTypeDecorator != null && argumentTypeDecorator.isOptional()) {
                remainingArgumentsAreOptional = true;
            }
            if (!hasParameter) {
                return functionAssignment && !typescript || remainingArgumentsAreOptional;
            }
            if (!hasArgument) {
                return remainingParametersAreOptional || functionAssignment && typescript;
            }
            JSType parameterRestTuple = JSTypeUtils.getRawRestParameterType((Ref<JSType>)paramRestType);
            JSType restTuple = JSTypeUtils.getRawRestParameterType((Ref<JSType>)argRestType);
            JSTupleType jSTupleType = argRestTuple = restTuple instanceof JSTupleType ? (JSTupleType)restTuple : null;
            if (parameterRestTuple instanceof JSTupleType && JSTypeUtils.checkTuple(processingContext, argRestTuple, (JSTupleType)parameterRestTuple, argument, tupleOffset = argIndex - paramIndex) || JSTypeUtils.matchRestTuples(processingContext, argIterator, argRestTuple, parameterRestTuple, -argIndex + paramIndex, parameterTypeDecorator, parameter, argumentTypeDecorator, argument) || JSTypeUtils.isAssignableType(parameter, argument, processingContext) || functionAssignment && !jsDocFunctionAssignment && JSTypeUtils.isAssignableType(argument, parameter, processingContext)) continue;
            return false;
        }
        return typescript || !functionAssignment || remainingParametersAreOptional || paramRestType != null || !remainingArgumentsAreOptional && (!jsDocFunctionAssignment || argRestType == null);
    }

    @Nullable
    private static JSType getRawRestParameterType(@Nullable Ref<JSType> paramRestType) {
        JSType type;
        JSType jSType = type = paramRestType == null ? null : (JSType)paramRestType.get();
        if (type == null) {
            return null;
        }
        if (type instanceof JSRestTypeImpl) {
            return ((JSRestTypeImpl)type).getIterableType();
        }
        return new JSArrayTypeImpl(type, type.getSource());
    }

    @Nullable
    private static JSType getArgumentType(@NotNull JSParameterTypeDecorator argumentTypeDecorator, boolean isParameterRest) {
        JSType argument;
        if (argumentTypeDecorator == null) {
            JSTypeUtils.$$$reportNull$$$0(56);
        }
        if ((argument = argumentTypeDecorator.getSimpleType()) instanceof JSSimpleRecordTypeImpl && argument.getSourceElement() instanceof JSDestructuringObject) {
            Collection<JSRecordType.PropertySignature> properties = ((JSSimpleRecordTypeImpl)argument).getProperties();
            StreamEx newProperties = StreamEx.of(properties).map(el -> new JSRecordTypeImpl.PropertySignatureImpl(el.getMemberName(), el.getJSType(), true, true, el.getMemberSource()));
            return new JSSimpleRecordTypeImpl(argument.getSource(), newProperties.toList());
        }
        if (argument instanceof JSSpreadType && isParameterRest) {
            argument = ((JSSpreadType)argument).getComponentType();
        }
        return argument;
    }

    private static boolean checkTuple(@Nullable ProcessingContext processingContext, @Nullable JSTupleType argRestType, @NotNull JSTupleType parameter, @Nullable JSType argument, int tupleOffset) {
        if (parameter == null) {
            JSTypeUtils.$$$reportNull$$$0(57);
        }
        if (parameter.hasTypeByIndex(tupleOffset) && JSTypeUtils.isAssignableType(parameter.getTypeByIndex(tupleOffset), argument instanceof JSSpreadType ? ((JSSpreadType)argument).getComponentType() : argument, processingContext)) {
            return true;
        }
        if (argRestType != null) {
            int offset = -1;
            boolean fail = false;
            for (JSType type : argRestType.getTypes()) {
                ++offset;
                if (type instanceof JSSpreadType) {
                    type = ((JSSpreadType)type).getComponentType();
                }
                if (parameter.hasTypeByIndex(tupleOffset + offset) && JSTypeUtils.isAssignableType(parameter.getTypeByIndex(tupleOffset + offset), type, processingContext)) continue;
                fail = true;
                break;
            }
            if (!fail) {
                return true;
            }
        }
        return false;
    }

    private static boolean matchRestTuples(@Nullable ProcessingContext processingContext, @NotNull Iterator<? extends JSParameterTypeDecorator> argIterator, JSTupleType argRestTuple, @Nullable JSType paramRestType, int tupleOffset, @Nullable JSParameterTypeDecorator parameterTypeDecorator, @Nullable JSType parameter, @Nullable JSParameterTypeDecorator argumentTypeDecorator, @Nullable JSType argument) {
        JSTypeSource source;
        if (argIterator == null) {
            JSTypeUtils.$$$reportNull$$$0(58);
        }
        if (parameterTypeDecorator == null) {
            return false;
        }
        if (!parameterTypeDecorator.isRest()) {
            if (argRestTuple != null && argRestTuple.hasTypeByIndex(tupleOffset)) {
                return JSTypeUtils.isAssignableType(parameter, argRestTuple.getTypeByIndex(tupleOffset), processingContext);
            }
            return false;
        }
        if (!(paramRestType instanceof JSGenericParameterImpl)) {
            if (argRestTuple != null && paramRestType != null) {
                return JSTypeUtils.checkTuple(processingContext, paramRestType instanceof JSTupleType ? (JSTupleType)paramRestType : null, argRestTuple, paramRestType, tupleOffset);
            }
            return false;
        }
        JSType constraintType = ((JSGenericParameterImpl)paramRestType).getConstraintType();
        if (!(paramRestType instanceof TypeScriptConditionalTypeGenericParameterImpl || constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType))) {
            return false;
        }
        ArrayList<JSType> argumentTypes = new ArrayList<JSType>();
        if (argRestTuple != null) {
            if (argRestTuple.hasTypeByIndex(tupleOffset)) {
                argumentTypes.add(argRestTuple.getTypeByIndex(tupleOffset));
            }
        } else {
            argumentTypes.add(argument);
        }
        JSTypeSource jSTypeSource = source = argument != null ? argument.getSource() : paramRestType.getSource();
        if (argumentTypeDecorator != null && argumentTypeDecorator.isRest() && argumentTypes.size() == 1) {
            return JSTypeUtils.isAssignableType(paramRestType, new JSArrayTypeImpl(JSTypeUtils.widenLiteralTypes((JSType)argumentTypes.get(0)), source), processingContext);
        }
        int firstOptional = argumentTypeDecorator != null && argumentTypeDecorator.isOptional() ? 0 : -1;
        int i = -1;
        while (argIterator.hasNext()) {
            JSType type;
            ++i;
            JSParameterTypeDecorator nextDecorator = argIterator.next();
            if (nextDecorator == null) continue;
            if (firstOptional == -1 && nextDecorator.isOptional()) {
                firstOptional = i;
            }
            argumentTypes.add((type = nextDecorator.getInferredType()) != null && nextDecorator.isRest() ? new JSSpreadTypeImpl(type.getSource(), type) : type);
        }
        return JSTypeUtils.isAssignableType(paramRestType, JSTupleTypeImpl.createTupleType(source, argumentTypes, true, firstOptional, false), processingContext);
    }

    @NotNull
    private static List<JSParameterTypeDecorator> spreadArguments(@NotNull List<JSParameterTypeDecorator> arguments) {
        JSParameterTypeDecorator lastItem;
        if (arguments == null) {
            JSTypeUtils.$$$reportNull$$$0(59);
        }
        if ((lastItem = (JSParameterTypeDecorator)ContainerUtil.getLastItem(arguments)) == null) {
            List<JSParameterTypeDecorator> list2 = arguments;
            if (list2 == null) {
                JSTypeUtils.$$$reportNull$$$0(60);
            }
            return list2;
        }
        JSType type = lastItem.getSimpleType();
        if (!(type instanceof JSSpreadType)) {
            List<JSParameterTypeDecorator> list3 = arguments;
            if (list3 == null) {
                JSTypeUtils.$$$reportNull$$$0(61);
            }
            return list3;
        }
        JSType innerType = ((JSSpreadType)type).getInnerType();
        if (!(innerType instanceof JSTupleType)) {
            List<JSParameterTypeDecorator> list4 = arguments;
            if (list4 == null) {
                JSTypeUtils.$$$reportNull$$$0(62);
            }
            return list4;
        }
        ArrayList<JSParameterTypeDecorator> expanded = new ArrayList<JSParameterTypeDecorator>(arguments.size());
        expanded.addAll(arguments);
        expanded.remove(expanded.size() - 1);
        int maxLength = ((JSTupleType)innerType).getMaxLength();
        if (maxLength != Integer.MAX_VALUE) {
            for (int i = 0; i < maxLength; ++i) {
                expanded.add(new JSParameterTypeDecoratorImpl(((JSTupleType)innerType).getTypeByIndex(i), i >= ((JSTupleType)innerType).getOptionalStart(), false, false));
            }
        } else {
            List types2 = ((JSTupleType)innerType).getTypes();
            for (int i = 0; i < types2.size(); ++i) {
                JSType jsType = (JSType)types2.get(i);
                expanded.add(new JSParameterTypeDecoratorImpl(jsType instanceof JSSpreadType ? ((JSSpreadType)jsType).getComponentType() : jsType, false, i == types2.size() - 1, false));
            }
        }
        ArrayList<JSParameterTypeDecorator> arrayList = expanded;
        if (arrayList == null) {
            JSTypeUtils.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable JSTypeSubstitutor rawArguments, boolean call, @Nullable JSGenericTypesEvaluator.GenericErrorReporter report) {
        return JSTypeUtils.applyGenericArguments(_type, rawArguments, call, report, true);
    }

    @Contract(value="!null,_,_,_,_->!null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable JSTypeSubstitutor rawArguments, boolean call, final @Nullable JSGenericTypesEvaluator.GenericErrorReporter report, boolean expand) {
        if (_type == null || rawArguments == null || rawArguments.isEmpty()) {
            return _type;
        }
        PsiElement element = _type.getSource().getSourceElement();
        final ProcessingContext context = JSTypeComparingContextService.setCallEnvironment(JSTypeComparingContextService.getProcessingContextWithCache(element), call);
        final JSTypeSubstitutor typeArguments = rawArguments;
        return _type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSRecursiveExpandTransformer(true){

            @Override
            @NotNull
            protected JSType expand(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(type instanceof JSCodeBasedType)) {
                    JSType jSType = type;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                PsiElement sourceElement = type.getSourceElement();
                JSFunction parent = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, JSFunction.class, (boolean)false);
                while (parent != null) {
                    Object[] parameters;
                    if (parent instanceof TypeScriptTypeParameterListOwner && (parameters = ((TypeScriptTypeParameterListOwner)parent).getTypeParameters()).length > 0) {
                        if (StreamEx.of((Object[])parameters).map(el -> el.getGenericId()).anyMatch(arg_0 -> ((JSTypeSubstitutor)typeArguments).containsId(arg_0))) {
                            JSType jSType = type.substitute();
                            if (jSType == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return jSType;
                        }
                    }
                    parent = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{JSFunction.class});
                }
                JSType jSType = type;
                if (jSType == null) {
                    1.$$$reportNull$$$0(3);
                }
                return jSType;
            }

            @Override
            @NotNull
            protected JSType processExpanded(@NotNull JSType type) {
                JSTypeWithOuterGenerics remappedType;
                if (type == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (type instanceof JSGenericTypeImpl) {
                    boolean applyForArguments = this.shouldApplyForArguments(type);
                    JSType jSType = applyForArguments ? type : JSTypeBaseImpl.getSelfNoTransformationType();
                    if (jSType == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return jSType;
                }
                if (type instanceof JSTypeWithOuterGenerics && (remappedType = JSTypeUtils.concatGenericsToJSGenericTypeIfNestedLocal((JSTypeWithOuterGenerics)type, typeArguments)) != null) {
                    Object object = remappedType.isEquivalentTo(type, context, false) ? JSTypeBaseImpl.getSelfNoTransformationType() : remappedType;
                    if (object == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    return object;
                }
                if (type instanceof TypeScriptGenericThisTypeImpl && typeArguments.containsId((JSTypeSubstitutor.JSTypeGenericId)((TypeScriptGenericThisTypeImpl)type).getGenericId())) {
                    JSType substitutionType = typeArguments.get((JSTypeSubstitutor.JSTypeGenericId)((TypeScriptGenericThisTypeImpl)type).getGenericId());
                    boolean useSelf = substitutionType == null || substitutionType instanceof TypeScriptGenericThisTypeImpl && type.getResolvedTypeId().equals(substitutionType.getResolvedTypeId());
                    JSType jSType = useSelf ? JSTypeBaseImpl.getSelfNoTransformationType() : substitutionType;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    return jSType;
                }
                boolean isTypeImpl = type instanceof JSTypeImpl;
                if (isTypeImpl || type instanceof JSGenericParameterImpl) {
                    JSResolvedTypeInfo resolvedType;
                    JSType jsType;
                    JSType jSType = isTypeImpl && type.isTypeScript() ? null : (jsType = typeArguments.get((JSTypeSubstitutor.JSTypeGenericId)(isTypeImpl ? new JSTypeSubstitutor.StringGenericId(type.getTypeText()) : ((JSGenericParameterImpl)type).getGenericId())));
                    if (jsType != null) {
                        if (isTypeImpl && jsType.isTypeScript()) {
                            JSType jSType2 = type;
                            if (jSType2 == null) {
                                1.$$$reportNull$$$0(8);
                            }
                            return jSType2;
                        }
                        if (type instanceof JSGenericParameterImpl) {
                            JSType afterProcess = this.processGenericParameter((JSGenericParameterImpl)type, jsType);
                            JSType jSType3 = afterProcess == type ? JSTypeBaseImpl.getSelfNoTransformationType() : afterProcess;
                            if (jSType3 == null) {
                                1.$$$reportNull$$$0(9);
                            }
                            return jSType3;
                        }
                        JSType jSType4 = jsType == type ? JSTypeBaseImpl.getSelfNoTransformationType() : jsType;
                        if (jSType4 == null) {
                            1.$$$reportNull$$$0(10);
                        }
                        return jSType4;
                    }
                    if (type instanceof JSResolvableType && (resolvedType = ((JSResolvableType)type).resolveType()).isLocal()) {
                        JSTypeWithOuterGenerics jSTypeWithOuterGenerics = new JSTypeWithOuterGenerics(type, typeArguments);
                        if (jSTypeWithOuterGenerics == null) {
                            1.$$$reportNull$$$0(11);
                        }
                        return jSTypeWithOuterGenerics;
                    }
                }
                JSType jSType = type;
                if (jSType == null) {
                    1.$$$reportNull$$$0(12);
                }
                return jSType;
            }

            @NotNull
            private JSType processGenericParameter(@NotNull JSGenericParameterImpl currentType, @NotNull JSType replacement) {
                JSType newConstraint;
                if (currentType == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (replacement == null) {
                    1.$$$reportNull$$$0(14);
                }
                JSType oldConstraint = currentType.getConstraintType();
                if (report != null && oldConstraint != null && !(newConstraint = JSTypeUtils.applyCompositeMapping(oldConstraint, (Function<JSType, JSType>)this)).isDirectlyAssignableType(replacement, context)) {
                    PsiElement sourceElement = currentType.getSource().getSourceElement();
                    TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptPropertySignature.class});
                    if (propertySignature == null || !propertySignature.isOptional()) {
                        report.error("typescript.validation.cannot.find.best.common.type");
                    }
                    JSType jSType = newConstraint;
                    if (jSType == null) {
                        1.$$$reportNull$$$0(15);
                    }
                    return jSType;
                }
                JSType jSType = replacement instanceof JSGenericParameterImpl && replacement != currentType && replacement.getResolvedTypeId().equals(currentType.getResolvedTypeId()) ? currentType : replacement;
                if (jSType == null) {
                    1.$$$reportNull$$$0(16);
                }
                return jSType;
            }

            public boolean shouldApplyForArguments(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(17);
                }
                JSResolvedTypeId ownId = type.getResolvedTypeId();
                return typeArguments.types().stream().noneMatch(subst -> subst != null && Objects.equals(ownId, subst.getResolvedTypeId()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$1";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentType";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "replacement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "expand";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processExpanded";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "processGenericParameter";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "expand";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "processExpanded";
                        break;
                    }
                    case 13: 
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "processGenericParameter";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldApplyForArguments";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 15: 
                    case 16: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Nullable
    private static JSTypeWithOuterGenerics concatGenericsToJSGenericTypeIfNestedLocal(@NotNull JSTypeWithOuterGenerics genericType, @NotNull JSTypeSubstitutor typeArguments) {
        JSType jsType;
        JSResolvedTypeInfo resolvedType;
        JSType innerType;
        if (genericType == null) {
            JSTypeUtils.$$$reportNull$$$0(64);
        }
        if (typeArguments == null) {
            JSTypeUtils.$$$reportNull$$$0(65);
        }
        if ((innerType = genericType.getType()) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)innerType).resolveType()).isLocal() && (jsType = typeArguments.getForJSGenerics(innerType.getTypeText())) == null) {
            JSTypeSubstitutor newOuterArguments = typeArguments;
            JSTypeSubstitutor outerArguments = genericType.getOuterArguments();
            if (!outerArguments.isEmpty() && (newOuterArguments = JSTypeSubstitutor.combine((JSTypeSubstitutor)newOuterArguments, (JSTypeSubstitutor)outerArguments)) == outerArguments) {
                return genericType;
            }
            return new JSTypeWithOuterGenerics(innerType, newOuterArguments);
        }
        return genericType;
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyGenericArguments(@Nullable JSType _type, @Nullable JSTypeSubstitutor typeArguments) {
        return JSTypeUtils.applyGenericArguments(_type, typeArguments, false, null);
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType addJSGenericParameters(@Nullable JSType _type, @NotNull Set<String> genericParameters) {
        if (genericParameters == null) {
            JSTypeUtils.$$$reportNull$$$0(66);
        }
        if (_type == null || genericParameters.isEmpty()) {
            return _type;
        }
        return JSTypeUtils.applyCompositeMapping(_type, (Function<JSType, JSType>)((Function)type -> {
            if (type instanceof JSTypeImpl && genericParameters.contains(type.getTypeText())) {
                JSTypeBaseImpl result2 = new JSGenericParameterImpl(type.getTypeText(), type.getSource());
                if (((JSTypeImpl)type).getJSContext() == JSContext.STATIC) {
                    result2 = new JSApplyTypeofType(result2, result2.getSource());
                }
                return result2;
            }
            return type;
        }));
    }

    @Nullable
    @Contract(value="!null, _ -> !null")
    public static JSType applyCompositeMapping(@Nullable JSType type, @NotNull Function<JSType, JSType> f) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(67);
        }
        return JSTypeUtils.transformTypeHierarchySafe(type, f);
    }

    public static boolean hasForeignGenericParameter(@Nullable JSType startType) {
        if (startType == null) {
            return false;
        }
        if (startType instanceof JSGenericParameterImpl) {
            return true;
        }
        return JSTypeUtils.hasForeignGenericParameter(startType, new HashSet<JSTypeSubstitutor.JSTypeGenericId>());
    }

    public static boolean hasForeignGenericParameter(@NotNull JSType startType, final @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> ignoredGenericIds) {
        if (startType == null) {
            JSTypeUtils.$$$reportNull$$$0(68);
        }
        if (ignoredGenericIds == null) {
            JSTypeUtils.$$$reportNull$$$0(69);
        }
        final Ref result2 = Ref.create();
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor(false){

            public void visitJSType(@NotNull JSType currentType) {
                boolean hasNewIgnored;
                if (currentType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!result2.isNull()) {
                    return;
                }
                if (currentType instanceof JSGenericParameterImpl && !ignoredGenericIds.contains(((JSGenericParameterImpl)currentType).getGenericId())) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                Set newIgnoredIds = currentType instanceof JSTypeWithGenericParameters ? ((JSTypeWithGenericParameters)currentType).getGenericIds() : Collections.emptySet();
                boolean bl = hasNewIgnored = !newIgnoredIds.isEmpty();
                if (hasNewIgnored) {
                    ignoredGenericIds.addAll(newIgnoredIds);
                }
                super.visitJSType(currentType);
                if (hasNewIgnored) {
                    ignoredGenericIds.removeAll(newIgnoredIds);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentType", "com/intellij/lang/javascript/psi/JSTypeUtils$2", "visitJSType"));
            }
        };
        visitor.visitJSType(startType);
        return !result2.isNull();
    }

    public static boolean hasTypes(@Nullable JSType type, Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(70);
        }
        return JSTypeUtils.hasTypes(type, false, typeClasses);
    }

    public static boolean hasTypes(@Nullable JSType type, boolean expandTypeOfType, Class<?> ... typeClasses) {
        if (typeClasses == null) {
            JSTypeUtils.$$$reportNull$$$0(71);
        }
        return JSTypeUtils.hasTypes(type, expandTypeOfType, (Condition<? super JSType>)((Condition)t -> {
            for (Class typeClass : typeClasses) {
                if (!typeClass.isInstance(t)) continue;
                return true;
            }
            return false;
        }));
    }

    public static boolean hasTypes(@Nullable JSType type, final boolean expandTypeOfType, final @NotNull Condition<? super JSType> condition) {
        if (condition == null) {
            JSTypeUtils.$$$reportNull$$$0(72);
        }
        if (type == null) {
            return false;
        }
        if (condition.value((Object)type)) {
            return true;
        }
        final Ref result2 = Ref.create();
        type.acceptChildren(new JSRecursiveTypeVisitor(expandTypeOfType){

            public void visitJSType(@NotNull JSType typeToVisit) {
                if (typeToVisit == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!result2.isNull()) {
                    return;
                }
                if (condition.value((Object)typeToVisit)) {
                    result2.set((Object)Boolean.TRUE);
                    return;
                }
                if (expandTypeOfType && typeToVisit instanceof JSCodeBasedType) {
                    JSType substitute = typeToVisit.substitute();
                    substitute.accept((JSRecursiveTypeVisitor)this);
                    return;
                }
                super.visitJSType(typeToVisit);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeToVisit", "com/intellij/lang/javascript/psi/JSTypeUtils$3", "visitJSType"));
            }
        });
        return !result2.isNull();
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrictRecursive(@Nullable JSType type, final boolean strict) {
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSCacheableTypeTransformerBase(){

            @NotNull
            public JSType fun(@NotNull JSType type) {
                if (type == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (type.getSource().isStrict() == strict) {
                    JSType jSType = type;
                    if (jSType == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }
                JSType newType = JSTypeUtils.copyWithStrict(type, strict);
                if (newType != type) {
                    JSType jSType = newType.transformTypeHierarchy((JSRecursiveTypeTransformer)this);
                    if (jSType == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return jSType;
                }
                JSType jSType = type;
                if (jSType == null) {
                    4.$$$reportNull$$$0(3);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$4";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithStrict(@Nullable JSType type, boolean strict) {
        if (type == null) {
            return null;
        }
        return type.copyWithStrict(strict);
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageOfContext(@Nullable JSType jsType, @NotNull PsiElement context) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(73);
        }
        return JSTypeUtils.copyWithLanguageRecursive(jsType, JSTypeSourceFactory.getSourceLanguage(context));
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    public static JSType copyWithLanguageRecursive(@Nullable JSType jsType, @NotNull JSTypeSource.SourceLanguage language) {
        if (language == null) {
            JSTypeUtils.$$$reportNull$$$0(74);
        }
        return JSTypeBaseImpl.copyWithLanguageRecursive(jsType, language);
    }

    @NotNull
    public static List<JSType> addPossibleOption(@NotNull Collection<? extends JSType> types2, @NotNull JSType newOption) {
        if (types2 == null) {
            JSTypeUtils.$$$reportNull$$$0(75);
        }
        if (newOption == null) {
            JSTypeUtils.$$$reportNull$$$0(76);
        }
        boolean hasAnyType = false;
        int typesCount = 0;
        for (JSType jSType : types2) {
            ++typesCount;
            if (!(jSType instanceof JSAnyType)) continue;
            hasAnyType = true;
        }
        JSTypeSource optionSource = newOption.getSource();
        List<JSType> list2 = newOption instanceof JSUnionType && !optionSource.isStrict() ? ((JSUnionType)newOption).getTypes() : Collections.singletonList(newOption);
        SmartList result2 = new SmartList();
        if (types2.isEmpty()) {
            result2.addAll(list2);
            SmartList smartList = result2;
            if (smartList == null) {
                JSTypeUtils.$$$reportNull$$$0(77);
            }
            return smartList;
        }
        for (JSType typeToAdd : list2) {
            boolean alreadyPresent = false;
            for (JSType jSType : types2) {
                if (!typeToAdd.isEquivalentTo(jSType, null, false)) continue;
                alreadyPresent = true;
                break;
            }
            if (alreadyPresent) continue;
            if (!newOption.isTypeScript() && typesCount > 5) {
                if (hasAnyType) continue;
                result2.add(JSAnyType.getWithLanguage(optionSource.getLanguage(), false));
                ++typesCount;
                continue;
            }
            result2.add(typeToAdd);
            ++typesCount;
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(78);
        }
        return smartList;
    }

    public static boolean processExpandedType(JSTypeProcessor processor, JSType type, @NotNull JSEvaluateContext context, PsiElement source) {
        if (context == null) {
            JSTypeUtils.$$$reportNull$$$0(79);
        }
        return JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type1 -> {
            processor.process((JSType)type1, context, source);
            return true;
        }), type, true, false, false);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(80);
        }
        return JSTypeUtils.processExpandedType(processor, type, false, true, true);
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType) {
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(81);
        }
        return JSTypeUtils.processExpandedType(processor, type, completeSubstitute, recurse, processOnlyFinalType, null);
    }

    private static Set<JSResolvedTypeId> getOrCreateProcessingSet(@NotNull JSType type, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(82);
        }
        if (processedTypeIds != null) {
            return processedTypeIds;
        }
        HashSet<JSResolvedTypeId> set = new HashSet<JSResolvedTypeId>();
        set.add(type.getResolvedTypeId());
        return set;
    }

    public static boolean processExpandedType(@NotNull Processor<? super JSType> processor, @Nullable JSType type, boolean completeSubstitute, boolean recurse, boolean processOnlyFinalType, @Nullable Set<JSResolvedTypeId> processedTypeIds) {
        JSType newType;
        if (processor == null) {
            JSTypeUtils.$$$reportNull$$$0(83);
        }
        if (type != null && processedTypeIds != null && !processedTypeIds.add(type.getResolvedTypeId())) {
            return false;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            boolean isStrictTypeScript = JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionOrIntersectionType)type);
            if (isStrictTypeScript && completeSubstitute) {
                JSType resolveUnionType = type.substitute();
                if (resolveUnionType == type) {
                    resolveUnionType = type.asRecordType();
                }
                processor.process((Object)resolveUnionType);
            } else {
                processedTypeIds = JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds);
                List types2 = ((JSUnionOrIntersectionType)type).getTypes();
                if (type instanceof JSIntersectionType && type.getSourceElement() instanceof JSObjectLiteralExpression) {
                    types2 = ContainerUtil.reverse(types2);
                }
                for (JSType jsType : types2) {
                    if (!processOnlyFinalType) {
                        processor.process((Object)jsType);
                    }
                    if (!recurse) continue;
                    JSTypeUtils.processExpandedType(processor, jsType, completeSubstitute, true, processOnlyFinalType, processedTypeIds);
                }
            }
            return false;
        }
        if (type instanceof JSTypeImpl) {
            JSType typedefValue;
            JSTypeSource typeSource = type.getSource();
            if (typeSource.isStrict() && type.resolveClass() == null && (typedefValue = ((JSTypeImpl)type).getJSTypedef()) != null || (typedefValue = ((JSTypeImpl)type).resolveType().getAliasedType()) != null) {
                if (!processOnlyFinalType) {
                    processor.process((Object)typedefValue);
                }
                if (!recurse) {
                    return true;
                }
                return JSTypeUtils.processExpandedType(processor, typedefValue, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
        } else if ((type instanceof JSTypeWithIncompleteSubstitution || type instanceof JSEvaluableType && !(type instanceof JSEvaluableOnlyType) || type instanceof JSWrapperType) && type != (newType = type instanceof JSEvaluableType || type instanceof JSTypeWithIncompleteSubstitution ? (completeSubstitute ? JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type) : type.substitute()) : JSTypeUtils.unwrapType(type))) {
            if (!processOnlyFinalType) {
                processor.process((Object)newType);
            }
            if (recurse) {
                JSTypeUtils.processExpandedType(processor, newType, completeSubstitute, true, processOnlyFinalType, JSTypeUtils.getOrCreateProcessingSet(type, processedTypeIds));
            }
            return false;
        }
        if (processOnlyFinalType) {
            processor.process((Object)type);
        }
        return true;
    }

    public static boolean areTypesCompatible(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext processingContext, @Nullable PsiElement psiContext) {
        boolean eq;
        JSType substitute;
        if (type1 == null) {
            type1 = JSAnyType.get(psiContext, false);
        }
        if (type2 == null) {
            type2 = JSAnyType.get(psiContext, false);
        }
        if (type1 instanceof JSCodeBasedType && (substitute = type1.substitute()) != type1) {
            return JSTypeUtils.areTypesCompatible(substitute, type2, processingContext, psiContext);
        }
        if (type2 instanceof JSCodeBasedType && (substitute = type2.substitute()) != type2) {
            return JSTypeUtils.areTypesCompatible(type1, substitute, processingContext, psiContext);
        }
        if (type1 instanceof JSStringLiteralTypeImpl) {
            return type2 instanceof JSStringType;
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return type1 instanceof JSStringType;
        }
        if (type1 instanceof JSArrayType && !((JSArrayType)type1).isPrimitive()) {
            if (type2 instanceof JSArrayType && ((JSArrayType)type2).isPrimitive()) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type2)) {
                return true;
            }
        }
        if (type2 instanceof JSArrayType && !((JSArrayType)type2).isPrimitive()) {
            if (type1 instanceof JSArrayType && ((JSArrayType)type1).isPrimitive()) {
                return true;
            }
            if (JSGenericTypeImpl.isGenericActionScriptVectorType(type1)) {
                return true;
            }
        }
        if (eq = type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (psiContext != null && !DialectDetector.isActionScript(psiContext)) {
            return type1.isDirectlyAssignableType(type2, processingContext) && type2.isDirectlyAssignableType(type1, processingContext);
        }
        return false;
    }

    @Nullable
    public static JSType getTypeOfElement(@Nullable PsiElement element) {
        if (element instanceof TypeScriptPropertySignature && ((TypeScriptPropertySignature)element).isOptional() && ((TypeScriptPropertySignature)element).getJSType() != null) {
            return TypeScriptTypeGuard.wrapWithUndefined(((TypeScriptPropertySignature)element).getJSType(), null);
        }
        if (element instanceof JSClass) {
            return ((JSClass)element).getStaticJSType();
        }
        if (element instanceof JSTypeInfoOwner) {
            return ((JSTypeInfoOwner)element).getJSType();
        }
        if (element instanceof JSImplicitElement) {
            return JSTypeUtils.createType(((JSImplicitElement)element).getTypeString(), JSTypeSourceFactory.createTypeSource(element, true));
        }
        if (element instanceof JSFunction && ((JSFunction)element).isGetProperty()) {
            return ((JSFunction)element).getReturnType();
        }
        return null;
    }

    public static boolean isActionScriptVectorType(@Nullable JSType type) {
        if (type == null || type.getSource().isTypeScript()) {
            return false;
        }
        return "Vector".equals(JSTypeUtils.getQualifiedNameMatchingType(type, false));
    }

    @NotNull
    public static String defaultValueOfType(@Nullable JSType retType) {
        if (retType == null) {
            if ("undefined" == null) {
                JSTypeUtils.$$$reportNull$$$0(84);
            }
            return "undefined";
        }
        String string = retType.getDefaultValue();
        if (string == null) {
            JSTypeUtils.$$$reportNull$$$0(85);
        }
        return string;
    }

    @Deprecated
    @NonNls
    public static String defaultValueOfType(@NonNls String retType) {
        if (retType == null) {
            return "null";
        }
        switch (retType) {
            case "int": 
            case "uint": 
            case "Number": {
                return "0";
            }
            case "Boolean": {
                return "false";
            }
            case "String": {
                return "\"\"";
            }
        }
        return "null";
    }

    @Nullable
    public static List<JSType> getGenericTypeArguments(@Nullable JSType type) {
        if (type instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)type).getArguments();
        }
        if (type instanceof JSTupleType) {
            return JSTypeUtils.getGenericTypeArguments(((JSTupleType)type).toArrayType(true));
        }
        if (type instanceof JSArrayType) {
            JSType jsType = (JSType)ObjectUtils.coalesce((Object)((JSArrayType)type).getType(), (Object)JSAnyType.get(type.getSource().getSourceElement(), type.getSource().isStrict()));
            return Collections.singletonList(jsType);
        }
        if (type instanceof JSAliasTypeImpl) {
            return JSTypeUtils.getGenericTypeArguments(((JSAliasTypeImpl)type).getAlias());
        }
        return null;
    }

    @Contract(value="!null,_->!null")
    public static JSType expandEnumAndLiteralTypeByExpectedType(@Nullable JSType original, @Nullable JSType expectedType) {
        if (JSTypeUtils.containsLiteralTypes(expectedType) || JSTypeUtils.isEnumLiteralWithContextNumberOrString(original, expectedType)) {
            return original;
        }
        return JSTypeUtils.widenLiteralTypes(original, true);
    }

    private static boolean isEnumLiteralWithContextNumberOrString(@Nullable JSType expressionJSType, @Nullable JSType expectedType) {
        return JSTypeUtils.isEnumLiteral(expressionJSType) && (expectedType instanceof JSStringType || expectedType instanceof JSNumberType);
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralTypes(@Nullable JSType type) {
        JSType constraintType;
        if (type instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)type).getConstraintType()) != null) {
            type = constraintType;
        }
        if (type instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return true;
        }
        Ref hasLiteral = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (JSTypeUtils.isLiteralType(t, true)) {
                hasLiteral.set((Object)true);
                return false;
            }
            return true;
        }), type);
        return (Boolean)hasLiteral.get();
    }

    public static boolean isLiteralType(@Nullable JSType t, boolean expandTypeof) {
        JSType constraintType;
        if (t instanceof JSLiteralType) {
            return true;
        }
        if (t instanceof TypeScriptTypeOperatorJSTypeImpl) {
            return true;
        }
        if (JSTypeUtils.isEnumLiteral(t)) {
            return true;
        }
        if (t instanceof TypeScriptConditionalTypeJSTypeImpl && JSTypeUtils.hasForeignGenericParameter(t) && (JSTypeUtils.isLiteralType(((TypeScriptConditionalTypeJSTypeImpl)t).getTypeIfTrue(), false) || JSTypeUtils.isLiteralType(((TypeScriptConditionalTypeJSTypeImpl)t).getTypeIfFalse(), false))) {
            return true;
        }
        if (t instanceof TypeScriptGenericParameterImpl && (constraintType = ((TypeScriptGenericParameterImpl)t).getConstraintType()) != null && JSTypeUtils.isLiteralType(constraintType, false)) {
            return true;
        }
        if (expandTypeof) {
            return JSTypeUtils.isLiteralType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(t), false);
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isEnumLiteral(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        return info.isEnumLiteral();
    }

    @Contract(value="null, _ -> false")
    public static boolean isStringOrStringUnion(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return false;
        }
        if (allowResolve) {
            type = type.substitute();
        }
        if (type instanceof JSStringType) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().allMatch(el -> JSTypeUtils.isStringOrStringUnion(el, allowResolve));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isLiteralOrCompositeWithLiteralType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (JSTypeUtils.isLiteralType(type, true)) {
            return true;
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).getTypes().stream().anyMatch(el -> JSTypeUtils.isLiteralOrCompositeWithLiteralType(el));
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean containsLiteralOrEnumOrPrimitiveTypes(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        Ref hasLiteralOrPrimitiveOrEnum = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSResolvedTypeInfo info;
            if (t instanceof JSStringType || t instanceof JSNumberType || t instanceof JSBooleanType || t instanceof JSBigIntType || JSTypeUtils.isLiteralType(t, true)) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            if (t instanceof JSTypeImpl && (info = ((JSTypeImpl)t).resolveType()).isEnum()) {
                hasLiteralOrPrimitiveOrEnum.set((Object)true);
            }
            return true;
        }), type);
        return (Boolean)hasLiteralOrPrimitiveOrEnum.get();
    }

    @Contract(value="null -> null")
    public static JSType expandEnumLiteralIfNeeded(@Nullable JSType exprType) {
        return exprType;
    }

    @Nullable
    @Contract(value="!null->!null")
    public static JSType widenLiteralTypes(@Nullable JSType type) {
        return JSTypeUtils.widenLiteralTypes(type, false);
    }

    @Nullable
    @Contract(value="!null,_->!null")
    public static JSType widenLiteralTypes(@Nullable JSType type, boolean allowResolve) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSTypeWithWidening && ((JSTypeWithWidening)type).allowWidening()) {
            return ((JSTypeWithWidening)type).widen(allowResolve);
        }
        if (JSTypeUtils.isUnionTypeWithLiteralCandidate(type)) {
            return ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)nested -> JSTypeUtils.widenLiteralTypes(nested, allowResolve)));
        }
        return type;
    }

    private static boolean isUnionTypeWithLiteralCandidate(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(86);
        }
        return type instanceof JSUnionType && JSTypeUtils.hasTypes(type, JSStringLiteralTypeImpl.class, JSNumberLiteralTypeImpl.class, JSBigIntLiteralTypeImpl.class, JSBooleanLiteralTypeImpl.class, JSTypeImpl.class);
    }

    @Contract(value="!null->!null")
    public static JSType getApparentType(@Nullable JSType type) {
        if ((type = JSTypeUtils.widenLiteralTypes(type)) instanceof JSNullType || type instanceof JSUndefinedType) {
            return JSAnyType.get(type.getSource());
        }
        if (type instanceof JSTypeofTypeImpl) {
            return new JSWidenType(type);
        }
        if (JSTypeUtils.hasTypes(type, JSUnionOrIntersectionType.class, JSTupleType.class)) {
            JSCacheableTypeTransformerBase cacheableTransformation = new JSCacheableTypeTransformerBase(){

                @NotNull
                public JSType fun(@NotNull JSType type) {
                    JSType optimizeTypeIfComposite;
                    if (type == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (type instanceof JSUnionOrIntersectionType && type != (optimizeTypeIfComposite = JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE))) {
                        JSType jSType = optimizeTypeIfComposite.transformTypeHierarchy((JSRecursiveTypeTransformer)this);
                        if (jSType == null) {
                            5.$$$reportNull$$$0(1);
                        }
                        return jSType;
                    }
                    if (type instanceof JSTupleType) {
                        JSType jSType = JSTupleTypeImpl.createTupleType(type.getSource(), ContainerUtil.map((Collection)((JSTupleType)type).getTypes(), t -> t.transformTypeHierarchy((JSRecursiveTypeTransformer)this)), true, ((JSTupleType)type).getOptionalStart(), ((JSTupleType)type).isReadonly());
                        if (jSType == null) {
                            5.$$$reportNull$$$0(2);
                        }
                        return jSType;
                    }
                    JSType jSType = type;
                    if (jSType == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    return jSType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils$5";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils$5";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fun";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "fun";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            type = type.transformTypeHierarchy((Function)cacheableTransformation);
        }
        return type;
    }

    public static JSType getCommonType(@NotNull JSType type1, @NotNull JSType type2, @Nullable DialectOptionHolder holder, boolean allowResolve) {
        boolean isTypeScript;
        if (type1 == null) {
            JSTypeUtils.$$$reportNull$$$0(87);
        }
        if (type2 == null) {
            JSTypeUtils.$$$reportNull$$$0(88);
        }
        JSTypeSource source = type1.getSource();
        boolean bl = isTypeScript = holder != null && holder.isTypeScript;
        if (!(!(type1 instanceof JSStringType) || !(type2 instanceof JSStringType) || isTypeScript && type1 instanceof JSStringLiteralTypeImpl && type2 instanceof JSStringLiteralTypeImpl)) {
            return JSNamedTypeFactory.createType("string", source, ((JSStringType)type1).isStaticOrInstance());
        }
        if (isTypeScript) {
            return JSCompositeTypeImpl.getCommonType(type1, type2, null, allowResolve);
        }
        if (type1.isEquivalentTo(type2, null, allowResolve)) {
            return type1;
        }
        return JSAnyType.getWithLanguage(source.getLanguage(), false);
    }

    @NotNull
    public static JSType replaceImplicitTypesWithAny(@NotNull JSType type) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(89);
        }
        JSType jSType = type.transformTypeHierarchy(jsType -> {
            JSType toProcess = JSTypeUtils.getValuableType(jsType);
            if (jsType instanceof JSAnyType) {
                return jsType;
            }
            if (!toProcess.isSourceStrict() && toProcess.isTypeScript()) {
                PsiElement sourceElement = toProcess.getSource().getSourceElement();
                return sourceElement != null ? JSAnyType.get(sourceElement, true) : JSAnyType.getWithLanguage(toProcess.getSource().getLanguage(), true);
            }
            return jsType;
        });
        if (jSType == null) {
            JSTypeUtils.$$$reportNull$$$0(90);
        }
        return jSType;
    }

    public static boolean isAnyType(JSType expressionType) {
        return expressionType instanceof JSAnyType || expressionType instanceof JSUnionType && ((JSUnionType)expressionType).isAnyType() || expressionType instanceof JSCodeBasedType;
    }

    @Contract(value="!null->!null;null->null")
    public static JSType unwrapType(@Nullable JSType topOwnerType) {
        for (int i = 0; topOwnerType instanceof JSWrapperType && i < 10; ++i) {
            topOwnerType = ((JSWrapperType)topOwnerType).getOriginalType();
        }
        return topOwnerType;
    }

    public static JSType getCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        DialectOptionHolder holder;
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(91);
        }
        DialectOptionHolder dialectOptionHolder = holder = context == null ? null : DialectDetector.dialectOfElement(context);
        if (holder != null && holder.isTypeScript) {
            return JSTypeUtils.getTypeScriptCommonType(providers, context, allowResolve);
        }
        JSAnyType commonType = null;
        for (TypeProvider typeProvider : providers) {
            JSType exprType = typeProvider.getType();
            if (!((commonType = commonType != null && exprType != null ? JSTypeUtils.getCommonType(commonType, exprType, holder, allowResolve) : exprType) instanceof JSAnyType)) continue;
            break;
        }
        if (commonType == null) {
            commonType = JSAnyType.get(context, false);
        }
        return commonType;
    }

    public static JSType getTypeScriptCommonType(@NotNull Collection<? extends TypeProvider> providers, @Nullable PsiElement context, boolean allowResolve) {
        if (providers == null) {
            JSTypeUtils.$$$reportNull$$$0(92);
        }
        List<JSType> types2 = new ArrayList(providers.size());
        boolean hasStringType = false;
        for (TypeProvider typeProvider : providers) {
            JSType type = typeProvider.getType();
            if (type instanceof JSAnyType) {
                return type;
            }
            types2.add(type);
            if (!(type instanceof JSStringType) || type instanceof JSStringLiteralTypeImpl) continue;
            hasStringType = true;
        }
        if (hasStringType) {
            types2 = ContainerUtil.filter(types2, el -> !(el instanceof JSStringLiteralTypeImpl));
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        return JSCompositeTypeImpl.getCommonType(types2, source, allowResolve);
    }

    private static boolean isAssignableType(@Nullable JSType thisType, @Nullable JSType elementType, ProcessingContext processingContext) {
        return thisType == null || thisType.isDirectlyAssignableType(elementType, processingContext);
    }

    public static List<JSParameterTypeDecorator> getParameterTypeDecorators(List<? extends JSType> parameters) {
        ArrayList<JSParameterTypeDecorator> decorators = new ArrayList<JSParameterTypeDecorator>(parameters.size());
        for (JSType jSType : parameters) {
            decorators.add(new JSParameterTypeDecoratorImpl(jSType, false, false, true));
        }
        return decorators;
    }

    @NotNull
    public static JSContext combineJSContexts(@NotNull JSContext f, @NotNull JSContext g) {
        if (f == null) {
            JSTypeUtils.$$$reportNull$$$0(93);
        }
        if (g == null) {
            JSTypeUtils.$$$reportNull$$$0(94);
        }
        if (f == JSContext.STATIC && g == JSContext.STATIC) {
            JSContext jSContext = JSContext.STATIC;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(95);
            }
            return jSContext;
        }
        if (f == JSContext.INSTANCE || g == JSContext.INSTANCE) {
            JSContext jSContext = JSContext.INSTANCE;
            if (jSContext == null) {
                JSTypeUtils.$$$reportNull$$$0(96);
            }
            return jSContext;
        }
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSTypeUtils.$$$reportNull$$$0(97);
        }
        return jSContext;
    }

    @NotNull
    public static Object getTypeInvalidationDependency() {
        Key key = PsiModificationTracker.MODIFICATION_COUNT;
        if (key == null) {
            JSTypeUtils.$$$reportNull$$$0(98);
        }
        return key;
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromProperties(@NotNull Map<JSQualifiedName, String> properties, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (properties == null) {
            JSTypeUtils.$$$reportNull$$$0(99);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(100);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(101);
        }
        ArrayList<Pair> list2 = new ArrayList<Pair>(properties.size());
        for (Map.Entry<JSQualifiedName, String> entry : properties.entrySet()) {
            list2.add(Pair.create((Object)entry.getKey(), (Object)entry.getValue()));
        }
        return JSTypeUtils.buildRecordTypeFromQualifiedNames(list2, optional, typeSource);
    }

    @Nullable
    public static JSRecordType buildRecordTypeFromQualifiedNames(@NotNull Collection<? extends Pair<JSQualifiedName, String>> qualifiedNames, @NotNull Set<JSQualifiedName> optional, @NotNull JSTypeSource typeSource) {
        if (qualifiedNames == null) {
            JSTypeUtils.$$$reportNull$$$0(102);
        }
        if (optional == null) {
            JSTypeUtils.$$$reportNull$$$0(103);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(104);
        }
        RecordTypeNode root = new RecordTypeNode();
        for (Pair<JSQualifiedName, String> pair : qualifiedNames) {
            List components = ((JSQualifiedName)pair.getFirst()).toComponents();
            RecordTypeNode currentPath = root;
            for (int i = 0; i < components.size(); ++i) {
                String component = (String)components.get(i);
                RecordTypeNode child = currentPath.myChildren.get(component);
                if (child == null) {
                    child = new RecordTypeNode();
                    child.myOptional = optional.contains(pair.getFirst());
                    currentPath.myChildren.put(component, child);
                }
                currentPath = child;
                if (i != components.size() - 1) continue;
                String typeString = (String)pair.getSecond();
                currentPath.myType = JSTypeUtils.createTypeFromJSDoc(typeString, typeSource);
            }
        }
        return (JSRecordType)JSTypeUtils.buildTypeFromRecordTypeNode(root, typeSource);
    }

    @Nullable
    private static JSType buildTypeFromRecordTypeNode(@NotNull RecordTypeNode node, @NotNull JSTypeSource typeSource) {
        if (node == null) {
            JSTypeUtils.$$$reportNull$$$0(105);
        }
        if (typeSource == null) {
            JSTypeUtils.$$$reportNull$$$0(106);
        }
        if (node.myChildren.isEmpty()) {
            return node.myType;
        }
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(node.myChildren.size());
        for (Map.Entry<String, RecordTypeNode> entry : node.myChildren.entrySet()) {
            JSType type = JSTypeUtils.buildTypeFromRecordTypeNode(entry.getValue(), typeSource);
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(entry.getKey(), type, entry.getValue().myOptional, false));
        }
        return new JSRecordTypeImpl(typeSource, typeMembers);
    }

    @NotNull
    public static Collection<JSImplicitElement> getImplicitMembersFromRecordType(@NotNull JSRecordType type, @Nullable JSQualifiedName namespace, @Nullable PsiElement parent) {
        if (type == null) {
            JSTypeUtils.$$$reportNull$$$0(107);
        }
        SmartList elements = new SmartList();
        for (JSRecordType.TypeMember member : type.getTypeMembers()) {
            if (!(member instanceof JSRecordType.PropertySignature)) continue;
            String name = ((JSRecordType.PropertySignature)member).getMemberName();
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, parent).setNamespace(namespace).setProperties(JSImplicitElement.Property.MinorImportance).setType(JSImplicitElement.Type.Property).setNamespaceExplicitlyDeclared(namespace != null);
            JSType jsType = ((JSRecordType.PropertySignature)member).getJSType();
            if (jsType instanceof JSRecordType) {
                Collection<JSImplicitElement> childElements = JSTypeUtils.getImplicitMembersFromRecordType((JSRecordType)jsType, JSQualifiedNameImpl.create(name, namespace), parent);
                elements.addAll(childElements);
            }
            if (jsType != null) {
                builder.setTypeString(jsType.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
            JSImplicitElementImpl element = new JSImplicitElementImpl(builder);
            elements.add((Object)element);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSTypeUtils.$$$reportNull$$$0(108);
        }
        return smartList;
    }

    @Contract(value="!null,_ -> !null")
    public static JSType transformTypeHierarchySafe(@Nullable JSType type, @NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeUtils.$$$reportNull$$$0(109);
        }
        if (type == null) {
            return null;
        }
        return type.transformTypeHierarchy(transformation);
    }

    public static boolean isNeedWrapTypeForSerialization(@Nullable JSType type) {
        return type instanceof JSUnionOrIntersectionType || type instanceof JSFunctionTypeImpl || type instanceof TypeScriptTypeOperatorJSTypeImpl;
    }

    @Nullable
    public static PsiElement getLocalScopeFromSource(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSTypeUtils.$$$reportNull$$$0(110);
        }
        if (!namespace.isLocal()) {
            return null;
        }
        PsiElement sourceElement = namespace.getSource().getSourceElement();
        if (sourceElement instanceof PsiFile) {
            return sourceElement;
        }
        return sourceElement != null ? JSUseScopeProvider.getLexicalScopeOrFile(sourceElement) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 108: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 108: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 40: 
            case 43: 
            case 53: 
            case 82: 
            case 86: 
            case 89: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 12: 
            case 101: 
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 13: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 15: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overloadPacks";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTypes";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyCallElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startFunction";
                break;
            }
            case 47: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypeDecorator";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argIterator";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericParameters";
                break;
            }
            case 67: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredGenericIds";
                break;
            }
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 73: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newOption";
                break;
            }
            case 80: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 100: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optional";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeUtils";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInPromiseType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMatchingNamespace";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypeName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "combineSignaturesOfUnionMembers";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "typeOrAny";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValidConstituents";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeWithMixins";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseOverloadFunctionTypes";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "spreadArguments";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "addPossibleOption";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultValueOfType";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceImplicitTypesWithAny";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "combineJSContexts";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInvalidationDependency";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitMembersFromRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeInOriginalTree";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializedOrJSDocType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseSerializedType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTypeFromJSDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createParameterType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIterableCollectionType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIndexableType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMapType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "wrapInPromiseType";
                break;
            }
            case 13: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 108: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPromiseComponentTypeOrNull";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSingleGenericArgTypeFromGenericType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSingleGenericComponentType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIterableComponentType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "typeCanBeAssignedWithoutCoercion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMatchingNamespace";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameMatchingType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceMatchingType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasFunctionType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMergedUnionSignatureType";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "combineSignaturesOfUnionMembers";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "typeOrAny";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "mergeWithMixins";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptInterfaceInJavaScriptContext";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyTypeOrNotStrictType";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tryGetReturnType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "chooseOverloadFunctionTypes";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "applyJSGenericsForType";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "areArgumentsAssignable";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkTuple";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "matchRestTuples";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "spreadArguments";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "concatGenericsToJSGenericTypeIfNestedLocal";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addJSGenericParameters";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "applyCompositeMapping";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "hasForeignGenericParameter";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "hasTypes";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageOfContext";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleOption";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processExpandedType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateProcessingSet";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isUnionTypeWithLiteralCandidate";
                break;
            }
            case 87: 
            case 88: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getCommonType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplicitTypesWithAny";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getTypeScriptCommonType";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "combineJSContexts";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromProperties";
                break;
            }
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromQualifiedNames";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeFromRecordTypeNode";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitMembersFromRecordType";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchySafe";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFromSource";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSingleGenericArgTypeFromGenericType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 51: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 77: 
            case 78: 
            case 84: 
            case 85: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 108: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RecordTypeNode {
        Map<String, RecordTypeNode> myChildren = new LinkedHashMap<String, RecordTypeNode>();
        boolean myOptional;
        JSType myType;

        private RecordTypeNode() {
        }
    }

    public static interface TypeProvider {
        @Nullable
        public JSType getType();
    }
}

