/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.ImportCommonJSModuleFix;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddInnerRequireAmdModuleToModulesListFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    private final String myRequireName;
    @NotNull
    private final JSAmdUtil.AmdLoaderCallOnPointers myAmdLoaderCallOnPointers;
    private final String myPath;
    private final String myReferenceName;
    private final boolean myIsSingleQuotes;

    public AddInnerRequireAmdModuleToModulesListFix(@NotNull String requireName, @NotNull JSAmdUtil.AmdLoaderCallOnPointers pointers, String path, String referenceName, boolean isSingleQuotes) {
        if (requireName == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(0);
        }
        if (pointers == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(1);
        }
        this.myRequireName = requireName;
        this.myAmdLoaderCallOnPointers = pointers;
        this.myPath = path;
        this.myReferenceName = referenceName;
        this.myIsSingleQuotes = isSingleQuotes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myIsSingleQuotes) {
            String string = "Insert " + this.myRequireName + "('" + this.myPath + "')";
            if (string == null) {
                AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = "Insert " + this.myRequireName + "(\"" + this.myPath + "\")";
        if (string == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(6);
        }
        this.invokeImpl();
    }

    private void invokeImpl() {
        JSAmdUtil.AmdLoaderCall amdLoaderCall = this.myAmdLoaderCallOnPointers.toCall();
        if (!amdLoaderCall.isValid()) {
            return;
        }
        JSParameter parameter = amdLoaderCall.getRequireSugaredParameter();
        Project project = parameter.getProject();
        StringBuilder text = new StringBuilder();
        if (this.myIsSingleQuotes) {
            text.append("var ").append(this.myReferenceName).append(" = ").append(this.myRequireName).append("('").append(this.myPath).append("');");
        } else {
            text.append("var ").append(this.myReferenceName).append(" = ").append(this.myRequireName).append("(\"").append(this.myPath).append("\");");
        }
        PsiElement requireElement = ImportCommonJSModuleFix.createDummyFile(project, text.toString()).getFirstChild();
        JSFunctionExpression callBackExpression = amdLoaderCall.getCallBackExpression();
        JSBlockStatement element = callBackExpression.getBlock();
        if (element == null) {
            return;
        }
        PsiElement last = new LastImportRequireInScope(false).withRequireName(this.myRequireName).findAndSelect((PsiElement)element);
        if (last == null) {
            PsiElement child = PsiTreeUtil.getChildOfType((PsiElement)element, JSStatement.class);
            if (child == null) {
                element.add(requireElement);
            } else {
                element.addBefore(requireElement, child);
            }
        } else {
            element.addAfter(requireElement, last);
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart(callBackExpression.getContainingFile());
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = AddInnerRequireAmdModuleToModulesListFix.class.getName();
        if (string == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inspection.amd.modules.dependencies.family.name", (Object[])new Object[0]);
        if (string == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            AddInnerRequireAmdModuleToModulesListFix.$$$reportNull$$$0(10);
        }
        this.invokeImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/AddInnerRequireAmdModuleToModulesListFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

