/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.util.JSLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterInspection;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EslintConfiguration", storages={@Storage(value="jsLinters/eslint.xml")})
public class EslintConfiguration
extends JSLinterConfiguration<EslintState> {
    private static final String TAG_CUSTOM_CONFIGURATION_FILE = "custom-configuration-file";
    private static final String ATTR_CUSTOM_CONFIGURATION_FILE_USED = "used";
    private static final String ATTR_CUSTOM_CONFIGURATION_FILE_PATH = "path";
    private static final String TAG_ADDITIONAL_RULES_DIR = "additional-rules-dir";
    private static final String TAG_EXTRA_ESLINT_OPTIONS = "extra-options";
    private final JSLinterPackage myPackage;

    public EslintConfiguration(@NotNull Project project) {
        if (project == null) {
            EslintConfiguration.$$$reportNull$$$0(0);
        }
        super(project);
        this.myPackage = new JSLinterPackage(project, "eslint", true);
    }

    @NotNull
    public static EslintConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            EslintConfiguration.$$$reportNull$$$0(1);
        }
        EslintConfiguration eslintConfiguration = JSLinterConfiguration.getInstance(project, EslintConfiguration.class);
        if (eslintConfiguration == null) {
            EslintConfiguration.$$$reportNull$$$0(2);
        }
        return eslintConfiguration;
    }

    @Override
    @NotNull
    protected Class<? extends JSLinterInspection> getInspectionClass() {
        if (EslintInspection.class == null) {
            EslintConfiguration.$$$reportNull$$$0(3);
        }
        return EslintInspection.class;
    }

    @Override
    protected void savePrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            EslintConfiguration.$$$reportNull$$$0(4);
        }
        this.doSavePrivateSettings(state);
    }

    @Override
    @NotNull
    protected EslintState loadPrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            EslintConfiguration.$$$reportNull$$$0(5);
        }
        EslintState.Builder builder = new EslintState.Builder(state);
        this.doLoadPrivateSettings(builder);
        EslintState eslintState = builder.build();
        if (eslintState == null) {
            EslintConfiguration.$$$reportNull$$$0(6);
        }
        return eslintState;
    }

    @Override
    @Nullable
    protected Element toXml(@NotNull EslintState state) {
        String extraOptions;
        String additionalRulesDirPath;
        if (state == null) {
            EslintConfiguration.$$$reportNull$$$0(7);
        }
        if (EslintConfiguration.isEmpty(state)) {
            return null;
        }
        Element parent = new Element("eslint");
        if (state.isCustomConfigFileUsed() || !state.getCustomConfigFilePath().isEmpty()) {
            Element customConfigurationFileElement = new Element(TAG_CUSTOM_CONFIGURATION_FILE);
            customConfigurationFileElement.setAttribute(ATTR_CUSTOM_CONFIGURATION_FILE_USED, Boolean.toString(state.isCustomConfigFileUsed()));
            customConfigurationFileElement.setAttribute(ATTR_CUSTOM_CONFIGURATION_FILE_PATH, state.getCustomConfigFilePath());
            parent.addContent(customConfigurationFileElement);
        }
        if (!(additionalRulesDirPath = state.getAdditionalRulesDirPath()).isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_ADDITIONAL_RULES_DIR, (String)additionalRulesDirPath);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(extraOptions = state.getExtraOptions()))) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_EXTRA_ESLINT_OPTIONS, (String)extraOptions);
        }
        return parent;
    }

    @Override
    @NotNull
    protected EslintState fromXml(@NotNull Element element) {
        String extraOptions;
        String additionalRulesDirPath;
        if (element == null) {
            EslintConfiguration.$$$reportNull$$$0(8);
        }
        EslintState.Builder builder = new EslintState.Builder();
        Element customConfigurationFileElement = element.getChild(TAG_CUSTOM_CONFIGURATION_FILE);
        if (customConfigurationFileElement != null) {
            boolean used = Boolean.parseBoolean(customConfigurationFileElement.getAttributeValue(ATTR_CUSTOM_CONFIGURATION_FILE_USED));
            builder.setCustomConfigFileUsed(used);
            String customConfigFilePath = customConfigurationFileElement.getAttributeValue(ATTR_CUSTOM_CONFIGURATION_FILE_PATH);
            builder.setCustomConfigFilePath(StringUtil.notNullize((String)customConfigFilePath));
        }
        if ((additionalRulesDirPath = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG_ADDITIONAL_RULES_DIR)) != null) {
            builder.setAdditionalRulesDirPath(additionalRulesDirPath);
        }
        if ((extraOptions = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG_EXTRA_ESLINT_OPTIONS)) != null) {
            builder.setExtraOptions(extraOptions);
        }
        EslintState eslintState = builder.build();
        if (eslintState == null) {
            EslintConfiguration.$$$reportNull$$$0(9);
        }
        return eslintState;
    }

    @Override
    @NotNull
    protected EslintState getDefaultState() {
        EslintState eslintState = EslintState.DEFAULT;
        if (eslintState == null) {
            EslintConfiguration.$$$reportNull$$$0(10);
        }
        return eslintState;
    }

    private void doSavePrivateSettings(@NotNull EslintState state) {
        if (state == null) {
            EslintConfiguration.$$$reportNull$$$0(11);
        }
        this.myPackage.force(state.getInterpreterRef(), state.getNodePackageRef());
    }

    private void doLoadPrivateSettings(@NotNull EslintState.Builder builder) {
        if (builder == null) {
            EslintConfiguration.$$$reportNull$$$0(12);
        }
        this.myPackage.readOrDetect();
        builder.setInterpreterRef(this.myPackage.getInterpreter());
        builder.setEslintPackage(this.myPackage.getPackage());
    }

    private static boolean isEmpty(@NotNull EslintState state) {
        if (state == null) {
            EslintConfiguration.$$$reportNull$$$0(13);
        }
        String additionalRulesDirPath = state.getAdditionalRulesDirPath();
        String extraOptions = state.getExtraOptions();
        return (!state.isCustomConfigFileUsed() || state.getCustomConfigFilePath().isEmpty()) && additionalRulesDirPath.isEmpty() && StringUtil.isEmptyOrSpaces((String)extraOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fromXml";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "savePrivateSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateSettings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toXml";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromXml";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doSavePrivateSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doLoadPrivateSettings";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

