/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSJoinVariableStatementsIntention
extends JavaScriptIntention {
    public JSJoinVariableStatementsIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(1);
        }
        List<JSVarStatement> statements = JSJoinVariableStatementsIntention.findSubsequentVarStatements(element);
        StringBuilder newStatementBuilder = new StringBuilder();
        newStatementBuilder.append(Objects.requireNonNull(statements.get(0).getVarKeyword()).getText()).append(" ");
        boolean first = true;
        for (JSVarStatement statement : statements) {
            JSInitializerOwner[] declarations;
            for (JSInitializerOwner variable : declarations = statement.getDeclarations()) {
                if (first) {
                    first = false;
                } else {
                    newStatementBuilder.append(", ");
                }
                newStatementBuilder.append(variable.getText());
            }
        }
        newStatementBuilder.append(JSCodeStyleSettings.getSemicolon(element));
        JSStatement newStatement = JSPsiElementFactory.createJSStatement(newStatementBuilder.toString(), element);
        JSVarStatement initialStatement = statements.get(0);
        JSVarStatement replaced = (JSVarStatement)initialStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)initialStatement);
        HashSet elements = ContainerUtil.newHashSet((Object[])new PsiElement[]{replaced});
        for (JSVarStatement statement : statements) {
            JSInitializerOwner[] declarations = statement.getDeclarations();
            if (declarations.length != 1 || !(declarations[0] instanceof JSVariable)) {
                CommentsMover commentsMover = new CommentsMover((JSSourceElement)statement);
                commentsMover.move(elements, elements);
            } else {
                String name = ((JSVariable)declarations[0]).getName();
                CommentsMover commentsMover = new CommentsMover((JSSourceElement)statement, true);
                for (JSVariable variable : replaced.getVariables()) {
                    if (!Objects.equals(name, variable.getName())) continue;
                    HashSet varr = ContainerUtil.newHashSet((Object[])new PsiElement[]{variable});
                    commentsMover.move(varr, varr);
                    break;
                }
            }
            NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
            statement.delete();
            eraser.process();
        }
        JSJoinVariableStatementsIntention.fixCommentsIndents(editor, replaced);
    }

    private static void fixCommentsIndents(@NotNull Editor editor, @NotNull JSVarStatement replaced) {
        if (editor == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(2);
        }
        if (replaced == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(3);
        }
        LogicalPosition position = editor.offsetToLogicalPosition(replaced.getTextOffset());
        int offsetFromLineStart = position.column;
        String shift = StringUtil.repeat((String)" ", (int)offsetFromLineStart);
        PsiElement prevSibling = replaced.getPrevSibling();
        ArrayList<PsiElement> possiblyToDelete = new ArrayList<PsiElement>();
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling instanceof PsiWhiteSpace) {
                possiblyToDelete.add(prevSibling);
            } else if (!possiblyToDelete.isEmpty()) {
                boolean one = true;
                for (PsiElement psiElement : ContainerUtil.reverse(possiblyToDelete)) {
                    if (one) {
                        one = false;
                        psiElement.replace(JSChangeUtil.createTokenElement(psiElement, JSTokenTypes.WHITE_SPACE, StringUtil.convertLineSeparators((String)"\r\n") + shift));
                        continue;
                    }
                    psiElement.delete();
                }
                possiblyToDelete.clear();
            }
            prevSibling = prevSibling.getPrevSibling();
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(5);
        }
        return JSJoinVariableStatementsIntention.findSubsequentVarStatements(element).size() > 1;
    }

    @NotNull
    private static List<JSVarStatement> findSubsequentVarStatements(PsiElement element) {
        PsiElement parent = element.getParent();
        JSVarStatement initial = null;
        if (parent instanceof JSVarStatement) {
            initial = (JSVarStatement)parent;
        } else if (parent instanceof JSVariable) {
            initial = ((JSVariable)parent).getStatement();
        }
        if (initial == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSJoinVariableStatementsIntention.$$$reportNull$$$0(6);
            }
            return list2;
        }
        JSVarStatement.VarKeyword initialVarKeyword = initial.getVarKeyword();
        if (initialVarKeyword == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSJoinVariableStatementsIntention.$$$reportNull$$$0(7);
            }
            return list3;
        }
        boolean isDeclareInitial = JSJoinVariableStatementsIntention.isDeclare(initial);
        boolean isExportInitial = JSJoinVariableStatementsIntention.isExport(initial);
        ArrayList<JSVarStatement> statements = new ArrayList<JSVarStatement>();
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)initial);
        while (prev instanceof JSVarStatement && ((JSVarStatement)prev).getVarKeyword() == initialVarKeyword && isDeclareInitial == JSJoinVariableStatementsIntention.isDeclare((JSVarStatement)prev) && isExportInitial == JSJoinVariableStatementsIntention.isExport((JSVarStatement)prev)) {
            statements.add(0, (JSVarStatement)prev);
            prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev);
        }
        statements.add(initial);
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)initial);
        while (next instanceof JSVarStatement && ((JSVarStatement)next).getVarKeyword() == initialVarKeyword && isDeclareInitial == JSJoinVariableStatementsIntention.isDeclare((JSVarStatement)next) && isExportInitial == JSJoinVariableStatementsIntention.isExport((JSVarStatement)next)) {
            statements.add((JSVarStatement)next);
            next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)next);
        }
        ArrayList<JSVarStatement> arrayList = statements;
        if (arrayList == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static boolean isDeclare(JSVarStatement initial) {
        JSAttributeList attributeList = initial.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    private static boolean isExport(JSVarStatement initial) {
        JSAttributeList attributeList = initial.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.join.vars.intention", (Object[])new Object[0]);
        if (string == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaced";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSJoinVariableStatementsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSJoinVariableStatementsIntention";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubsequentVarStatements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fixCommentsIndents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

