/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidUsageOfThisInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.potentially.invalid.usage.of.this.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){
            private final Set<JSThisExpression> processedExpressions = new HashSet<JSThisExpression>();

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.process((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = JSResolveUtil.findParent((PsiElement)node)) instanceof JSClass) {
                    return;
                }
                this.process(node);
            }

            private void process(final @NotNull JSFunction function) {
                if (function == null) {
                    1.$$$reportNull$$$0(2);
                }
                final Set referencedFields = JSPotentiallyInvalidUsageOfThisInspection.getReferencedFields(function);
                function.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){
                    JSFunction fun;
                    boolean sameThis;
                    boolean myThisTypeExplicitlyDeclared;
                    {
                        this.fun = function;
                    }

                    public void visitJSThisExpression(JSThisExpression node) {
                        if (this.fun != function && !this.sameThis && !this.myThisTypeExplicitlyDeclared && JSPotentiallyInvalidUsageOfThisInspection.shouldReportThis(node, referencedFields, function) && processedExpressions.add(node)) {
                            holder.registerProblem((PsiElement)node, JSBundle.message((String)"javascript.potentially.invalid.usage.of.this", (Object[])new Object[0]), new LocalQuickFix[0]);
                        }
                    }

                    public boolean visitAsFunction(JSFunction function2) {
                        this.proceedFun(function2);
                        return true;
                    }

                    private void proceedFun(JSFunction node) {
                        JSFunction prev = this.fun;
                        boolean sameThisSave = this.sameThis;
                        boolean _thisTypeExplicitlyDeclared = this.myThisTypeExplicitlyDeclared;
                        this.fun = node;
                        this.sameThis = JSPotentiallyInvalidUsageOfThisInspection.isSameThisAsBefore(node);
                        this.myThisTypeExplicitlyDeclared = JSPotentiallyInvalidUsageOfThisInspection.isThisTypeExplicitlyDeclared(node);
                        super.visitJSElement((JSElement)node);
                        this.fun = prev;
                        this.sameThis = sameThisSave;
                        this.myThisTypeExplicitlyDeclared = _thisTypeExplicitlyDeclared;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static boolean isThisTypeExplicitlyDeclared(@NotNull JSFunction node) {
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(4);
        }
        return JSDocumentationUtils.findContextType((PsiElement)node) != null || TypeScriptPsiUtil.getThisParameter(node) != null;
    }

    private static boolean shouldReportThis(@NotNull JSThisExpression node, @NotNull Set<String> referencedFields, @NotNull JSFunction outerFunction) {
        PsiElement parent;
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(5);
        }
        if (referencedFields == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(6);
        }
        if (outerFunction == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(7);
        }
        if (!((parent = node.getParent()) instanceof JSReferenceExpression)) {
            return false;
        }
        String referencedName = ((JSReferenceExpression)parent).getReferenceName();
        boolean referenceInClass = referencedName != null && referencedFields.contains(referencedName);
        JSQualifiedNameImpl outerFunctionQName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)outerFunction);
        if (!referenceInClass) {
            PsiElement resolve = ((JSReferenceExpression)parent).resolve();
            boolean bl = referenceInClass = resolve instanceof JSPsiElementBase && outerFunctionQName != null && outerFunctionQName.equals(((JSPsiElementBase)resolve).getNamespace());
        }
        if (!referenceInClass) {
            return false;
        }
        JSNamespace result2 = JSContextResolver.resolveContext((PsiElement)node);
        boolean sameThisReportedByContextResolver = result2 != null && outerFunctionQName != null && outerFunctionQName.equals(result2.getQualifiedName());
        return !sameThisReportedByContextResolver;
    }

    @NotNull
    private static Set<String> getReferencedFields(@NotNull JSFunction function) {
        if (function == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(8);
        }
        THashSet referencedFields = new THashSet();
        ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function).forceIgnore(e -> e instanceof JSFunction && !((JSFunction)e).isArrowFunction())).filter(JSThisExpression.class).forEach(arg_0 -> JSPotentiallyInvalidUsageOfThisInspection.lambda$getReferencedFields$1((Set)referencedFields, arg_0));
        THashSet tHashSet = referencedFields;
        if (tHashSet == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(9);
        }
        return tHashSet;
    }

    private static boolean isSameThisAsBefore(@NotNull JSFunction node) {
        if (node == null) {
            JSPotentiallyInvalidUsageOfThisInspection.$$$reportNull$$$0(10);
        }
        PsiElement parent = JSPsiImplUtils.getNonParenthesizeParent((PsiElement)node);
        if (node.isArrowFunction()) {
            return true;
        }
        if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            return lOperand instanceof JSReferenceExpression && ((JSReferenceExpression)lOperand).getQualifier() instanceof JSThisExpression;
        }
        if (parent instanceof JSArgumentList) {
            JSExpression methodExpression;
            PsiElement grandParent;
            JSExpression[] arguments = ((JSArgumentList)parent).getArguments();
            PsiFile containingFile = node.getContainingFile();
            for (int i = 0; i < arguments.length; ++i) {
                JSExpression initializer;
                PsiElement resolve;
                if (arguments[i] != node) continue;
                if (i + 1 >= arguments.length) break;
                JSExpression argument = arguments[i + 1];
                if (argument instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)argument).resolve()) instanceof JSVariable && resolve.getContainingFile() == containingFile && (initializer = ((JSVariable)resolve).getInitializer()) != null) {
                    argument = initializer;
                }
                if (!(argument instanceof JSThisExpression)) break;
                return true;
            }
            return (grandParent = parent.getParent()) instanceof JSCallExpression && (methodExpression = ((JSCallExpression)grandParent).getMethodExpression()) instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSThisExpression;
        }
        if (parent instanceof JSReferenceExpression && parent.getParent() instanceof JSCallExpression) {
            JSExpression[] arguments;
            JSCallExpression callExpression = (JSCallExpression)parent.getParent();
            String name = ((JSReferenceExpression)parent).getReferenceName();
            if ("bind".equals(name) && (arguments = callExpression.getArguments()).length == 1 && arguments[0] instanceof JSThisExpression) {
                return true;
            }
            JSType exprType = JSResolveUtil.getExpressionJSType((JSExpression)callExpression);
            List<JSType> types2 = exprType instanceof JSUnionType ? ((JSUnionType)exprType).getTypes() : Collections.singletonList(exprType);
            for (JSType type : types2) {
                JSType thisType;
                if (!(type instanceof JSFunctionTypeImpl) || (thisType = ((JSFunctionTypeImpl)type).getThisType()) == null || !StringUtil.equals((CharSequence)thisType.getResolvedTypeText(), (CharSequence)JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)node))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static /* synthetic */ void lambda$getReferencedFields$1(Set referencedFields, JSThisExpression node) {
        String referencedName;
        PsiElement parent = node.getParent();
        if (parent instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)parent).getReferenceName()) != null) {
            referencedFields.add(referencedName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFields";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerFunction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfThisInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedFields";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isThisTypeExplicitlyDeclared";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldReportThis";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedFields";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSameThisAsBefore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

