/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSRecursiveWalkingElementSkippingNestedFunctionsVisitor;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public class JSPotentiallyInvalidUsageOfClassThisInspection
extends JSInspection {
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.potentially.invalid.usage.of.class.this.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.isArrowFunction()) {
                    return;
                }
                this.process((JSFunction)node);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                JSClass parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = JSUtils.getMemberContainingClass((PsiElement)node)) != null || node.isArrowFunction()) {
                    return;
                }
                this.process(node);
            }

            private void process(@NotNull JSFunction function) {
                JSClass clazz;
                if (function == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)function, (Class[])new Class[]{JSClass.class})) == null) {
                    return;
                }
                if (JSDocumentationUtils.findContextType((PsiElement)function) != null) {
                    return;
                }
                if (DialectDetector.isTypeScript((PsiElement)function) && TypeScriptPsiUtil.getThisParameter(function) != null) {
                    return;
                }
                final Set fieldNames = StreamSupport.stream(clazz.getMembers().spliterator(), false).filter(m -> m instanceof JSNamedElement).map(m -> m.getName()).collect(Collectors.toSet());
                function.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementSkippingNestedFunctionsVisitor(){

                    public void visitJSThisExpression(JSThisExpression node) {
                        PsiElement parent = node.getParent();
                        if (!(parent instanceof JSReferenceExpression) || ((JSReferenceExpression)parent).getQualifier() != node) {
                            return;
                        }
                        String name = ((JSReferenceExpression)parent).getReferenceName();
                        if (name == null || !fieldNames.contains(name)) {
                            return;
                        }
                        holder.registerProblem(parent, JSBundle.message((String)"javascript.potentially.invalid.usage.of.class.this", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "process";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSPotentiallyInvalidUsageOfClassThisInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSPotentiallyInvalidUsageOfClassThisInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

