/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class JSIncompatibleTypesComparisonInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSIncompatibleTypesComparisonInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSIncompatibleTypesComparisonInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(JSBinaryExpression node) {
                if (JSIncompatibleTypesComparisonInspection.isAcceptable(node)) {
                    ValidateTypesUtil.checkTypesInComparison(node, JSAnalysisHandlersFactory.forElement((PsiElement)node).getTypeChecker(holder));
                }
            }
        };
        if (jSElementVisitor == null) {
            JSIncompatibleTypesComparisonInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    public static boolean isAcceptable(JSBinaryExpression node) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)node);
        return holder != null && !holder.isTypeScript && !holder.isFlow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSIncompatibleTypesComparisonInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSIncompatibleTypesComparisonInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

