/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.JSGroupNames;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEqualityComparisonWithCoercionInspection
extends JSInspection {
    private static final Map<String, Severity> LEGACY_SERIALIZED_VALUES = ContainerUtil.immutableMapBuilder().put((Object)"All", (Object)Severity.Always).put((Object)"All except when comparing with null", (Object)Severity.AlwaysExceptNull).put((Object)"All except when comparing with null or typeof", (Object)Severity.AlwaysExceptNull).put((Object)"Only suspicious expressions", (Object)Severity.OnlySuspicious).build();
    @Nullable
    public Severity mySeverity;
    @NotNull
    private final Severity myDefaultSeverity;
    private final Condition<? super DialectOptionHolder> myAcceptsDialect;

    public JSEqualityComparisonWithCoercionInspection(@NotNull Severity severity, Condition<? super DialectOptionHolder> acceptsDialect) {
        if (severity == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(0);
        }
        this.mySeverity = severity;
        this.myDefaultSeverity = severity;
        this.myAcceptsDialect = acceptsDialect;
    }

    public JSEqualityComparisonWithCoercionInspection() {
        this(Severity.AlwaysExceptNull, (Condition<? super DialectOptionHolder>)((Condition)holder -> holder.isJavaScript()));
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(2);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitJSBinaryExpression(expression);
                IElementType signTokenType = expression.getOperationSign();
                DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)expression);
                if (!JSTokenTypes.EQEQ.equals(signTokenType) && !JSTokenTypes.NE.equals(signTokenType) || dialectOptionHolder == null || !JSEqualityComparisonWithCoercionInspection.this.myAcceptsDialect.value((Object)dialectOptionHolder)) {
                    return;
                }
                if (JSEqualityComparisonWithCoercionInspection.this.needToHighlight(expression)) {
                    IElementType newSign = signTokenType == JSTokenTypes.EQEQ ? JSTokenTypes.EQEQEQ : JSTokenTypes.NEQEQ;
                    String newSignText = signTokenType == JSTokenTypes.EQEQ ? "===" : "!==";
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"javascript.equality.comparison.with.coercion.error.string", (Object[])new Object[0]), new LocalQuickFix[]{new MyQuickfix(newSign, newSignText)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$1", "visitJSBinaryExpression"));
            }
        };
        if (jSElementVisitor == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(3);
        }
        return jSElementVisitor;
    }

    private boolean needToHighlight(@NotNull JSBinaryExpression expression) {
        JSExpression rhs;
        JSExpression lhs;
        if (expression == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(4);
        }
        if (JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(lhs = JSUtils.unparenthesize(expression.getLOperand()), rhs = JSUtils.unparenthesize(expression.getROperand())) || JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(rhs, lhs)) {
            return false;
        }
        Severity severity = (Severity)((Object)ObjectUtils.coalesce((Object)((Object)this.mySeverity), (Object)((Object)this.myDefaultSeverity)));
        switch (severity) {
            case Always: {
                return true;
            }
            case AlwaysExceptNull: {
                return !JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(lhs, rhs) && !JSEqualityComparisonWithCoercionInspection.isTypeOfAndStringLiteral(rhs, lhs) && !JSEqualityComparisonWithCoercionInspection.isNull(lhs) && !JSEqualityComparisonWithCoercionInspection.isNull(rhs);
            }
            case OnlySuspicious: {
                return JSEqualityComparisonWithCoercionInspection.mayCauseCoercion(rhs) || JSEqualityComparisonWithCoercionInspection.mayCauseCoercion(lhs);
            }
        }
        throw new AssertionError((Object)String.format("%s was out of range of expected values", new Object[]{severity}));
    }

    private static boolean isTypeOfAndStringLiteral(@Nullable JSExpression lExpression, @Nullable JSExpression rExpression) {
        if (lExpression instanceof JSPrefixExpression) {
            IElementType sign = ((JSPrefixExpression)lExpression).getOperationSign();
            return sign == JSTokenTypes.TYPEOF_KEYWORD && rExpression instanceof JSLiteralExpression && ((JSLiteralExpression)rExpression).isStringLiteral();
        }
        return false;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 5, true, false));
        ComboBox severityCombobox = new ComboBox((Object[])Severity.values());
        severityCombobox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", Severity::getPresentableText));
        severityCombobox.setSelectedItem((Object)(this.mySeverity != null ? this.mySeverity : this.myDefaultSeverity));
        severityCombobox.addActionListener(e -> {
            this.mySeverity = (Severity)((Object)((Object)severityCombobox.getSelectedItem()));
        });
        JLabel label = new JLabel(JSBundle.message((String)"javascript.equality.comparison.with.coercion.options.label", (Object[])new Object[0]));
        panel.add((Component)label, "West");
        panel.add((Component)severityCombobox, "West");
        return panel;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(5);
        }
        super.readSettings(node);
        for (Element child : node.getChildren("option")) {
            if (!StringUtil.equals((CharSequence)child.getAttributeValue("name"), (CharSequence)"mySeverity")) continue;
            String value = child.getAttributeValue("value");
            if (this.mySeverity != null || !StringUtil.isNotEmpty((String)value)) continue;
            this.mySeverity = LEGACY_SERIALIZED_VALUES.get(value);
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.display.name", (Object[])new Object[0]);
        if (string == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            JSEqualityComparisonWithCoercionInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static boolean isNull(@Nullable JSExpression expression) {
        return expression instanceof JSLiteralExpression && "null".equals(expression.getText());
    }

    private static boolean mayCauseCoercion(@Nullable JSExpression expression) {
        if (!(expression instanceof JSLiteralExpression)) {
            return false;
        }
        if (JSEqualityComparisonWithCoercionInspection.isNull(expression)) {
            return true;
        }
        String text = expression.getText();
        return "0".equals(text) || "0x0".equals(text) || "0X0".equals(text) || "0.0".equals(text) || "0L".equals(text) || "0l".equals(text) || "true".equals(text) || "false".equals(text) || "undefined".equals(text) || "''".equals(text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "needToHighlight";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TSInspection
    extends JSEqualityComparisonWithCoercionInspection {
        public TSInspection() {
            super(Severity.OnlySuspicious, (Condition<? super DialectOptionHolder>)((Condition)holder -> holder.isTypeScript));
        }

        @Override
        @NotNull
        public String getShortName() {
            if ("JSEqualityComparisonWithCoercion.TS" == null) {
                TSInspection.$$$reportNull$$$0(0);
            }
            return "JSEqualityComparisonWithCoercion.TS";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$TSInspection", "getShortName"));
        }
    }

    public static enum Severity {
        Always(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.always", (Object[])new Object[0]), "Always"),
        AlwaysExceptNull(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.always.except.null", (Object[])new Object[0]), "AlwaysExceptNull"),
        OnlySuspicious(JSBundle.message((String)"javascript.equality.comparison.with.coercion.option.only.suspicious", (Object[])new Object[0]), "OnlySuspicious");

        private final String myPresentableText;
        private final String mySerializedName;

        private Severity(String presentableText, String mySerialized) {
            this.myPresentableText = presentableText;
            this.mySerializedName = mySerialized;
        }

        @NotNull
        String getPresentableText() {
            String string = this.myPresentableText;
            if (string == null) {
                Severity.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.mySerializedName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$Severity", "getPresentableText"));
        }
    }

    private static class MyQuickfix
    implements LocalQuickFix {
        private final IElementType signType;
        private final String signString;

        MyQuickfix(IElementType signType, String signString) {
            this.signType = signType;
            this.signString = signString;
        }

        @NotNull
        public String getName() {
            String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.fix", (Object[])new Object[]{this.signString});
            if (string == null) {
                MyQuickfix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JSBundle.message((String)"javascript.equality.comparison.with.coercion.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickfix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MyQuickfix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                MyQuickfix.$$$reportNull$$$0(3);
            }
            ASTNode expressionNode = descriptor2.getPsiElement().getNode();
            ASTNode operatorNode = JSBinaryExpressionImpl.getOperationSignNode(expressionNode);
            LeafElement newChild = ASTFactory.leaf((IElementType)this.signType, (CharSequence)this.signString);
            CodeEditUtil.setNodeGenerated((ASTNode)newChild, (boolean)true);
            expressionNode.replaceChild(operatorNode, (ASTNode)newChild);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$MyQuickfix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSEqualityComparisonWithCoercionInspection$MyQuickfix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

