/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiQualifiedReference;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/inspection/JSObjectNullOrUndefinedInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "DecoratorWithErrors", "intellij.javascript.impl"})
public class JSObjectNullOrUndefinedInspection
extends JSInspection {
    @NotNull
    private static final List<Pair<JSDecoratedType.TypeDecoration, String>> mapping;
    public static final DecoratorWithErrors DecoratorWithErrors;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ JSObjectNullOrUndefinedInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                PsiElement parent = node.getParent();
                if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node || parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == node) {
                    this.checkNullabilityState(node);
                }
            }

            private final void checkNullabilityState(JSReferenceExpression candidate) {
                if (!JSTypeGuardChecker.isNarrowableReference((JSExpression)candidate)) {
                    return;
                }
                Set<JSDecoratedType.TypeDecoration> set = JSTypeGuardChecker.getDecoratorsForExpression(candidate);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"JSTypeGuardChecker.getDe\u2026sForExpression(candidate)");
                Set<JSDecoratedType.TypeDecoration> decorators = set;
                for (Pair<JSDecoratedType.TypeDecoration, String> pair : JSObjectNullOrUndefinedInspection.DecoratorWithErrors.getMapping()) {
                    if (!this.logDecoratorError(candidate, decorators, (JSDecoratedType.TypeDecoration)pair.getFirst(), (String)pair.getSecond())) continue;
                    return;
                }
            }

            @NotNull
            public final String getReferenceName(@NotNull JSReferenceExpression expression) {
                Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                Object object = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)expression);
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = "Object";
                }
                return object;
            }

            private final boolean logDecoratorError(JSReferenceExpression candidate, Set<? extends JSDecoratedType.TypeDecoration> decorators, JSDecoratedType.TypeDecoration decorator, String errorKey) {
                if (decorators.contains(decorator)) {
                    JSReferenceExpression jSReferenceExpression = candidate;
                    if (jSReferenceExpression == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    }
                    this.$holder.registerProblem((PsiElement)jSReferenceExpression, JSBundle.message((String)errorKey, (Object[])new Object[]{this.getReferenceName(candidate)}), this.this$0.problemHighlightType(), new LocalQuickFix[0]);
                    return true;
                }
                return false;
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    protected ProblemHighlightType problemHighlightType() {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    static {
        DecoratorWithErrors = new DecoratorWithErrors(null);
        mapping = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED, (Object)"javascript.object.is.null.or.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_NULL, (Object)"javascript.object.is.null"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, (Object)"javascript.object.is.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL, (Object)"javascript.object.is.possibly.null"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED, (Object)"javascript.object.is.possibly.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED, (Object)"javascript.object.is.possibly.null.or.undefined")});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/javascript/inspection/JSObjectNullOrUndefinedInspection$DecoratorWithErrors;", "", "()V", "mapping", "", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/psi/types/JSDecoratedType$TypeDecoration;", "", "getMapping", "()Ljava/util/List;", "intellij.javascript.impl"})
    public static final class DecoratorWithErrors {
        @NotNull
        public final List<Pair<JSDecoratedType.TypeDecoration, String>> getMapping() {
            return mapping;
        }

        private DecoratorWithErrors() {
        }

        public /* synthetic */ DecoratorWithErrors(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

