/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.ide.highlighter.EmbeddedTokenHighlighter;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.TypeScriptLanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TypeScriptHighlighter
extends JSHighlighter {
    public static final TextAttributesKey TS_KEYWORD;
    public static final TextAttributesKey TS_STRING;
    public static final TextAttributesKey TS_NUMBER;
    public static final TextAttributesKey TS_REGEXP;
    public static final TextAttributesKey TS_LINE_COMMENT;
    public static final TextAttributesKey TS_BLOCK_COMMENT;
    public static final TextAttributesKey TS_DOC_COMMENT;
    public static final TextAttributesKey TS_OPERATION_SIGN;
    public static final TextAttributesKey TS_PARENTHS;
    public static final TextAttributesKey TS_BRACKETS;
    public static final TextAttributesKey TS_BRACES;
    public static final TextAttributesKey TS_COMMA;
    public static final TextAttributesKey TS_DOT;
    public static final TextAttributesKey TS_SEMICOLON;
    public static final TextAttributesKey TS_BAD_CHARACTER;
    public static final TextAttributesKey TS_DOC_TAG;
    public static final TextAttributesKey TS_DOC_MARKUP;
    public static final TextAttributesKey TS_VALID_STRING_ESCAPE;
    public static final TextAttributesKey TS_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey TS_LOCAL_VARIABLE;
    public static final TextAttributesKey TS_PARAMETER;
    public static final TextAttributesKey TS_TYPE_PARAMETER;
    public static final TextAttributesKey TS_INSTANCE_MEMBER_VARIABLE;
    public static final TextAttributesKey TS_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey TS_GLOBAL_VARIABLE;
    public static final TextAttributesKey TS_GLOBAL_FUNCTION;
    public static final TextAttributesKey TS_LOCAL_FUNCTION;
    public static final TextAttributesKey TS_DECORATOR;
    public static final TextAttributesKey TS_STATIC_MEMBER_FUNCTION;
    public static final TextAttributesKey TS_INSTANCE_MEMBER_FUNCTION;
    public static final TextAttributesKey TS_CLASS;
    public static final TextAttributesKey TS_INTERFACE;
    public static final TextAttributesKey TS_TYPE_ALIAS;
    public static final TextAttributesKey TS_PRIMITIVE_TYPES;
    public static final TextAttributesKey TS_MODULE_NAME;
    public static final TextAttributesKey FUNCTION_ARROW;
    public static final TextAttributesKey TS_TYPE_GUARD;
    private static final THashMap<IElementType, TextAttributesKey> tsKeys;
    private static final THashMap<TextAttributesKey, TextAttributesKey> ourJsToTSKeyMap;

    public TypeScriptHighlighter(boolean skipKeywordHighlights) {
        this(TypeScriptLanguageDialect.DIALECT_OPTION_HOLDER, skipKeywordHighlights);
    }

    public TypeScriptHighlighter(@NotNull DialectOptionHolder holder, boolean skipKeywordHighlights) {
        if (holder == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(0);
        }
        super(holder, skipKeywordHighlights);
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType == JSDocTokenTypes.DOC_TAG_NAME) {
            TextAttributesKey[] textAttributesKeyArray = TypeScriptHighlighter.pack((TextAttributesKey)TS_DOC_COMMENT, (TextAttributesKey)TS_DOC_TAG);
            if (textAttributesKeyArray == null) {
                TypeScriptHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey key = (TextAttributesKey)tsKeys.get((Object)tokenType);
        if (key == TS_KEYWORD) {
            TextAttributesKey[] textAttributesKeyArray = this.mySkipKeywordHighlights ? TextAttributesKey.EMPTY_ARRAY : TypeScriptHighlighter.pack((TextAttributesKey)TS_KEYWORD);
            if (textAttributesKeyArray == null) {
                TypeScriptHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = key == null ? super.getTokenHighlights(tokenType) : TypeScriptHighlighter.pack((TextAttributesKey)key);
        if (textAttributesKeyArray == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    @Override
    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])new TokenSet[]{super.getKeywords(), JSKeywordSets.TYPESCRIPT_RESERVED_WORDS});
        if (tokenSet == null) {
            TypeScriptHighlighter.$$$reportNull$$$0(4);
        }
        return tokenSet;
    }

    @Override
    public TextAttributesKey getMappedKey(TextAttributesKey original) {
        return (TextAttributesKey)ourJsToTSKeyMap.getOrDefault((Object)original, (Object)original);
    }

    static {
        IElementType[] javadoc;
        TS_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"TS.KEYWORD", (TextAttributesKey)JSHighlighter.JS_KEYWORD);
        TS_STRING = TextAttributesKey.createTextAttributesKey((String)"TS.STRING", (TextAttributesKey)JSHighlighter.JS_STRING);
        TS_NUMBER = TextAttributesKey.createTextAttributesKey((String)"TS.NUMBER", (TextAttributesKey)JSHighlighter.JS_NUMBER);
        TS_REGEXP = TextAttributesKey.createTextAttributesKey((String)"TS.REGEXP", (TextAttributesKey)JSHighlighter.JS_REGEXP);
        TS_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.LINE_COMMENT", (TextAttributesKey)JSHighlighter.JS_LINE_COMMENT);
        TS_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.BLOCK_COMMENT", (TextAttributesKey)JSHighlighter.JS_BLOCK_COMMENT);
        TS_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_COMMENT", (TextAttributesKey)JSHighlighter.JS_DOC_COMMENT);
        TS_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"TS.OPERATION_SIGN", (TextAttributesKey)JSHighlighter.JS_OPERATION_SIGN);
        TS_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"TS.PARENTHS", (TextAttributesKey)JSHighlighter.JS_PARENTHS);
        TS_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"TS.BRACKETS", (TextAttributesKey)JSHighlighter.JS_BRACKETS);
        TS_BRACES = TextAttributesKey.createTextAttributesKey((String)"TS.BRACES", (TextAttributesKey)JSHighlighter.JS_BRACES);
        TS_COMMA = TextAttributesKey.createTextAttributesKey((String)"TS.COMMA", (TextAttributesKey)JSHighlighter.JS_COMMA);
        TS_DOT = TextAttributesKey.createTextAttributesKey((String)"TS.DOT", (TextAttributesKey)JSHighlighter.JS_DOT);
        TS_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"TS.SEMICOLON", (TextAttributesKey)JSHighlighter.JS_SEMICOLON);
        TS_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"TS.BADCHARACTER", (TextAttributesKey)JSHighlighter.JS_BAD_CHARACTER);
        TS_DOC_TAG = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_TAG", (TextAttributesKey)JSHighlighter.JS_DOC_TAG);
        TS_DOC_MARKUP = TextAttributesKey.createTextAttributesKey((String)"TS.DOC_MARKUP", (TextAttributesKey)JSHighlighter.JS_DOC_MARKUP);
        TS_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"TS.VALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_VALID_STRING_ESCAPE);
        TS_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"TS.INVALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_INVALID_STRING_ESCAPE);
        TS_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_LOCAL_VARIABLE);
        TS_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"TS.PARAMETER", (TextAttributesKey)JSHighlighter.JS_PARAMETER);
        TS_TYPE_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE_PARAMETER");
        TS_INSTANCE_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        TS_STATIC_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_VARIABLE);
        TS_GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_GLOBAL_VARIABLE);
        TS_GLOBAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.GLOBAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_GLOBAL_FUNCTION);
        TS_LOCAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.LOCAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_LOCAL_FUNCTION);
        TS_DECORATOR = TextAttributesKey.createTextAttributesKey((String)"TS.DECORATOR", (TextAttributesKey)JSHighlighter.ES6_DECORATOR);
        TS_STATIC_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.STATIC_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
        TS_INSTANCE_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        TS_CLASS = TextAttributesKey.createTextAttributesKey((String)"TS.CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        TS_INTERFACE = TextAttributesKey.createTextAttributesKey((String)"TS.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        TS_TYPE_ALIAS = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE.ALIAS", (TextAttributesKey)TS_INTERFACE);
        TS_PRIMITIVE_TYPES = TextAttributesKey.createTextAttributesKey((String)"TS.PRIMITIVE.TYPES", (TextAttributesKey)TS_KEYWORD);
        TS_MODULE_NAME = TextAttributesKey.createTextAttributesKey((String)"TS.MODULE_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        FUNCTION_ARROW = TextAttributesKey.createTextAttributesKey((String)"TS.FUNCTION_ARROW", (TextAttributesKey)JSHighlighter.FUNCTION_ARROW);
        TS_TYPE_GUARD = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE_GUARD");
        ourJsToTSKeyMap = new THashMap();
        tsKeys = new THashMap();
        SyntaxHighlighterBase.fillMap(tsKeys, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)TS_OPERATION_SIGN);
        TypeScriptHighlighter.fillMap(tsKeys, (TokenSet)JSKeywordSets.TYPESCRIPT_RESERVED_WORDS, (TextAttributesKey)TS_KEYWORD);
        tsKeys.put((Object)StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, (Object)TS_VALID_STRING_ESCAPE);
        tsKeys.put((Object)StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, (Object)TS_INVALID_STRING_ESCAPE);
        tsKeys.put((Object)StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, (Object)TS_INVALID_STRING_ESCAPE);
        tsKeys.put((Object)JSTokenTypes.NUMERIC_LITERAL, (Object)TS_NUMBER);
        tsKeys.put((Object)JSTokenTypes.STRING_LITERAL, (Object)TS_STRING);
        tsKeys.put((Object)JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, (Object)TS_STRING);
        tsKeys.put((Object)JSTokenTypes.STRING_TEMPLATE_PART, (Object)TS_STRING);
        tsKeys.put((Object)JSTokenTypes.BACKQUOTE, (Object)TS_STRING);
        tsKeys.put((Object)JSTokenTypes.REGEXP_LITERAL, (Object)TS_REGEXP);
        tsKeys.put((Object)JSTokenTypes.LPAR, (Object)TS_PARENTHS);
        tsKeys.put((Object)JSTokenTypes.RPAR, (Object)TS_PARENTHS);
        tsKeys.put((Object)JSTokenTypes.LBRACE, (Object)TS_BRACES);
        tsKeys.put((Object)JSTokenTypes.RBRACE, (Object)TS_BRACES);
        tsKeys.put((Object)JSTokenTypes.LBRACKET, (Object)TS_BRACKETS);
        tsKeys.put((Object)JSTokenTypes.RBRACKET, (Object)TS_BRACKETS);
        tsKeys.put((Object)JSTokenTypes.COMMA, (Object)TS_COMMA);
        tsKeys.put((Object)JSTokenTypes.DOT, (Object)TS_DOT);
        tsKeys.put((Object)JSTokenTypes.SEMICOLON, (Object)TS_SEMICOLON);
        tsKeys.put((Object)JSTokenTypes.C_STYLE_COMMENT, (Object)TS_BLOCK_COMMENT);
        tsKeys.put((Object)JSTokenTypes.XML_STYLE_COMMENT, (Object)TS_BLOCK_COMMENT);
        tsKeys.put((Object)JSTokenTypes.DOC_COMMENT, (Object)TS_DOC_COMMENT);
        tsKeys.put((Object)JSTokenTypes.END_OF_LINE_COMMENT, (Object)TS_LINE_COMMENT);
        tsKeys.put((Object)JSTokenTypes.BAD_CHARACTER, (Object)TS_BAD_CHARACTER);
        tsKeys.put((Object)JSTokenTypes.EQGT, (Object)FUNCTION_ARROW);
        for (IElementType type2 : javadoc = IElementType.enumerate(type -> type instanceof JSDocElementType)) {
            tsKeys.put((Object)type2, (Object)TS_DOC_COMMENT);
        }
        tsKeys.put((Object)JSDocTokenTypes.DOC_TAG_VALUE, (Object)TS_DOC_COMMENT);
        tsKeys.put((Object)JSDocTokenTypes.DOC_TAG_NAMEPATH, (Object)TS_DOC_COMMENT);
        tsKeys.put((Object)JSTokenTypes.JSDOC_MARKUP, (Object)TS_DOC_MARKUP);
        ourJsToTSKeyMap.put((Object)JS_PARAMETER, (Object)TS_PARAMETER);
        ourJsToTSKeyMap.put((Object)JS_INSTANCE_MEMBER_VARIABLE, (Object)TS_INSTANCE_MEMBER_VARIABLE);
        ourJsToTSKeyMap.put((Object)JS_LOCAL_VARIABLE, (Object)TS_LOCAL_VARIABLE);
        ourJsToTSKeyMap.put((Object)JS_GLOBAL_VARIABLE, (Object)TS_GLOBAL_VARIABLE);
        ourJsToTSKeyMap.put((Object)JS_GLOBAL_FUNCTION, (Object)TS_GLOBAL_FUNCTION);
        ourJsToTSKeyMap.put((Object)JS_LOCAL_FUNCTION, (Object)TS_LOCAL_FUNCTION);
        ourJsToTSKeyMap.put((Object)ES6_DECORATOR, (Object)TS_DECORATOR);
        ourJsToTSKeyMap.put((Object)JS_INSTANCE_MEMBER_FUNCTION, (Object)TS_INSTANCE_MEMBER_FUNCTION);
        ourJsToTSKeyMap.put((Object)JS_STATIC_MEMBER_FUNCTION, (Object)TS_STATIC_MEMBER_FUNCTION);
        ourJsToTSKeyMap.put((Object)JS_STATIC_MEMBER_VARIABLE, (Object)TS_STATIC_MEMBER_VARIABLE);
        ourJsToTSKeyMap.put((Object)JS_CLASS, (Object)TS_CLASS);
        ourJsToTSKeyMap.put((Object)JS_INTERFACE, (Object)TS_INTERFACE);
        ourJsToTSKeyMap.put((Object)JS_TYPE_ALIAS, (Object)TS_TYPE_ALIAS);
        ourJsToTSKeyMap.put((Object)JS_DOC_MARKUP, (Object)TS_DOC_MARKUP);
        ourJsToTSKeyMap.put((Object)JS_DOC_COMMENT, (Object)TS_DOC_COMMENT);
        ourJsToTSKeyMap.put((Object)JS_KEYWORD, (Object)TS_KEYWORD);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class XmlTokenHighlighter
    implements EmbeddedTokenHighlighter {
        @NotNull
        public MultiMap<IElementType, TextAttributesKey> getEmbeddedTokenAttributes() {
            MultiMap map = MultiMap.create();
            map.putAllValues((Map)tsKeys);
            MultiMap multiMap = map;
            if (multiMap == null) {
                XmlTokenHighlighter.$$$reportNull$$$0(0);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/TypeScriptHighlighter$XmlTokenHighlighter", "getEmbeddedTokenAttributes"));
        }
    }
}

