/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.NotImplementedHierarchyBrowser;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.hierarchy.type.jsclass.JSTypeHierarchyBrowser;
import com.intellij.lang.javascript.hierarchy.type.jsfunction.JSFunctionHierarchyBrowser;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        VirtualFile file2;
        JSClass jsClass;
        if (dataContext == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(0);
        }
        if ((jsClass = JSTypeHierarchyProvider.getJSClass(dataContext)) != null) {
            return jsClass;
        }
        JSPsiElementBase target = JSHierarchyUtils.getElementFromContext(dataContext, JSHierarchyUtils::getTypeHierarchyTargetElement);
        if (target != null && target.isValid() && (file2 = (psiFile = target.getContainingFile()).getVirtualFile()) != null && !"swf".equalsIgnoreCase(file2.getExtension()) && !DialectDetector.isActionScript((PsiElement)psiFile)) {
            return target;
        }
        return null;
    }

    @Nullable
    private static JSClass getJSClass(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            JSExpression initializer;
            PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor, (int)3);
            if (targetElement instanceof JSClass) {
                return (JSClass)targetElement;
            }
            if (targetElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)targetElement).getInitializer()) instanceof JSClass) {
                return (JSClass)initializer;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 instanceof XmlFile) {
                Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file2);
                if (injEditor != null) {
                    PsiElement injTargetElement = TargetElementUtil.findTargetElement((Editor)injEditor, (int)3);
                    if (injTargetElement instanceof JSClass) {
                        return (JSClass)injTargetElement;
                    }
                    int offset = editor.getCaretModel().getOffset();
                    PsiElement element = file2.findElementAt(offset);
                    JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
                    if (jsClass != null) {
                        return jsClass;
                    }
                }
                if (JavaScriptSupportLoader.isFlexMxmFile(file2) || JavaScriptSupportLoader.isBindowsFile((PsiElement)file2)) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file2);
                }
            } else if (file2 instanceof JSFile) {
                int offset = editor.getCaretModel().getOffset();
                PsiElement element = file2.findElementAt(offset);
                return (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class);
            }
        } else {
            PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            if (element instanceof JSClass) {
                return (JSClass)element;
            }
            if (element instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)element);
            }
            if (element instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)element);
            }
        }
        return null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        if (target == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(1);
        }
        if (target instanceof JSClass) {
            JSTypeHierarchyBrowser jSTypeHierarchyBrowser = new JSTypeHierarchyBrowser(target.getProject(), (JSClass)target);
            if (jSTypeHierarchyBrowser == null) {
                JSTypeHierarchyProvider.$$$reportNull$$$0(2);
            }
            return jSTypeHierarchyBrowser;
        }
        if (target instanceof JSNamedElement) {
            JSFunctionHierarchyBrowser jSFunctionHierarchyBrowser = new JSFunctionHierarchyBrowser(target.getProject(), (JSNamedElement)target);
            if (jSFunctionHierarchyBrowser == null) {
                JSTypeHierarchyProvider.$$$reportNull$$$0(3);
            }
            return jSFunctionHierarchyBrowser;
        }
        NotImplementedHierarchyBrowser notImplementedHierarchyBrowser = new NotImplementedHierarchyBrowser(target);
        if (notImplementedHierarchyBrowser == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(4);
        }
        return notImplementedHierarchyBrowser;
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        if (hierarchyBrowser == null) {
            JSTypeHierarchyProvider.$$$reportNull$$$0(5);
        }
        if (hierarchyBrowser instanceof JSTypeHierarchyBrowser) {
            JSTypeHierarchyBrowser browser = (JSTypeHierarchyBrowser)hierarchyBrowser;
            String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
            browser.changeView(typeName);
        } else if (hierarchyBrowser instanceof JSFunctionHierarchyBrowser) {
            ((JSFunctionHierarchyBrowser)hierarchyBrowser).changeView(TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/type/JSTypeHierarchyProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHierarchyBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTarget";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHierarchyBrowser";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "browserActivated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

