/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.psi.PsiElement;
import java.util.Collection;

public class TypeScriptOverrideMembersHandler
extends BaseJSGenerateHandler {
    @Override
    protected String getTitleKey() {
        return "members.to.override.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.members.to.override", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        return new OverrideMethodsFix((JSClass)clazz);
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        JSClass jsClass = (JSClass)clazz;
        for (JSFunction function : JSInheritanceUtil.collectFunctionsToOverride(jsClass)) {
            candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)function));
        }
        for (JSClass aClass : jsClass.getSuperClasses()) {
            for (JSField field : aClass.getFields()) {
                JSAttributeList attributeList = field.getAttributeList();
                if (attributeList != null && TypeScriptOverrideMembersHandler.isStaticOrPrivate(attributeList)) continue;
                candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)field));
            }
        }
    }

    private static boolean isStaticOrPrivate(JSAttributeList attributeList) {
        return attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass) && DialectDetector.isTypeScript(jsClass);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }
}

