/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSDelegationNode;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptGenerateDelegatesHandler
extends BaseJSGenerateHandler {
    public static final String[] PRIMITIVE_TYPES = JSCommonTypeNames.ALL;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.generation.JavaScriptGenerateDelegatesHandler");

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        if (!super.isValidForTarget(jsClass)) {
            return false;
        }
        if (!(jsClass instanceof JSClass) || ((JSClass)jsClass).isInterface()) {
            return false;
        }
        return !JavaScriptGenerateDelegatesHandler.findCandidateFields((JSClass)jsClass).isEmpty();
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        List<JSChooserElementNode> selected;
        PsiElement jsClass;
        if (project == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(2);
        }
        if (!((jsClass = JavaScriptGenerateDelegatesHandler.findClassOrObjectLiteral(file2, editor, null)) instanceof JSClass)) {
            return;
        }
        Collection<JSField> fields = JavaScriptGenerateDelegatesHandler.findCandidateFields((JSClass)jsClass);
        LinkedList<JSChooserElementNode> nodes = new LinkedList<JSChooserElementNode>();
        for (JSField field : fields) {
            JSNamedElementNode parent = new JSNamedElementNode((JSPsiNamedElementBase)field);
            for (JSNamedElement value : JavaScriptGenerateDelegatesHandler.getMemberCandidates(jsClass, field).values()) {
                nodes.add(new JSDelegationNode((JSPsiNamedElementBase)value, parent));
            }
        }
        boolean testMode = ApplicationManager.getApplication().isUnitTestMode();
        if (testMode) {
            LOG.assertTrue(!nodes.isEmpty());
            selected = nodes;
        } else {
            MemberChooser<JSChooserElementNode> targetChooser = this.createMemberChooserDialog(project, jsClass, nodes, false, true, CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            targetChooser.show();
            if (targetChooser.getExitCode() != 0) {
                return;
            }
            selected = targetChooser.getSelectedElements();
        }
        if (selected == null) {
            return;
        }
        MultiMap byField = MultiMap.create();
        for (Object node : selected) {
            if (!(node instanceof JSDelegationNode)) continue;
            JSNamedElementNode delegate = (JSNamedElementNode)node.getParentNodeDelegate();
            byField.putValue((Object)((JSField)delegate.getPsiElement()), node);
        }
        HashSet knownNames = new HashSet();
        for (Map.Entry entry : byField.entrySet()) {
            HashSet<String> scopeNames = new HashSet<String>();
            for (JSChooserElementNode node : (Collection)entry.getValue()) {
                PsiElement element = node.getPsiElement();
                if (!(element instanceof PsiNamedElement)) continue;
                scopeNames.add(((PsiNamedElement)element).getName());
            }
            HashSet copy = new HashSet(scopeNames);
            copy.retainAll(knownNames);
            if (!copy.isEmpty()) {
                JavaScriptGenerateDelegatesHandler.showError(project, editor);
                return;
            }
            knownNames.addAll(scopeNames);
        }
        Collection entries = byField.entrySet();
        if (testMode) {
            entries = ContainerUtil.sorted((Collection)entries, Comparator.comparing(e -> ((JSField)e.getKey()).getName()));
        }
        for (Map.Entry entry : entries) {
            Collection value = (Collection)entry.getValue();
            if (testMode) {
                value = ContainerUtil.sorted((Collection)value, Comparator.comparing(v -> v.getText()));
            }
            this.createAndInvokeFix(project, editor, file2, jsClass, (JSField)entry.getKey(), value);
        }
    }

    private static void showError(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(4);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JSBundle.message((String)"generate.delegate.method.conflict.message", (Object[])new Object[0]), (String)JSBundle.message((String)"generate.delegate.method.conflict.message.title", (Object[])new Object[0]), null);
    }

    @NotNull
    private static Map<MemberDescriptor, JSNamedElement> getMemberCandidates(PsiElement jsClass, JSField field) {
        JSClass fieldClass = JavaScriptGenerateDelegatesHandler.resolveClass(field.getJSType(), (JSClass)jsClass);
        if (fieldClass == null) {
            Map<MemberDescriptor, JSNamedElement> map = Collections.emptyMap();
            if (map == null) {
                JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(5);
            }
            return map;
        }
        HashMap<MemberDescriptor, JSNamedElement> memberCandidates = new HashMap<MemberDescriptor, JSNamedElement>();
        boolean allowPackageLocal = !JSPsiImplUtils.differentPackageName(JavaScriptGenerateDelegatesHandler.getPackageName(fieldClass), JavaScriptGenerateDelegatesHandler.getPackageName((JSClass)jsClass));
        fieldClass.processDeclarations((PsiScopeProcessor)new MyResolveProcessor(jsClass, allowPackageLocal, memberCandidates), ResolveState.initial(), (PsiElement)fieldClass, (PsiElement)fieldClass);
        HashMap<MemberDescriptor, JSNamedElement> hashMap = memberCandidates;
        if (hashMap == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private void createAndInvokeFix(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, final PsiElement jsClass, final JSField field, Collection<JSChooserElementNode> selected) {
        if (project == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(9);
        }
        BaseCreateMembersFix<JSElement> fix = new BaseCreateMembersFix<JSElement>(jsClass){
            final JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix generateGetterFix;
            final JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix generateSetterFix;
            {
                super(jsClass2);
                this.generateGetterFix = new JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Getter, (JSClass)jsClass, null, false, field.getName());
                this.generateSetterFix = new JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Setter, (JSClass)jsClass, null, false, field.getName());
            }

            @Override
            protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSElement function) {
                attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
                attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.STATIC, JSPsiImplUtils.hasModifier((JSAttributeListOwner)field, JSAttributeList.ModifierType.STATIC));
                for (JSAttributeList.ModifierType modifierType : new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.NATIVE, JSAttributeList.ModifierType.DYNAMIC, JSAttributeList.ModifierType.FINAL, JSAttributeList.ModifierType.OVERRIDE, JSAttributeList.ModifierType.VIRTUAL}) {
                    attributeListWrapper.overrideModifier(modifierType, false);
                }
            }

            @Override
            protected void processElements(Project project, MultiMap<String, String> types2, Set<JSElement> elementsToProcess) {
                for (JSElement e : elementsToProcess) {
                    if (e instanceof JSFunction) {
                        this.anchor = this.doAddOneMethod(project, this.buildFunctionText(e, types2), this.anchor);
                        continue;
                    }
                    this.anchor = this.doAddOneMethod(project, this.generateGetterFix.buildFunctionText((JSNamedElement)e, types2), this.anchor);
                    this.anchor = this.doAddOneMethod(project, this.generateSetterFix.buildFunctionText((JSNamedElement)e, types2), this.anchor);
                }
            }

            @Override
            protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSElement element) {
                return OverrideMethodsFix.buildDelegatingText(retType, parameterList, (JSQualifiedNamedElement)((JSFunction)element), DialectDetector.isActionScript((PsiElement)field) ? field.getName() : "this." + field.getName(), this.anchor != null ? this.anchor : Objects.requireNonNull(this.myJsClass));
            }
        };
        this.doInvoke(project, editor, file2, selected, fix);
    }

    @Nullable
    private static JSClass resolveClass(@Nullable JSType fieldType, @NotNull JSClass contextClass) {
        if (contextClass == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(10);
        }
        if (fieldType == null) {
            return null;
        }
        if (fieldType.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
            return fieldType.resolveClass();
        }
        String type = JSTypeUtils.getQualifiedNameMatchingType(fieldType, false);
        if (type != null) {
            return (JSClass)ObjectUtils.tryCast((Object)JSClassResolver.getInstance().findClassByQName(type, (PsiElement)contextClass), JSClass.class);
        }
        return null;
    }

    @Nullable
    private static String getPackageName(JSClass fieldClass) {
        String qualifiedName = fieldClass.getQualifiedName();
        return qualifiedName == null ? null : StringUtil.getPackageName((String)qualifiedName);
    }

    @Override
    protected String getTitleKey() {
        return null;
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        if (!(clazz instanceof JSClass)) {
            return;
        }
        Collection<JSField> fields = JavaScriptGenerateDelegatesHandler.findCandidateFields((JSClass)clazz);
        for (JSField field : fields) {
            candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)field));
        }
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        return null;
    }

    private static Collection<JSField> findCandidateFields(@NotNull JSClass clazz) {
        if (clazz == null) {
            JavaScriptGenerateDelegatesHandler.$$$reportNull$$$0(11);
        }
        ArrayList<JSField> result2 = new ArrayList<JSField>();
        for (JSField field : clazz.getFields()) {
            JSClass fieldType;
            JSType type = field.getJSType();
            JSClass jSClass = fieldType = type != null ? JavaScriptGenerateDelegatesHandler.resolveClass(type, clazz) : null;
            if (fieldType == null || ArrayUtil.contains((String)fieldType.getQualifiedName(), (String[])PRIMITIVE_TYPES) || JSInheritanceUtil.isParentClass(clazz, fieldType, false)) continue;
            result2.add(field);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAndInvokeFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findCandidateFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveProcessor
    extends ResolveProcessor {
        private final PsiElement myJsClass;
        private final boolean myAllowPackageLocal;
        private final Map<MemberDescriptor, JSNamedElement> myMemberCandidates;

        private MyResolveProcessor(PsiElement jsClass, boolean allowPackageLocal, Map<MemberDescriptor, JSNamedElement> memberCandidates) {
            super((String)null);
            this.myJsClass = jsClass;
            this.myAllowPackageLocal = allowPackageLocal;
            this.myMemberCandidates = memberCandidates;
            this.setToProcessHierarchy(true);
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            JSClass clazz;
            if (element == null) {
                MyResolveProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                MyResolveProcessor.$$$reportNull$$$0(1);
            }
            if ((clazz = JSUtils.getMemberContainingClass(element)) == null || JSResolveUtil.isObjectClass((JSPsiElementBase)clazz) || clazz == this.myJsClass) {
                return true;
            }
            if (element instanceof JSFunction) {
                JSFunction method = (JSFunction)element;
                JSAttributeList attributeList = method.getAttributeList();
                if (this.skipCandidate((JSNamedElement)method, attributeList)) {
                    return true;
                }
                if (!this.myAllowPackageLocal && attributeList != null && attributeList.getNamespace() == null && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                    return true;
                }
                if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
                    return true;
                }
                if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                    return true;
                }
                if (JSInheritanceUtil.findMethodInClass(method, (JSClass)this.myJsClass, true) != null) {
                    return true;
                }
                this.myMemberCandidates.put(new MemberDescriptor(method), (JSNamedElement)method);
            } else if (element instanceof JSVariable) {
                JSVariable f = (JSVariable)element;
                JSAttributeList attributeList = f.getAttributeList();
                if (this.skipCandidate((JSNamedElement)f, attributeList)) {
                    return true;
                }
                if (!this.myAllowPackageLocal && attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                    return true;
                }
                if (((JSClass)this.myJsClass).findFunctionByName(f.getName()) != null) {
                    return true;
                }
                this.myMemberCandidates.put(new MemberDescriptor(f), (JSNamedElement)f);
            }
            return true;
        }

        private boolean skipCandidate(JSNamedElement f, JSAttributeList attributeList) {
            MemberDescriptor descriptor2;
            MemberDescriptor memberDescriptor = descriptor2 = f instanceof JSFunction ? new MemberDescriptor((JSFunction)f) : new MemberDescriptor((JSVariable)f);
            if (this.myMemberCandidates.containsKey(descriptor2)) {
                return true;
            }
            return attributeList != null && (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler$MyResolveProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MemberDescriptor {
        private final String name;
        @Nullable
        private final JSFunction.FunctionKind kind;

        MemberDescriptor(JSFunction method) {
            this.name = method.getName();
            this.kind = method.getKind();
        }

        MemberDescriptor(JSVariable field) {
            this.name = field.getName();
            this.kind = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberDescriptor that = (MemberDescriptor)o;
            if (this.kind != that.kind) {
                return false;
            }
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result2 = this.name == null ? 0 : this.name.hashCode();
            result2 = 31 * result2 + (this.kind != null ? this.kind.hashCode() : 0);
            return result2;
        }
    }
}

