/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.react.ReactAttributeDescriptor;
import com.intellij.lang.javascript.frameworks.react.ReactTagNameReference;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.references.JSXNamespaceReference;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactComponentUtil;
import com.intellij.lang.javascript.frameworks.react.tsx.TypeScriptReactTagUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeInfoOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.HtmlXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlTagNameProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactXmlExtension
extends HtmlXmlExtension
implements XmlTagNameProvider {
    private static final XmlExtension.AttributeValuePresentation BRACES_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("{" == null) {
                1.$$$reportNull$$$0(0);
            }
            return "{";
        }

        @NotNull
        public String getPostfix() {
            if ("}" == null) {
                1.$$$reportNull$$$0(1);
            }
            return "}";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final XmlExtension.AttributeValuePresentation EMPTY_VALUE_PRESENTATION = new XmlExtension.AttributeValuePresentation(){

        @NotNull
        public String getPrefix() {
            if ("" == null) {
                2.$$$reportNull$$$0(0);
            }
            return "";
        }

        @NotNull
        public String getPostfix() {
            if ("" == null) {
                2.$$$reportNull$$$0(1);
            }
            return "";
        }

        public boolean showAutoPopup() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPostfix";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };

    @NotNull
    public static ResolveResult[] resolveQualifiedComponent(@NotNull XmlTag tag) {
        JSXNamespaceReference parentRef;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(0);
        }
        if ((parentRef = ReactXmlExtension.getQualifierReference(tag)) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactXmlExtension.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        String localName = tag.getLocalName();
        Collection<PsiElement> elements = JSXResolveUtil.expandReferenceElements((PsiElement)tag, parentRef);
        if (elements.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactXmlExtension.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List candidates = JSXResolveUtil.resolveNestedName((PsiElement)tag, localName, elements, parentRef);
        ResolveResult[] components = ReactXmlExtension.resolveComponentNameForCandidates(tag, candidates);
        if (components.length > 0) {
            if (components == null) {
                ReactXmlExtension.$$$reportNull$$$0(3);
            }
            return components;
        }
        List result2 = candidates.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)ReactXmlExtension.resolveGlobalComponentElements(tag, tag.getName())) : candidates;
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(result2);
        if (resolveResultArray == null) {
            ReactXmlExtension.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Nullable
    public static JSXNamespaceReference getQualifierReference(@NotNull XmlTag tag) {
        PsiReference[] references;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(5);
        }
        if ((references = tag.getReferences()).length == 0) {
            return null;
        }
        PsiReference lastRef = references[references.length - 1];
        if (!(lastRef instanceof JSXNamespaceReference)) {
            return null;
        }
        return (JSXNamespaceReference)lastRef;
    }

    @NotNull
    public static ResolveResult[] resolveTopLevelTagOrComponent(@NotNull XmlTag tag) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(6);
        }
        String tagName = tag.getName();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)tag);
        boolean isComponentName = ReactXmlExtension.isComponentName(tagName);
        if (isTypeScript && !isComponentName) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(ContainerUtil.createMaybeSingletonList((Object)TypeScriptReactTagUtil.resolveTag(tag)));
            if (resolveResultArray == null) {
                ReactXmlExtension.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        if (!isComponentName) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactXmlExtension.$$$reportNull$$$0(8);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        List candidates = JSXResolveUtil.resolveTopLevelName((PsiElement)tag, tagName);
        ResolveResult[] resolvedCandidates = ReactXmlExtension.resolveComponentNameForCandidates(tag, candidates);
        if (resolvedCandidates.length > 0) {
            if (resolvedCandidates == null) {
                ReactXmlExtension.$$$reportNull$$$0(9);
            }
            return resolvedCandidates;
        }
        List finalResult = candidates.isEmpty() ? ContainerUtil.createMaybeSingletonList((Object)ReactXmlExtension.resolveGlobalComponentElements(tag, tagName)) : candidates;
        ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(finalResult);
        if (resolveResultArray == null) {
            ReactXmlExtension.$$$reportNull$$$0(10);
        }
        return resolveResultArray;
    }

    @Nullable
    private static PsiElement resolveGlobalComponentElements(@NotNull XmlTag tag, @NotNull String fullTagName) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(11);
        }
        if (fullTagName == null) {
            ReactXmlExtension.$$$reportNull$$$0(12);
        }
        if (DialectDetector.isTypeScript((PsiElement)tag)) {
            return null;
        }
        return ReactXmlExtension.resolveComponentForIndexes(tag, fullTagName);
    }

    @NotNull
    private static JSResolveResult getResolveResult(@NotNull PsiElement candidate, @NotNull XmlTag tag) {
        PsiElement signatureElement;
        JSRecordTypeImpl recordType;
        JSResolveResult signature;
        if (candidate == null) {
            ReactXmlExtension.$$$reportNull$$$0(13);
        }
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(14);
        }
        if (candidate instanceof ES6ImportedBinding || candidate instanceof ES6ImportSpecifierAlias || candidate instanceof TypeScriptImportStatement || candidate instanceof JSVariable) {
            JSResolveResult jSResolveResult = ReactXmlExtension.resolveResult(candidate, null);
            if (jSResolveResult == null) {
                ReactXmlExtension.$$$reportNull$$$0(15);
            }
            return jSResolveResult;
        }
        if (candidate instanceof ES6ImportSpecifier) {
            ES6ImportSpecifier specifier = (ES6ImportSpecifier)candidate;
            Collection<PsiElement> elements = JSResolveResult.resolveReference((PsiPolyVariantReference)specifier);
            PsiElement resolveResult = (PsiElement)ContainerUtil.getFirstItem(elements);
            if (resolveResult != null) {
                JSResolveResult jSResolveResult = ReactXmlExtension.resolveResult(resolveResult, (ES6ImportExportDeclarationPart)specifier);
                if (jSResolveResult == null) {
                    ReactXmlExtension.$$$reportNull$$$0(16);
                }
                return jSResolveResult;
            }
            JSResolveResult jSResolveResult = ReactXmlExtension.resolveResult((PsiElement)specifier, null);
            if (jSResolveResult == null) {
                ReactXmlExtension.$$$reportNull$$$0(17);
            }
            return jSResolveResult;
        }
        if (candidate instanceof TypeScriptFunction && ((TypeScriptFunction)candidate).isOverloadImplementation() && (signature = TypeScriptSignatureChooser.getOverloadSignatureForImplementation(candidate, ContainerUtil.createMaybeSingletonList((Object)(recordType = TypeScriptReactComponentUtil.createRecordTypeFromTag(tag, candidate))))).isValidResult() && (signatureElement = signature.getElement()) != null) {
            JSResolveResult jSResolveResult = ReactXmlExtension.resolveResult(signatureElement, null);
            if (jSResolveResult == null) {
                ReactXmlExtension.$$$reportNull$$$0(18);
            }
            return jSResolveResult;
        }
        JSResolveResult jSResolveResult = ReactXmlExtension.resolveResult(candidate, null);
        if (jSResolveResult == null) {
            ReactXmlExtension.$$$reportNull$$$0(19);
        }
        return jSResolveResult;
    }

    @Nullable
    private static PsiElement resolveComponentForIndexes(@NotNull XmlTag tag, @NotNull String qualifiedName) {
        GlobalSearchScope scope;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(20);
        }
        if (qualifiedName == null) {
            ReactXmlExtension.$$$reportNull$$$0(21);
        }
        if ((scope = ReactXmlExtension.getResolveScopeForIndexProcessing(tag, ReactXmlExtension.hasQualifiedName(tag))) == null) {
            return null;
        }
        Collection<JSPsiElementBase> results = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qualifiedName, scope);
        PsiElement possibleCandidate = null;
        for (PsiElement psiElement : results) {
            if (ReactXmlExtension.isReactComponent(psiElement)) {
                return psiElement;
            }
            if (!ReactXmlExtension.isPossibleReactComponent(psiElement)) continue;
            possibleCandidate = psiElement;
        }
        return possibleCandidate;
    }

    @Nullable
    public static GlobalSearchScope getResolveScopeForIndexProcessing(@NotNull XmlTag tag, boolean hasQName) {
        boolean acceptOnlyModules;
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(22);
        }
        boolean bl = acceptOnlyModules = ES6PsiUtil.findExternalModule((PsiElement)tag) != null;
        if (!hasQName && acceptOnlyModules) {
            return null;
        }
        final PsiManager manager2 = tag.getManager();
        return new DelegatingGlobalSearchScope(JSResolveUtil.getResolveScope((PsiElement)tag)){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                PsiFile psiFile = manager2.findFile(file2);
                if (!(psiFile instanceof JSFile)) {
                    return false;
                }
                return ((JSFile)psiFile).isCommonJSModule() == acceptOnlyModules;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension$3", "contains"));
            }
        };
    }

    @Contract(value="null -> false")
    public static boolean isComponentName(@Nullable String tagName) {
        if (tagName == null) {
            return false;
        }
        if (tagName.indexOf(".") > 0 && tagName.charAt(0) != '[') {
            return true;
        }
        if (tagName.isEmpty()) {
            return false;
        }
        char firstChar = tagName.charAt(0);
        return Character.isUpperCase(firstChar) || firstChar == '_';
    }

    @Nullable
    protected static JSExpression getInitializer(@NotNull PsiElement clazz) {
        if (clazz == null) {
            ReactXmlExtension.$$$reportNull$$$0(23);
        }
        if (clazz instanceof JSVariable) {
            return ((JSVariable)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSDefinitionExpression) {
            return ((JSDefinitionExpression)clazz).getInitializerOrStub();
        }
        if (clazz instanceof JSProperty) {
            JSFunction function = ((JSProperty)clazz).tryGetFunctionInitializer();
            return function instanceof JSExpression ? (JSExpression)function : null;
        }
        return null;
    }

    public boolean isAvailable(PsiFile file2) {
        if (file2 instanceof JSFile) {
            return true;
        }
        FileType type = file2.getFileType();
        if (type instanceof LanguageFileType && HTMLLanguage.INSTANCE.equals(((LanguageFileType)type).getLanguage())) {
            JSLanguageDialect configuredJSVersion = DialectDetector.getConfiguredJSVersion(file2);
            return configuredJSVersion.getOptionHolder().isJSX;
        }
        return false;
    }

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return nameElement.getTreeParent() instanceof JSXXmlLiteralExpressionImpl ? new ReactTagNameReference(nameElement, startTagFlag) : super.createTagNameReference(nameElement, startTagFlag);
    }

    public static boolean isPossibleReactComponent(@NotNull PsiElement candidate) {
        if (candidate == null) {
            ReactXmlExtension.$$$reportNull$$$0(24);
        }
        if (ReactXmlExtension.isReactComponent(candidate)) {
            return true;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression || candidate instanceof JSProperty) {
            if (candidate instanceof JSVariable && DialectDetector.isTypeScript(candidate)) {
                return ReactXmlExtension.isCompatibleComponentType(((JSVariable)candidate).getJSType());
            }
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            JSType type = JSResolveUtil.getExpressionJSType(initializer);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        if (candidate instanceof JSClass && !(candidate instanceof TypeScriptTypeAlias)) {
            return !((JSClass)candidate).isInterface() && ((JSClass)candidate).getExtendsList() != null;
        }
        if (candidate instanceof JSCallExpression) {
            String name = ReactXmlExtension.resolveCallComponentName((JSCallExpression)candidate);
            if (name != null) {
                return ReactXmlExtension.isComponentName(name);
            }
            JSType type = JSResolveUtil.getExpressionJSType((JSExpression)candidate);
            return ReactXmlExtension.isCompatibleComponentType(type);
        }
        return true;
    }

    protected static boolean isCompatibleComponentType(JSType type) {
        if (type instanceof JSPrimitiveType && !(type instanceof JSStringType)) {
            return false;
        }
        return !(type instanceof JSRecordType) || ((JSRecordType)type).hasProperty("render");
    }

    public static boolean isReactComponent(@Nullable PsiElement candidate) {
        if (candidate == null) {
            return false;
        }
        if (candidate instanceof JSVariable || candidate instanceof JSDefinitionExpression) {
            JSExpression initializer = ReactXmlExtension.getInitializer(candidate);
            if (initializer instanceof JSXmlLiteralExpression) {
                return true;
            }
            if (JSXHarmonyLanguageDialect.isReactComponent(initializer)) {
                return true;
            }
            if (DialectDetector.isTypeScript(candidate) && candidate instanceof JSVariable) {
                JSRecordType recordType;
                JSType type = ((JSVariable)candidate).getJSType();
                JSRecordType jSRecordType = recordType = type != null ? type.asRecordType() : null;
                if (recordType != null && (recordType.hasProperty("render") || recordType.hasProperty("propTypes"))) {
                    return true;
                }
                if (initializer instanceof JSFunction && ReactXmlExtension.isComponentName(((JSVariable)candidate).getName())) {
                    return ReactXmlExtension.isFunctionComponentBySignature((JSFunction)initializer);
                }
            }
        }
        if (candidate instanceof JSCallExpression && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)((JSCallExpression)candidate))) {
            return true;
        }
        if (candidate instanceof ES6ImportExportDeclarationPart || candidate instanceof TypeScriptImportStatement) {
            return true;
        }
        if (candidate instanceof JSFunction) {
            JSFunction function = (JSFunction)candidate;
            return function.getName() != null && ReactXmlExtension.isComponentName(function.getName());
        }
        if (candidate instanceof JSClass) {
            JSClass jsClass = (JSClass)candidate;
            ThreeState component = ReactXmlExtension.isAcceptableClassComponent(jsClass);
            switch (component) {
                case YES: {
                    return true;
                }
                case NO: {
                    return false;
                }
                case UNSURE: {
                    return ReactXmlExtension.checkClassHierarchyHasComponent(jsClass);
                }
            }
        }
        return false;
    }

    public void addTagNameVariants(List<LookupElement> elements, @NotNull XmlTag tag, String prefix) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(25);
        }
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element) {
        Collection<PsiElement> collection = ReactXmlExtension.getElementsByImport(element, true);
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(26);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> getElementsByImport(@Nullable PsiElement element, boolean resolveCallExpression) {
        if (element == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ReactXmlExtension.$$$reportNull$$$0(27);
            }
            return list2;
        }
        Collection collection = JSStubBasedPsiTreeUtil.calculateMeaningfulElements(element).stream().flatMap(el -> {
            JSExpression initializer;
            JSVariable variable;
            if (resolveCallExpression && el instanceof JSCallExpression) {
                return ReactXmlExtension.resolveCallExpression((JSCallExpression)el).stream();
            }
            if (el instanceof JSVariable && (variable = (JSVariable)el).getTypeElement() == null && (initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)variable)) instanceof JSFunction) {
                el = initializer;
            }
            return Stream.of(el);
        }).collect(Collectors.toList());
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpression(@NotNull JSCallExpression result2) {
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(29);
        }
        String componentName = ReactXmlExtension.resolveCallComponentName(result2);
        Collection<PsiElement> collection = ReactXmlExtension.resolveCallExpressionForName(result2, componentName);
        if (collection == null) {
            ReactXmlExtension.$$$reportNull$$$0(30);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiElement> resolveCallExpressionForName(@NotNull JSCallExpression result2, String componentName) {
        PsiElement componentCandidate;
        PsiElement module;
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(31);
        }
        if (!StringUtil.isEmpty((String)componentName) && (module = ES6PsiUtil.findExternalModule((PsiElement)result2)) != null && (componentCandidate = JSStubBasedPsiTreeUtil.resolveLocally(componentName, module)) != null && ReactXmlExtension.isPossibleReactComponent(componentCandidate)) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)componentCandidate);
            if (list2 == null) {
                ReactXmlExtension.$$$reportNull$$$0(32);
            }
            return list2;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            ReactXmlExtension.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @Nullable
    public static String resolveCallComponentName(@NotNull JSCallExpression result2) {
        Map strings;
        JSElementIndexingData data;
        if (result2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(34);
        }
        if ((data = result2.getIndexingData()) != null && (strings = data.getUserStrings()) != null) {
            return (String)strings.get("wrapped.component.name");
        }
        return null;
    }

    public static boolean nonJsxTag(@Nullable XmlTag tag) {
        return !(tag instanceof JSXXmlLiteralExpressionImpl);
    }

    public static boolean hasQualifiedName(@NotNull XmlTag tag) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(35);
        }
        String name = tag.getName();
        String localName = tag.getLocalName();
        return !localName.equals(name);
    }

    @NotNull
    public static ThreeState isAcceptableClassComponent(@NotNull JSClass jsClass) {
        String[] texts;
        if (jsClass == null) {
            ReactXmlExtension.$$$reportNull$$$0(36);
        }
        if (jsClass.isInterface() || jsClass.getExtendsList() == null) {
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                ReactXmlExtension.$$$reportNull$$$0(37);
            }
            return threeState;
        }
        for (String text : texts = jsClass.getExtendsList().getReferenceTexts()) {
            int index = text.lastIndexOf(".");
            if (index > 0 && text.length() > index + 1) {
                text = text.substring(index + 1);
            }
            if (!TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(text)) continue;
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                ReactXmlExtension.$$$reportNull$$$0(38);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            ReactXmlExtension.$$$reportNull$$$0(39);
        }
        return threeState;
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlElementDescriptor elementDescriptor = element.getDescriptor();
        if (elementDescriptor instanceof ReactXmlElementDescriptor) {
            return elementDescriptor.getNSDescriptor();
        }
        return super.getNSDescriptor(element, namespace, strict);
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        return end != null && TreeUtil.findSibling((ASTNode)end, (IElementType)JSStubElementTypes.XML_JS_SCRIPT) == null;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        String tagName = tag.getName();
        if (!ReactXmlExtension.isComponentName(tagName)) {
            return false;
        }
        boolean children = "children".equals(attrName);
        boolean passedAttributes = false;
        for (PsiElement child : tag.getChildren()) {
            if ((!children || passedAttributes) && child instanceof JSEmbeddedContent) {
                return true;
            }
            IElementType type = child.getNode().getElementType();
            if (children && (child instanceof XmlText || child instanceof XmlTag || type == JSTokenTypes.XML_ENTITY_REF)) {
                return true;
            }
            if (!children && (type == XmlTokenType.XML_EMPTY_ELEMENT_END || type == XmlTokenType.XML_TAG_END)) break;
            passedAttributes |= type == XmlTokenType.XML_TAG_END;
        }
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor2) {
        if ("children".equals(descriptor2.getName())) {
            return false;
        }
        return super.shouldBeInserted(descriptor2);
    }

    @NotNull
    public XmlExtension.AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlTag tag, @NotNull String attributeName, @NotNull String defaultAttributeQuote) {
        if (attributeName == null) {
            ReactXmlExtension.$$$reportNull$$$0(40);
        }
        if (defaultAttributeQuote == null) {
            ReactXmlExtension.$$$reportNull$$$0(41);
        }
        if (tag instanceof JSXXmlLiteralExpressionImpl) {
            JSCodeStyleSettings.JSXAttributeValuePresentation presentation = ReactXmlExtension.getAttributeValue(tag, attributeName);
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createValueWithBraces();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(42);
                }
                return attributeValuePresentation;
            }
            if (presentation == JSCodeStyleSettings.JSXAttributeValuePresentation.NONE) {
                XmlExtension.AttributeValuePresentation attributeValuePresentation = ReactXmlExtension.createEmptyValue();
                if (attributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(43);
                }
                return attributeValuePresentation;
            }
        }
        XmlExtension.AttributeValuePresentation attributeValuePresentation = super.getAttributeValuePresentation(tag, attributeName, defaultAttributeQuote);
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(44);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static JSCodeStyleSettings.JSXAttributeValuePresentation getTypeBasedJSXAttributeValuePresentation(@NotNull XmlAttributeDescriptor descriptor2) {
        JSType attributeType;
        if (descriptor2 == null) {
            ReactXmlExtension.$$$reportNull$$$0(45);
        }
        if ((attributeType = ReactXmlExtension.getType(descriptor2)) != null && attributeType.getSource().isTypeScript()) {
            attributeType = attributeType.substitute();
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = !JSTypeUtils.isStringOrStringUnion(attributeType, false) ? JSCodeStyleSettings.JSXAttributeValuePresentation.BRACES : JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(46);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    public static JSCodeStyleSettings.JSXAttributeValuePresentation getAttributeValue(@NotNull XmlTag tag, @NotNull String attributeName) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(47);
        }
        if (attributeName == null) {
            ReactXmlExtension.$$$reportNull$$$0(48);
        }
        if (tag instanceof JSXXmlLiteralExpressionImpl) {
            XmlAttributeDescriptor attributeDescriptor;
            XmlElementDescriptor descriptor2;
            JSCodeStyleSettings.JSXAttributeValuePresentation value = JSCodeStyleSettings.getJSXAttributeValue((PsiElement)tag);
            if (value == JSCodeStyleSettings.JSXAttributeValuePresentation.TYPE_BASED && (descriptor2 = tag.getDescriptor()) != null && (attributeDescriptor = descriptor2.getAttributeDescriptor(attributeName, tag)) instanceof ReactAttributeDescriptor) {
                JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = ReactXmlExtension.getTypeBasedJSXAttributeValuePresentation(attributeDescriptor);
                if (jSXAttributeValuePresentation == null) {
                    ReactXmlExtension.$$$reportNull$$$0(49);
                }
                return jSXAttributeValuePresentation;
            }
            JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = value;
            if (jSXAttributeValuePresentation == null) {
                ReactXmlExtension.$$$reportNull$$$0(50);
            }
            return jSXAttributeValuePresentation;
        }
        JSCodeStyleSettings.JSXAttributeValuePresentation jSXAttributeValuePresentation = JSCodeStyleSettings.JSXAttributeValuePresentation.QUOTES;
        if (jSXAttributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(51);
        }
        return jSXAttributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createValueWithBraces() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = BRACES_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(52);
        }
        return attributeValuePresentation;
    }

    @NotNull
    private static XmlExtension.AttributeValuePresentation createEmptyValue() {
        XmlExtension.AttributeValuePresentation attributeValuePresentation = EMPTY_VALUE_PRESENTATION;
        if (attributeValuePresentation == null) {
            ReactXmlExtension.$$$reportNull$$$0(53);
        }
        return attributeValuePresentation;
    }

    @Nullable
    public static JSType getType(@Nullable XmlAttributeDescriptor descriptor2) {
        if (!(descriptor2 instanceof ReactAttributeDescriptor)) {
            return null;
        }
        return ((ReactAttributeDescriptor)descriptor2).getValueType();
    }

    @Nullable
    public static JSType getPropType(@Nullable PsiElement declaration) {
        String typeString;
        if (declaration instanceof JSTypeInfoOwner) {
            JSTypeInfoOwner signature = (JSTypeInfoOwner)declaration;
            return signature.getJSType();
        }
        if (declaration instanceof JSImplicitElement && !StringUtil.isEmpty((String)(typeString = ((JSImplicitElement)declaration).getTypeString()))) {
            return JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource(declaration, false));
        }
        return null;
    }

    public static boolean isFunctionComponentBySignature(@NotNull JSFunction element) {
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(54);
        }
        if (element.isConstructor()) {
            return false;
        }
        JSType returnedType = element.getReturnType();
        if (returnedType instanceof JSPrimitiveType || returnedType instanceof JSVoidType) {
            return false;
        }
        JSParameterListElement[] parameters = element.getParameters();
        return parameters.length <= 2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ResolveResult[] resolveComponentNameForCandidates(@NotNull XmlTag tag, @NotNull Collection<? extends PsiElement> candidates) {
        if (tag == null) {
            ReactXmlExtension.$$$reportNull$$$0(55);
        }
        if (candidates == null) {
            ReactXmlExtension.$$$reportNull$$$0(56);
        }
        if (candidates.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ReactXmlExtension.$$$reportNull$$$0(57);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        HashSet<Object> visitedOverloadImplementations = new HashSet<Object>();
        ArrayList<JSResolveResult> elements = new ArrayList<JSResolveResult>();
        for (PsiElement psiElement : candidates) {
            void var5_5;
            if (!ReactXmlExtension.isPossibleReactComponent(psiElement)) continue;
            if (psiElement instanceof TypeScriptFunction) {
                if (((TypeScriptFunction)psiElement).isOverloadDeclaration()) {
                    PsiElement psiElement2;
                    TypeScriptFunction implementation = TypeScriptPsiUtil.getOverloadImplementation((TypeScriptFunction)psiElement);
                    Object object = psiElement2 = implementation == null ? psiElement : implementation;
                    if (implementation != null && !visitedOverloadImplementations.add(implementation)) {
                        continue;
                    }
                } else if (((TypeScriptFunction)psiElement).isOverloadImplementation() && !visitedOverloadImplementations.add(psiElement)) continue;
            }
            elements.add(ReactXmlExtension.getResolveResult((PsiElement)var5_5, tag));
        }
        ResolveResult[] resolveResultArray = elements.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            ReactXmlExtension.$$$reportNull$$$0(58);
        }
        return resolveResultArray;
    }

    @NotNull
    private static JSResolveResult resolveResult(@NotNull PsiElement element, @Nullable ES6ImportExportDeclarationPart es6Import) {
        if (element == null) {
            ReactXmlExtension.$$$reportNull$$$0(59);
        }
        JSResolveResult jSResolveResult = new JSResolveResult(element, (JSElement)es6Import, null);
        if (jSResolveResult == null) {
            ReactXmlExtension.$$$reportNull$$$0(60);
        }
        return jSResolveResult;
    }

    static boolean checkClassHierarchyHasComponent(@NotNull JSClass jsClass) {
        TypeScriptUtil.JSClassHierarchyProcessor processor;
        if (jsClass == null) {
            ReactXmlExtension.$$$reportNull$$$0(61);
        }
        return !JSClassUtils.processClassesInHierarchy(jsClass, false, processor = (parentCandidate, typeSubstitutor, fromImplements) -> {
            String parentCandidateName;
            if (parentCandidate == null) {
                ReactXmlExtension.$$$reportNull$$$0(62);
            }
            if (typeSubstitutor == null) {
                ReactXmlExtension.$$$reportNull$$$0(63);
            }
            return !TypeScriptReactComponentUtil.REACT_COMPONENT_NAMES.contains(parentCandidateName = parentCandidate.getName());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullTagName";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 36: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 54: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCandidate";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactXmlExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTopLevelTagOrComponent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResult";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsByImport";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpression";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCallExpressionForName";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "isAcceptableClassComponent";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuePresentation";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValue";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createValueWithBraces";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyValue";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveComponentNameForCandidates";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 60: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveTopLevelTagOrComponent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveGlobalComponentElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResult";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentForIndexes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeForIndexProcessing";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getInitializer";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleReactComponent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addTagNameVariants";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpression";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallExpressionForName";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveCallComponentName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableClassComponent";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getTypeBasedJSXAttributeValuePresentation";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionComponentBySignature";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resolveComponentNameForCandidates";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveResult";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkClassHierarchyHasComponent";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkClassHierarchyHasComponent$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

