/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.mozilla;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.library.JSExternalDocumentationProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.xml.util.documentation.MdnDocumentationUtil;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdnExtDocProvider
extends JSExternalDocumentationProvider {
    public MdnExtDocProvider(String docUrl) {
        super(docUrl);
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        PsiComment comment = (PsiComment)ReadAction.compute(() -> JSDocumentationUtils.findDocComment(element));
        if (comment != null) {
            return null;
        }
        return MdnDocumentationUtil.fetchExternalDocumentation(docUrls, () -> {
            Ref result2 = new Ref();
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (!element.isValid()) {
                    return;
                }
                SmartPsiElementPointer originalElement = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
                String doc = new JSDocumentationProvider().generateDoc(element, originalElement != null ? originalElement.getElement() : null);
                result2.set((Object)doc);
            });
            return (String)result2.get();
        });
    }
}

