/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXExpressionParser;
import com.intellij.lang.javascript.flow.psi.FlowJSParser;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.openapi.util.Ref;

public class FlowJSExpressionParser
extends JSXExpressionParser<FlowJSParser> {
    private int myParenthesizedLevel = 0;

    public FlowJSExpressionParser(FlowJSParser parser) {
        super(parser);
    }

    @Override
    public boolean parseQualifiedTypeName() {
        if (this.builder.getTokenType() == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            return this.parseQualifiedTypeNameTail(marker);
        }
        return super.parseQualifiedTypeName();
    }

    @Override
    protected boolean parseUnaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT && ((ES6FunctionParser)((FlowJSParser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseUnaryExpression();
    }

    @Override
    protected int getCurrentBinarySignPriority(boolean allowIn, boolean advance) {
        int x = FlowJSExpressionParser.getUncollapsedComparisonOperatorsPriority(advance, this.builder);
        if (x > 0) {
            return x;
        }
        return super.getCurrentBinarySignPriority(allowIn, advance);
    }

    @Override
    protected boolean isFunctionPropertyStart() {
        return JSKeywordSets.PROPERTY_NAMES.contains(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.LT || super.isFunctionPropertyStart();
    }

    @Override
    protected void parseDestructuringArrayElement() {
        PsiBuilder.Marker arrayElement = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.parseDestructuringRestElementNoMarker(true);
            arrayElement.done(JSStubElementTypes.DESTRUCTURING_ARRAY_REST);
            return;
        }
        arrayElement.done(this.parseDestructuringElementNoMarker(true, false));
    }

    @Override
    protected boolean parseDialectSpecificMemberExpressionPart(Ref<PsiBuilder.Marker> markerRef) {
        if (((FlowJSPsiTypeParser)((FlowJSParser)this.myJavaScriptParser).getTypeParser()).parseOptionalTypeArgumentList()) {
            return true;
        }
        return super.parseDialectSpecificMemberExpressionPart(markerRef);
    }

    @Override
    public void parseParenthesizedExpression() {
        try {
            ++this.myParenthesizedLevel;
            super.parseParenthesizedExpression();
        }
        finally {
            --this.myParenthesizedLevel;
        }
    }

    public int getParenthesizedLevel() {
        return this.myParenthesizedLevel;
    }
}

