/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.TypeScriptJSXFileType;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptArrayType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptExternalModuleIndex;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeMemberParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptUtil {
    public static final FileType[] TYPESCRIPT_FILE_TYPES_ARRAY = new FileType[]{TypeScriptFileType.INSTANCE, TypeScriptJSXFileType.INSTANCE};
    public static final Collection<FileType> TYPESCRIPT_FILE_TYPES = ContainerUtil.newArrayList((Object[])TYPESCRIPT_FILE_TYPES_ARRAY);
    public static final String TYPESCRIPT_FILE_EXTENSION = ".ts";
    public static final String TYPESCRIPT_JSX_FILE_EXTENSION = ".tsx";
    public static final String[] TYPESCRIPT_EXTENSIONS_WITHOUT_DTS = new String[]{".ts", ".tsx"};
    public static final String TYPESCRIPT_DECLARATIONS_FILE_EXTENSION = ".d.ts";
    public static final String[] TYPESCRIPT_EXTENSIONS = new String[]{".d.ts", ".ts", ".tsx"};
    public static final String LIB_PREFIX = "lib.";
    public static final String[] TYPESCRIPT_DECLARATIONS_FILE_EXTENSIONS = new String[]{".d.ts"};
    public static final String COMPILER_DIRECTORY_NAME = "jsLanguageServicesImpl";
    public static final Function<PsiElement, TypeScriptInterface> TYPESCRIPT_INTERFACE_FILTER = element -> element instanceof TypeScriptInterface ? (TypeScriptInterface)element : null;
    public static final String TYPINGS = "typings";
    public static final String TS_CONFIG = "tsconfig";
    public static final String TYPES = "types";

    @NotNull
    public static Collection<JSFunctionWithSubstitutor> resolveConstructorFunctions(@NotNull TypeScriptClass clazz, @Nullable PsiElement methodExpression) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(0);
        }
        THashSet visitedClasses = new THashSet();
        ArrayDeque<TypeScriptClass> classQueue = new ArrayDeque<TypeScriptClass>();
        if (methodExpression != null) {
            PsiElement parent = methodExpression.getParent();
            if (!(methodExpression instanceof JSNewExpression) && !(parent instanceof JSNewExpression)) {
                List list2 = ContainerUtil.emptyList();
                if (list2 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(1);
                }
                return list2;
            }
        }
        classQueue.add(clazz);
        while (!classQueue.isEmpty()) {
            TypeScriptClass currentClass;
            JSClass rawClass = (JSClass)classQueue.poll();
            if (!(rawClass instanceof TypeScriptClass) || !visitedClasses.add((currentClass = (TypeScriptClass)rawClass).getQualifiedName())) continue;
            Object[] constructors = currentClass.getConstructors();
            if (constructors.length > 0) {
                List list3 = ContainerUtil.map((Object[])constructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list3 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(2);
                }
                return list3;
            }
            Collection indirectConstructors = currentClass.getIndirectSuperConstructors();
            if (!indirectConstructors.isEmpty()) {
                List list4 = ContainerUtil.map((Collection)indirectConstructors, JSPsiImplUtils.TO_FUNCTION_WITH_SUBSTITUTOR);
                if (list4 == null) {
                    TypeScriptUtil.$$$reportNull$$$0(3);
                }
                return list4;
            }
            Collections.addAll(classQueue, currentClass.getSuperClasses());
        }
        List list5 = ContainerUtil.emptyList();
        if (list5 == null) {
            TypeScriptUtil.$$$reportNull$$$0(4);
        }
        return list5;
    }

    @Nullable
    public static VirtualFile findFileByReferencePath(@NotNull PsiFile file2, @NotNull String referencePath) {
        ConcurrentMap refPathToVirtualFile;
        Object value;
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(5);
        }
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(6);
        }
        if ((value = (refPathToVirtualFile = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            ConcurrentMap result2 = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{file2, VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
        })).get(referencePath)) == null) {
            VirtualFile result2 = TypeScriptUtil.calcFileByReferencePath(file2.getProject(), file2.getVirtualFile(), referencePath);
            refPathToVirtualFile.put(referencePath, result2 == null ? ObjectUtils.NULL : result2);
            return result2;
        }
        return TypeScriptUtil.getValue(value);
    }

    @Nullable
    private static VirtualFile getValue(@NotNull Object object) {
        if (object == null) {
            TypeScriptUtil.$$$reportNull$$$0(7);
        }
        if (object instanceof VirtualFile) {
            return (VirtualFile)object;
        }
        return null;
    }

    @Nullable
    public static VirtualFile calcFileByReferencePath(Project project, @Nullable VirtualFile virtualFile, @NotNull String referencePath) {
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(8);
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile result2 = null;
        referencePath = referencePath.replace('\\', '/');
        VirtualFile dir = virtualFile.getParent();
        if (referencePath.startsWith(".")) {
            if (dir != null) {
                result2 = TypeScriptUtil.getFileByRelativePath(referencePath, dir);
            }
        } else {
            VirtualFile contentRootForFile = ProjectRootManager.getInstance((Project)project).getFileIndex().getContentRootForFile(virtualFile, true);
            VirtualFile imported = TypeScriptUtil.findForContentRoot(referencePath, contentRootForFile, dir);
            if (imported == null) {
                for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                    if (!contentRoot.equals(contentRootForFile) && (imported = TypeScriptUtil.findForContentRoot(referencePath, contentRoot, contentRoot)) != null) break;
                }
            }
            result2 = imported;
        }
        return result2;
    }

    @Nullable
    private static VirtualFile findForContentRoot(@NotNull String referencePath, VirtualFile contentRoot, VirtualFile startFrom) {
        VirtualFile contentRootParent;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(9);
        }
        VirtualFile imported = null;
        VirtualFile virtualFile = contentRootParent = contentRoot != null ? contentRoot.getParent() : null;
        while (imported == null && startFrom != null && startFrom.isInLocalFileSystem()) {
            imported = TypeScriptUtil.getFileByRelativePath(referencePath, startFrom);
            if (contentRootParent != null && startFrom.equals(contentRootParent)) break;
            startFrom = startFrom.getParent();
        }
        return imported;
    }

    private static VirtualFile getFileByRelativePath(@NotNull String referencePath, VirtualFile currentParent) {
        VirtualFile imported;
        if (referencePath == null) {
            TypeScriptUtil.$$$reportNull$$$0(10);
        }
        if ((imported = currentParent.findFileByRelativePath(referencePath)) == null || imported.isDirectory()) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_DECLARATIONS_FILE_EXTENSION);
        }
        if (imported == null) {
            imported = currentParent.findFileByRelativePath(referencePath + TYPESCRIPT_JSX_FILE_EXTENSION);
        }
        return imported;
    }

    @NotNull
    public static ResolveResult[] findExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleText) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(11);
        }
        if (unquotedEscapedModuleText == null) {
            TypeScriptUtil.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String quoted = StringUtil.wrapWithDoubleQuote((String)JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleText));
        String unifiedName = CommonJSUtil.unifyModuleName(quoted);
        GlobalSearchScope scope = TypeScriptUtil.createScopeWithFilterByNodeModules((PsiElement)refFile);
        Collection<JSQualifiedNamedElement> modules = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(unifiedName, scope);
        if (!modules.isEmpty()) {
            ArrayList<JSResolveResult> result2 = new ArrayList<JSResolveResult>();
            for (JSNamedElement jSNamedElement : modules) {
                if (!(jSNamedElement instanceof TypeScriptModule) || ((TypeScriptModule)jSNamedElement).isAugmentation()) continue;
                result2.add(new JSResolveResult((PsiElement)jSNamedElement));
            }
            if (!ContainerUtil.isEmpty(result2)) {
                ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
                if (resolveResultArray == null) {
                    TypeScriptUtil.$$$reportNull$$$0(13);
                }
                return resolveResultArray;
            }
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            TypeScriptUtil.$$$reportNull$$$0(14);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static ResolveResult[] findPatternBasedExternalModule(@NotNull PsiFile refFile, @NotNull String unquotedEscapedModuleName, @NotNull Project project) {
        if (refFile == null) {
            TypeScriptUtil.$$$reportNull$$$0(15);
        }
        if (unquotedEscapedModuleName == null) {
            TypeScriptUtil.$$$reportNull$$$0(16);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        String unquotedModuleName = JSStringUtil.unescapeStringLiteralValue(unquotedEscapedModuleName);
        Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(project, (PsiElement)refFile);
        List patterns = ContainerUtil.map(patternExternalModules, module -> JSPathMappingsUtil.createPatternForString(StringUtil.unquoteString((String)module.getExternalModuleText()), false));
        Pair path = JSPathMappingsUtil.findMaxElementByPaths(unquotedModuleName, patterns);
        if (path != null && path.getFirst() != null) {
            ArrayList<JSResolveResult> resultPatternModules = new ArrayList<JSResolveResult>();
            String pattern = StringUtil.wrapWithDoubleQuote((String)((JSModulePattern)path.getFirst()).getPattern());
            for (TypeScriptModule module2 : patternExternalModules) {
                if (!pattern.equals(module2.getExternalModuleText())) continue;
                resultPatternModules.add(new JSResolveResult((PsiElement)module2));
            }
            return resultPatternModules.toArray(ResolveResult.EMPTY_ARRAY);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public static Collection<TypeScriptModule> getAllRegularExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(18);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"reg", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    @NotNull
    private static GlobalSearchScope createScopeWithFilterByNodeModules(@NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(19);
        }
        GlobalSearchScope globalSearchScope = TypeScriptUtil.createFilterByNodeModuleScope(JSResolveUtil.getResolveScope(owner), owner);
        if (globalSearchScope == null) {
            TypeScriptUtil.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    public static Collection<TypeScriptModule> getAllPatternExternalModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(21);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"pat", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    public static Collection<TypeScriptModule> getAllAugmentationModules(Project project, @NotNull PsiElement owner) {
        if (owner == null) {
            TypeScriptUtil.$$$reportNull$$$0(22);
        }
        return StubIndex.getElements(TypeScriptExternalModuleIndex.KEY, (Object)"aug", (Project)project, (GlobalSearchScope)TypeScriptUtil.createScopeWithFilterByNodeModules(owner), TypeScriptModule.class);
    }

    @NotNull
    public static Collection<JSClass<?>> getNonStrictParents(@NotNull JSClass<?> clazz, boolean includeInterfaces) {
        if (clazz == null) {
            TypeScriptUtil.$$$reportNull$$$0(23);
        }
        ArrayList result2 = new ArrayList();
        JSClassUtils.processClassesInHierarchy(clazz, includeInterfaces, (aClass, typeSubstitutor, fromImplements) -> {
            result2.add(aClass);
            return true;
        });
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @Contract(value="null->null")
    public static String convertToExternalModuleText(@Nullable String unifiedModuleName) {
        if (unifiedModuleName == null) {
            return null;
        }
        if (unifiedModuleName.startsWith("module:")) {
            String sub = unifiedModuleName.substring("module:".length());
            return JSStringUtil.isDoubleQuotedString(sub) ? sub : StringUtil.wrapWithDoubleQuote((String)sub);
        }
        return null;
    }

    public static void resolveNameToClassesOverAliases(@Nullable String name, @NotNull PsiElement context, @NotNull Collection<JSClass> resultCollection, Collection<JSClass> visitedAliases) {
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(25);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(26);
        }
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveTypeName(name, context);
        for (PsiElement psiElement : result2.getElements()) {
            if (!(psiElement instanceof JSClass)) continue;
            if (psiElement instanceof TypeScriptTypeAlias) {
                TypeScriptUtil.resolveAliasToClass((TypeScriptTypeAlias)psiElement, resultCollection, visitedAliases);
                continue;
            }
            resultCollection.add((JSClass)psiElement);
        }
    }

    public static void resolveAliasToClass(@NotNull TypeScriptTypeAlias alias, @NotNull Collection<JSClass> resultCollection, @Nullable Collection<JSClass> visitedAliases) {
        TypeScriptType declaration;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(27);
        }
        if (resultCollection == null) {
            TypeScriptUtil.$$$reportNull$$$0(28);
        }
        if ((declaration = alias.getTypeDeclaration()) instanceof TypeScriptSingleType && !TypeScriptUtil.hasTypeArguments((TypeScriptSingleType)declaration)) {
            if (visitedAliases == null) {
                visitedAliases = new HashSet<JSClass>();
            }
            if (!visitedAliases.add((JSClass)alias)) {
                return;
            }
            TypeScriptSingleType singleType = (TypeScriptSingleType)declaration;
            TypeScriptUtil.resolveNameToClassesOverAliases(singleType.getQualifiedTypeName(), (PsiElement)alias, resultCollection, visitedAliases);
        } else {
            resultCollection.add((JSClass)alias);
        }
    }

    private static boolean hasTypeArguments(@NotNull TypeScriptSingleType singleType) {
        if (singleType == null) {
            TypeScriptUtil.$$$reportNull$$$0(29);
        }
        return singleType.getTypeArguments().length > 0;
    }

    @NotNull
    public static Iterable<JSNamedElement> getNamedMembers(@NotNull JSClass<?> aClass) {
        if (aClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(30);
        }
        Iterable members = aClass.getMembers();
        ArrayList<JSNamedElement> namedElements = new ArrayList<JSNamedElement>();
        for (JSElement member : members) {
            if (!(member instanceof JSNamedElement)) continue;
            namedElements.add((JSNamedElement)member);
        }
        ArrayList<JSNamedElement> arrayList = namedElements;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    public static JSType applyGenericsToType(@NotNull JSType typeInParentClass, @Nullable JSClass surroundClass, @Nullable JSClass parentClass) {
        if (typeInParentClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(32);
        }
        if (parentClass != null && surroundClass != null && DialectDetector.isTypeScript((PsiElement)surroundClass)) {
            JSType jSType = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(surroundClass, (List<? extends JSType>)ContainerUtil.emptyList(), parentClass, typeInParentClass);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(33);
            }
            return jSType;
        }
        JSType jSType = typeInParentClass;
        if (jSType == null) {
            TypeScriptUtil.$$$reportNull$$$0(34);
        }
        return jSType;
    }

    @NotNull
    public static String buildParameterTypeListStringWithApplyingGenerics(TypeScriptFunction function, @Nullable PsiElement surroundClass) {
        TypeScriptTypeParameterList list2;
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)function);
        if (classOfContext != null && (list2 = function.getTypeParameterList()) != null) {
            String join = StringUtil.join((Object[])list2.getTypeParameters(), parameter -> {
                TypeScriptGenericDeclarationTypeImpl jsType = TypeScriptGenericTypesEvaluator.buildGenericParameterDeclaration(parameter);
                if (surroundClass instanceof JSClass) {
                    jsType = TypeScriptUtil.applyGenericsToType(jsType, (JSClass)surroundClass, classOfContext);
                }
                return jsType.getTypeText(JSType.TypeTextFormat.CODE);
            }, (String)", ");
            String string = StringUtil.isEmpty((String)join) ? "" : "<" + join + ">";
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(35);
            }
            return string;
        }
        if ("" == null) {
            TypeScriptUtil.$$$reportNull$$$0(36);
        }
        return "";
    }

    @NotNull
    public static Map<TypeScriptMemberInfo, JSClass> getUnimplementedMembers(@NotNull JSClass jsClass, boolean includeOptional) {
        if (jsClass == null) {
            TypeScriptUtil.$$$reportNull$$$0(37);
        }
        ArrayList implementedInterfaces = new ArrayList();
        HashMap typeSubstitutors = new HashMap();
        JSClassUtils.processClassesInHierarchy(jsClass, true, (aClass, typeSubstitutor, fromImplements) -> {
            if ((includeOptional || fromImplements || TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)aClass)) && aClass != jsClass) {
                implementedInterfaces.add(aClass);
            }
            typeSubstitutors.put(aClass, typeSubstitutor);
            return true;
        });
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, DialectDetector.isTypeScript((PsiElement)jsClass));
        LinkedHashMap<TypeScriptMemberInfo, JSClass> membersToImplement = new LinkedHashMap<TypeScriptMemberInfo, JSClass>();
        for (JSClass implementedInterface : implementedInterfaces) {
            JSType typeDeclaration;
            ArrayList<TypeScriptMemberInfo> implementedMembers = new ArrayList<TypeScriptMemberInfo>();
            if (implementedInterface instanceof TypeScriptInterface) {
                TypeScriptObjectType body = ((TypeScriptInterface)implementedInterface).getBody();
                if (body == null) continue;
                for (TypeScriptTypeMember typeMember : body.getTypeMembers()) {
                    JSRecordType.TypeMember interfaceTypeMember = TypeScriptTypeMemberParser.buildTypeMember(typeMember);
                    if (interfaceTypeMember == null) continue;
                    implementedMembers.add(TypeScriptMemberInfo.create(interfaceTypeMember, (JSElement)typeMember));
                }
            } else if (implementedInterface instanceof TypeScriptClass) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)implementedInterface, true);
                for (JSNamedElement jSNamedElement : TypeScriptUtil.getNamedMembers(implementedInterface)) {
                    JSRecordType.TypeMember member = TypeScriptTypeMemberParser.buildTypeMemberFromClassMember(implementedInterface, (JSElement)jSNamedElement, false, typeSource, (JSTypeSubstitutor)typeSubstitutors.get(implementedInterface));
                    if (member == null) continue;
                    implementedMembers.add(TypeScriptMemberInfo.create(member, (JSElement)jSNamedElement));
                }
            } else if (implementedInterface instanceof TypeScriptTypeAlias && (typeDeclaration = ((TypeScriptTypeAlias)implementedInterface).getParsedTypeDeclaration()) != null) {
                if (JSTypeUtils.hasForeignGenericParameter(typeDeclaration)) {
                    JSTypeSubstitutor substitutor = TypeScriptGenericTypesEvaluator.getTypeSubstitutorForExtendClass(jsClass, implementedInterface);
                    typeDeclaration = JSTypeUtils.applyGenericArguments(typeDeclaration, substitutor);
                }
                JSRecordType recordType = typeDeclaration.asRecordType();
                for (JSRecordType.TypeMember member : recordType.getTypeMembers()) {
                    if (!(member instanceof JSRecordType.PropertySignature)) continue;
                    String name = ((JSRecordType.PropertySignature)member).getMemberName();
                    JSType type2 = ((JSRecordType.PropertySignature)member).getJSType();
                    implementedMembers.add(TypeScriptMemberInfo.create(member, (JSElement)new JSLocalImplicitElementImpl(name, type2, (PsiElement)implementedInterface, JSImplicitElement.Type.Property)));
                }
            }
            JSRecordType classType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, true, TypeScriptPsiUtil.isAbstractElement((JSAttributeListOwner)jsClass), false);
            classType = (JSRecordType)classType.transformTypeHierarchy(type -> TypeScriptUtil.replaceThisType(type, jsClass, source));
            JSRecordTypeImpl objectType = null;
            ArrayList<JSRecordType.TypeMember> arrayList = new ArrayList<JSRecordType.TypeMember>();
            for (TypeScriptMemberInfo implementedMember : implementedMembers) {
                ProcessingContext context;
                boolean memberIsAlreadyAdded = false;
                for (TypeScriptMemberInfo member2 : membersToImplement.keySet()) {
                    if (member2.getMember() == null || !member2.getMember().isEquivalentTo(implementedMember.getMember(), true)) continue;
                    memberIsAlreadyAdded = true;
                    break;
                }
                if (memberIsAlreadyAdded) continue;
                arrayList.clear();
                arrayList.add(includeOptional ? TypeScriptUtil.overrideOptionalFlagForTypeMember(implementedMember.getMember()) : implementedMember.getMember());
                JSRecordTypeImpl type3 = new JSRecordTypeImpl(source, arrayList);
                if ((type3 = type3.transformTypeHierarchy(type1 -> TypeScriptUtil.replaceThisType(type1, jsClass, source))).isDirectlyAssignableType((JSType)classType, context = JSTypeComparingContextService.getProcessingContextWithCallEnvironment((PsiElement)jsClass))) continue;
                if (objectType == null) {
                    List<JSClass> objectClasses = TypeScriptClassResolver.getInstance().findObjectClasses(jsClass);
                    for (JSClass objectClass : objectClasses) {
                        JSRecordType currentObjectType = TypeScriptTypeParser.buildTypeFromClass(objectClass, false, false, false, false);
                        if (objectType == null) {
                            objectType = currentObjectType;
                            continue;
                        }
                        List objectTypeMembers = ContainerUtil.concat((List)objectType.getTypeMembers(), (List)currentObjectType.getTypeMembers());
                        objectType = new JSRecordTypeImpl(objectType.getSource(), objectTypeMembers);
                    }
                    if (objectType == null) {
                        objectType = new JSRecordTypeImpl(source, Collections.emptyList());
                    }
                }
                if (type3.isDirectlyAssignableType(objectType, context)) continue;
                membersToImplement.put(implementedMember, implementedInterface);
            }
        }
        LinkedHashMap<TypeScriptMemberInfo, JSClass> linkedHashMap = membersToImplement;
        if (linkedHashMap == null) {
            TypeScriptUtil.$$$reportNull$$$0(38);
        }
        return linkedHashMap;
    }

    private static JSType replaceThisType(JSType type, JSClass jsClass, JSTypeSource source) {
        if (type instanceof TypeScriptGenericThisTypeImpl) {
            String name = jsClass.getQualifiedName();
            if (name != null) {
                return new TypeScriptGenericThisTypeImpl(type.getSource(), JSNamedTypeFactory.createType(name, source, JSTypeContext.INSTANCE));
            }
            if (jsClass instanceof JSClassExpression) {
                return new TypeScriptGenericThisTypeImpl(type.getSource(), (JSType)TypeScriptTypeParser.buildTypeFromClass(jsClass, false));
            }
        }
        return type;
    }

    private static JSRecordType.TypeMember overrideOptionalFlagForTypeMember(JSRecordType.TypeMember member) {
        JSRecordType.PropertySignature propertySignature;
        if (member instanceof JSRecordType.PropertySignature && (propertySignature = (JSRecordType.PropertySignature)member).isOptional()) {
            return new JSRecordTypeImpl.PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.getJSType(), false, propertySignature.isConst(), propertySignature.getMemberSource());
        }
        return member;
    }

    public static boolean isTypeScriptMethod(PsiElement element) {
        return element instanceof JSFunction && !(element instanceof TypeScriptCallSignature);
    }

    public static boolean isTypeScriptProperty(PsiElement element) {
        return element instanceof TypeScriptPropertySignature || element instanceof JSVariable;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull String name, @NotNull PsiElement context) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(39);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(40);
        }
        JSType type = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(context), JSContext.INSTANCE);
        String string = TypeScriptUtil.getShortestTypeNameInContext(type, context);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContext(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(42);
        }
        if (!((type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(type))) instanceof JSNamedType) || context == null || type instanceof JSPrimitiveType) {
            String string = type.getTypeText(JSType.TypeTextFormat.CODE);
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(43);
            }
            return string;
        }
        String text = type.getResolvedTypeText();
        String string = TypeScriptUtil.getShortestTypeNameInContextForQualifiedName(context, text);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public static String getShortestTypeNameInContextForQualifiedName(@NotNull PsiElement context, @NotNull String startQName) {
        String currentName;
        JSQualifiedNameImpl name;
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(45);
        }
        if (startQName == null) {
            TypeScriptUtil.$$$reportNull$$$0(46);
        }
        if ((name = JSQualifiedNameImpl.fromQualifiedName(startQName)).getParent() == null) {
            String string = startQName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(47);
            }
            return string;
        }
        String result2 = null;
        String qName = null;
        for (JSQualifiedNameImpl current = name; !(current == null || !StringUtil.isEmpty(result2) && StringUtil.equals((CharSequence)startQName, result2) || TypeScriptUtil.hasAmbientExternalModuleInQName(currentName = current.getName())); current = current.getParent()) {
            qName = qName == null ? currentName : currentName + "." + qName;
            result2 = TypeScriptImportHandler.getInstance().getQualifiedNameResolvedType(qName, context);
        }
        if (result2 != null && StringUtil.equals((CharSequence)startQName, result2)) {
            String string = qName;
            if (string == null) {
                TypeScriptUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        String string = startQName;
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(49);
        }
        return string;
    }

    public static boolean hasAmbientExternalModuleInQName(@Nullable String value) {
        return value != null && value.startsWith("module:");
    }

    @NotNull
    public static JSType getBaseTypeOfEnumLiteralType(@NotNull JSResolvableType type) {
        String text;
        JSQualifiedNameImpl name;
        JSQualifiedName parent;
        if (type == null) {
            TypeScriptUtil.$$$reportNull$$$0(50);
        }
        if ((parent = (name = JSQualifiedNameImpl.fromQualifiedName(text = type.getResolvedTypeText())).getParent()) != null) {
            String qualifiedName = parent.getQualifiedName();
            JSType jSType = JSNamedType.createType(qualifiedName, type.getSource(), JSTypeContext.INSTANCE);
            if (jSType == null) {
                TypeScriptUtil.$$$reportNull$$$0(51);
            }
            return jSType;
        }
        JSResolvableType jSResolvableType = type;
        if (jSResolvableType == null) {
            TypeScriptUtil.$$$reportNull$$$0(52);
        }
        return jSResolvableType;
    }

    @NotNull
    public static File getTypeScriptExternalFolderFile() {
        File file2 = new File(TypeScriptUtil.getTypeScriptCompilerFolderFile(), "external");
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(53);
        }
        return file2;
    }

    @NotNull
    public static File getTypeScriptCompilerFolderFile() throws RuntimeException {
        File file2;
        block7: {
            String jarPath;
            block5: {
                File file3;
                block6: {
                    try {
                        jarPath = PathUtil.getJarPathForClass(TypeScriptUtil.class);
                        if (jarPath.endsWith(".jar")) break block5;
                        URL resource = TypeScriptUtil.class.getClassLoader().getResource(COMPILER_DIRECTORY_NAME);
                        if (resource == null) {
                            throw new RuntimeException("Cannot find file compiler implementation");
                        }
                        file3 = new File(URLUtil.decode((String)resource.getPath()));
                        if (file3 != null) break block6;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    TypeScriptUtil.$$$reportNull$$$0(54);
                }
                return file3;
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            file2 = new File(pluginBaseDir, COMPILER_DIRECTORY_NAME);
            if (file2 != null) break block7;
            TypeScriptUtil.$$$reportNull$$$0(55);
        }
        return file2;
    }

    public static boolean resolveIsStrict(@NotNull JSReferenceExpression node) {
        if (node == null) {
            TypeScriptUtil.$$$reportNull$$$0(56);
        }
        return TypeScriptUtil.isStrictResolveQualifier(node.getQualifier());
    }

    public static boolean isStrictResolveQualifier(@Nullable JSExpression qualifier) {
        JSType jsType;
        if (TypeScriptUtil.isValidThisQualifier(qualifier) || TypeScriptUtil.isValidSuperQualifier(qualifier) || qualifier == null) {
            return true;
        }
        if (qualifier instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ((JSReferenceExpression)qualifier).multiResolve(false)) {
                PsiElement resolve = result2.getElement();
                if (!(resolve instanceof TypeScriptModule) && !(resolve instanceof TypeScriptImportStatement) && !(resolve instanceof ES6ImportedBinding) && !(resolve instanceof ES6ImportSpecifierAlias) && !(resolve instanceof JSFile)) continue;
                return true;
            }
        }
        if (TypeScriptUtil.isStrictType(jsType = JSResolveUtil.getExpressionJSType(qualifier))) {
            return !TypeScriptUtil.isImportType(jsType) || TypeScriptUtil.isStrictType(jsType.substitute());
        }
        return false;
    }

    public static boolean isImportType(JSType jsType) {
        if (!(jsType instanceof JSTypeImpl)) {
            return false;
        }
        String typeText = jsType.getTypeText();
        return typeText.startsWith("import(") && typeText.endsWith(")");
    }

    public static boolean isValidSuperQualifier(JSExpression qualifier) {
        return qualifier instanceof JSSuperExpression && JSResolveUtil.getClassOfContext((PsiElement)qualifier) != null;
    }

    public static boolean isValidThisQualifier(JSExpression qualifier) {
        return qualifier instanceof JSThisExpression && JSContextResolver.findContextElement((JSThisExpression)qualifier) instanceof JSClass;
    }

    public static ProblemHighlightType getProblemHighlightTypeForType(@Nullable JSType type) {
        if (TypeScriptUtil.isStrictType(type)) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    public static boolean isStrictType(@Nullable JSType jsType) {
        return jsType != null && !JSTypeUtils.hasAnyTypeOrNotStrictType(jsType) && !(jsType instanceof JSNullType);
    }

    public static boolean isUnderNodeModules(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(57);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(58);
        }
        return JSLibraryUtil.hasDirectoryInPath(file2, JSLibraryUtil.LIBRARY_DIR_NAMES, project.getBaseDir());
    }

    public static boolean isDefinitionFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(59);
        }
        return TypeScriptUtil.isDefinitionFile(file2.getNameSequence());
    }

    public static boolean isDefinitionFile(@NotNull CharSequence fileName) {
        int dtslength;
        int length;
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(60);
        }
        if ((length = fileName.length()) <= (dtslength = TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length())) {
            return false;
        }
        for (int i = 0; i < dtslength; ++i) {
            char ch = fileName.charAt(i + length - dtslength);
            if ('A' <= ch && ch <= 'Z') {
                ch = (char)(ch + 32);
            }
            if (ch == TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static JSRecordType getFunctionTypeMembers(@Nullable PsiElement source) {
        if (source == null || !DialectDetector.isTypeScript(source)) {
            return null;
        }
        return TypeScriptUtil.getTypeMembers(source, JSTypeUtils.getFunctionTypeName(source.getContainingFile(), false));
    }

    private static JSRecordType getTypeMembers(@NotNull PsiElement source, @NotNull String className2) {
        if (source == null) {
            TypeScriptUtil.$$$reportNull$$$0(61);
        }
        if (className2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(62);
        }
        ArrayList members = new ArrayList();
        JSElement context = ES6PsiUtil.getNonStrictExportScope(source);
        if (context == null) {
            context = source;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(className2, (PsiElement)context);
        for (PsiElement psiElement : elements) {
            JSElement container = ES6PsiUtil.getExportScope(psiElement);
            if (!(psiElement instanceof JSClass) || container == null || ES6PsiUtil.isExternalModule((PsiElement)container) || TypeScriptModuleAccessibilityChecker.INSTANCE.check((PsiElement)context, psiElement) != null) continue;
            JSRecordType current = TypeScriptTypeParser.buildTypeFromClass((JSClass)psiElement, false);
            members.addAll(current.getTypeMembers());
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)context, true), members);
    }

    @NotNull
    public static GlobalSearchScope createFilterByNodeModuleScope(@NotNull GlobalSearchScope scope, @NotNull PsiElement context) {
        if (scope == null) {
            TypeScriptUtil.$$$reportNull$$$0(63);
        }
        if (context == null) {
            TypeScriptUtil.$$$reportNull$$$0(64);
        }
        if (context instanceof PsiFile) {
            context = ((PsiFile)context).getOriginalFile();
        }
        final VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)context);
        final ProjectFileIndex index = ProjectFileIndex.getInstance((Project)context.getProject());
        Object resultScope = contextFile == null ? scope : new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                VirtualFile currentNodeModules = JSLibraryUtil.findAncestorLibraryDir(file2, "node_modules");
                if (currentNodeModules == null) {
                    return true;
                }
                VirtualFile parentDir = currentNodeModules.getParent();
                boolean isPartOfProject = index.isInContent(parentDir) || index.isInLibrary(parentDir);
                return !isPartOfProject || VfsUtilCore.isAncestor((VirtualFile)parentDir, (VirtualFile)contextFile, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$1", "contains"));
            }
        };
        Object object = DialectDetector.isTypeScript(context) ? resultScope : TypeScriptUtil.excludeTsGlobalDeclarationsFromNodeModules((GlobalSearchScope)resultScope, context.getProject());
        if (object == null) {
            TypeScriptUtil.$$$reportNull$$$0(65);
        }
        return object;
    }

    @Nullable
    public static JSRecordType getTypeAliasRecordTypeForSubstitutor(@NotNull TypeScriptTypeAlias alias, @Nullable JSTypeSubstitutor substitutor) {
        JSType typeToProcess;
        if (alias == null) {
            TypeScriptUtil.$$$reportNull$$$0(66);
        }
        return (typeToProcess = JSTypeUtils.applyGenericArguments(alias.getParsedTypeDeclaration(), substitutor)) == null ? null : typeToProcess.asRecordType();
    }

    public static boolean isDefinitionFile(@Nullable PsiFile file2) {
        return file2 != null && TypeScriptUtil.isDefinitionFile(file2.getName());
    }

    public static List<VirtualFile> getLibFiles(@NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        if (includeCondition == null) {
            TypeScriptUtil.$$$reportNull$$$0(67);
        }
        File externalDirectory = TypeScriptUtil.getTypeScriptExternalFolderFile();
        return TypeScriptUtil.getLibFiles(externalDirectory, includeCondition, includeInvalid);
    }

    @NotNull
    public static List<VirtualFile> getLibFiles(@NotNull File libFolder, @NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        if (libFolder == null) {
            TypeScriptUtil.$$$reportNull$$$0(68);
        }
        if (includeCondition == null) {
            TypeScriptUtil.$$$reportNull$$$0(69);
        }
        if (!libFolder.exists() || !libFolder.isDirectory()) {
            Logger.getInstance(TypeScriptUtil.class).error("Cannot find external directory, the installation is possibly broken.");
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptUtil.$$$reportNull$$$0(70);
            }
            return list2;
        }
        File[] files = libFolder.listFiles();
        if (files == null) {
            Logger.getInstance(TypeScriptUtil.class).error("Cannot find files in the external directory, the installation is possibly broken.");
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                TypeScriptUtil.$$$reportNull$$$0(71);
            }
            return list3;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.length);
        for (File file2 : files) {
            String name;
            if (file2.isDirectory() || !(name = file2.getName()).startsWith(LIB_PREFIX) || !TypeScriptUtil.isDefinitionFile(name) || !includeCondition.value((Object)name)) continue;
            ContainerUtil.addIfNotNull(result2, (Object)JSLibraryUtil.findFileByIO(file2, includeInvalid));
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            TypeScriptUtil.$$$reportNull$$$0(72);
        }
        return arrayList;
    }

    public static int getTypePrecedence(@NotNull JSTypeDeclaration declaration) {
        if (declaration == null) {
            TypeScriptUtil.$$$reportNull$$$0(73);
        }
        if (declaration instanceof TypeScriptParenthesizedType) {
            return 0;
        }
        if (declaration instanceof TypeScriptSingleType) {
            return 1;
        }
        if (declaration instanceof TypeScriptArrayType) {
            return 2;
        }
        if (declaration instanceof TypeScriptTypeOperator) {
            return 3;
        }
        if (declaration instanceof TypeScriptUnionOrIntersectionType) {
            TypeScriptUnionOrIntersectionType unionOrIntersection = (TypeScriptUnionOrIntersectionType)declaration;
            return unionOrIntersection.isIntersectionType() ? 4 : 5;
        }
        if (declaration instanceof TypeScriptFunctionType) {
            return 6;
        }
        return -1;
    }

    public static PsiElement evaluateThisFromFunction(TypeScriptFunction function, PsiElement context) {
        TypeScriptTypeEvaluator evaluator = new TypeScriptTypeEvaluator(new JSEvaluateContext(function.getContainingFile()), new JSSimpleTypeProcessor(context), JSDialectSpecificHandlersFactory.forElement((PsiElement)function).getTypeEvaluationHelper());
        JSType thisType = evaluator.computeThisType(function);
        if (thisType == null) {
            return null;
        }
        PsiElement sourceElement = thisType.getSourceElement();
        if (!(sourceElement instanceof TypeScriptType)) {
            return sourceElement;
        }
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSParameter) {
            return parent;
        }
        if (parent instanceof JSVariable && ((JSVariable)parent).getInitializer() instanceof JSObjectLiteralExpression) {
            JSType originalType = ((TypeScriptType)sourceElement).getJSType();
            if (originalType instanceof JSResolvableType) {
                Collection<? extends PsiElement> declarations = ((JSResolvableType)originalType).resolveType().getDeclarations();
                if (declarations.size() == 1) {
                    return declarations.iterator().next();
                }
            } else {
                Collection<? extends PsiElement> declarations;
                JSType type = originalType.substitute();
                if (type instanceof JSResolvableType && (declarations = ((JSResolvableType)type).resolveType().getDeclarations()).size() == 1) {
                    return declarations.iterator().next();
                }
            }
        }
        return sourceElement;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name, @NotNull String extension) {
        if (name == null) {
            TypeScriptUtil.$$$reportNull$$$0(74);
        }
        if (extension == null) {
            TypeScriptUtil.$$$reportNull$$$0(75);
        }
        CharSequence charSequence = name.subSequence(0, name.length() - extension.length());
        if (charSequence == null) {
            TypeScriptUtil.$$$reportNull$$$0(76);
        }
        return charSequence;
    }

    public static boolean isES6LibName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptUtil.$$$reportNull$$$0(77);
        }
        if ((libraryName = StringUtil.toLowerCase((String)libraryName)).startsWith("esnext")) {
            return true;
        }
        if (!libraryName.startsWith("es")) {
            return false;
        }
        int indexOfEnd = libraryName.indexOf(".");
        if (indexOfEnd == -1) {
            indexOfEnd = libraryName.length();
        }
        try {
            String index = libraryName.substring(2, indexOfEnd);
            int parsedValue = Integer.parseInt(index);
            if (index.length() == 1 && parsedValue >= 6) {
                return true;
            }
            if (index.length() == 4 && parsedValue >= 2015) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptUtil.class).debug((Throwable)e);
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope excludeTsGlobalDeclarationsFromNodeModules(@NotNull GlobalSearchScope scope, final @NotNull Project project) {
        if (scope == null) {
            TypeScriptUtil.$$$reportNull$$$0(78);
        }
        if (project == null) {
            TypeScriptUtil.$$$reportNull$$$0(79);
        }
        final TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(project);
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(scope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                CharSequence name = file2.getNameSequence();
                if (!StringUtil.endsWith((CharSequence)name, (CharSequence)TypeScriptUtil.TYPESCRIPT_FILE_EXTENSION)) {
                    return true;
                }
                VirtualFile topDirectory = JSLibraryUtil.getLibraryFolder(file2, "node_modules");
                if (topDirectory == null) {
                    return true;
                }
                return configService.isImplicitIncludedNodeModulesFile(project, file2, topDirectory);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$2", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            TypeScriptUtil.$$$reportNull$$$0(80);
        }
        return delegatingGlobalSearchScope;
    }

    public static boolean isTypeScriptFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptUtil.$$$reportNull$$$0(81);
        }
        for (FileType type : TYPESCRIPT_FILE_TYPES_ARRAY) {
            if (!FileTypeManager.getInstance().isFileOfType(file2, type)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLibraryName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptUtil.$$$reportNull$$$0(82);
        }
        int end = fileName.length() - TYPESCRIPT_DECLARATIONS_FILE_EXTENSION.length();
        int start = LIB_PREFIX.length();
        String string = "lib.d.ts".equals(fileName) ? fileName : fileName.substring(start, end);
        if (string == null) {
            TypeScriptUtil.$$$reportNull$$$0(83);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 80: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 80: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 5: 
            case 57: 
            case 59: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedEscapedModuleName";
                break;
            }
            case 17: 
            case 58: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 25: 
            case 40: 
            case 45: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultCollection";
                break;
            }
            case 27: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInParentClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 39: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startQName";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 60: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 63: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeCondition";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorFunctions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findExternalModule";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStrictParents";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedMembers";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "applyGenericsToType";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "buildParameterTypeListStringWithApplyingGenerics";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnimplementedMembers";
                break;
            }
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContext";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptExternalFolderFile";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeScriptCompilerFolderFile";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilterByNodeModuleScope";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFiles";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeTsGlobalDeclarationsFromNodeModules";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorFunctions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 80: 
            case 83: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileByReferencePath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calcFileByReferencePath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findForContentRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFileByRelativePath";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExternalModule";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternBasedExternalModule";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllRegularExternalModules";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createScopeWithFilterByNodeModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllPatternExternalModules";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAllAugmentationModules";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNonStrictParents";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameToClassesOverAliases";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveAliasToClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeArguments";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getNamedMembers";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyGenericsToType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getUnimplementedMembers";
                break;
            }
            case 39: 
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContext";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getShortestTypeNameInContextForQualifiedName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getBaseTypeOfEnumLiteralType";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resolveIsStrict";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isUnderNodeModules";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isDefinitionFile";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMembers";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "createFilterByNodeModuleScope";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAliasRecordTypeForSubstitutor";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getLibFiles";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getTypePrecedence";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isES6LibName";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "excludeTsGlobalDeclarationsFromNodeModules";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptFile";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 20: 
            case 24: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 65: 
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 80: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface JSClassHierarchyProcessor
    extends JSClassUtils.JSClassHierarchyProcessor {
        public boolean process(@NotNull JSClass<?> var1, @NotNull JSTypeSubstitutor var2, boolean var3);

        @Override
        default public boolean process(@NotNull JSClass<?> aClass, @NotNull JSTypeSubstitutor typeSubstitutor, boolean fromImplements, boolean fromStaticContext, int depth) {
            if (aClass == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(0);
            }
            if (typeSubstitutor == null) {
                JSClassHierarchyProcessor.$$$reportNull$$$0(1);
            }
            if (fromStaticContext) {
                return true;
            }
            return this.process(aClass, typeSubstitutor, fromImplements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeSubstitutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptUtil$JSClassHierarchyProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

