/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSLookupPriority {
    LOWEST_PRIORITY(0, 0),
    NO_RELEVANT_SMARTNESS_PRIORITY(1, 0),
    RELEVANT_SMARTNESS_PRIORITY(1, 1),
    NO_RELEVANT_NO_SMARTNESS_PRIORITY(1, 2),
    RELEVANT_NO_SMARTNESS_PRIORITY(4, 0),
    TOP_LEVEL_SYMBOLS_FROM_OTHER_FILES(4, 1),
    CONDITIONAL_COMPILATION_CONSTANTS_PRIORITY(4, 2),
    NON_CONTEXT_KEYWORDS_PRIORITY(5, 0),
    KEYWORDS_PRIORITY(6, 0),
    MAX_PRIORITY(7, 0),
    NEIGHBOUR_REFERENCES_PRIORITY(7, 1),
    SMART_MATCHED_PARAMETER_NAME(8, 0),
    NESTING_LEVEL_REST(99, 94),
    NESTING_LEVEL_5(99, 95),
    NESTING_LEVEL_4(99, 96),
    NESTING_LEVEL_3(99, 97),
    NESTING_LEVEL_2(99, 98),
    NESTING_LEVEL_1(99, 99),
    LOCAL_SCOPE_MAX_PRIORITY_EXOTIC(100, 0),
    LOCAL_SCOPE_MAX_PRIORITY(101, 0),
    SMART_KEYWORDS_PRIORITY(102, 0),
    SMART_PRIORITY(103, 0),
    MATCHED_PARAMETER_NAME(103, 0),
    MATCHED_TYPE_PRIORITY(104, 0);

    public static final Key<Integer> EXPLICIT_PROXIMITY_KEY;
    private final int myPriority;
    private final int myProximity;

    private JSLookupPriority(int priority, int proximity) {
        this.myPriority = priority;
        this.myProximity = proximity;
    }

    @NotNull
    public static JSLookupPriority getSameFileValue(boolean matchesReferencedParameterName, int nestingLevel) {
        if (matchesReferencedParameterName) {
            JSLookupPriority jSLookupPriority = MATCHED_PARAMETER_NAME;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(0);
            }
            return jSLookupPriority;
        }
        if (nestingLevel < 0) {
            JSLookupPriority jSLookupPriority = NO_RELEVANT_NO_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(1);
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = JSLookupPriority.getNestingLevelPriority(nestingLevel);
        if (jSLookupPriority == null) {
            JSLookupPriority.$$$reportNull$$$0(2);
        }
        return jSLookupPriority;
    }

    @NotNull
    public static JSLookupPriority getNestingLevelPriority(int nestingLevel) {
        if (nestingLevel == 0) {
            JSLookupPriority jSLookupPriority = LOCAL_SCOPE_MAX_PRIORITY;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(3);
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 1) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_1;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(4);
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 2) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_2;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(5);
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 3) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_3;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(6);
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 4) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_4;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(7);
            }
            return jSLookupPriority;
        }
        if (nestingLevel == 5) {
            JSLookupPriority jSLookupPriority = NESTING_LEVEL_5;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(8);
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = NESTING_LEVEL_REST;
        if (jSLookupPriority == null) {
            JSLookupPriority.$$$reportNull$$$0(9);
        }
        return jSLookupPriority;
    }

    @NotNull
    public static JSLookupPriority getLookupPriority(@Nullable BaseJSSymbolProcessor.MatchType matchType, boolean fromRelevantFileOrDirectory, boolean hasSomeSmartnessAvailable) {
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            JSLookupPriority jSLookupPriority = LOCAL_SCOPE_MAX_PRIORITY;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(10);
            }
            return jSLookupPriority;
        }
        if (hasSomeSmartnessAvailable) {
            JSLookupPriority jSLookupPriority = fromRelevantFileOrDirectory ? RELEVANT_SMARTNESS_PRIORITY : NO_RELEVANT_SMARTNESS_PRIORITY;
            if (jSLookupPriority == null) {
                JSLookupPriority.$$$reportNull$$$0(11);
            }
            return jSLookupPriority;
        }
        JSLookupPriority jSLookupPriority = fromRelevantFileOrDirectory ? RELEVANT_NO_SMARTNESS_PRIORITY : NO_RELEVANT_NO_SMARTNESS_PRIORITY;
        if (jSLookupPriority == null) {
            JSLookupPriority.$$$reportNull$$$0(12);
        }
        return jSLookupPriority;
    }

    public static JSLookupPriority getSameTypeValue(boolean matchesReferencedParameterName, BaseJSSymbolProcessor.MatchType matchType, int nestingLevel) {
        if (matchesReferencedParameterName && (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE)) {
            return MATCHED_PARAMETER_NAME;
        }
        if (matchType == BaseJSSymbolProcessor.MatchType.COMPLETE_WITH_CONTEXT || matchType == BaseJSSymbolProcessor.MatchType.COMPLETE) {
            return JSLookupPriority.getNestingLevelPriority(nestingLevel);
        }
        return NO_RELEVANT_NO_SMARTNESS_PRIORITY;
    }

    public static JSLookupPriority getSmartVariantPriority(boolean matchesReferencedParameterName) {
        return matchesReferencedParameterName ? SMART_MATCHED_PARAMETER_NAME : MAX_PRIORITY;
    }

    public int getPriorityValue() {
        return this.myPriority;
    }

    public int getProximityValue() {
        return this.myProximity;
    }

    static {
        EXPLICIT_PROXIMITY_KEY = Key.create((String)"js.explicit.proximity.key");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/completion/JSLookupPriority";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameFileValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestingLevelPriority";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupPriority";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

