/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigManager;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfigurable;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configPath", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getConfigPath", "()Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getHelpTopic", "getId", "isModified", "", "reset", "intellij.javascript.impl"})
public final class WebPackConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    @NotNull
    private final TextFieldWithBrowseButton configPath;
    @NotNull
    private final Project project;

    @NotNull
    public String getId() {
        return "settings.webpack";
    }

    @NotNull
    public String getHelpTopic() {
        return "procedures.webpack";
    }

    @NotNull
    public final TextFieldWithBrowseButton getConfigPath() {
        return this.configPath;
    }

    public boolean isModified() {
        return Intrinsics.areEqual((Object)FileUtil.toSystemDependentName((String)WebPackConfigManager.Companion.instance(this.project).getConfigPathOrDefault()), (Object)this.configPath.getText()) ^ true;
    }

    @NotNull
    public String getDisplayName() {
        return "webpack";
    }

    @Nullable
    public JComponent createComponent() {
        LabeledComponent labeledComponent = LabeledComponent.create((JComponent)((JComponent)this.configPath), (String)"webpack configuration file:");
        Intrinsics.checkExpressionValueIsNotNull((Object)labeledComponent, (String)"LabeledComponent.create(\u2026ack configuration file:\")");
        LabeledComponent component = labeledComponent;
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter((Condition)createComponent.descriptor.1.INSTANCE);
        this.configPath.addBrowseFolderListener(new TextBrowseFolderListener(descriptor2, this.project));
        JTextField jTextField = this.configPath.getTextField();
        if (jTextField == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.components.JBTextField");
        }
        StatusText statusText = ((JBTextField)jTextField).getEmptyText();
        Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"(configPath.textField as JBTextField).emptyText");
        statusText.setText("path to webpack configuration file");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)component, "North");
        return panel;
    }

    public void apply() {
        String string = this.configPath.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"configPath.text");
        CharSequence charSequence = string;
        boolean bl = false;
        String string2 = charSequence;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String path = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        charSequence = path;
        WebPackConfigManager webPackConfigManager = WebPackConfigManager.Companion.instance(this.project);
        bl = false;
        boolean bl2 = charSequence.length() == 0;
        String string3 = bl2 ? null : path;
        webPackConfigManager.loadState(new WebPackConfiguration(string3));
    }

    public void reset() {
        this.configPath.setText(FileUtil.toSystemDependentName((String)WebPackConfigManager.Companion.instance(this.project).getConfigPathOrDefault()));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public WebPackConfigurable(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.configPath = new TextFieldWithBrowseButton();
    }
}

