/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NpmRunSettings {
    private static final String TAG_PACKAGE_JSON_PATH = "package-json";
    private static final String TAG_COMMAND = "command";
    private static final String TAG_SCRIPTS = "scripts";
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_PACKAGE_MANAGER = "package-manager";
    private final String myPackageJsonSystemIndependentPath;
    private final String myPackageJsonSystemDependentPath;
    private final NpmCommand myCommand;
    private final List<String> myScriptNames;
    private final String myArguments;
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final NodePackageRef myPackageManagerPackageRef;
    private final EnvironmentVariablesData myEnvData;

    public NpmRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            NpmRunSettings.$$$reportNull$$$0(0);
        }
        this.myPackageJsonSystemIndependentPath = FileUtil.toSystemIndependentName((String)builder.myPackageJsonPath);
        this.myPackageJsonSystemDependentPath = FileUtil.toSystemDependentName((String)this.myPackageJsonSystemIndependentPath);
        this.myCommand = builder.myCommand;
        this.myScriptNames = builder.myScriptNames;
        this.myArguments = builder.myArguments;
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myPackageManagerPackageRef = builder.myPackageManagerPackageRef;
        this.myEnvData = builder.myEnvData;
    }

    @NotNull
    public String getPackageJsonSystemIndependentPath() {
        String string = this.myPackageJsonSystemIndependentPath;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPackageJsonSystemDependentPath() {
        String string = this.myPackageJsonSystemDependentPath;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public NpmCommand getCommand() {
        NpmCommand npmCommand = this.myCommand;
        if (npmCommand == null) {
            NpmRunSettings.$$$reportNull$$$0(3);
        }
        return npmCommand;
    }

    @NotNull
    public List<String> getScriptNames() {
        List<String> list2 = this.myScriptNames;
        if (list2 == null) {
            NpmRunSettings.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            NpmRunSettings.$$$reportNull$$$0(6);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            NpmRunSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public NodePackageRef getPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = this.myPackageManagerPackageRef;
        if (nodePackageRef == null) {
            NpmRunSettings.$$$reportNull$$$0(8);
        }
        return nodePackageRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NpmRunSettings.$$$reportNull$$$0(9);
        }
        return environmentVariablesData;
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder(this);
        if (builder == null) {
            NpmRunSettings.$$$reportNull$$$0(10);
        }
        return builder;
    }

    @NotNull
    public static Builder builder() {
        Builder builder = new Builder();
        if (builder == null) {
            NpmRunSettings.$$$reportNull$$$0(11);
        }
        return builder;
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(12);
        }
        if (!this.myPackageJsonSystemIndependentPath.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_PACKAGE_JSON_PATH, (String)this.myPackageJsonSystemIndependentPath);
        }
        JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_COMMAND, (String)this.myCommand.getCliOption());
        this.writeScripts(parent);
        if (!this.myArguments.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_ARGUMENTS, (String)this.myArguments);
        }
        JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_INTERPRETER, (String)this.myInterpreterRef.getReferenceName());
        if (!this.myNodeOptions.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_OPTIONS, (String)this.myNodeOptions);
        }
        if (!NpmUtil.isProjectPackageManagerPackageRef(this.myPackageManagerPackageRef)) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_PACKAGE_MANAGER, (String)this.myPackageManagerPackageRef.getIdentifier());
        }
        this.myEnvData.writeExternal(parent);
    }

    private void writeScripts(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(13);
        }
        if (NpmCommand.RUN_SCRIPT == this.myCommand) {
            Element scriptsElement = new Element(TAG_SCRIPTS);
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)scriptsElement, (String)TAG_SCRIPT, this.myScriptNames);
            parent.addContent(scriptsElement);
        }
    }

    @NotNull
    public static NpmRunSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(14);
        }
        Builder builder = new Builder();
        builder.setPackageJsonPath(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_PACKAGE_JSON_PATH)));
        NpmCommand command = NpmCommand.find(JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_COMMAND));
        if (command != null) {
            builder.setCommand(command);
        }
        builder.setScriptNames(NpmRunSettings.readScripts(parent));
        builder.setArguments(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_ARGUMENTS)));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_INTERPRETER);
        if (interpreterRefName != null) {
            builder.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        }
        builder.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_OPTIONS)));
        String packageManagerReferenceName = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_PACKAGE_MANAGER);
        builder.setPackageManagerPackageRef(packageManagerReferenceName == null ? NpmUtil.createProjectPackageManagerPackageRef() : NpmUtil.DESCRIPTOR.createPackageRef(packageManagerReferenceName));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)parent));
        NpmRunSettings npmRunSettings = builder.build();
        if (npmRunSettings == null) {
            NpmRunSettings.$$$reportNull$$$0(15);
        }
        return npmRunSettings;
    }

    @NotNull
    private static List<String> readScripts(@NotNull Element parent) {
        Element tasksElement;
        if (parent == null) {
            NpmRunSettings.$$$reportNull$$$0(16);
        }
        if ((tasksElement = parent.getChild(TAG_SCRIPTS)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmRunSettings.$$$reportNull$$$0(17);
            }
            return list2;
        }
        List list3 = JDOMExternalizerUtil.getChildrenValueAttributes((Element)tasksElement, (String)TAG_SCRIPT);
        if (list3 == null) {
            NpmRunSettings.$$$reportNull$$$0(18);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageJsonSystemDependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageRef";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readExternal";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readScripts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeScripts";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readScripts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myPackageJsonPath;
        private NpmCommand myCommand;
        private List<String> myScriptNames;
        private String myArguments;
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private NodePackageRef myPackageManagerPackageRef;
        private EnvironmentVariablesData myEnvData;

        private Builder() {
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = ImmutableList.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myPackageManagerPackageRef = NpmUtil.createProjectPackageManagerPackageRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
        }

        private Builder(@NotNull NpmRunSettings copy) {
            if (copy == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myPackageJsonPath = "";
            this.myCommand = NpmCommand.RUN_SCRIPT;
            this.myScriptNames = ImmutableList.of();
            this.myArguments = "";
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myPackageManagerPackageRef = NpmUtil.createProjectPackageManagerPackageRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myPackageJsonPath = copy.myPackageJsonSystemIndependentPath;
            this.myCommand = copy.myCommand;
            this.myScriptNames = copy.myScriptNames;
            this.myArguments = copy.myArguments;
            this.myInterpreterRef = copy.myInterpreterRef;
            this.myNodeOptions = copy.myNodeOptions;
            this.myPackageManagerPackageRef = copy.myPackageManagerPackageRef;
            this.myEnvData = copy.myEnvData;
        }

        @NotNull
        public Builder setPackageJsonPath(@NotNull String packageJsonPath) {
            if (packageJsonPath == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myPackageJsonPath = packageJsonPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setCommand(@NotNull NpmCommand command) {
            if (command == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myCommand = command;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setScriptNames(@NotNull List<String> scriptNames) {
            if (scriptNames == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myScriptNames = ImmutableList.copyOf(scriptNames);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@NotNull String nodeOptions) {
            if (nodeOptions == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.myNodeOptions = nodeOptions;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder setPackageManagerPackageRef(@NotNull NodePackageRef packageManagerPackageRef) {
            if (packageManagerPackageRef == null) {
                Builder.$$$reportNull$$$0(13);
            }
            this.myPackageManagerPackageRef = packageManagerPackageRef;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(15);
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return builder;
        }

        @NotNull
        public NpmRunSettings build() {
            NpmRunSettings npmRunSettings = new NpmRunSettings(this);
            if (npmRunSettings == null) {
                Builder.$$$reportNull$$$0(17);
            }
            return npmRunSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageJsonPath";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = NpmRunSettings.TAG_COMMAND;
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptNames";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = NpmRunSettings.TAG_ARGUMENTS;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeOptions";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageManagerPackageRef";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPackageJsonPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setCommand";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setScriptNames";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setPackageManagerPackageRef";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setPackageJsonPath";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setCommand";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setScriptNames";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setNodeOptions";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "setPackageManagerPackageRef";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 16: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

