/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpReferenceContributor
extends PsiReferenceContributor {
    private static final ElementPattern<JSLiteralExpression> DEPENDENCY_PLACE = PlatformPatterns.psiElement(JSLiteralExpression.class).and((ElementPattern)new FilterPattern(new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            JSLiteralExpression literal;
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral()) {
                JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)literal);
                return jsFile != null && GulpfilePsiStructure.isDependency(literal);
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    }));

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            GulpReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider(DEPENDENCY_PLACE, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                JSLiteralExpression literal;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (processingContext == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((literal = (JSLiteralExpression)ObjectUtils.tryCast((Object)psiElement, JSLiteralExpression.class)) != null && literal.isQuotedLiteral()) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{new GulpTaskReference(literal)};
                    if (psiReferenceArray == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiElement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processingContext";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    @Nullable
    private static JSFile getJSFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return (JSFile)ObjectUtils.tryCast((Object)psiFile.getOriginalFile(), JSFile.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor", "registerReferenceProviders"));
    }

    private static class GulpTaskReference
    implements PsiReference {
        private final JSLiteralExpression myDependency;

        GulpTaskReference(@NotNull JSLiteralExpression dependency) {
            if (dependency == null) {
                GulpTaskReference.$$$reportNull$$$0(0);
            }
            this.myDependency = dependency;
        }

        @NotNull
        public PsiElement getElement() {
            JSLiteralExpression jSLiteralExpression = this.myDependency;
            if (jSLiteralExpression == null) {
                GulpTaskReference.$$$reportNull$$$0(1);
            }
            return jSLiteralExpression;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int length = this.myDependency.getTextLength();
            if (length < 2) {
                TextRange textRange = new TextRange(0, length);
                if (textRange == null) {
                    GulpTaskReference.$$$reportNull$$$0(2);
                }
                return textRange;
            }
            TextRange textRange = new TextRange(1, length - 1);
            if (textRange == null) {
                GulpTaskReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        @Nullable
        public PsiElement resolve() {
            JSExpression[] arguments;
            String taskName;
            GulpfilePsiStructure structure;
            JSCallExpression callExpr;
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile != null && (callExpr = (structure = GulpfilePsiStructure.get(jsFile)).getPsiByName(taskName = StringUtil.unquoteString((String)this.myDependency.getText()))) != null && (arguments = callExpr.getArguments()).length > 0) {
                return arguments[0];
            }
            return null;
        }

        @NotNull
        public String getCanonicalText() {
            TextRange range = this.getRangeInElement();
            String string = range.substring(this.myDependency.getText());
            if (string == null) {
                GulpTaskReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            ElementManipulator elementManipulator;
            if (newElementName == null) {
                GulpTaskReference.$$$reportNull$$$0(5);
            }
            if ((elementManipulator = ElementManipulators.getManipulator((PsiElement)this.myDependency)) != null) {
                return elementManipulator.handleContentChange((PsiElement)this.myDependency, this.getRangeInElement(), newElementName);
            }
            throw new IncorrectOperationException("Cannot handleElementRename for " + this.myDependency.getClass());
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            JSLiteralExpression literal;
            if (element == null) {
                GulpTaskReference.$$$reportNull$$$0(6);
            }
            if (element instanceof JSLiteralExpression && (literal = (JSLiteralExpression)element).isQuotedLiteral()) {
                return this.handleElementRename(StringUtil.unquoteString((String)literal.getText()));
            }
            throw new IncorrectOperationException("Cannot bindToElement(class: " + element.getClass() + ")");
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                GulpTaskReference.$$$reportNull$$$0(7);
            }
            return this.myDependency.getManager().areElementsEquivalent(this.resolve(), element);
        }

        @NotNull
        public Object[] getVariants() {
            JSFile jsFile = GulpReferenceContributor.getJSFile((PsiElement)this.myDependency);
            if (jsFile == null) {
                if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                    GulpTaskReference.$$$reportNull$$$0(8);
                }
                return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            }
            GulpfilePsiStructure structure = GulpfilePsiStructure.get(jsFile);
            Object[] objectArray = ArrayUtilRt.toStringArray(structure.getTasks());
            if (objectArray == null) {
                GulpTaskReference.$$$reportNull$$$0(9);
            }
            return objectArray;
        }

        public boolean isSoft() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpReferenceContributor$GulpTaskReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

