/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSFileReferenceCache {
    private static final Key<SoftReference<Map<String, CachedValue<Collection<PsiElement>>>>> KEY = Key.create((String)"module.ref.map.key");
    @NotNull
    private final ProjectRootManager myProjectRoot;

    public static JSFileReferenceCache getInstance(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(0);
        }
        return (JSFileReferenceCache)ServiceManager.getService((Project)project, JSFileReferenceCache.class);
    }

    public JSFileReferenceCache(@NotNull ProjectRootManager projectRoot) {
        if (projectRoot == null) {
            JSFileReferenceCache.$$$reportNull$$$0(1);
        }
        this.myProjectRoot = projectRoot;
    }

    @NotNull
    Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner) {
        String referenceText;
        if (referenceOwner == null) {
            JSFileReferenceCache.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(referenceOwner)))) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(3);
            }
            return list2;
        }
        Collection<PsiElement> collection = this.resolveModuleReference(referenceOwner, referenceText);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveModuleReference(@Nullable PsiElement context, @NotNull String referenceText) {
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(5);
        }
        if (context == null || StringUtil.isEmpty((String)referenceText)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PsiElement moduleContext = JSFileReferenceCache.getModuleContext(context);
        if (moduleContext == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(7);
            }
            return set;
        }
        Collection<PsiElement> directModules = this.resolveDirectModules(moduleContext, referenceText);
        Collection<PsiElement> collection = JSFileReferencesUtil.mergeWithAugmentations(context, directModules);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveDirectModules(@NotNull PsiElement moduleReference) {
        String referenceText;
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(moduleReference)))) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSFileReferenceCache.$$$reportNull$$$0(10);
            }
            return list2;
        }
        PsiElement context = JSFileReferenceCache.getModuleContext(moduleReference);
        if (context == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(11);
            }
            return set;
        }
        Collection<PsiElement> collection = this.resolveDirectModules(context, referenceText);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    private static PsiElement getModuleContext(@NotNull PsiElement moduleReference) {
        PsiFile containingFile;
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(13);
        }
        if ((containingFile = moduleReference.getContainingFile()) == null) {
            return null;
        }
        PsiFile file2 = containingFile.getOriginalFile();
        if (file2 instanceof JSFile) {
            return file2;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(moduleReference);
        if (module != null) {
            return module instanceof PsiFile ? ((PsiFile)module).getOriginalFile() : module;
        }
        return file2;
    }

    @NotNull
    private Collection<PsiElement> resolveDirectModules(@NotNull PsiElement element, @NotNull String quotedRef) {
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(14);
        }
        if (quotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(15);
        }
        String unquotedRef = JSStringUtil.unquoteStringLiteralValue(quotedRef);
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file2 == null) {
            Collection<PsiElement> collection = this.resolveDirectModulesNoCache(element, unquotedRef);
            if (collection == null) {
                JSFileReferenceCache.$$$reportNull$$$0(16);
            }
            return collection;
        }
        Collection<PsiElement> collection = JSFileReferencesUtil.isLibraryElement(element) ? this.getLibraryCachedModules(element, unquotedRef) : this.getCachedModules(element, unquotedRef);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(17);
        }
        return collection;
    }

    private Collection<PsiElement> getCachedModules(@NotNull PsiElement context, @NotNull String ref) {
        ConcurrentMap map;
        Collection<PsiElement> elements;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(18);
        }
        if (ref == null) {
            JSFileReferenceCache.$$$reportNull$$$0(19);
        }
        if ((elements = (Collection<PsiElement>)(map = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}))).get(ref)) != null) {
            return elements;
        }
        elements = this.resolveDirectModulesNoCache(context, ref);
        map.putIfAbsent(ref, elements);
        return elements;
    }

    private Collection<PsiElement> getLibraryCachedModules(@NotNull PsiElement element, @NotNull String unquotedRef) {
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(20);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(21);
        }
        Map<String, CachedValue<Collection<PsiElement>>> map = this.getLibraryFilesMap(element);
        return (Collection)this.getLibraryCachedValue(element, unquotedRef, map).getValue();
    }

    @NotNull
    private CachedValue<Collection<PsiElement>> getLibraryCachedValue(@NotNull PsiElement context, @NotNull String unquotedRef, @NotNull Map<String, CachedValue<Collection<PsiElement>>> map) {
        CachedValue<Collection<PsiElement>> value;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(22);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(23);
        }
        if (map == null) {
            JSFileReferenceCache.$$$reportNull$$$0(24);
        }
        if ((value = map.get(unquotedRef)) != null) {
            CachedValue<Collection<PsiElement>> cachedValue = value;
            if (cachedValue == null) {
                JSFileReferenceCache.$$$reportNull$$$0(25);
            }
            return cachedValue;
        }
        value = this.createLibraryCachedValueForText(context, unquotedRef);
        CachedValue<Collection<PsiElement>> prev = map.putIfAbsent(unquotedRef, value);
        if (prev != null) {
            value = prev;
        }
        CachedValue<Collection<PsiElement>> cachedValue = value;
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(26);
        }
        return cachedValue;
    }

    @NotNull
    private CachedValue<Collection<PsiElement>> createLibraryCachedValueForText(@NotNull PsiElement context, @NotNull String unquotedRef) {
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(27);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(28);
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)context.getProject()).createCachedValue(() -> {
            Collection<PsiElement> elements = this.resolveDirectModulesNoCache(context, unquotedRef);
            ProjectFileIndex index = this.myProjectRoot.getFileIndex();
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)context);
            ArrayList<Object> deps = new ArrayList<Object>(elements.size() + 2);
            deps.add(file2);
            deps.add(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS);
            boolean allResolveResultsFromLibrary = true;
            for (PsiElement element : elements) {
                VirtualFile curr;
                if (element instanceof JSFile && (curr = PsiUtilCore.getVirtualFile((PsiElement)element)) != null && (index.isInLibrary(curr) || index.isExcluded(curr))) {
                    deps.add(element);
                    continue;
                }
                allResolveResultsFromLibrary = false;
                break;
            }
            if (allResolveResultsFromLibrary) {
                return CachedValueProvider.Result.create(elements, (Object[])deps.toArray());
            }
            return CachedValueProvider.Result.create(elements, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }, false);
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(29);
        }
        return cachedValue;
    }

    @NotNull
    private Map<String, CachedValue<Collection<PsiElement>>> getLibraryFilesMap(@NotNull PsiElement context) {
        SoftReference data;
        Map result2;
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(30);
        }
        if ((result2 = (Map)SoftReference.deref((Getter)(data = (SoftReference)context.getUserData(KEY)))) != null) {
            Map map = result2;
            if (map == null) {
                JSFileReferenceCache.$$$reportNull$$$0(31);
            }
            return map;
        }
        result2 = ContainerUtil.newConcurrentMap();
        context.putUserData(KEY, (Object)new SoftReference((Object)result2));
        Map map = result2;
        if (map == null) {
            JSFileReferenceCache.$$$reportNull$$$0(32);
        }
        return map;
    }

    @NotNull
    private Collection<PsiElement> resolveDirectModulesNoCache(@NotNull PsiElement context, @NotNull String unquotedRef) {
        if (context == null) {
            JSFileReferenceCache.$$$reportNull$$$0(33);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(34);
        }
        Collection<PsiElement> collection = JSFileReferencesUtil.INSTANCE.calculateMainModules(context, unquotedRef);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(35);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedRef";
                break;
            }
            case 18: 
            case 22: 
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 21: 
            case 23: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRef";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReference";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectModules";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryCachedValue";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryCachedValueForText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryFilesMap";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveDirectModulesNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectModules";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContext";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedModules";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryCachedModules";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryCachedValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryCachedValueForText";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryFilesMap";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveDirectModulesNoCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

