/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterNpmPackageDoesNotExistsException;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintPackage {
    private static final String UNDEFINED_VERSION = "<unknown>";
    private final VirtualFile myCli;
    private final String myVersion;

    private StylelintPackage(@NotNull VirtualFile cli, @NotNull String version) {
        if (cli == null) {
            StylelintPackage.$$$reportNull$$$0(0);
        }
        if (version == null) {
            StylelintPackage.$$$reportNull$$$0(1);
        }
        this.myCli = cli;
        this.myVersion = version;
    }

    @NotNull
    public static StylelintPackage fromNodePackage(@NotNull Project project, @NotNull NodePackage pkg, boolean refresh, @Nullable VirtualFile contextFile) throws IOException {
        String path;
        if (project == null) {
            StylelintPackage.$$$reportNull$$$0(2);
        }
        if (pkg == null) {
            StylelintPackage.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(path = pkg.getSystemIndependentPath()))) {
            throw new JSLinterNpmPackageDoesNotExistsException(JSLinterUtil.createLinterPackageError(project, path, "Stylelint", contextFile));
        }
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (packageDir == null || !packageDir.isValid() || !packageDir.isDirectory()) {
            throw new JSLinterNpmPackageDoesNotExistsException(JSLinterUtil.createLinterPackageError(project, path, "Stylelint", contextFile));
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir);
        if (packageJson == null) {
            throw new IOException("Please specify Stylelint package correctly: \".../package.json\" file not found");
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJson, refresh);
        SemVer version = packageJsonData.getVersion();
        String packageVersion = version != null ? version.getRawVersion() : UNDEFINED_VERSION;
        String binPath = (String)ObjectUtils.notNull((Object)packageJsonData.getBinPath("stylelint"), (Object)("dist" + File.separator + "cli.js"));
        VirtualFile cli = packageDir.findFileByRelativePath(binPath);
        if (cli == null || !cli.isValid() || cli.isDirectory()) {
            throw new IOException("Please specify Stylelint package correctly: \".../" + binPath + "\" file not found");
        }
        StylelintPackage stylelintPackage = new StylelintPackage(cli, packageVersion);
        if (stylelintPackage == null) {
            StylelintPackage.$$$reportNull$$$0(4);
        }
        return stylelintPackage;
    }

    @NotNull
    public VirtualFile getCli() {
        VirtualFile virtualFile = this.myCli;
        if (virtualFile == null) {
            StylelintPackage.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public String getVersionStr() {
        String string = this.myVersion;
        if (string == null) {
            StylelintPackage.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cli";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintPackage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNodePackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCli";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionStr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromNodePackage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

