/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NpmInstallQuickFix;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatchResponse;
import com.intellij.javascript.nodejs.packageJson.PackageVersionRangeMatcher;
import com.intellij.javascript.nodejs.packageJson.codeInsight.OpenInstalledPackageQuickFix;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageJsonMismatchedDependencyInspection
extends JSInspection {
    private static final Logger LOG = Logger.getInstance(PackageJsonMismatchedDependencyInspection.class);
    private static final List<String> DEPENDENCIES = ImmutableList.of((Object)"dependencies", (Object)"devDependencies");

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(1);
        }
        JsonElementVisitor jsonElementVisitor = new JsonElementVisitor(){

            public void visitFile(PsiFile file2) {
                if (PackageJsonUtil.isPackageJsonFile(file2)) {
                    PackageJsonMismatchedDependencyInspection.annotate((JsonFile)file2, holder);
                }
            }
        };
        if (jsonElementVisitor == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(2);
        }
        return jsonElementVisitor;
    }

    private static void annotate(@NotNull JsonFile file2, @NotNull ProblemsHolder holder) {
        List<PackageVersionRangeMatchResponse> mismatches;
        if (file2 == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(4);
        }
        VirtualFile packageJson = file2.getVirtualFile();
        Project project = file2.getProject();
        if (packageJson == null || !JSLibraryUtil.isUnderContentRootsAndOutsideOfLibraryRoots(project, packageJson)) {
            return;
        }
        List<JsonProperty> properties = PackageJsonMismatchedDependencyInspection.getDependencies(file2);
        if (properties.isEmpty()) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        MultiMap map = MultiMap.create();
        for (JsonProperty property : properties) {
            JsonStringLiteral nameLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getNameElement(), JsonStringLiteral.class);
            JsonStringLiteral versionLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
            if (nameLiteral == null || versionLiteral == null) continue;
            String packageName = property.getName();
            InstalledPackageVersion pkgVersion = finder.findInstalledPackage(packageName);
            if (pkgVersion == null) {
                holder.registerProblem((PsiElement)versionLiteral, PackageJsonMismatchedDependencyInspection.getTextRange((JsonValue)versionLiteral), "The " + StringUtil.wrapWithDoubleQuote((String)packageName) + " package is not installed", new LocalQuickFix[]{new NpmInstallQuickFix(project, packageJson)});
                continue;
            }
            String text = versionLiteral.getText();
            if (!StringUtil.isQuotedString((String)text)) continue;
            String versionRange = StringUtil.unquoteString((String)text);
            if (versionRange.isEmpty()) {
                holder.registerProblem((PsiElement)versionLiteral, "The package version is not specified", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                continue;
            }
            if (pkgVersion.getVersion() == null) continue;
            String version = pkgVersion.getVersion().getRawVersion();
            map.putValue((Object)new PackageVersionRangeMatchRequest(packageName, versionRange, version), (Object)new DependencyDeclaration(versionLiteral, pkgVersion));
        }
        if (map.keySet().isEmpty()) {
            return;
        }
        try {
            mismatches = PackageVersionRangeMatcher.findMismatches(project, new ArrayList<PackageVersionRangeMatchRequest>(map.keySet()));
        }
        catch (NodeInterpreterUtil.InvalidNodeInterpreter e) {
            LOG.info("Invalid node interpreter:" + e.getMessage());
            return;
        }
        catch (ExecutionException e) {
            LOG.info("Cannot match", (Throwable)e);
            return;
        }
        for (PackageVersionRangeMatchResponse mismatch : mismatches) {
            PackageVersionRangeMatchRequest request = mismatch.getRequest();
            Collection declarations = map.get((Object)request);
            if (declarations.isEmpty()) {
                LOG.warn("No package declarations by " + request);
                continue;
            }
            for (DependencyDeclaration declaration : declarations) {
                ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                fixes.add(new NpmInstallQuickFix(project, packageJson));
                if (holder.isOnTheFly()) {
                    fixes.add(new OpenInstalledPackageQuickFix(declaration.myInstalledPackageVersion.getPackageDir(), request.getPackageName()));
                }
                holder.registerProblem((PsiElement)declaration.myVersion, PackageJsonMismatchedDependencyInspection.getTextRange((JsonValue)declaration.myVersion), "The installed version " + StringUtil.wrapWithDoubleQuote((String)(request.getPackageName() + "@" + request.getVersion())) + " doesn't match the version range " + StringUtil.wrapWithDoubleQuote((String)request.getVersionRange()), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    @NotNull
    public static List<JsonProperty> getDependencies(@NotNull JsonFile file2) {
        if (file2 == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(5);
        }
        ArrayList<JsonProperty> properties = new ArrayList<JsonProperty>();
        for (JsonValue value : file2.getAllTopLevelValues()) {
            JsonObject root = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
            if (root == null) continue;
            for (JsonProperty property : root.getPropertyList()) {
                JsonObject obj;
                if (!DEPENDENCIES.contains(property.getName()) || (obj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                properties.addAll(obj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = properties;
        if (arrayList == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static TextRange getTextRange(@NotNull JsonValue element) {
        if (element == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(7);
        }
        TextRange range = element.getTextRange();
        if (element instanceof JsonStringLiteral && range.getLength() > 2 && StringUtil.isQuotedString((String)element.getText())) {
            TextRange textRange = new TextRange(1, range.getLength() - 1);
            if (textRange == null) {
                PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)0, (int)range.getLength());
        if (textRange == null) {
            PackageJsonMismatchedDependencyInspection.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DependencyDeclaration {
        public final JsonStringLiteral myVersion;
        public final InstalledPackageVersion myInstalledPackageVersion;

        DependencyDeclaration(@NotNull JsonStringLiteral version, @NotNull InstalledPackageVersion installedPackageVersion) {
            if (version == null) {
                DependencyDeclaration.$$$reportNull$$$0(0);
            }
            if (installedPackageVersion == null) {
                DependencyDeclaration.$$$reportNull$$$0(1);
            }
            this.myVersion = version;
            this.myInstalledPackageVersion = installedPackageVersion;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "installedPackageVersion";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/PackageJsonMismatchedDependencyInspection$DependencyDeclaration";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

