/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.NpmRegistryService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class NpmRegistryServiceImpl
extends NpmRegistryService {
    private static final String USER_AGENT = "JetBrains IDE";
    private static final Logger LOG = Logger.getInstance(NpmRegistryServiceImpl.class);
    private static final Map<String, String> ourTestUrlMappings = ApplicationManager.getApplication().isUnitTestMode() ? ContainerUtil.newConcurrentMap() : null;
    private final ConcurrentMap<String, TimestampedVersions> myVersionsCache = ContainerUtil.createConcurrentSoftMap();
    private final ConcurrentMap<String, Future<AvailablePackageVersions>> myRunningFutures = ContainerUtil.newConcurrentMap();
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Npm Registry Pool", (int)2);

    @Override
    public void findPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        int MAX_DUP_COUNT = 50;
        int limitMargin = 1 + limit / 100;
        int queryLimit = searchQuery.getMaxQueryBatchSize();
        HashSet<String> all = new HashSet<String>();
        int found = 0;
        int skip = 0;
        int dupCount = 0;
        while (found < limit) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int localLimit = Math.min(queryLimit, limit - found + limitMargin);
            List<NodePackageBasicInfo> results = NpmRegistryServiceImpl.findPackagesOrWaitForIt(indicator, searchQuery, skip, localLimit);
            skip += results.size();
            for (NodePackageBasicInfo info : results) {
                if (all.add(info.getName())) {
                    if (!filter.value((Object)info)) continue;
                    consumer.consume((Object)info);
                    if (++found < limit) continue;
                    break;
                }
                ++dupCount;
            }
            if (results.size() < localLimit) break;
            if (dupCount <= 50) continue;
            LOG.warn("Found over 50 duplicated packages with query: " + searchQuery + ". Stopping to preserve infinite loop.");
            break;
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> findPackagesOrWaitForIt(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List list2;
            try {
                list2 = (List)ApplicationUtil.runWithCheckCanceled(() -> NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (list2 == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<NodePackageBasicInfo> list3 = NpmRegistryServiceImpl.doFetchPackages(indicator, searchQuery, skip, limit);
        if (list3 == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @NotNull
    private static List<NodePackageBasicInfo> doFetchPackages(@Nullable ProgressIndicator indicator, @NotNull NpmRegistryService.SearchQuery searchQuery, int skip, int limit) throws IOException {
        List<NodePackageBasicInfo> list2;
        if (searchQuery == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(6);
        }
        String url = searchQuery.getQueryUrl(skip, limit);
        try {
            long startNano = System.nanoTime();
            String content = NpmRegistryServiceImpl.fetchUrl(url, null, indicator);
            List<NodePackageBasicInfo> infos = searchQuery.parseContent(content);
            long exactPrefixes = infos.stream().filter(info -> info.getName().startsWith(searchQuery.myText)).count();
            LOG.info("Found " + infos.size() + " packages (" + exactPrefixes + " with '" + searchQuery.myText + "' prefix) in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list2 = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for " + searchQuery + ": " + e.getMessage(), e);
        }
        if (list2 == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @Nullable
    public JsonObject fetchPackageJson(@NotNull String packageName, @NotNull String versionOrRange, @Nullable ProgressIndicator indicator) {
        String packagePath;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(8);
        }
        if (versionOrRange == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(9);
        }
        if (versionOrRange.isEmpty()) {
            versionOrRange = "*";
        }
        SemVer version = SemVer.parseFromText((String)versionOrRange);
        Requirement req = null;
        if (version == null) {
            try {
                req = Requirement.buildNPM((String)versionOrRange);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean distTag = false;
        String versionSuffix = null;
        if (packageName.startsWith("@")) {
            if (version != null) {
                versionSuffix = "=" + versionOrRange;
            } else if (!"latest".equals(versionOrRange) && req != null) {
                versionSuffix = versionOrRange;
            } else {
                distTag = true;
            }
            packagePath = "@" + URLUtil.encodeURIComponent((String)packageName.substring(1));
        } else {
            if (version != null) {
                versionSuffix = versionOrRange;
            } else if ("latest".equals(versionOrRange) || req == null) {
                versionSuffix = versionOrRange;
            }
            packagePath = URLUtil.encodeURIComponent((String)packageName);
        }
        boolean fetchList = versionSuffix == null;
        String url = "https://registry.npmjs.org/" + packagePath + (!fetchList ? "/" + versionSuffix : "");
        long startNano = System.nanoTime();
        try {
            JsonObject result2;
            String content = NpmRegistryServiceImpl.fetchUrl(url, null, null);
            if (fetchList) {
                version = distTag ? NpmRegistryServiceImpl.findDistTag(content, versionOrRange) : NpmRegistryServiceImpl.findHighestPackageVersion(content, versionOrRange);
                if (version == null) {
                    return null;
                }
                try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                    result2 = NpmRegistryServiceImpl.loadPackageJson(reader, version.getRawVersion());
                }
            } else {
                result2 = (JsonObject)new JsonParser().parse(content);
            }
            LOG.info("Loaded package.json for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return result2;
        }
        catch (Exception e) {
            LOG.info("Failed to fetch package.json from " + url, (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static SemVer findDistTag(@NotNull String content, @NotNull String distTag) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        if (distTag == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(11);
        }
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            AvailablePackageVersions versions = AvailablePackageVersions.parseFromPackageMetadata(reader);
            SemVer semVer = versions.findVersionByDistTag(distTag);
            return semVer;
        }
    }

    @Nullable
    private static SemVer findHighestPackageVersion(@NotNull String content, @NotNull String range) throws IOException {
        if (content == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        if (range == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        Requirement req = Requirement.buildNPM((String)range);
        Semver highest = null;
        try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("versions")) {
                    reader.beginObject();
                    while (reader.hasNext()) {
                        try {
                            Semver v = new Semver(reader.nextName(), Semver.SemverType.NPM);
                            if (req.isSatisfiedBy(v) && (highest == null || v.isGreaterThan(highest))) {
                                highest = v;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        reader.skipValue();
                    }
                    break;
                }
                reader.skipValue();
            }
        }
        if (highest == null) {
            return null;
        }
        return SemVer.parseFromText((String)highest.getOriginalValue());
    }

    @Nullable
    private static JsonObject loadPackageJson(@NotNull JsonReader reader, @NotNull String version) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(14);
        }
        if (version == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("versions")) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String v = reader.nextName();
                    if (version.equals(v)) {
                        return (JsonObject)new JsonParser().parse(reader);
                    }
                    reader.skipValue();
                }
                break;
            }
            reader.skipValue();
        }
        return null;
    }

    @Override
    @Nullable
    public AvailablePackageVersions getCachedPackageVersions(@NotNull String packageName) {
        TimestampedVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        if ((cache = (TimestampedVersions)this.myVersionsCache.get(packageName)) != null && cache.getCreateTimeNano() + TimeUnit.MINUTES.toNanos(10L) > System.nanoTime()) {
            return cache.getVersions();
        }
        return null;
    }

    @Override
    @NotNull
    public Promise<AvailablePackageVersions> asyncUpdateAndGetPackageVersions(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(17);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Future<AvailablePackageVersions> future = this.getOrCreateVersionsFetchFuture(packageName);
            try {
                promise.setResult((Object)future.get());
            }
            catch (Exception e) {
                promise.setError((Throwable)e);
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(18);
        }
        return asyncPromise;
    }

    @Override
    @NotNull
    public AvailablePackageVersions getCachedOrFetchPackageVersions(@Nullable ProgressIndicator indicator, @NotNull String packageName) {
        AvailablePackageVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(19);
        }
        if ((cache = this.getCachedPackageVersions(packageName)) != null) {
            AvailablePackageVersions availablePackageVersions = cache;
            if (availablePackageVersions == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(20);
            }
            return availablePackageVersions;
        }
        Future<AvailablePackageVersions> future = this.getOrCreateVersionsFetchFuture(packageName);
        AvailablePackageVersions versions = null;
        if (indicator == null) {
            try {
                versions = future.get();
            }
            catch (Exception exception) {}
        } else {
            while (true) {
                try {
                    versions = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!indicator.isCanceled()) continue;
                    AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.createEmpty();
                    if (availablePackageVersions == null) {
                        NpmRegistryServiceImpl.$$$reportNull$$$0(21);
                    }
                    return availablePackageVersions;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
        }
        AvailablePackageVersions availablePackageVersions = versions != null ? versions : AvailablePackageVersions.createEmpty();
        if (availablePackageVersions == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(22);
        }
        return availablePackageVersions;
    }

    @Override
    @NotNull
    public Future<AvailablePackageVersions> getCachedOrFetchPackageVersionsFuture(@NotNull String packageName) {
        AvailablePackageVersions cache;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(23);
        }
        if ((cache = this.getCachedPackageVersions(packageName)) != null) {
            FixedFuture fixedFuture = new FixedFuture((Object)cache);
            if (fixedFuture == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(24);
            }
            return fixedFuture;
        }
        Future<AvailablePackageVersions> future = this.getOrCreateVersionsFetchFuture(packageName);
        if (future == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(25);
        }
        return future;
    }

    public static void addTestUrlMapping(@NotNull String url, @NotNull String localFile, @NotNull Disposable parentDisposable) {
        if (url == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(26);
        }
        if (localFile == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(27);
        }
        if (parentDisposable == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(28);
        }
        if (ourTestUrlMappings.put(url, localFile) != null) {
            throw new IllegalStateException("Existent mapping for " + url);
        }
        Disposer.register((Disposable)parentDisposable, () -> ourTestUrlMappings.remove(url));
    }

    public static void addTestUrlMappings(@NotNull Map<String, String> mappings, @NotNull Disposable parentDisposable) {
        if (mappings == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(29);
        }
        if (parentDisposable == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(30);
        }
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            NpmRegistryServiceImpl.addTestUrlMapping(entry.getKey(), entry.getValue(), parentDisposable);
        }
    }

    @NotNull
    private Future<AvailablePackageVersions> getOrCreateVersionsFetchFuture(@NotNull String packageName) {
        FutureTask<AvailablePackageVersions> newFuture;
        Future running;
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(31);
        }
        if ((running = (Future)this.myRunningFutures.putIfAbsent(packageName, newFuture = new FutureTask<AvailablePackageVersions>(() -> {
            AvailablePackageVersions versions = NpmRegistryServiceImpl.fetchPackageVersions(packageName);
            this.myVersionsCache.put(packageName, new TimestampedVersions(versions));
            this.myRunningFutures.remove(packageName);
            return versions;
        }))) != null) {
            Future future = running;
            if (future == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(32);
            }
            return future;
        }
        this.myExecutorService.submit(newFuture);
        FutureTask<AvailablePackageVersions> futureTask = newFuture;
        if (futureTask == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(33);
        }
        return futureTask;
    }

    @Nullable
    private static AvailablePackageVersions fetchPackageVersions(@NotNull String packageName) {
        if (packageName == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(34);
        }
        String packagePath = packageName.startsWith("@") ? "@" + URLUtil.encodeURIComponent((String)packageName.substring(1)) : URLUtil.encodeURIComponent((String)packageName);
        String url = "http://registry.npmjs.org/" + packagePath;
        long startNano = System.nanoTime();
        try {
            String content = NpmRegistryServiceImpl.fetchUrl(url, "application/vnd.npm.install-v1+json; q=1.0, application/json; q=0.8, */*", null);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            AvailablePackageVersions versions = AvailablePackageVersions.parseFromPackageMetadata(reader);
            reader.close();
            List<Pair<String, SemVer>> distTags = versions.getDistTags();
            LOG.info("Found " + distTags.size() + " dist-tags, " + versions.getVersions().size() + " versions for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
            return versions;
        }
        catch (Exception e) {
            String message = "Failed to fetch '" + packageName + "' package versions from " + url;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error(message, (Throwable)e);
            } else {
                LOG.info(message, (Throwable)e);
            }
            return null;
        }
    }

    @NotNull
    private static String fetchUrl(@NotNull String url, @Nullable String mimeType, @Nullable ProgressIndicator indicator) throws IOException {
        if (url == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(35);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String mappedUrl = ourTestUrlMappings.computeIfAbsent(url, u -> {
                throw new IllegalStateException("URL " + u + " is not mapped to local resource.");
            });
            String string = FileUtil.loadFile((File)new File(mappedUrl), (Charset)StandardCharsets.UTF_8);
            if (string == null) {
                NpmRegistryServiceImpl.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = HttpRequests.request((String)url).userAgent(USER_AGENT).accept(mimeType).gzip(true).readString(indicator);
        if (string == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(37);
        }
        return string;
    }

    @Nullable
    public static NodePackageBasicInfo readPackageInfo(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NpmRegistryServiceImpl.$$$reportNull$$$0(38);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        String name = null;
        String description = null;
        while (reader.hasNext()) {
            String propName = reader.nextName();
            if (propName.equals("name")) {
                name = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if (propName.equals("description")) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name != null ? new NodePackageBasicInfo(name, description) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchQuery";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 19: 
            case 23: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOrRange";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTag";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 26: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localFile";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagesOrWaitForIt";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchPackages";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncUpdateAndGetPackageVersions";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrFetchPackageVersions";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedOrFetchPackageVersionsFuture";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateVersionsFetchFuture";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPackagesOrWaitForIt";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFetchPackages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageJson";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findDistTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findHighestPackageVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadPackageJson";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPackageVersions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "asyncUpdateAndGetPackageVersions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageVersions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCachedOrFetchPackageVersionsFuture";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addTestUrlMapping";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addTestUrlMappings";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateVersionsFetchFuture";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageVersions";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fetchUrl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "readPackageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PrefixPackageListJsonReader {
        private final JsonReader myReader;
        private final List<NodePackageBasicInfo> myResult;

        PrefixPackageListJsonReader(@NotNull JsonReader reader) {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(0);
            }
            this.myResult = new ArrayList<NodePackageBasicInfo>();
            this.myReader = reader;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                List<NodePackageBasicInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    PrefixPackageListJsonReader.$$$reportNull$$$0(1);
                }
                return list2;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if ("rows".equals(name)) {
                    this.readPackagesInsideRows();
                    break;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            List<NodePackageBasicInfo> list3 = this.myResult;
            if (list3 == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(2);
            }
            return list3;
        }

        private void readPackagesInsideRows() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                NodePackageBasicInfo info = PrefixPackageListJsonReader.readSinglePackage(this.myReader);
                if (info == null) continue;
                this.myResult.add(info);
            }
            this.myReader.endArray();
        }

        @Nullable
        private static NodePackageBasicInfo readSinglePackage(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(3);
            }
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                reader.skipValue();
                return null;
            }
            reader.beginObject();
            NodePackageBasicInfo info = null;
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("key".equals(name)) {
                    info = PrefixPackageListJsonReader.readArrayInsideKey(reader);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return info;
        }

        @Nullable
        private static NodePackageBasicInfo readArrayInsideKey(@NotNull JsonReader reader) throws IOException {
            if (reader == null) {
                PrefixPackageListJsonReader.$$$reportNull$$$0(4);
            }
            if (reader.peek() != JsonToken.BEGIN_ARRAY) {
                reader.skipValue();
                return null;
            }
            reader.beginArray();
            String name = null;
            String description = null;
            int i = 0;
            while (reader.hasNext()) {
                if (i < 2 && reader.peek() == JsonToken.STRING) {
                    String str = reader.nextString();
                    if (i == 0) {
                        name = str;
                    } else {
                        description = str;
                    }
                } else {
                    reader.skipValue();
                }
                ++i;
            }
            reader.endArray();
            return name != null ? new NodePackageBasicInfo(name, description) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$PrefixPackageListJsonReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$PrefixPackageListJsonReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "readSinglePackage";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "readArrayInsideKey";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FullTextPackageListJsonReader {
        private final JsonReader myReader;
        private final List<NodePackageBasicInfo> myResult;

        FullTextPackageListJsonReader(@NotNull JsonReader reader) {
            if (reader == null) {
                FullTextPackageListJsonReader.$$$reportNull$$$0(0);
            }
            this.myResult = new ArrayList<NodePackageBasicInfo>();
            this.myReader = reader;
        }

        @NotNull
        public List<NodePackageBasicInfo> read() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                List<NodePackageBasicInfo> list2 = Collections.emptyList();
                if (list2 == null) {
                    FullTextPackageListJsonReader.$$$reportNull$$$0(1);
                }
                return list2;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (name.equals("objects")) {
                    this.readObjects();
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
            List<NodePackageBasicInfo> list3 = this.myResult;
            if (list3 == null) {
                FullTextPackageListJsonReader.$$$reportNull$$$0(2);
            }
            return list3;
        }

        private void readObjects() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_ARRAY) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginArray();
            while (this.myReader.hasNext()) {
                this.readObject();
            }
            this.myReader.endArray();
        }

        private void readObject() throws IOException {
            if (this.myReader.peek() != JsonToken.BEGIN_OBJECT) {
                this.myReader.skipValue();
                return;
            }
            this.myReader.beginObject();
            while (this.myReader.hasNext()) {
                String name = this.myReader.nextName();
                if (name.equals("package")) {
                    ContainerUtil.addIfNotNull(this.myResult, (Object)NpmRegistryServiceImpl.readPackageInfo(this.myReader));
                    continue;
                }
                this.myReader.skipValue();
            }
            this.myReader.endObject();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextPackageListJsonReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextPackageListJsonReader";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "read";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class NamePrefixSearchQuery
    extends NpmRegistryService.SearchQuery {
        private final String myBaseUrl;
        private final String myStartKey;
        private final String myEndKey;

        NamePrefixSearchQuery(@NotNull String prefix) {
            if (prefix == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(0);
            }
            super(prefix);
            this.myBaseUrl = prefix.startsWith("@") ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
            this.myStartKey = URLUtil.encodeURIComponent((String)("[\"" + prefix + "\"]"));
            this.myEndKey = URLUtil.encodeURIComponent((String)("[\"" + prefix + "z\",{}]"));
        }

        @Override
        @NotNull
        public String getQueryUrl(int from, int limit) {
            String string = this.myBaseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + from + "&limit=" + limit + "&start_key=" + this.myStartKey + "&end_key=" + this.myEndKey;
            if (string == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public int getMaxQueryBatchSize() {
            return 10000;
        }

        @Override
        @NotNull
        public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
            List<NodePackageBasicInfo> list2;
            if (content == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(2);
            }
            try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                List<NodePackageBasicInfo> list3 = new PrefixPackageListJsonReader(reader).read();
                list2 = list3;
            }
            if (list2 == null) {
                NamePrefixSearchQuery.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public String toString() {
            return "'" + this.myText + "*' (Prefix)";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$NamePrefixSearchQuery";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$NamePrefixSearchQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class FullTextSearchQuery
    extends NpmRegistryService.SearchQuery {
        FullTextSearchQuery(@NotNull String text) {
            if (text == null) {
                FullTextSearchQuery.$$$reportNull$$$0(0);
            }
            super(text);
        }

        @Override
        @NotNull
        public String getQueryUrl(int from, int limit) {
            String string = "https://registry.npmjs.org/-/v1/search?&text=" + URLUtil.encodeURIComponent((String)("\"" + this.myText + "\"")) + "&from=" + from + "&size=" + limit;
            if (string == null) {
                FullTextSearchQuery.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public int getMaxQueryBatchSize() {
            return 250;
        }

        @Override
        @NotNull
        public List<NodePackageBasicInfo> parseContent(@NotNull String content) throws IOException {
            List<NodePackageBasicInfo> list2;
            if (content == null) {
                FullTextSearchQuery.$$$reportNull$$$0(2);
            }
            try (JsonReader reader = new JsonReader((Reader)new StringReader(content));){
                List<NodePackageBasicInfo> list3 = new FullTextPackageListJsonReader(reader).read();
                list2 = list3;
            }
            if (list2 == null) {
                FullTextSearchQuery.$$$reportNull$$$0(3);
            }
            return list2;
        }

        public String toString() {
            return "'" + this.myText + "' (Full Text)";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextSearchQuery";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NpmRegistryServiceImpl$FullTextSearchQuery";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQueryUrl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TimestampedVersions {
        private final long myCreateTimeNano;
        private final AvailablePackageVersions myVersions;

        private TimestampedVersions(@Nullable AvailablePackageVersions versions) {
            this.myVersions = versions;
            this.myCreateTimeNano = System.nanoTime();
        }

        public long getCreateTimeNano() {
            return this.myCreateTimeNano;
        }

        @Nullable
        public AvailablePackageVersions getVersions() {
            return this.myVersions;
        }
    }
}

