/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInstalledPackageFinder {
    private final List<VirtualFile> myNodeModulesDirs;

    public NodeInstalledPackageFinder(@NotNull Project project, @NotNull VirtualFile initialLocation) {
        if (project == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(0);
        }
        if (initialLocation == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(1);
        }
        this.myNodeModulesDirs = new ArrayList<VirtualFile>();
        ReadAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            NodeModuleSearchUtil.processUpNodeModulesDirs(project, initialLocation, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
                this.myNodeModulesDirs.add((VirtualFile)nodeModulesDir);
                return true;
            }));
        });
    }

    @Nullable
    public InstalledPackageVersion findInstalledPackage(@NotNull String packageName) {
        if (packageName == null) {
            NodeInstalledPackageFinder.$$$reportNull$$$0(2);
        }
        for (VirtualFile nodeModulesDir : this.myNodeModulesDirs) {
            VirtualFile packageDir = nodeModulesDir.findFileByRelativePath(packageName);
            if (packageDir == null || !packageDir.isDirectory() || !packageDir.isValid()) continue;
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir);
            if (packageJson != null) {
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                SemVer version = data.getVersion();
                if (version != null && packageName.equals(data.getName())) {
                    return new InstalledPackageVersion(packageDir, packageJson, version);
                }
                return new InstalledPackageVersion(packageDir, packageJson, null);
            }
            return new InstalledPackageVersion(packageDir, null, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialLocation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/NodeInstalledPackageFinder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstalledPackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

